/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.BinaryMRInstructionBase;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.data.OperationsOnMatrixValues;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.BinaryOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class BinaryInstruction
extends BinaryMRInstructionBase {
    public BinaryInstruction(Operator op, byte in1, byte in2, byte out, String istr) {
        super(op, in1, in2, out);
        this.mrtype = MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary;
        this.instString = istr;
    }

    public static BinaryInstruction parseInstruction(String str) throws DMLRuntimeException {
        InstructionUtils.checkNumFields(str, 3);
        String[] parts = InstructionUtils.getInstructionParts(str);
        String opcode = parts[0];
        byte in1 = Byte.parseByte(parts[1]);
        byte in2 = Byte.parseByte(parts[2]);
        byte out = Byte.parseByte(parts[3]);
        BinaryOperator bop = InstructionUtils.parseBinaryOperator(opcode);
        if (bop != null) {
            return new BinaryInstruction(bop, in1, in2, out, str);
        }
        return null;
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) throws DMLRuntimeException {
        IndexedMatrixValue in1 = cachedValues.getFirst(this.input1);
        IndexedMatrixValue in2 = cachedValues.getFirst(this.input2);
        if (in1 == null && in2 == null) {
            return;
        }
        IndexedMatrixValue out = this.output != this.input1 && this.output != this.input2 || this.output == this.input1 && in1 == null || this.output == this.input2 && in2 == null ? cachedValues.holdPlace(this.output, valueClass) : tempValue;
        MatrixIndexes finalIndexes = null;
        if (in1 == null) {
            in1 = zeroInput;
            in1.getValue().reset(in2.getValue().getNumRows(), in2.getValue().getNumColumns());
            finalIndexes = in2.getIndexes();
        } else {
            finalIndexes = in1.getIndexes();
        }
        if (in2 == null) {
            in2 = zeroInput;
            in2.getValue().reset(in1.getValue().getNumRows(), in1.getValue().getNumColumns());
        }
        out.getIndexes().setIndexes(finalIndexes);
        OperationsOnMatrixValues.performBinaryIgnoreIndexes(in1.getValue(), in2.getValue(), out.getValue(), (BinaryOperator)this.optr);
        if (out == tempValue) {
            cachedValues.add(this.output, out);
        }
    }
}

