/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.gpu;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.functionobjects.SwapIndex;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.gpu.GPUInstruction;
import org.apache.sysml.runtime.matrix.data.LibMatrixCUDA;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.ReorgOperator;
import org.apache.sysml.utils.GPUStatistics;

public class ReorgGPUInstruction
extends GPUInstruction {
    private CPOperand _input;
    private CPOperand _output;

    public ReorgGPUInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String istr) {
        super(op, opcode, istr);
        this._gputype = GPUInstruction.GPUINSTRUCTION_TYPE.Reorg;
        this._input = in;
        this._output = out;
    }

    public static ReorgGPUInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 2);
        String opcode = parts[0];
        CPOperand in = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        if (!opcode.equalsIgnoreCase("r'")) {
            throw new DMLRuntimeException("Unknown opcode while parsing a ReorgInstruction: " + str);
        }
        return new ReorgGPUInstruction(new ReorgOperator(SwapIndex.getSwapIndexFnObject()), in, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        GPUStatistics.incrementNoOfExecutedGPUInst();
        MatrixObject mat = this.getMatrixInputForGPUInstruction(ec, this._input.getName());
        int rlen = (int)mat.getNumColumns();
        int clen = (int)mat.getNumRows();
        ec.setMetaData(this._output.getName(), rlen, clen);
        LibMatrixCUDA.transpose(ec, this.getExtendedOpcode(), mat, this._output.getName());
        ec.releaseMatrixInputForGPUInstruction(this._input.getName());
        ec.releaseMatrixOutputForGPUInstruction(this._output.getName());
    }
}

