/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.gpu;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.gpu.ArithmeticBinaryGPUInstruction;
import org.apache.sysml.runtime.matrix.data.LibMatrixCUDA;
import org.apache.sysml.runtime.matrix.operators.BinaryOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.utils.GPUStatistics;

public class MatrixMatrixArithmeticGPUInstruction
extends ArithmeticBinaryGPUInstruction {
    public MatrixMatrixArithmeticGPUInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(op, in1, in2, out, opcode, istr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        GPUStatistics.incrementNoOfExecutedGPUInst();
        MatrixObject in1 = this.getMatrixInputForGPUInstruction(ec, this._input1.getName());
        MatrixObject in2 = this.getMatrixInputForGPUInstruction(ec, this._input2.getName());
        boolean isLeftTransposed = false;
        boolean isRightTransposed = false;
        long rlen1 = in1.getNumRows();
        long clen1 = in1.getNumColumns();
        long rlen2 = in2.getNumRows();
        long clen2 = in2.getNumColumns();
        long rlen = rlen1;
        long clen = clen1;
        if (rlen1 != rlen2 || clen1 != clen2) {
            rlen = rlen1 > rlen2 ? rlen1 : rlen2;
            clen = clen1 > clen2 ? clen1 : clen2;
        }
        ec.setMetaData(this._output.getName(), (int)rlen, (int)clen);
        BinaryOperator bop = (BinaryOperator)this._optr;
        LibMatrixCUDA.matrixScalarArithmetic(ec, this.getExtendedOpcode(), in1, in2, this._output.getName(), isLeftTransposed, isRightTransposed, bop);
        ec.releaseMatrixInputForGPUInstruction(this._input1.getName());
        ec.releaseMatrixInputForGPUInstruction(this._input2.getName());
        ec.releaseMatrixOutputForGPUInstruction(this._output.getName());
    }
}

