/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.gpu;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.gpu.BuiltinUnaryGPUInstruction;
import org.apache.sysml.runtime.instructions.gpu.GPUInstruction;
import org.apache.sysml.runtime.matrix.data.LibMatrixCUDA;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.utils.GPUStatistics;

public class MatrixBuiltinGPUInstruction
extends BuiltinUnaryGPUInstruction {
    public MatrixBuiltinGPUInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String instr) {
        super(op, in, out, 1, opcode, instr);
        this._gputype = GPUInstruction.GPUINSTRUCTION_TYPE.BuiltinUnary;
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        GPUStatistics.incrementNoOfExecutedGPUInst();
        String opcode = this.getOpcode();
        MatrixObject mat = this.getMatrixInputForGPUInstruction(ec, this._input.getName());
        ec.setMetaData(this._output.getName(), mat.getNumRows(), mat.getNumColumns());
        if (opcode.equals("sel+")) {
            LibMatrixCUDA.relu(ec, this.getExtendedOpcode(), mat, this._output.getName());
        } else if (opcode.equals("exp")) {
            LibMatrixCUDA.exp(ec, this.getExtendedOpcode(), mat, this._output.getName());
        } else {
            throw new DMLRuntimeException("Unsupported GPU operator:" + opcode);
        }
        ec.releaseMatrixInputForGPUInstruction(this._input.getName());
        ec.releaseMatrixOutputForGPUInstruction(this._output.getName());
    }
}

