/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.cp.BuiltinBinaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.DoubleObject;
import org.apache.sysml.runtime.instructions.cp.IntObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.cp.StringObject;
import org.apache.sysml.runtime.matrix.operators.BinaryOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class ScalarScalarBuiltinCPInstruction
extends BuiltinBinaryCPInstruction {
    public ScalarScalarBuiltinCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String instr) {
        super(op, in1, in2, out, 2, opcode, instr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        ScalarObject so1 = ec.getScalarInput(this.input1.getName(), this.input1.getValueType(), this.input1.isLiteral());
        ScalarObject so2 = ec.getScalarInput(this.input2.getName(), this.input2.getValueType(), this.input2.isLiteral());
        BinaryOperator dop = (BinaryOperator)this._optr;
        ScalarObject sores = null;
        if (so1 instanceof StringObject || so2 instanceof StringObject) {
            throw new DMLRuntimeException("Binary builtin '" + this.getOpcode() + "' not supported over string inputs.");
        }
        if (so1 instanceof DoubleObject || so2 instanceof DoubleObject || this.output.getValueType() == Expression.ValueType.DOUBLE) {
            sores = new DoubleObject(dop.fn.execute(so1.getDoubleValue(), so2.getDoubleValue()));
        } else if (so1 instanceof IntObject || so2 instanceof IntObject) {
            sores = new IntObject((long)dop.fn.execute(so1.getLongValue(), so2.getLongValue()));
        } else {
            throw new DMLRuntimeException("Binary builtin '" + this.getOpcode() + "' not supported over boolean inputs.");
        }
        ec.setScalarOutput(this.output.getName(), sores);
    }
}

