/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.api.DMLScript;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.DMLScriptException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.cp.BuiltinUnaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.DoubleObject;
import org.apache.sysml.runtime.instructions.cp.IntObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.cp.StringObject;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.SimpleOperator;

public class ScalarBuiltinCPInstruction
extends BuiltinUnaryCPInstruction {
    public ScalarBuiltinCPInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String instr) {
        super(op, in, out, 1, opcode, instr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        String opcode = this.getOpcode();
        SimpleOperator dop = (SimpleOperator)this._optr;
        ScalarObject sores = null;
        ScalarObject so = null;
        so = ec.getScalarInput(this.input1.getName(), this.input1.getValueType(), this.input1.isLiteral());
        if (opcode.equalsIgnoreCase("print")) {
            String outString = so.getLanguageSpecificStringValue();
            if (!DMLScript.suppressPrint2Stdout()) {
                System.out.println(outString);
            }
            sores = new StringObject(outString);
        } else {
            if (opcode.equalsIgnoreCase("stop")) {
                throw new DMLScriptException(so.getStringValue());
            }
            if (so instanceof IntObject && this.output.getValueType() == Expression.ValueType.INT) {
                long rval = (long)dop.fn.execute(so.getLongValue());
                sores = new IntObject(rval);
            } else {
                double rval = dop.fn.execute(so.getDoubleValue());
                sores = new DoubleObject(rval);
            }
        }
        ec.setScalarOutput(this.output.getName(), sores);
    }
}

