/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.functionobjects.MinusMultiply;
import org.apache.sysml.runtime.functionobjects.PlusMultiply;
import org.apache.sysml.runtime.functionobjects.ValueFunctionWithConstant;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.ArithmeticBinaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.BinaryOperator;

public class PlusMultCPInstruction
extends ArithmeticBinaryCPInstruction {
    public PlusMultCPInstruction(BinaryOperator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String str) {
        super(op, in1, in2, out, opcode, str);
        this.input3 = in3;
    }

    public static PlusMultCPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        CPOperand operand1 = new CPOperand(parts[1]);
        CPOperand operand2 = new CPOperand(parts[3]);
        CPOperand operand3 = new CPOperand(parts[2]);
        CPOperand outOperand = new CPOperand(parts[4]);
        BinaryOperator bOperator = new BinaryOperator(opcode.equals("+*") ? PlusMultiply.getPlusMultiplyFnObject() : MinusMultiply.getMinusMultiplyFnObject());
        return new PlusMultCPInstruction(bOperator, operand1, operand2, operand3, outOperand, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        String output_name = this.output.getName();
        MatrixBlock matrix1 = ec.getMatrixInput(this.input1.getName());
        MatrixBlock matrix2 = ec.getMatrixInput(this.input2.getName());
        ScalarObject scalar = ec.getScalarInput(this.input3.getName(), this.input3.getValueType(), this.input3.isLiteral());
        ((ValueFunctionWithConstant)((BinaryOperator)this._optr).fn).setConstant(scalar.getDoubleValue());
        MatrixBlock out = (MatrixBlock)matrix1.binaryOperations((BinaryOperator)this._optr, matrix2, new MatrixBlock());
        ec.releaseMatrixInput(this.input1.getName());
        ec.releaseMatrixInput(this.input2.getName());
        ec.setMatrixOutput(output_name, out);
    }
}

