/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.api.DMLScript;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.IndexingCPInstruction;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.util.IndexRange;
import org.apache.sysml.utils.Statistics;

public final class MatrixIndexingCPInstruction
extends IndexingCPInstruction {
    public MatrixIndexingCPInstruction(Operator op, CPOperand in, CPOperand rl, CPOperand ru, CPOperand cl, CPOperand cu, CPOperand out, String opcode, String istr) {
        super(op, in, rl, ru, cl, cu, out, opcode, istr);
    }

    public MatrixIndexingCPInstruction(Operator op, CPOperand lhsInput, CPOperand rhsInput, CPOperand rl, CPOperand ru, CPOperand cl, CPOperand cu, CPOperand out, String opcode, String istr) {
        super(op, lhsInput, rhsInput, rl, ru, cl, cu, out, opcode, istr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        String opcode = this.getOpcode();
        IndexRange ixrange = this.getIndexRange(ec);
        MatrixObject mo = ec.getMatrixObject(this.input1.getName());
        if (opcode.equalsIgnoreCase("rangeReIndex")) {
            MatrixBlock resultBlock = null;
            if (mo.isPartitioned()) {
                resultBlock = mo.readMatrixPartition(ixrange.add(1));
            } else {
                MatrixBlock matBlock = ec.getMatrixInput(this.input1.getName());
                resultBlock = matBlock.sliceOperations(ixrange, new MatrixBlock());
                ec.releaseMatrixInput(this.input1.getName());
                resultBlock.examSparsity();
            }
            ec.setMatrixOutput(this.output.getName(), resultBlock);
        } else if (opcode.equalsIgnoreCase("leftIndex")) {
            MatrixObject.UpdateType updateType = mo.getUpdateType();
            if (DMLScript.STATISTICS) {
                if (updateType.isInPlace()) {
                    Statistics.incrementTotalLixUIP();
                }
                Statistics.incrementTotalLix();
            }
            MatrixBlock matBlock = ec.getMatrixInput(this.input1.getName());
            MatrixBlock resultBlock = null;
            if (this.input2.getDataType() == Expression.DataType.MATRIX) {
                MatrixBlock rhsMatBlock = ec.getMatrixInput(this.input2.getName());
                resultBlock = matBlock.leftIndexingOperations(rhsMatBlock, ixrange, new MatrixBlock(), updateType);
                ec.releaseMatrixInput(this.input2.getName());
            } else {
                if (!ixrange.isScalar()) {
                    throw new DMLRuntimeException("Invalid index range of scalar leftindexing: " + ixrange.toString() + ".");
                }
                ScalarObject scalar = ec.getScalarInput(this.input2.getName(), Expression.ValueType.DOUBLE, this.input2.isLiteral());
                resultBlock = matBlock.leftIndexingOperations(scalar, (int)ixrange.rowStart, (int)ixrange.colStart, new MatrixBlock(), updateType);
            }
            ec.releaseMatrixInput(this.input1.getName());
            resultBlock.examSparsity();
            ec.setMatrixOutput(this.output.getName(), resultBlock, updateType);
        } else {
            throw new DMLRuntimeException("Invalid opcode (" + opcode + ") encountered in MatrixIndexingCPInstruction.");
        }
    }
}

