/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.Operator;

public abstract class ComputationCPInstruction
extends CPInstruction {
    public CPOperand output;
    public CPOperand input1;
    public CPOperand input2;
    public CPOperand input3;

    public ComputationCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(op, opcode, istr);
        this.input1 = in1;
        this.input2 = in2;
        this.input3 = null;
        this.output = out;
    }

    public ComputationCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String istr) {
        super(op, opcode, istr);
        this.input1 = in1;
        this.input2 = in2;
        this.input3 = in3;
        this.output = out;
    }

    public String getOutputVariableName() {
        return this.output.getName();
    }

    protected boolean checkGuardedRepresentationChange(MatrixBlock in1, MatrixBlock out) {
        return this.checkGuardedRepresentationChange(in1, null, out);
    }

    protected boolean checkGuardedRepresentationChange(MatrixBlock in1, MatrixBlock in2, MatrixBlock out) {
        double memDense = OptimizerUtils.estimateSize(out.getNumRows(), out.getNumColumns());
        double memIn1 = in1 != null ? (double)in1.getInMemorySize() : 0.0;
        double memIn2 = in2 != null ? (double)in2.getInMemorySize() : 0.0;
        return memDense < memIn1 + memIn2;
    }
}

