/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.compress.CompressedMatrixBlock;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class CompressionCPInstruction
extends UnaryCPInstruction {
    public CompressionCPInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String istr) {
        super(op, in, null, null, out, opcode, istr);
    }

    public static Instruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        return new CompressionCPInstruction(null, in1, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        MatrixBlock in = ec.getMatrixInput(this.input1.getName());
        CompressedMatrixBlock cmb = new CompressedMatrixBlock(in);
        cmb.compress(OptimizerUtils.getConstrainedNumThreads(-1));
        ec.releaseMatrixInput(this.input1.getName());
        ec.setMatrixOutput(this.output.getName(), cmb);
    }
}

