/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.BinaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.BooleanObject;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.matrix.operators.BinaryOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class BooleanBinaryCPInstruction
extends BinaryCPInstruction {
    public BooleanBinaryCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(op, in1, in2, out, opcode, istr);
        this._cptype = CPInstruction.CPINSTRUCTION_TYPE.BooleanBinary;
    }

    public static BooleanBinaryCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        CPOperand in1 = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        CPOperand in2 = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        CPOperand out = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        String opcode = BooleanBinaryCPInstruction.parseBinaryInstruction(str, in1, in2, out);
        Expression.ValueType vt1 = in1.getValueType();
        Expression.ValueType vt2 = in2.getValueType();
        Expression.ValueType vt3 = out.getValueType();
        if (vt1 != Expression.ValueType.BOOLEAN || vt3 != Expression.ValueType.BOOLEAN || vt2 != null && vt2 != Expression.ValueType.BOOLEAN) {
            throw new DMLRuntimeException("Unexpected ValueType in ArithmeticInstruction.");
        }
        BinaryOperator bop = InstructionUtils.parseBinaryOperator(opcode);
        return new BooleanBinaryCPInstruction(bop, in1, in2, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        ScalarObject so1 = ec.getScalarInput(this.input1.getName(), this.input1.getValueType(), this.input1.isLiteral());
        ScalarObject so2 = ec.getScalarInput(this.input2.getName(), this.input2.getValueType(), this.input2.isLiteral());
        BinaryOperator dop = (BinaryOperator)this._optr;
        boolean rval = dop.fn.execute(so1.getBooleanValue(), so2.getBooleanValue());
        BooleanObject sores = new BooleanObject(rval);
        ec.setScalarOutput(this.output.getName(), sores);
    }
}

