/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysml.runtime.instructions.cp.DoubleObject;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.AggregateTernaryOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class AggregateTernaryCPInstruction
extends ComputationCPInstruction {
    public AggregateTernaryCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String istr) {
        super(op, in1, in2, in3, out, opcode, istr);
        this._cptype = CPInstruction.CPINSTRUCTION_TYPE.AggregateTernary;
    }

    public static AggregateTernaryCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("tak+*") || opcode.equalsIgnoreCase("tack+*")) {
            InstructionUtils.checkNumFields(parts, 5);
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand in2 = new CPOperand(parts[2]);
            CPOperand in3 = new CPOperand(parts[3]);
            CPOperand out = new CPOperand(parts[4]);
            int numThreads = Integer.parseInt(parts[5]);
            AggregateTernaryOperator op = InstructionUtils.parseAggregateTernaryOperator(opcode, numThreads);
            return new AggregateTernaryCPInstruction(op, in1, in2, in3, out, opcode, str);
        }
        throw new DMLRuntimeException("AggregateTernaryInstruction.parseInstruction():: Unknown opcode " + opcode);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        MatrixBlock matBlock1 = ec.getMatrixInput(this.input1.getName());
        MatrixBlock matBlock2 = ec.getMatrixInput(this.input2.getName());
        MatrixBlock matBlock3 = this.input3.isLiteral() ? null : ec.getMatrixInput(this.input3.getName());
        AggregateTernaryOperator ab_op = (AggregateTernaryOperator)this._optr;
        MatrixBlock ret = matBlock1.aggregateTernaryOperations(matBlock1, matBlock2, matBlock3, new MatrixBlock(), ab_op, true);
        ec.releaseMatrixInput(this.input1.getName());
        ec.releaseMatrixInput(this.input2.getName());
        if (!this.input3.isLiteral()) {
            ec.releaseMatrixInput(this.input3.getName());
        }
        if (this.output.getDataType().isScalar()) {
            ec.setScalarOutput(this.output.getName(), new DoubleObject(ret.quickGetValue(0, 0)));
        } else {
            ec.setMatrixOutput(this.output.getName(), ret);
        }
    }
}

