/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor.opt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.AggBinaryOp;
import org.apache.sysml.hops.DataGenOp;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.FunctionOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.IndexingOp;
import org.apache.sysml.hops.LeftIndexingOp;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.ParameterizedBuiltinOp;
import org.apache.sysml.hops.ReorgOp;
import org.apache.sysml.hops.UnaryOp;
import org.apache.sysml.hops.recompile.Recompiler;
import org.apache.sysml.hops.rewrite.HopRewriteUtils;
import org.apache.sysml.hops.rewrite.ProgramRewriteStatus;
import org.apache.sysml.hops.rewrite.ProgramRewriter;
import org.apache.sysml.hops.rewrite.RewriteInjectSparkLoopCheckpointing;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.FunctionStatementBlock;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.ParForStatement;
import org.apache.sysml.parser.ParForStatementBlock;
import org.apache.sysml.parser.StatementBlock;
import org.apache.sysml.parser.VariableSet;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.ForProgramBlock;
import org.apache.sysml.runtime.controlprogram.FunctionProgramBlock;
import org.apache.sysml.runtime.controlprogram.IfProgramBlock;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.ProgramBlock;
import org.apache.sysml.runtime.controlprogram.WhileProgramBlock;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.controlprogram.parfor.ProgramConverter;
import org.apache.sysml.runtime.controlprogram.parfor.opt.CostEstimator;
import org.apache.sysml.runtime.controlprogram.parfor.opt.OptNode;
import org.apache.sysml.runtime.controlprogram.parfor.opt.OptTree;
import org.apache.sysml.runtime.controlprogram.parfor.opt.OptTreeConverter;
import org.apache.sysml.runtime.controlprogram.parfor.opt.OptTreePlanMappingAbstract;
import org.apache.sysml.runtime.controlprogram.parfor.opt.Optimizer;
import org.apache.sysml.runtime.controlprogram.parfor.opt.ProgramRecompiler;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.FunctionCallCPInstruction;
import org.apache.sysml.runtime.instructions.spark.data.RDDObject;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MatrixFormatMetaData;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.utils.Explain;
import org.apache.sysml.yarn.ropt.YarnClusterAnalyzer;

public class OptimizerRuleBased
extends Optimizer {
    public static final double PROB_SIZE_THRESHOLD_REMOTE = 100.0;
    public static final double PROB_SIZE_THRESHOLD_PARTITIONING = 2.0;
    public static final double PROB_SIZE_THRESHOLD_MB = 2.68435456E8;
    public static final int MAX_REPLICATION_FACTOR_PARTITIONING = 5;
    public static final int MAX_REPLICATION_FACTOR_EXPORT = 7;
    public static final boolean ALLOW_REMOTE_NESTED_PARALLELISM = false;
    public static final boolean APPLY_REWRITE_NESTED_PARALLELISM = false;
    public static final String FUNCTION_UNFOLD_NAMEPREFIX = "__unfold_";
    public static final boolean APPLY_REWRITE_UPDATE_INPLACE_INTERMEDIATE = true;
    public static final double PAR_K_FACTOR = 1.0;
    public static final double PAR_K_MR_FACTOR = 1.0;
    protected long _N = -1L;
    protected long _Nmax = -1L;
    protected int _lk = -1;
    protected int _lkmaxCP = -1;
    protected int _lkmaxMR = -1;
    protected int _rnk = -1;
    protected int _rk = -1;
    protected int _rk2 = -1;
    protected int _rkmax = -1;
    protected int _rkmax2 = -1;
    protected double _lm = -1.0;
    protected double _rm = -1.0;
    protected double _rm2 = -1.0;
    protected CostEstimator _cost = null;
    protected static ThreadLocal<ArrayList<String>> listUIPRes = new ThreadLocal<ArrayList<String>>(){

        @Override
        protected ArrayList<String> initialValue() {
            return new ArrayList<String>();
        }
    };

    @Override
    public Optimizer.CostModelType getCostModelType() {
        return Optimizer.CostModelType.STATIC_MEM_METRIC;
    }

    @Override
    public Optimizer.PlanInputType getPlanInputType() {
        return Optimizer.PlanInputType.ABSTRACT_PLAN;
    }

    @Override
    public ParForProgramBlock.POptMode getOptMode() {
        return ParForProgramBlock.POptMode.RULEBASED;
    }

    @Override
    public boolean optimize(ParForStatementBlock sb, ParForProgramBlock pb, OptTree plan, CostEstimator est, ExecutionContext ec) throws DMLRuntimeException {
        LOG.debug((Object)("--- " + (Object)((Object)this.getOptMode()) + " OPTIMIZER -------"));
        OptNode pn = plan.getRoot();
        if (pn.isLeaf()) {
            return true;
        }
        this.analyzeProblemAndInfrastructure(pn);
        this._cost = est;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: Optimize w/ max_mem=" + OptimizerRuleBased.toMB(this._lm) + "/" + OptimizerRuleBased.toMB(this._rm) + "/" + OptimizerRuleBased.toMB(this._rm2) + ", max_k=" + this._lk + "/" + this._rk + "/" + this._rk2 + ")."));
        if (this._rnk <= 0 || this._rk <= 0) {
            LOG.warn((Object)((Object)((Object)this.getOptMode()) + " OPT: Optimize for inactive cluster (num_nodes=" + this._rnk + ", num_map_slots=" + this._rk + ")."));
        }
        pn.setSerialParFor();
        double M0a = this._cost.getEstimate(CostEstimator.TestMeasure.MEMORY_USAGE, pn);
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: estimated mem (serial exec) M=" + OptimizerRuleBased.toMB(M0a)));
        HashMap<String, ParForProgramBlock.PartitionFormat> partitionedMatrices = new HashMap<String, ParForProgramBlock.PartitionFormat>();
        this.rewriteSetDataPartitioner(pn, ec.getVariables(), partitionedMatrices, OptimizerUtils.getLocalMemBudget());
        double M0b = this._cost.getEstimate(CostEstimator.TestMeasure.MEMORY_USAGE, pn);
        this.rewriteRemoveUnnecessaryCompareMatrix(pn, ec);
        boolean flagLIX = this.rewriteSetResultPartitioning(pn, M0b, ec.getVariables());
        double M1 = this._cost.getEstimate(CostEstimator.TestMeasure.MEMORY_USAGE, pn);
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: estimated new mem (serial exec) M=" + OptimizerRuleBased.toMB(M1)));
        double M2 = this._cost.getEstimate(CostEstimator.TestMeasure.MEMORY_USAGE, pn, LopProperties.ExecType.CP);
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: estimated new mem (serial exec, all CP) M=" + OptimizerRuleBased.toMB(M2)));
        double M3 = this._cost.getEstimate(CostEstimator.TestMeasure.MEMORY_USAGE, pn, true);
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: estimated new mem (cond partitioning) M=" + OptimizerRuleBased.toMB(M3)));
        boolean flagRecompMR = this.rewriteSetExecutionStategy(pn, M0a, M1, M2, M3, flagLIX);
        if (pn.getExecType() == this.getRemoteExecType()) {
            if (M1 > this._rm && M3 <= this._rm) {
                this.rewriteSetDataPartitioner(pn, ec.getVariables(), partitionedMatrices, M3);
                M1 = this._cost.getEstimate(CostEstimator.TestMeasure.MEMORY_USAGE, pn);
            }
            if (flagRecompMR) {
                this.rewriteSetOperationsExecType(pn, flagRecompMR);
                M1 = this._cost.getEstimate(CostEstimator.TestMeasure.MEMORY_USAGE, pn);
            }
            this.rewriteDataColocation(pn, ec.getVariables());
            this.rewriteSetPartitionReplicationFactor(pn, partitionedMatrices, ec.getVariables());
            this.rewriteSetExportReplicationFactor(pn, ec.getVariables());
            boolean flagNested = this.rewriteNestedParallelism(pn, M1, flagLIX);
            this.rewriteSetDegreeOfParallelism(pn, M1, flagNested);
            this.rewriteSetTaskPartitioner(pn, flagNested, flagLIX);
            this.rewriteSetFusedDataPartitioningExecution(pn, M1, flagLIX, partitionedMatrices, ec.getVariables());
            this.rewriteSetTranposeSparseVectorOperations(pn, partitionedMatrices, ec.getVariables());
            HashSet<String> inplaceResultVars = new HashSet<String>();
            this.rewriteSetInPlaceResultIndexing(pn, M1, ec.getVariables(), inplaceResultVars, ec);
            this.rewriteDisableCPCaching(pn, inplaceResultVars, ec.getVariables());
        } else {
            this.rewriteSetDegreeOfParallelism(pn, M1, false);
            this.rewriteSetTaskPartitioner(pn, false, false);
            HashSet<String> inplaceResultVars = new HashSet<String>();
            this.rewriteSetInPlaceResultIndexing(pn, M1, ec.getVariables(), inplaceResultVars, ec);
            if (!OptimizerUtils.isSparkExecutionMode()) {
                this.rewriteEnableRuntimePiggybacking(pn, ec.getVariables(), partitionedMatrices);
            } else {
                this.rewriteInjectSparkLoopCheckpointing(pn);
                this.rewriteInjectSparkRepartition(pn, ec.getVariables());
                this.rewriteSetSparkEagerRDDCaching(pn, ec.getVariables());
            }
        }
        this.rewriteSetResultMerge(pn, ec.getVariables(), true);
        this.rewriteSetRecompileMemoryBudget(pn);
        this.rewriteRemoveRecursiveParFor(pn, ec.getVariables());
        this.rewriteRemoveUnnecessaryParFor(pn);
        this._numTotalPlans = -1L;
        return true;
    }

    protected void analyzeProblemAndInfrastructure(OptNode pn) {
        this._N = Long.parseLong(pn.getParam(OptNode.ParamType.NUM_ITERATIONS));
        this._Nmax = pn.getMaxProblemSize();
        this._lk = InfrastructureAnalyzer.getLocalParallelism();
        this._lkmaxCP = (int)Math.ceil(1.0 * (double)this._lk);
        this._lkmaxMR = (int)Math.ceil(1.0 * (double)this._lk);
        this._lm = OptimizerUtils.getLocalMemBudget();
        if (OptimizerUtils.isSparkExecutionMode()) {
            this._rnk = SparkExecutionContext.getNumExecutors();
            this._rk2 = this._rk = SparkExecutionContext.getDefaultParallelism(true);
            int cores = SparkExecutionContext.getDefaultParallelism(true) / SparkExecutionContext.getNumExecutors();
            int ccores = (int)Math.min((long)cores, this._N);
            this._rm = SparkExecutionContext.getBroadcastMemoryBudget() / (double)ccores;
            this._rm2 = SparkExecutionContext.getBroadcastMemoryBudget() / (double)ccores;
        } else {
            this._rnk = InfrastructureAnalyzer.getRemoteParallelNodes();
            this._rk = InfrastructureAnalyzer.getRemoteParallelMapTasks();
            this._rk2 = InfrastructureAnalyzer.getRemoteParallelReduceTasks();
            this._rm = OptimizerUtils.getRemoteMemBudgetMap(false);
            this._rm2 = OptimizerUtils.getRemoteMemBudgetReduce();
            if (InfrastructureAnalyzer.isYarnEnabled()) {
                long tmprk = YarnClusterAnalyzer.getNumCores();
                this._rk = (int)Math.max((long)this._rk, tmprk);
                this._rk2 = (int)Math.max((long)this._rk2, tmprk / 2L);
            }
        }
        this._rkmax = (int)Math.ceil(1.0 * (double)this._rk);
        this._rkmax2 = (int)Math.ceil(1.0 * (double)this._rk2);
    }

    protected OptNode.ExecType getRemoteExecType() {
        return OptimizerUtils.isSparkExecutionMode() ? OptNode.ExecType.SPARK : OptNode.ExecType.MR;
    }

    protected boolean rewriteSetDataPartitioner(OptNode n, LocalVariableMap vars, HashMap<String, ParForProgramBlock.PartitionFormat> partitionedMatrices, double thetaM) throws DMLRuntimeException {
        if (n.getNodeType() != OptNode.NodeType.PARFOR) {
            LOG.warn((Object)((Object)((Object)this.getOptMode()) + " OPT: Data partitioner can only be set for a ParFor node."));
        }
        boolean blockwise = false;
        long id = n.getID();
        Object[] o = OptTreeConverter.getAbstractPlanMapping().getMappedProg(id);
        ParForStatementBlock pfsb = (ParForStatementBlock)o[0];
        ParForProgramBlock pfpb = (ParForProgramBlock)o[1];
        boolean apply = false;
        if (OptimizerUtils.isHybridExecutionMode() && ((double)this._N >= 2.0 || (double)this._Nmax >= 2.0)) {
            ArrayList<String> cand = pfsb.getReadOnlyParentVars();
            HashMap<String, ParForProgramBlock.PartitionFormat> cand2 = new HashMap<String, ParForProgramBlock.PartitionFormat>();
            for (String c : cand) {
                ParForProgramBlock.PartitionFormat dpf = pfsb.determineDataPartitionFormat(c);
                if (dpf == ParForProgramBlock.PartitionFormat.NONE || dpf._dpf == ParForProgramBlock.PDataPartitionFormat.BLOCK_WISE_M_N) continue;
                cand2.put(c, dpf);
            }
            apply = this.rFindDataPartitioningCandidates(n, cand2, vars, thetaM);
            if (apply) {
                partitionedMatrices.putAll(cand2);
            }
        }
        ParForProgramBlock.PDataPartitioner REMOTE = OptimizerUtils.isSparkExecutionMode() ? ParForProgramBlock.PDataPartitioner.REMOTE_SPARK : ParForProgramBlock.PDataPartitioner.REMOTE_MR;
        ParForProgramBlock.PDataPartitioner pdp = apply ? REMOTE : ParForProgramBlock.PDataPartitioner.NONE;
        pfpb.setDataPartitioner(pdp);
        n.addParam(OptNode.ParamType.DATA_PARTITIONER, pdp.toString());
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'set data partitioner' - result=" + pdp.toString() + " (" + ProgramConverter.serializeStringCollection(partitionedMatrices.keySet()) + ")"));
        return blockwise;
    }

    protected boolean rFindDataPartitioningCandidates(OptNode n, HashMap<String, ParForProgramBlock.PartitionFormat> cand, LocalVariableMap vars, double thetaM) throws DMLRuntimeException {
        Hop h;
        String inMatrix;
        boolean ret = false;
        if (!n.isLeaf()) {
            for (OptNode cn : n.getChilds()) {
                if (cn.getNodeType() == OptNode.NodeType.FUNCCALL) continue;
                ret |= this.rFindDataPartitioningCandidates(cn, cand, vars, thetaM);
            }
        } else if (n.getNodeType() == OptNode.NodeType.HOP && n.getParam(OptNode.ParamType.OPSTRING).equals(IndexingOp.OPSTRING) && cand.containsKey(inMatrix = (h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID())).getInput().get(0).getName())) {
            ParForProgramBlock.PartitionFormat dpf = cand.get(inMatrix);
            double mnew = this.getNewRIXMemoryEstimate(n, inMatrix, dpf, vars);
            if (n.getExecType() == this.getRemoteExecType() || h.getMemEstimate() > thetaM) {
                n.setExecType(OptNode.ExecType.CP);
                n.addParam(OptNode.ParamType.DATA_PARTITION_FORMAT, dpf.toString());
                h.setMemEstimate(mnew);
                ret = true;
            } else {
                n.addParam(OptNode.ParamType.DATA_PARTITION_COND, String.valueOf(true));
                n.addParam(OptNode.ParamType.DATA_PARTITION_COND_MEM, String.valueOf(mnew));
            }
        }
        return ret;
    }

    protected double getNewRIXMemoryEstimate(OptNode n, String varName, ParForProgramBlock.PartitionFormat dpf, LocalVariableMap vars) throws DMLRuntimeException {
        double mem = -1.0;
        Data dat = vars.get(varName);
        if (dat != null) {
            MatrixObject mo = (MatrixObject)dat;
            switch (dpf._dpf) {
                case COLUMN_WISE: {
                    mem = OptimizerUtils.estimateSize(mo.getNumRows(), 1L);
                    break;
                }
                case ROW_WISE: {
                    mem = OptimizerUtils.estimateSize(1L, mo.getNumColumns());
                    break;
                }
                case COLUMN_BLOCK_WISE_N: {
                    mem = OptimizerUtils.estimateSize(mo.getNumRows(), dpf._N);
                    break;
                }
                case ROW_BLOCK_WISE_N: {
                    mem = OptimizerUtils.estimateSize(dpf._N, mo.getNumColumns());
                    break;
                }
            }
        }
        return mem;
    }

    protected static LopProperties.ExecType getRIXExecType(MatrixObject mo, ParForProgramBlock.PDataPartitionFormat dpf, boolean withSparsity) throws DMLRuntimeException {
        double mem = -1.0;
        long rlen = mo.getNumRows();
        long clen = mo.getNumColumns();
        long brlen = mo.getNumRowsPerBlock();
        long bclen = mo.getNumColumnsPerBlock();
        long nnz = mo.getNnz();
        double lsparsity = (double)nnz / (double)rlen / (double)clen;
        double sparsity = withSparsity ? lsparsity : 1.0;
        switch (dpf) {
            case COLUMN_WISE: {
                mem = OptimizerUtils.estimateSizeExactSparsity(mo.getNumRows(), 1L, sparsity);
                break;
            }
            case COLUMN_BLOCK_WISE: {
                mem = OptimizerUtils.estimateSizeExactSparsity(mo.getNumRows(), bclen, sparsity);
                break;
            }
            case ROW_WISE: {
                mem = OptimizerUtils.estimateSizeExactSparsity(1L, mo.getNumColumns(), sparsity);
                break;
            }
            case ROW_BLOCK_WISE: {
                mem = OptimizerUtils.estimateSizeExactSparsity(brlen, mo.getNumColumns(), sparsity);
                break;
            }
        }
        if (mem < OptimizerUtils.getLocalMemBudget()) {
            return LopProperties.ExecType.CP;
        }
        return LopProperties.ExecType.CP_FILE;
    }

    public static boolean allowsBinaryCellPartitions(MatrixObject mo, ParForProgramBlock.PartitionFormat dpf) throws DMLRuntimeException {
        return OptimizerRuleBased.getRIXExecType(mo, ParForProgramBlock.PDataPartitionFormat.COLUMN_BLOCK_WISE, false) == LopProperties.ExecType.CP;
    }

    protected boolean rewriteSetResultPartitioning(OptNode n, double M, LocalVariableMap vars) throws DMLRuntimeException {
        boolean apply;
        long id = n.getID();
        Object[] o = OptTreeConverter.getAbstractPlanMapping().getMappedProg(id);
        ParForProgramBlock pfpb = (ParForProgramBlock)o[1];
        Collection<OptNode> cand = n.getNodeList(this.getRemoteExecType());
        boolean bl = apply = M < this._rm && !cand.isEmpty() && this.isResultPartitionableAll(cand, pfpb.getResultVariables(), vars, pfpb.getIterablePredicateVars()[0]);
        if (apply) {
            try {
                for (OptNode lix : cand) {
                    this.recompileLIX(lix, vars);
                }
            }
            catch (Exception ex) {
                throw new DMLRuntimeException("Unable to recompile LIX.", ex);
            }
        }
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'set result partitioning' - result=" + apply));
        return apply;
    }

    protected boolean isResultPartitionableAll(Collection<OptNode> nlist, ArrayList<String> resultVars, LocalVariableMap vars, String iterVarname) throws DMLRuntimeException {
        boolean ret = true;
        for (OptNode n : nlist) {
            if (!(ret &= this.isResultPartitionable(n, resultVars, vars, iterVarname))) break;
        }
        return ret;
    }

    protected boolean isResultPartitionable(OptNode n, ArrayList<String> resultVars, LocalVariableMap vars, String iterVarname) throws DMLRuntimeException {
        boolean ret = true;
        String opStr = n.getParam(OptNode.ParamType.OPSTRING);
        if (opStr == null || !opStr.equals(LeftIndexingOp.OPSTRING)) {
            ret = false;
        }
        Hop h = null;
        Hop base = null;
        if (ret && !resultVars.contains((base = (h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID())).getInput().get(0)).getName())) {
            ret = false;
        }
        if (ret) {
            int dpf = 0;
            Hop inpRowL = h.getInput().get(2);
            Hop inpRowU = h.getInput().get(3);
            Hop inpColL = h.getInput().get(4);
            Hop inpColU = h.getInput().get(5);
            if (inpRowL.getName().equals(iterVarname) && inpRowU.getName().equals(iterVarname)) {
                dpf = 1;
            }
            if (inpColL.getName().equals(iterVarname) && inpColU.getName().equals(iterVarname)) {
                int n2 = dpf = dpf == 0 ? 2 : 3;
            }
            if (dpf == 0) {
                ret = false;
            } else {
                boolean sparse;
                MatrixObject mo = (MatrixObject)vars.get(base.getName());
                if (mo.getNnz() != 0L) {
                    ret = false;
                }
                if (sparse = MatrixBlock.evalSparseFormatInMemory(base.getDim1(), base.getDim2(), base.getDim1())) {
                    double memSparseBlock = this.estimateSizeSparseRowBlock(base.getDim1());
                    double memSparseRow1 = this.estimateSizeSparseRow(base.getDim2(), base.getDim2());
                    double memSparseRowMin = this.estimateSizeSparseRowMin(base.getDim2());
                    double memTask1 = -1.0;
                    int taskN = -1;
                    switch (dpf) {
                        case 1: {
                            memTask1 = memSparseBlock + memSparseRow1;
                            taskN = (int)((this._rm - memSparseBlock) / memSparseRow1);
                            break;
                        }
                        case 2: {
                            memTask1 = memSparseBlock + memSparseRowMin * (double)base.getDim1();
                            taskN = this.estimateNumTasksSparseCol(this._rm - memSparseBlock, base.getDim1());
                            break;
                        }
                        case 3: {
                            memTask1 = memSparseBlock + memSparseRowMin;
                            taskN = (int)((this._rm - memSparseBlock) / memSparseRowMin);
                        }
                    }
                    if (memTask1 > this._rm || memTask1 < 0.0) {
                        ret = false;
                    } else {
                        n.addParam(OptNode.ParamType.TASK_SIZE, String.valueOf(taskN));
                    }
                } else {
                    ret = false;
                }
            }
        }
        return ret;
    }

    private double estimateSizeSparseRowBlock(long rows) {
        return 44L + rows * 8L;
    }

    private double estimateSizeSparseRow(long cols, long nnz) {
        long cnnz = Math.max(4L, Math.max(cols, nnz));
        return 116L + 12L * cnnz;
    }

    private double estimateSizeSparseRowMin(long cols) {
        long cnnz = Math.min(4L, cols);
        return 116L + 12L * cnnz;
    }

    private int estimateNumTasksSparseCol(double budget, long rows) {
        double lbudget = budget - (double)(rows * 116L);
        return (int)Math.floor(lbudget / 12.0);
    }

    protected void recompileLIX(OptNode n, LocalVariableMap vars) throws DMLRuntimeException, HopsException, LopsException, IOException {
        Hop h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID());
        h.setForcedExecType(LopProperties.ExecType.CP);
        n.setExecType(OptNode.ExecType.CP);
        long pid = OptTreeConverter.getAbstractPlanMapping().getMappedParentID(n.getID());
        OptNode nParent = OptTreeConverter.getAbstractPlanMapping().getOptNode(pid);
        Object[] o = OptTreeConverter.getAbstractPlanMapping().getMappedProg(pid);
        StatementBlock sb = (StatementBlock)o[0];
        ProgramBlock pb = (ProgramBlock)o[1];
        HashMap<Hop, Double> estRix = this.getPartitionedRIXEstimates(nParent);
        ArrayList<Instruction> newInst = Recompiler.recompileHopsDag(sb, sb.get_hops(), vars, null, false, 0L);
        pb.setInstructions(newInst);
        this.resetPartitionRIXEstimates(estRix);
        h.setMemEstimate(this._rm - 1.0);
    }

    protected HashMap<Hop, Double> getPartitionedRIXEstimates(OptNode parent) {
        HashMap<Hop, Double> estimates = new HashMap<Hop, Double>();
        for (OptNode n : parent.getChilds()) {
            if (n.getParam(OptNode.ParamType.DATA_PARTITION_FORMAT) == null) continue;
            Hop h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID());
            estimates.put(h, h.getMemEstimate());
        }
        return estimates;
    }

    protected void resetPartitionRIXEstimates(HashMap<Hop, Double> estimates) {
        for (Map.Entry<Hop, Double> e : estimates.entrySet()) {
            Hop h = e.getKey();
            double val = e.getValue();
            h.setMemEstimate(val);
        }
    }

    protected boolean rewriteSetExecutionStategy(OptNode n, double M0, double M, double M2, double M3, boolean flagLIX) throws DMLRuntimeException {
        ParForProgramBlock.PDataPartitioner REMOTE_DP;
        boolean isCPOnly = n.isCPOnly();
        boolean isCPOnlyPossible = isCPOnly || this.isCPOnlyPossible(n, this._rm);
        String datapartitioner = n.getParam(OptNode.ParamType.DATA_PARTITIONER);
        OptNode.ExecType REMOTE = this.getRemoteExecType();
        ParForProgramBlock.PDataPartitioner pDataPartitioner = REMOTE_DP = OptimizerUtils.isSparkExecutionMode() ? ParForProgramBlock.PDataPartitioner.REMOTE_SPARK : ParForProgramBlock.PDataPartitioner.REMOTE_MR;
        if (ConfigurationManager.isParallelParFor() && (isCPOnly && M <= this._rm || isCPOnly && M3 <= this._rm || isCPOnlyPossible && M2 <= this._rm)) {
            int cpk = (int)Math.min((double)this._lk, Math.floor(this._lm / M));
            if (2 * cpk < this._lk && (long)(2 * cpk) < this._N && 2 * cpk < this._rk) {
                n.setExecType(REMOTE);
            } else if ((long)this._lk < this._N && this._lk < this._rk && M <= this._rm && this.isLargeProblem(n, M0)) {
                n.setExecType(REMOTE);
            } else if (!isCPOnly && isCPOnlyPossible) {
                n.setExecType(REMOTE);
            } else if (flagLIX) {
                n.setExecType(REMOTE);
            } else if (datapartitioner != null && datapartitioner.equals(REMOTE_DP.toString()) && !InfrastructureAnalyzer.isLocalMode()) {
                n.setExecType(REMOTE);
            } else {
                n.setExecType(OptNode.ExecType.CP);
            }
        } else {
            n.setExecType(OptNode.ExecType.CP);
        }
        long id = n.getID();
        ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(id)[1];
        ParForProgramBlock.PExecMode mode = n.getExecType().toParForExecMode();
        pfpb.setExecMode(mode);
        boolean requiresRecompile = (mode == ParForProgramBlock.PExecMode.REMOTE_MR || mode == ParForProgramBlock.PExecMode.REMOTE_SPARK) && !isCPOnly;
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'set execution strategy' - result=" + (Object)((Object)mode) + " (recompile=" + requiresRecompile + ")"));
        return requiresRecompile;
    }

    protected boolean isLargeProblem(OptNode pn, double M0) {
        return ((double)this._N >= 100.0 || (double)this._Nmax >= 1000.0) && M0 > 2.68435456E8;
    }

    protected boolean isCPOnlyPossible(OptNode n, double memBudget) throws DMLRuntimeException {
        double mem;
        Hop h;
        boolean ret;
        OptNode.ExecType et = n.getExecType();
        boolean bl = ret = et == OptNode.ExecType.CP;
        if (n.isLeaf() && et == this.getRemoteExecType() && (h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID())).getForcedExecType() != LopProperties.ExecType.MR && h.getForcedExecType() != LopProperties.ExecType.SPARK && (mem = this._cost.getLeafNodeEstimate(CostEstimator.TestMeasure.MEMORY_USAGE, n, LopProperties.ExecType.CP)) <= memBudget) {
            ret = true;
        }
        if (!n.isLeaf()) {
            for (OptNode c : n.getChilds()) {
                if (!ret) break;
                ret &= this.isCPOnlyPossible(c, memBudget);
            }
        }
        return ret;
    }

    protected void rewriteSetOperationsExecType(OptNode pn, boolean recompile) throws DMLRuntimeException {
        int count = this.setOperationExecType(pn, OptNode.ExecType.CP);
        if (recompile && count <= 0) {
            LOG.warn((Object)"OPT: Forced set operations exec type 'CP', but no operation requires recompile.");
        }
        ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(pn.getID())[1];
        HashSet<String> fnStack = new HashSet<String>();
        Recompiler.recompileProgramBlockHierarchy2Forced(pfpb.getChildBlocks(), 0L, fnStack, LopProperties.ExecType.CP);
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'set operation exec type CP' - result=" + count));
    }

    protected int setOperationExecType(OptNode n, OptNode.ExecType et) {
        int count = 0;
        if (n.getExecType() != OptNode.ExecType.CP && n.getNodeType() == OptNode.NodeType.HOP) {
            n.setExecType(OptNode.ExecType.CP);
            count = 1;
        }
        if (!n.isLeaf()) {
            for (OptNode c : n.getChilds()) {
                count += this.setOperationExecType(c, et);
            }
        }
        return count;
    }

    protected void rewriteDataColocation(OptNode n, LocalVariableMap vars) throws DMLRuntimeException {
        boolean apply = false;
        String varname = null;
        String partitioner = n.getParam(OptNode.ParamType.DATA_PARTITIONER);
        ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(n.getID())[1];
        if (partitioner != null && partitioner.equals(ParForProgramBlock.PDataPartitioner.REMOTE_MR.toString()) && n.getExecType() == OptNode.ExecType.MR) {
            HashSet<String> cand = new HashSet<String>();
            this.rFindDataColocationCandidates(n, cand, pfpb.getIterablePredicateVars()[0]);
            long nnzMax = Long.MIN_VALUE;
            for (String c : cand) {
                long nnzTmp;
                MatrixObject tmp = (MatrixObject)vars.get(c);
                if (tmp == null || (nnzTmp = tmp.getNnz()) <= nnzMax) continue;
                nnzMax = nnzTmp;
                varname = c;
                apply = true;
            }
        }
        if (apply) {
            pfpb.enableColocatedPartitionedMatrix(varname);
        }
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'enable data colocation' - result=" + apply + (apply ? " (" + varname + ")" : "")));
    }

    protected void rFindDataColocationCandidates(OptNode n, HashSet<String> cand, String iterVarname) throws DMLRuntimeException {
        if (!n.isLeaf()) {
            for (OptNode cn : n.getChilds()) {
                this.rFindDataColocationCandidates(cn, cand, iterVarname);
            }
        } else if (n.getNodeType() == OptNode.NodeType.HOP && n.getParam(OptNode.ParamType.OPSTRING).equals(IndexingOp.OPSTRING) && n.getParam(OptNode.ParamType.DATA_PARTITION_FORMAT) != null) {
            ParForProgramBlock.PartitionFormat dpf = ParForProgramBlock.PartitionFormat.valueOf(n.getParam(OptNode.ParamType.DATA_PARTITION_FORMAT));
            Hop h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID());
            String inMatrix = h.getInput().get(0).getName();
            String indexAccess = null;
            switch (dpf._dpf) {
                case ROW_WISE: {
                    if (!(h.getInput().get(1) instanceof DataOp)) break;
                    indexAccess = h.getInput().get(1).getName();
                    break;
                }
                case COLUMN_WISE: {
                    if (!(h.getInput().get(3) instanceof DataOp)) break;
                    indexAccess = h.getInput().get(3).getName();
                    break;
                }
            }
            if (indexAccess != null && indexAccess.equals(iterVarname)) {
                cand.add(inMatrix);
            }
        }
    }

    protected void rewriteSetPartitionReplicationFactor(OptNode n, HashMap<String, ParForProgramBlock.PartitionFormat> partitionedMatrices, LocalVariableMap vars) throws DMLRuntimeException {
        boolean apply = false;
        double sizeReplicated = 0.0;
        int replication = 1;
        ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(n.getID())[1];
        if ((n.getExecType() == OptNode.ExecType.MR && n.getParam(OptNode.ParamType.DATA_PARTITIONER).equals(ParForProgramBlock.PDataPartitioner.REMOTE_MR.name()) || n.getExecType() == OptNode.ExecType.SPARK && n.getParam(OptNode.ParamType.DATA_PARTITIONER).equals(ParForProgramBlock.PDataPartitioner.REMOTE_SPARK.name())) && n.hasNestedParallelism(false) && n.hasNestedPartitionReads(false)) {
            apply = true;
            replication = (int)Math.min(this._N, (long)this._rnk);
            replication = Math.min(replication, 5);
            try {
                FileSystem fs = FileSystem.get((Configuration)ConfigurationManager.getCachedJobConf());
                long hdfsCapacityRemain = fs.getStatus().getRemaining();
                long sizeInputs = 0L;
                for (String var : partitionedMatrices.keySet()) {
                    MatrixObject mo = (MatrixObject)vars.get(var);
                    Path fname = new Path(mo.getFileName());
                    if (!fs.exists(fname)) continue;
                    sizeInputs += fs.getContentSummary(fname).getLength();
                }
                replication = (int)Math.min((double)replication, Math.floor(0.9 * (double)hdfsCapacityRemain / (double)sizeInputs));
                replication = Math.max(replication, 1);
                sizeReplicated = (long)replication * sizeInputs;
            }
            catch (Exception ex) {
                throw new DMLRuntimeException("Failed to analyze remaining hdfs capacity.", ex);
            }
        }
        if (apply) {
            pfpb.setPartitionReplicationFactor(replication);
        }
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'set partition replication factor' - result=" + apply + (apply ? " (" + replication + ", " + OptimizerRuleBased.toMB(sizeReplicated) + ")" : "")));
    }

    protected void rewriteSetExportReplicationFactor(OptNode n, LocalVariableMap vars) throws DMLRuntimeException {
        boolean apply = false;
        int replication = -1;
        ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(n.getID())[1];
        if (n.getExecType() == this.getRemoteExecType()) {
            apply = true;
            replication = (int)Math.min(this._N, (long)this._rnk);
            replication = Math.min(replication, 7);
        }
        if (apply) {
            pfpb.setExportReplicationFactor(replication);
        }
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'set export replication factor' - result=" + apply + (apply ? " (" + replication + ")" : "")));
    }

    protected boolean rewriteNestedParallelism(OptNode n, double M, boolean flagLIX) throws DMLRuntimeException {
        boolean nested = false;
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'enable nested parallelism' - result=" + nested));
        return nested;
    }

    protected void rewriteSetDegreeOfParallelism(OptNode n, double M, boolean flagNested) throws DMLRuntimeException {
        OptNode.ExecType type = n.getExecType();
        long id = n.getID();
        ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(id)[1];
        if (type == OptNode.ExecType.CP) {
            int kMax = ConfigurationManager.isParallelParFor() ? (n.isCPOnly() ? this._lkmaxCP : this._lkmaxMR) : 1;
            double mem = OptimizerUtils.isSparkExecutionMode() && !n.isCPOnly() ? this._lm / 2.0 : this._lm;
            kMax = Math.min(kMax, (int)Math.floor(mem / M));
            kMax = Math.max(kMax, 1);
            int parforK = (int)(this._N < (long)kMax ? this._N : (long)kMax);
            pfpb.setDegreeOfParallelism(parforK);
            n.setK(parforK);
            int remainParforK = (int)Math.ceil((double)(kMax - parforK + 1) / (double)parforK);
            int remainOpsK = Math.max(this._lkmaxCP / parforK, 1);
            this.rAssignRemainingParallelism(n, remainParforK, remainOpsK);
        } else {
            int kMax = -1;
            if (flagNested) {
                pfpb.setDegreeOfParallelism(this._rnk);
                n.setK(this._rnk);
                kMax = this._rkmax / this._rnk;
            } else {
                int tmpK = (int)(this._N < (long)this._rk ? this._N : (long)this._rk);
                pfpb.setDegreeOfParallelism(tmpK);
                n.setK(tmpK);
                kMax = this._rkmax / tmpK;
            }
            kMax = Math.min(kMax, (int)Math.floor(this._rm / M));
            if (kMax < 1) {
                kMax = 1;
            }
            kMax = 1;
            this.rAssignRemainingParallelism(n, kMax, 1);
        }
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'set degree of parallelism' - result=(see EXPLAIN)"));
    }

    protected void rAssignRemainingParallelism(OptNode n, int parforK, int opsK) throws DMLRuntimeException {
        ArrayList<OptNode> childs = n.getChilds();
        if (childs != null) {
            boolean recompileSB = false;
            for (OptNode c : childs) {
                if (c.getNodeType() == OptNode.NodeType.PARFOR) {
                    int tmpN = Integer.parseInt(c.getParam(OptNode.ParamType.NUM_ITERATIONS));
                    int tmpK = tmpN < parforK ? tmpN : parforK;
                    long id = c.getID();
                    c.setK(tmpK);
                    ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(id)[1];
                    pfpb.setDegreeOfParallelism(tmpK);
                    int remainParforK = (int)Math.ceil((double)(parforK - tmpK + 1) / (double)tmpK);
                    int remainOpsK = Math.max(opsK / tmpK, 1);
                    this.rAssignRemainingParallelism(c, remainParforK, remainOpsK);
                    continue;
                }
                if (c.getNodeType() == OptNode.NodeType.HOP) {
                    Hop h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(c.getID());
                    if (!(!ConfigurationManager.isParallelMatrixOperations() || !(h instanceof Hop.MultiThreadedHop) || h instanceof ParameterizedBuiltinOp && ((ParameterizedBuiltinOp)h).getOp() != Hop.ParamBuiltinOp.GROUPEDAGG || h instanceof UnaryOp && !((UnaryOp)h).isCumulativeUnaryOperation() || h instanceof ReorgOp && ((ReorgOp)h).getOp() != Hop.ReOrgOp.TRANSPOSE)) {
                        Hop.MultiThreadedHop mhop = (Hop.MultiThreadedHop)((Object)h);
                        mhop.setMaxNumThreads(opsK);
                        c.setK(opsK);
                        recompileSB = true;
                        continue;
                    }
                    if (!(h instanceof Hop.MultiThreadedHop)) continue;
                    Hop.MultiThreadedHop mhop = (Hop.MultiThreadedHop)((Object)h);
                    mhop.setMaxNumThreads(1);
                    c.setK(1);
                    continue;
                }
                this.rAssignRemainingParallelism(c, parforK, opsK);
            }
            if (recompileSB) {
                try {
                    ProgramBlock pb = (ProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(n.getID())[1];
                    Recompiler.recompileProgramBlockInstructions(pb);
                }
                catch (Exception ex) {
                    throw new DMLRuntimeException(ex);
                }
            }
        }
    }

    protected void rewriteSetTaskPartitioner(OptNode pn, boolean flagNested, boolean flagLIX) {
        if (pn.getNodeType() != OptNode.NodeType.PARFOR) {
            LOG.warn((Object)((Object)((Object)this.getOptMode()) + " OPT: Task partitioner can only be set for a ParFor node."));
        }
        if (flagNested && flagLIX) {
            LOG.warn((Object)((Object)((Object)this.getOptMode()) + " OPT: Task partitioner decision has conflicting input from rewrites 'nested parallelism' and 'result partitioning'."));
        }
        boolean jvmreuse = ConfigurationManager.getDMLConfig().getBooleanValue("jvmreuse");
        if (flagNested) {
            this.setTaskPartitioner(pn, ParForProgramBlock.PTaskPartitioner.STATIC);
            this.setTaskPartitioner(pn.getChilds().get(0), ParForProgramBlock.PTaskPartitioner.FACTORING);
        } else if (flagLIX) {
            this.setTaskPartitioner(pn, ParForProgramBlock.PTaskPartitioner.FACTORING_CMAX);
        } else if ((pn.getExecType() == OptNode.ExecType.MR && !jvmreuse || pn.getExecType() == OptNode.ExecType.SPARK) && pn.hasOnlySimpleChilds()) {
            this.setTaskPartitioner(pn, ParForProgramBlock.PTaskPartitioner.STATIC);
        } else if (this._N / 4L >= (long)pn.getK()) {
            this.setTaskPartitioner(pn, ParForProgramBlock.PTaskPartitioner.FACTORING);
        } else {
            this.setTaskPartitioner(pn, ParForProgramBlock.PTaskPartitioner.NAIVE);
        }
    }

    protected void setTaskPartitioner(OptNode n, ParForProgramBlock.PTaskPartitioner partitioner) {
        boolean flagLIX;
        long id = n.getID();
        ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(id)[1];
        pfpb.setTaskPartitioner(partitioner);
        n.addParam(OptNode.ParamType.TASK_PARTITIONER, partitioner.toString());
        boolean bl = flagLIX = partitioner == ParForProgramBlock.PTaskPartitioner.FACTORING_CMAX;
        if (flagLIX) {
            long maxc = n.getMaxC(this._N);
            pfpb.setTaskSize(maxc);
            pfpb.disableJVMReuse();
            n.addParam(OptNode.ParamType.TASK_SIZE, String.valueOf(maxc));
        }
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'set task partitioner' - result=" + (Object)((Object)partitioner) + (flagLIX ? "," + n.getParam(OptNode.ParamType.TASK_SIZE) : "")));
    }

    protected void rewriteSetFusedDataPartitioningExecution(OptNode pn, double M, boolean flagLIX, HashMap<String, ParForProgramBlock.PartitionFormat> partitionedMatrices, LocalVariableMap vars) throws DMLRuntimeException {
        ParForProgramBlock.PExecMode REMOTE_DPE;
        if (pn.getNodeType() != OptNode.NodeType.PARFOR) {
            LOG.warn((Object)((Object)((Object)this.getOptMode()) + " OPT: Fused data partitioning and execution is only applicable for a ParFor node."));
        }
        boolean apply = false;
        String partitioner = pn.getParam(OptNode.ParamType.DATA_PARTITIONER);
        ParForProgramBlock.PDataPartitioner REMOTE_DP = OptimizerUtils.isSparkExecutionMode() ? ParForProgramBlock.PDataPartitioner.REMOTE_SPARK : ParForProgramBlock.PDataPartitioner.REMOTE_MR;
        ParForProgramBlock.PExecMode pExecMode = REMOTE_DPE = OptimizerUtils.isSparkExecutionMode() ? ParForProgramBlock.PExecMode.REMOTE_SPARK_DP : ParForProgramBlock.PExecMode.REMOTE_MR_DP;
        if ((pn.getExecType() == OptNode.ExecType.MR && M < this._rm2 || pn.getExecType() == OptNode.ExecType.SPARK) && partitioner != null && partitioner.equals(REMOTE_DP.toString()) && partitionedMatrices.size() == 1) {
            ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(pn.getID())[1];
            String moVarname = partitionedMatrices.keySet().iterator().next();
            ParForProgramBlock.PartitionFormat moDpf = partitionedMatrices.get(moVarname);
            MatrixObject mo = (MatrixObject)vars.get(moVarname);
            String iterVarname = pfpb.getIterablePredicateVars()[0];
            if (this.rIsAccessByIterationVariable(pn, moVarname, iterVarname) && (moDpf == ParForProgramBlock.PartitionFormat.ROW_WISE && mo.getNumRows() == this._N || moDpf == ParForProgramBlock.PartitionFormat.COLUMN_WISE && mo.getNumColumns() == this._N || moDpf._dpf == ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE_N && mo.getNumRows() <= this._N * (long)moDpf._N || moDpf._dpf == ParForProgramBlock.PDataPartitionFormat.COLUMN_BLOCK_WISE_N && mo.getNumColumns() <= this._N * (long)moDpf._N)) {
                int k = (int)Math.min(this._N, (long)this._rk2);
                pn.addParam(OptNode.ParamType.DATA_PARTITIONER, REMOTE_DPE.toString() + "(fused)");
                pn.setK(k);
                pfpb.setExecMode(REMOTE_DPE);
                pfpb.setDataPartitioner(ParForProgramBlock.PDataPartitioner.NONE);
                pfpb.enableColocatedPartitionedMatrix(moVarname);
                pfpb.setDegreeOfParallelism(k);
                apply = true;
            }
        }
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'set fused data partitioning and execution' - result=" + apply));
    }

    protected boolean rIsAccessByIterationVariable(OptNode n, String varName, String iterVarname) throws DMLRuntimeException {
        boolean ret = true;
        if (!n.isLeaf()) {
            for (OptNode cn : n.getChilds()) {
                this.rIsAccessByIterationVariable(cn, varName, iterVarname);
            }
        } else if (n.getNodeType() == OptNode.NodeType.HOP && n.getParam(OptNode.ParamType.OPSTRING).equals(IndexingOp.OPSTRING) && n.getParam(OptNode.ParamType.DATA_PARTITION_FORMAT) != null) {
            ParForProgramBlock.PartitionFormat dpf = ParForProgramBlock.PartitionFormat.valueOf(n.getParam(OptNode.ParamType.DATA_PARTITION_FORMAT));
            Hop h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID());
            String inMatrix = h.getInput().get(0).getName();
            String indexAccess = null;
            switch (dpf._dpf) {
                case ROW_WISE: {
                    if (!(h.getInput().get(1) instanceof DataOp)) break;
                    indexAccess = h.getInput().get(1).getName();
                    break;
                }
                case ROW_BLOCK_WISE_N: {
                    indexAccess = OptimizerRuleBased.rGetVarFromExpression(h.getInput().get(1));
                    break;
                }
                case COLUMN_WISE: {
                    if (!(h.getInput().get(3) instanceof DataOp)) break;
                    indexAccess = h.getInput().get(3).getName();
                    break;
                }
                case COLUMN_BLOCK_WISE_N: {
                    indexAccess = OptimizerRuleBased.rGetVarFromExpression(h.getInput().get(3));
                    break;
                }
            }
            ret &= inMatrix != null && inMatrix.equals(varName) && indexAccess != null && indexAccess.equals(iterVarname);
        }
        return ret;
    }

    private static String rGetVarFromExpression(Hop current) {
        String var = null;
        for (Hop c : current.getInput()) {
            var = OptimizerRuleBased.rGetVarFromExpression(c);
            if (var == null) continue;
            return var;
        }
        return current instanceof DataOp ? current.getName() : null;
    }

    protected void rewriteSetTranposeSparseVectorOperations(OptNode pn, HashMap<String, ParForProgramBlock.PartitionFormat> partitionedMatrices, LocalVariableMap vars) throws DMLRuntimeException {
        if (pn.getNodeType() != OptNode.NodeType.PARFOR) {
            LOG.warn((Object)((Object)((Object)this.getOptMode()) + " OPT: Transpose sparse vector operations is only applicable for a ParFor node."));
        }
        boolean apply = false;
        ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(pn.getID())[1];
        if (pfpb.getExecMode() == ParForProgramBlock.PExecMode.REMOTE_MR_DP && partitionedMatrices.size() == 1) {
            String moVarname = partitionedMatrices.keySet().iterator().next();
            ParForProgramBlock.PartitionFormat moDpf = partitionedMatrices.get(moVarname);
            Data dat = vars.get(moVarname);
            if (dat != null && dat instanceof MatrixObject && moDpf == ParForProgramBlock.PartitionFormat.COLUMN_WISE && ((MatrixObject)dat).getSparsity() <= 0.4 && this.rIsTransposeSafePartition(pn, moVarname)) {
                pfpb.setTransposeSparseColumnVector(true);
                apply = true;
            }
        }
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'set transpose sparse vector operations' - result=" + apply));
    }

    protected boolean rIsTransposeSafePartition(OptNode n, String varName) throws DMLRuntimeException {
        boolean ret;
        block3: {
            Hop h;
            String inMatrix;
            block2: {
                ret = true;
                if (n.isLeaf()) break block2;
                for (OptNode cn : n.getChilds()) {
                    this.rIsTransposeSafePartition(cn, varName);
                }
                break block3;
            }
            if (n.getNodeType() != OptNode.NodeType.HOP || !n.getParam(OptNode.ParamType.OPSTRING).equals(IndexingOp.OPSTRING) || n.getParam(OptNode.ParamType.DATA_PARTITION_FORMAT) == null || !(inMatrix = (h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID())).getInput().get(0).getName()).equals(varName)) break block3;
            ArrayList<Hop> parent = h.getParent();
            for (Hop p : parent) {
                ret &= p.isTransposeSafe();
            }
        }
        return ret;
    }

    protected void rewriteSetInPlaceResultIndexing(OptNode pn, double M, LocalVariableMap vars, HashSet<String> inPlaceResultVars, ExecutionContext ec) throws DMLRuntimeException {
        if (pn.getNodeType() != OptNode.NodeType.PARFOR) {
            LOG.warn((Object)((Object)((Object)this.getOptMode()) + " OPT: Set in-place result update is only applicable for a ParFor node."));
        }
        boolean apply = false;
        ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(pn.getID())[1];
        ArrayList<String> retVars = pfpb.getResultVariables();
        double sum = this.computeTotalSizeResultVariables(retVars, vars, pfpb.getDegreeOfParallelism());
        HashMap<String, ArrayList<UIPCandidateHop>> uipCandHopHM = new HashMap<String, ArrayList<UIPCandidateHop>>();
        double totalMem = Math.max(M + sum, this.rComputeSumMemoryIntermediates(pn, new HashSet<String>(), uipCandHopHM));
        if (this.rHasOnlyInPlaceSafeLeftIndexing(pn, retVars)) {
            if ((pfpb.getExecMode() == ParForProgramBlock.PExecMode.REMOTE_MR_DP || pfpb.getExecMode() == ParForProgramBlock.PExecMode.REMOTE_MR || pfpb.getExecMode() == ParForProgramBlock.PExecMode.REMOTE_SPARK_DP || pfpb.getExecMode() == ParForProgramBlock.PExecMode.REMOTE_SPARK) && totalMem < this._rm) {
                apply = true;
            } else if (pfpb.getExecMode() == ParForProgramBlock.PExecMode.LOCAL && totalMem * (double)pfpb.getDegreeOfParallelism() < this._lm && pn.isCPOnly()) {
                apply = true;
            }
        }
        if (LOG.isDebugEnabled()) {
            listUIPRes.remove();
        }
        if (apply) {
            for (String string : retVars) {
                Data data = vars.get(string);
                if (!(data instanceof MatrixObject)) continue;
                ((MatrixObject)data).setUpdateType(MatrixObject.UpdateType.INPLACE_PINNED);
            }
            inPlaceResultVars.addAll(retVars);
            this.isUpdateInPlaceApplicable(pn, uipCandHopHM);
            boolean bAnyUIPApplicable = false;
            for (Map.Entry<String, ArrayList<UIPCandidateHop>> entry : uipCandHopHM.entrySet()) {
                ArrayList<UIPCandidateHop> uipCandHopList = entry.getValue();
                if (uipCandHopList == null) continue;
                for (UIPCandidateHop uipCandHop : uipCandHopList) {
                    if (!uipCandHop.isIntermediate() || !uipCandHop.isLoopApplicable() || !uipCandHop.isUpdateInPlace()) continue;
                    uipCandHop.getHop().setUpdateType(MatrixObject.UpdateType.INPLACE_PINNED);
                    bAnyUIPApplicable = true;
                    if (!LOG.isDebugEnabled()) continue;
                    listUIPRes.get().add(uipCandHop.getHop().getName());
                }
            }
            if (bAnyUIPApplicable) {
                try {
                    LocalVariableMap localVariableMap = (LocalVariableMap)ec.getVariables().clone();
                    Recompiler.recompileProgramBlockHierarchy(pfpb.getChildBlocks(), localVariableMap, 0L, true);
                }
                catch (Exception exception) {
                    throw new DMLRuntimeException(exception);
                }
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("UpdateInPlace = " + apply + " for lines between " + pn.getBeginLine() + " and " + pn.getEndLine() + " for " + uipCandHopHM.size() + " intermediate matrix objects:" + uipCandHopHM.keySet().toString()));
            for (Map.Entry<String, ArrayList<UIPCandidateHop>> entry : uipCandHopHM.entrySet()) {
                ArrayList<UIPCandidateHop> arrayList = entry.getValue();
                if (arrayList == null) continue;
                for (UIPCandidateHop uipCandHop : arrayList) {
                    if (uipCandHop.getHop() != null) {
                        LOG.trace((Object)("Matrix Object: Name: " + uipCandHop.getHop().getName() + "<" + uipCandHop.getHop().getBeginLine() + "," + uipCandHop.getHop().getEndLine() + ">, InLoop:" + uipCandHop.isLoopApplicable() + ", UIPApplicable:" + uipCandHop.isUpdateInPlace() + ", HopUIPApplicable:" + (Object)((Object)uipCandHop.getHop().getUpdateType())));
                        LOG.trace((Object)"Explain Candidate HOP after recompile");
                        LOG.trace((Object)Explain.explain(uipCandHop.getHop()));
                        continue;
                    }
                    LOG.trace((Object)("Matrix Object: Name: " + uipCandHop.getLixHop().getName() + "<" + uipCandHop.getLixHop().getBeginLine() + "," + uipCandHop.getLixHop().getEndLine() + ">, InLoop:" + uipCandHop.isLoopApplicable() + ", Not an Intermediate matrix object"));
                }
            }
        }
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'set in-place result indexing' - result=" + apply + " (" + ProgramConverter.serializeStringCollection(inPlaceResultVars) + ", M=" + OptimizerRuleBased.toMB(totalMem) + ")"));
    }

    private void isUpdateInPlaceApplicable(OptNode pn, HashMap<String, ArrayList<UIPCandidateHop>> uipCandHopHM) throws DMLRuntimeException {
        UIPCandidateHop uipCandHop;
        Iterator<UIPCandidateHop> uipCandHopListIter;
        ArrayList<UIPCandidateHop> uipCandHopList;
        Map.Entry<String, ArrayList<UIPCandidateHop>> uipCandHopHMentry;
        this.rIsInLoop(pn, uipCandHopHM, false);
        Iterator<Map.Entry<String, ArrayList<UIPCandidateHop>>> uipCandHopHMIter = uipCandHopHM.entrySet().iterator();
        while (uipCandHopHMIter.hasNext()) {
            uipCandHopHMentry = uipCandHopHMIter.next();
            uipCandHopList = uipCandHopHMentry.getValue();
            if (uipCandHopList == null) continue;
            uipCandHopListIter = uipCandHopList.iterator();
            while (uipCandHopListIter.hasNext()) {
                uipCandHop = uipCandHopListIter.next();
                if (uipCandHop.isIntermediate() && uipCandHop.isLoopApplicable()) continue;
                uipCandHopListIter.remove();
                if (!LOG.isTraceEnabled()) continue;
                if (!uipCandHop.isIntermediate()) {
                    LOG.trace((Object)("Matrix Object: Name: " + uipCandHop.getLixHop().getName() + "<" + uipCandHop.getLixHop().getBeginLine() + "," + uipCandHop.getLixHop().getEndLine() + ">, removed from the candidate list as it is not an intermediate matrix object."));
                    continue;
                }
                LOG.trace((Object)("Matrix Object: Name: " + uipCandHop.getLixHop().getName() + "<" + uipCandHop.getLixHop().getBeginLine() + "," + uipCandHop.getLixHop().getEndLine() + ">, removed from the candidate list as it does not have loop criteria applicable."));
            }
            if (!uipCandHopList.isEmpty()) continue;
            uipCandHopHMIter.remove();
        }
        if (!uipCandHopHM.isEmpty()) {
            this.rResetVisitStatus(pn);
            this.rGetUIPConsumerList(pn, uipCandHopHM);
            uipCandHopHMIter = uipCandHopHM.entrySet().iterator();
            while (uipCandHopHMIter.hasNext()) {
                uipCandHopHMentry = uipCandHopHMIter.next();
                uipCandHopList = uipCandHopHMentry.getValue();
                if (uipCandHopList == null) continue;
                uipCandHopListIter = uipCandHopList.iterator();
                block3: while (uipCandHopListIter.hasNext()) {
                    uipCandHop = uipCandHopListIter.next();
                    ArrayList<Hop> consHops = uipCandHop.getConsumerHops();
                    if (consHops == null) continue;
                    for (Hop hop : consHops) {
                        if (!(hop instanceof FunctionOp)) continue;
                        uipCandHopListIter.remove();
                        if (!LOG.isTraceEnabled()) continue block3;
                        LOG.trace((Object)("Matrix Object: Name: " + uipCandHop.getLixHop().getName() + "<" + uipCandHop.getLixHop().getBeginLine() + "," + uipCandHop.getLixHop().getEndLine() + ">, removed from the candidate list as one of the consumer is FunctionOp."));
                        continue block3;
                    }
                }
                if (!uipCandHopList.isEmpty()) continue;
                uipCandHopHMIter.remove();
            }
            this.rResetVisitStatus(pn);
            this.rValidateUIPConsumerList(pn, uipCandHopHM);
        }
    }

    private void rIsInLoop(OptNode pn, HashMap<String, ArrayList<UIPCandidateHop>> uipCandHopHM, boolean bInLoop) throws DMLRuntimeException {
        if (!pn.isLeaf()) {
            ProgramBlock pb = (ProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(pn.getID())[1];
            VariableSet varUpdated = pb.getStatementBlock().variablesUpdated();
            boolean bUIPCandHopUpdated = false;
            for (Map.Entry<String, ArrayList<UIPCandidateHop>> entry : uipCandHopHM.entrySet()) {
                String uipCandHopID = entry.getKey();
                if (!varUpdated.containsVariable(uipCandHopID)) continue;
                bUIPCandHopUpdated = true;
                break;
            }
            if (!bUIPCandHopUpdated) {
                return;
            }
            boolean bLoop = false;
            if (bInLoop || pb instanceof WhileProgramBlock || pb instanceof ParForProgramBlock && ((ParForProgramBlock)pb).getDegreeOfParallelism() == 1 || pb instanceof ForProgramBlock && !(pb instanceof ParForProgramBlock)) {
                bLoop = true;
            }
            for (OptNode optNode : pn.getChilds()) {
                this.rIsInLoop(optNode, uipCandHopHM, bLoop);
            }
        } else {
            Hop hop = OptTreeConverter.getAbstractPlanMapping().getMappedHop(pn.getID());
            for (Map.Entry<String, ArrayList<UIPCandidateHop>> entry : uipCandHopHM.entrySet()) {
                ArrayList<UIPCandidateHop> uipCandHopList = entry.getValue();
                if (uipCandHopList == null) continue;
                for (UIPCandidateHop uipCandHop : uipCandHopList) {
                    if (hop instanceof DataGenOp && hop.getName().equals(uipCandHop.getLixHop().getName())) {
                        uipCandHop.setHop(hop);
                        uipCandHop.setLocation(hop.getBeginLine());
                        uipCandHop.setIntermediate(true);
                    }
                    if (!bInLoop || uipCandHop.getLocation() > hop.getBeginLine() || uipCandHop.getLixHop().getBeginLine() > hop.getEndLine()) continue;
                    uipCandHop.setIsLoopApplicable(true);
                }
            }
        }
    }

    private void rGetUIPConsumerList(OptNode pn, HashMap<String, ArrayList<UIPCandidateHop>> uipCandHopHM) throws DMLRuntimeException {
        if (!pn.isLeaf()) {
            if (pn.getNodeType() == OptNode.NodeType.FUNCCALL) {
                return;
            }
            ProgramBlock pb = (ProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(pn.getID())[1];
            VariableSet varRead = pb.getStatementBlock().variablesRead();
            boolean bUIPCandHopRead = false;
            for (Map.Entry<String, ArrayList<UIPCandidateHop>> entry : uipCandHopHM.entrySet()) {
                String uipCandHopID = entry.getKey();
                if (!varRead.containsVariable(uipCandHopID)) continue;
                bUIPCandHopRead = true;
                break;
            }
            if (!bUIPCandHopRead) {
                return;
            }
            for (OptNode optNode : pn.getChilds()) {
                this.rGetUIPConsumerList(optNode, uipCandHopHM);
            }
        } else {
            OptTreePlanMappingAbstract map = OptTreeConverter.getAbstractPlanMapping();
            long ppid = map.getMappedParentID(map.getMappedParentID(pn.getID()));
            Object[] o = map.getMappedProg(ppid);
            ProgramBlock pb = (ProgramBlock)o[1];
            Hop hop = OptTreeConverter.getAbstractPlanMapping().getMappedHop(pn.getID());
            this.rGetUIPConsumerList(hop, uipCandHopHM);
            if (pb instanceof IfProgramBlock || pb instanceof WhileProgramBlock || pb instanceof ForProgramBlock && !(pb instanceof ParForProgramBlock)) {
                this.rGetUIPConsumerList(pb, uipCandHopHM);
            }
        }
    }

    private void rGetUIPConsumerList(ProgramBlock pb, HashMap<String, ArrayList<UIPCandidateHop>> uipCandHopHM) throws DMLRuntimeException {
        ArrayList<ProgramBlock> childBlocks = null;
        ArrayList<ProgramBlock> elseBlocks = null;
        if (pb instanceof WhileProgramBlock) {
            childBlocks = ((WhileProgramBlock)pb).getChildBlocks();
        } else if (pb instanceof ForProgramBlock) {
            childBlocks = ((ForProgramBlock)pb).getChildBlocks();
        } else if (pb instanceof IfProgramBlock) {
            childBlocks = ((IfProgramBlock)pb).getChildBlocksIfBody();
            elseBlocks = ((IfProgramBlock)pb).getChildBlocksElseBody();
        }
        if (childBlocks != null) {
            for (ProgramBlock childBlock : childBlocks) {
                this.rGetUIPConsumerList(childBlock, uipCandHopHM);
                try {
                    this.rGetUIPConsumerList(childBlock.getStatementBlock().get_hops(), uipCandHopHM);
                }
                catch (Exception e) {
                    throw new DMLRuntimeException(e);
                }
            }
        }
        if (elseBlocks != null) {
            for (ProgramBlock childBlock : elseBlocks) {
                this.rGetUIPConsumerList(childBlock, uipCandHopHM);
                try {
                    this.rGetUIPConsumerList(childBlock.getStatementBlock().get_hops(), uipCandHopHM);
                }
                catch (Exception e) {
                    throw new DMLRuntimeException(e);
                }
            }
        }
    }

    private void rGetUIPConsumerList(ArrayList<Hop> hops, HashMap<String, ArrayList<UIPCandidateHop>> uipCandHopHM) throws DMLRuntimeException {
        if (hops != null) {
            for (Hop hop : hops) {
                this.rGetUIPConsumerList(hop, uipCandHopHM);
            }
        }
    }

    private void rGetUIPConsumerList(Hop hop, HashMap<String, ArrayList<UIPCandidateHop>> uipCandHopHM) throws DMLRuntimeException {
        String uipCandiateID;
        ArrayList<UIPCandidateHop> uipCandHopList;
        if (hop.isVisited()) {
            return;
        }
        if ((hop.getParent().isEmpty() || !(hop.getParent().get(0) instanceof LeftIndexingOp)) && (hop instanceof DataOp && ((DataOp)hop).getDataOpType() == Hop.DataOpTypes.TRANSIENTREAD || hop instanceof ReorgOp && (((ReorgOp)hop).getOp() == Hop.ReOrgOp.RESHAPE || ((ReorgOp)hop).getOp() == Hop.ReOrgOp.TRANSPOSE) || hop instanceof FunctionOp) && (uipCandHopList = uipCandHopHM.get(uipCandiateID = hop.getName())) != null) {
            for (UIPCandidateHop uipCandHop : uipCandHopList) {
                ArrayList<Hop> consumerHops = uipCandHop.getConsumerHops();
                if (uipCandHop.getConsumerHops() == null) {
                    consumerHops = new ArrayList();
                }
                consumerHops.add(this.getRootHop(hop));
                uipCandHop.setConsumerHops(consumerHops);
            }
        }
        for (Hop hopIn : hop.getInput()) {
            this.rGetUIPConsumerList(hopIn, uipCandHopHM);
        }
        hop.setVisited();
    }

    private Hop getRootHop(Hop hop) {
        return !hop.getParent().isEmpty() ? this.getRootHop(hop.getParent().get(0)) : hop;
    }

    private void rResetVisitStatus(OptNode pn) throws DMLRuntimeException {
        if (!pn.isLeaf()) {
            if (pn.getNodeType() == OptNode.NodeType.FUNCCALL) {
                Hop hopFunc = OptTreeConverter.getAbstractPlanMapping().getMappedHop(pn.getID());
                hopFunc.resetVisitStatus();
                return;
            }
            ProgramBlock pb = (ProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(pn.getID())[1];
            ArrayList<ProgramBlock> childBlocks = null;
            ArrayList<ProgramBlock> elseBlocks = null;
            if (pb instanceof WhileProgramBlock) {
                childBlocks = ((WhileProgramBlock)pb).getChildBlocks();
            } else if (pb instanceof ForProgramBlock) {
                childBlocks = ((ForProgramBlock)pb).getChildBlocks();
            } else if (pb instanceof IfProgramBlock) {
                childBlocks = ((IfProgramBlock)pb).getChildBlocksIfBody();
                elseBlocks = ((IfProgramBlock)pb).getChildBlocksElseBody();
            }
            if (childBlocks != null) {
                for (ProgramBlock childBlock : childBlocks) {
                    try {
                        Hop.resetVisitStatus(childBlock.getStatementBlock().get_hops());
                    }
                    catch (Exception e) {
                        throw new DMLRuntimeException(e);
                    }
                }
            }
            if (elseBlocks != null) {
                for (ProgramBlock childBlock : elseBlocks) {
                    try {
                        Hop.resetVisitStatus(childBlock.getStatementBlock().get_hops());
                    }
                    catch (Exception e) {
                        throw new DMLRuntimeException(e);
                    }
                }
            }
            for (OptNode optNode : pn.getChilds()) {
                this.rResetVisitStatus(optNode);
            }
        } else {
            Hop hop = OptTreeConverter.getAbstractPlanMapping().getMappedHop(pn.getID());
            if (hop != null) {
                hop.resetVisitStatus();
            }
        }
    }

    private void rValidateUIPConsumerList(OptNode pn, HashMap<String, ArrayList<UIPCandidateHop>> uipCandHopHM) throws DMLRuntimeException {
        if (!pn.isLeaf()) {
            if (pn.getNodeType() == OptNode.NodeType.FUNCCALL) {
                Hop hop = OptTreeConverter.getAbstractPlanMapping().getMappedHop(pn.getID());
                this.rValidateUIPConsumerList(hop.getInput(), uipCandHopHM);
                return;
            }
            ProgramBlock pb = (ProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(pn.getID())[1];
            VariableSet varRead = pb.getStatementBlock().variablesRead();
            boolean bUIPCandHopRead = false;
            for (Map.Entry<String, ArrayList<UIPCandidateHop>> entry : uipCandHopHM.entrySet()) {
                ArrayList<UIPCandidateHop> uipCandHopList = entry.getValue();
                if (uipCandHopList == null) continue;
                block1: for (UIPCandidateHop uipCandHop : uipCandHopList) {
                    ArrayList<Hop> consumerHops = uipCandHop.getConsumerHops();
                    if (consumerHops == null) continue;
                    for (Hop consumerHop : consumerHops) {
                        if (!varRead.containsVariable(consumerHop.getName())) continue;
                        bUIPCandHopRead = true;
                        continue block1;
                    }
                }
            }
            if (!bUIPCandHopRead) {
                return;
            }
            for (OptNode optNode : pn.getChilds()) {
                this.rValidateUIPConsumerList(optNode, uipCandHopHM);
            }
        } else {
            long ppid;
            OptTreePlanMappingAbstract map = OptTreeConverter.getAbstractPlanMapping();
            Object[] o = map.getMappedProg(ppid = map.getMappedParentID(map.getMappedParentID(pn.getID())));
            ProgramBlock pb = (ProgramBlock)o[1];
            if (pb instanceof IfProgramBlock || pb instanceof WhileProgramBlock || pb instanceof ForProgramBlock && !(pb instanceof ParForProgramBlock)) {
                this.rValidateUIPConsumerList(pb, uipCandHopHM);
            }
            long pid = map.getMappedParentID(pn.getID());
            o = map.getMappedProg(pid);
            pb = (ProgramBlock)o[1];
            Hop hop = map.getMappedHop(pn.getID());
            this.rValidateUIPConsumerList(hop, uipCandHopHM, pb.getStatementBlock().variablesRead());
        }
    }

    private void rValidateUIPConsumerList(ProgramBlock pb, HashMap<String, ArrayList<UIPCandidateHop>> uipCandHopHM) throws DMLRuntimeException {
        ArrayList<ProgramBlock> childBlocks = null;
        if (pb instanceof WhileProgramBlock) {
            childBlocks = ((WhileProgramBlock)pb).getChildBlocks();
        } else if (pb instanceof ForProgramBlock) {
            childBlocks = ((ForProgramBlock)pb).getChildBlocks();
        } else if (pb instanceof IfProgramBlock) {
            childBlocks = ((IfProgramBlock)pb).getChildBlocksIfBody();
            ArrayList<ProgramBlock> elseBlocks = ((IfProgramBlock)pb).getChildBlocksElseBody();
            if (childBlocks != null && elseBlocks != null) {
                childBlocks.addAll(elseBlocks);
            } else if (childBlocks == null) {
                childBlocks = elseBlocks;
            }
        }
        if (childBlocks != null) {
            for (ProgramBlock childBlock : childBlocks) {
                this.rValidateUIPConsumerList(childBlock, uipCandHopHM);
                try {
                    this.rValidateUIPConsumerList(childBlock.getStatementBlock(), uipCandHopHM);
                }
                catch (Exception e) {
                    throw new DMLRuntimeException(e);
                }
            }
        }
    }

    private void rValidateUIPConsumerList(StatementBlock sb, HashMap<String, ArrayList<UIPCandidateHop>> uipCandHopHM) throws DMLRuntimeException {
        VariableSet readVariables = sb.variablesRead();
        for (Map.Entry<String, ArrayList<UIPCandidateHop>> entry : uipCandHopHM.entrySet()) {
            ArrayList<UIPCandidateHop> uipCandHopList = entry.getValue();
            if (uipCandHopList == null) continue;
            block1: for (UIPCandidateHop uipCandHop : uipCandHopList) {
                ArrayList<Hop> consumerHops = uipCandHop.getConsumerHops();
                if (consumerHops == null) continue;
                for (Hop consumerHop : consumerHops) {
                    if (!readVariables.containsVariable(consumerHop.getName())) continue;
                    uipCandHop.setUpdateInPlace(false);
                    continue block1;
                }
            }
        }
    }

    private void rValidateUIPConsumerList(ArrayList<Hop> hops, HashMap<String, ArrayList<UIPCandidateHop>> uipCandHopHM) throws DMLRuntimeException {
        if (hops != null) {
            for (Hop hop : hops) {
                this.rValidateUIPConsumerList(hop, uipCandHopHM);
            }
        }
    }

    private void rValidateUIPConsumerList(Hop hop, HashMap<String, ArrayList<UIPCandidateHop>> uipCandHopHM) throws DMLRuntimeException {
        if (hop.isVisited()) {
            return;
        }
        for (Map.Entry<String, ArrayList<UIPCandidateHop>> entry : uipCandHopHM.entrySet()) {
            if (entry.getValue() == null) continue;
            block1: for (UIPCandidateHop uipCandHop : entry.getValue()) {
                ArrayList<Hop> consumerHops = uipCandHop.getConsumerHops();
                if (consumerHops == null) continue;
                for (Hop consumerHop : consumerHops) {
                    if (!hop.getName().equals(consumerHop.getName())) continue;
                    uipCandHop.setUpdateInPlace(false);
                    continue block1;
                }
            }
        }
        hop.setVisited();
    }

    private void rValidateUIPConsumerList(Hop hop, HashMap<String, ArrayList<UIPCandidateHop>> uipCandHopHM, VariableSet readVariables) throws DMLRuntimeException {
        if (hop.isVisited()) {
            return;
        }
        for (Map.Entry<String, ArrayList<UIPCandidateHop>> entry : uipCandHopHM.entrySet()) {
            if (entry.getValue() == null) continue;
            block1: for (UIPCandidateHop uipCandHop : entry.getValue()) {
                ArrayList<Hop> consumerHops = uipCandHop.getConsumerHops();
                if (consumerHops == null) continue;
                for (Hop consumerHop : consumerHops) {
                    if (!readVariables.containsVariable(consumerHop.getName())) continue;
                    uipCandHop.setUpdateInPlace(false);
                    continue block1;
                }
            }
        }
        hop.setVisited();
    }

    public static List<String> getUIPList() {
        return listUIPRes.get();
    }

    protected boolean rHasOnlyInPlaceSafeLeftIndexing(OptNode n, ArrayList<String> retVars) throws DMLRuntimeException {
        Hop h;
        boolean ret = true;
        if (!n.isLeaf()) {
            for (OptNode cn : n.getChilds()) {
                ret &= this.rHasOnlyInPlaceSafeLeftIndexing(cn, retVars);
            }
        } else if (n.getNodeType() == OptNode.NodeType.HOP && n.getParam(OptNode.ParamType.OPSTRING).equals(LeftIndexingOp.OPSTRING) && retVars.contains((h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID())).getInput().get(0).getName())) {
            ret &= h.getParent().size() == 1 && h.getParent().get(0).getName().equals(h.getInput().get(0).getName());
        }
        return ret;
    }

    private double computeTotalSizeResultVariables(ArrayList<String> retVars, LocalVariableMap vars, int k) {
        double sum = 1.0;
        for (String var : retVars) {
            Data dat = vars.get(var);
            if (!(dat instanceof MatrixObject)) continue;
            MatrixObject mo = (MatrixObject)dat;
            double nnz = mo.getNnz();
            if (nnz == 0.0) {
                sum += (double)OptimizerUtils.estimateSizeExactSparsity(mo.getNumRows(), mo.getNumColumns(), 1.0);
                continue;
            }
            double sp = mo.getSparsity();
            sum += (double)((long)(k + 1) * OptimizerUtils.estimateSizeExactSparsity(mo.getNumRows(), mo.getNumColumns(), Math.min(1.0 / (double)k + sp, 1.0)));
        }
        return sum;
    }

    protected void rewriteDisableCPCaching(OptNode pn, HashSet<String> inplaceResultVars, LocalVariableMap vars) throws DMLRuntimeException {
        if (pn.getNodeType() != OptNode.NodeType.PARFOR) {
            LOG.warn((Object)((Object)((Object)this.getOptMode()) + " OPT: Disable caching is only applicable for a ParFor node."));
        }
        ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(pn.getID())[1];
        double M_sumInterm = this.rComputeSumMemoryIntermediates(pn, inplaceResultVars, null);
        boolean apply = false;
        if ((pfpb.getExecMode() == ParForProgramBlock.PExecMode.REMOTE_MR_DP || pfpb.getExecMode() == ParForProgramBlock.PExecMode.REMOTE_MR) && M_sumInterm < this._rm) {
            pfpb.setCPCaching(false);
            apply = true;
        }
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'disable CP caching' - result=" + apply + " (M=" + OptimizerRuleBased.toMB(M_sumInterm) + ")"));
    }

    protected double rComputeSumMemoryIntermediates(OptNode n, HashSet<String> inplaceResultVars, HashMap<String, ArrayList<UIPCandidateHop>> uipCands) throws DMLRuntimeException {
        double sum;
        block7: {
            Hop h;
            block8: {
                block6: {
                    sum = 0.0;
                    if (n.isLeaf()) break block6;
                    for (OptNode cn : n.getChilds()) {
                        sum += this.rComputeSumMemoryIntermediates(cn, inplaceResultVars, uipCands);
                    }
                    break block7;
                }
                if (n.getNodeType() != OptNode.NodeType.HOP) break block7;
                h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID());
                if (uipCands != null && h.getDataType() == Expression.DataType.MATRIX && h instanceof LeftIndexingOp && h.getInput().get(0).getParent().size() == 1) {
                    long pid = OptTreeConverter.getAbstractPlanMapping().getMappedParentID(n.getID());
                    ProgramBlock pb = (ProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(pid)[1];
                    while (!(pb instanceof WhileProgramBlock) && !(pb instanceof ForProgramBlock)) {
                        pid = OptTreeConverter.getAbstractPlanMapping().getMappedParentID(pid);
                        OptNode parent2 = OptTreeConverter.getAbstractPlanMapping().getOptNode(pid);
                        if (parent2.getNodeType() == OptNode.NodeType.FUNCCALL) continue;
                        pb = (ProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(pid)[1];
                    }
                    if (!uipCands.containsKey(h.getName())) {
                        uipCands.put(h.getName(), new ArrayList());
                    }
                    uipCands.get(h.getName()).add(new UIPCandidateHop(h, pb));
                    if (LOG.isTraceEnabled()) {
                        StatementBlock sb = (StatementBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(OptTreeConverter.getAbstractPlanMapping().getMappedParentID(n.getID()))[0];
                        LOG.trace((Object)("Candidate Hop:" + h.getName() + "<" + h.getBeginLine() + "," + h.getEndLine() + ">,<" + h.getBeginColumn() + "," + h.getEndColumn() + "> PB:<" + pb.getBeginLine() + "," + pb.getEndLine() + ">,<" + pb.getBeginColumn() + "," + pb.getEndColumn() + "> SB:<" + sb.getBeginLine() + "," + sb.getEndLine() + ">,<" + sb.getBeginColumn() + "," + sb.getEndColumn() + ">"));
                    }
                }
                if (!n.getParam(OptNode.ParamType.OPSTRING).equals(IndexingOp.OPSTRING) || n.getParam(OptNode.ParamType.DATA_PARTITION_FORMAT) == null) break block8;
                sum += h.getMemEstimate();
                break block7;
            }
            sum += h.getOutputMemEstimate() + h.getIntermediateMemEstimate();
            if (h.getInput() == null) break block7;
            for (Hop cn : h.getInput()) {
                if (!(cn instanceof DataOp) || !((DataOp)cn).isRead() || inplaceResultVars.contains(cn.getName())) continue;
                sum += cn.getMemEstimate();
            }
        }
        return sum;
    }

    protected void rewriteEnableRuntimePiggybacking(OptNode n, LocalVariableMap vars, HashMap<String, ParForProgramBlock.PartitionFormat> partitionedMatrices) throws DMLRuntimeException {
        ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(n.getID())[1];
        HashSet<String> sharedVars = new HashSet<String>();
        boolean apply = false;
        if (OptimizerUtils.ALLOW_RUNTIME_PIGGYBACKING) {
            boolean bl = apply = this.rHasSharedMRInput(n, vars.keySet(), partitionedMatrices.keySet(), sharedVars) && n.getTotalK() > 1;
        }
        if (apply) {
            pfpb.setRuntimePiggybacking(apply);
        }
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'enable runtime piggybacking' - result=" + apply + " (" + ProgramConverter.serializeStringCollection(sharedVars) + ")"));
    }

    protected boolean rHasSharedMRInput(OptNode n, Set<String> inputVars, Set<String> partitionedVars, HashSet<String> sharedVars) throws DMLRuntimeException {
        boolean ret;
        block4: {
            block3: {
                ret = false;
                if (n.isLeaf()) break block3;
                for (OptNode cn : n.getChilds()) {
                    ret |= this.rHasSharedMRInput(cn, inputVars, partitionedVars, sharedVars);
                }
                break block4;
            }
            if (n.getNodeType() != OptNode.NodeType.HOP || n.getExecType() != OptNode.ExecType.MR) break block4;
            Hop h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID());
            for (Hop ch : h.getInput()) {
                if (ch instanceof DataOp && ch.getDataType() == Expression.DataType.MATRIX && inputVars.contains(ch.getName())) {
                    ret = true;
                    sharedVars.add(ch.getName());
                    continue;
                }
                if (!HopRewriteUtils.isTransposeOperation(ch) || !(ch.getInput().get(0) instanceof DataOp) || ch.getInput().get(0).getDataType() != Expression.DataType.MATRIX || !inputVars.contains(ch.getInput().get(0).getName())) continue;
                ret = true;
                sharedVars.add(ch.getInput().get(0).getName());
            }
        }
        return ret;
    }

    protected void rewriteInjectSparkLoopCheckpointing(OptNode n) throws DMLRuntimeException {
        Object[] progobj = OptTreeConverter.getAbstractPlanMapping().getMappedProg(n.getID());
        ParForStatementBlock pfsb = (ParForStatementBlock)progobj[0];
        ParForStatement fs = (ParForStatement)pfsb.getStatement(0);
        ParForProgramBlock pfpb = (ParForProgramBlock)progobj[1];
        boolean applied = false;
        try {
            RewriteInjectSparkLoopCheckpointing rewrite = new RewriteInjectSparkLoopCheckpointing(false);
            ProgramRewriter rewriter = new ProgramRewriter(rewrite);
            ProgramRewriteStatus state = new ProgramRewriteStatus();
            rewriter.rewriteStatementBlockHopDAGs(pfsb, state);
            fs.setBody(rewriter.rewriteStatementBlocks(fs.getBody(), state));
            if (state.getInjectedCheckpoints()) {
                pfpb.setChildBlocks(ProgramRecompiler.generatePartitialRuntimeProgram(pfpb.getProgram(), fs.getBody()));
                applied = true;
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'inject spark loop checkpointing' - result=" + applied));
    }

    protected void rewriteInjectSparkRepartition(OptNode n, LocalVariableMap vars) throws DMLRuntimeException {
        Object[] progobj = OptTreeConverter.getAbstractPlanMapping().getMappedProg(n.getID());
        ParForStatementBlock pfsb = (ParForStatementBlock)progobj[0];
        ParForProgramBlock pfpb = (ParForProgramBlock)progobj[1];
        ArrayList<String> ret = new ArrayList<String>();
        if (OptimizerUtils.isSparkExecutionMode() && n.getExecType() == OptNode.ExecType.CP && this._N > 1L) {
            HashSet<String> cand = new HashSet<String>();
            this.rCollectZipmmPartitioningCandidates(n, cand);
            HashSet<String> probe = new HashSet<String>(pfsb.getReadOnlyParentVars());
            for (String var : cand) {
                if (!probe.contains(var)) continue;
                ret.add(var);
            }
            ArrayList<String> tmp = new ArrayList<String>(ret);
            ret.clear();
            for (String var : tmp) {
                if (!(vars.get(var) instanceof MatrixObject)) continue;
                MatrixObject mo = (MatrixObject)vars.get(var);
                double sp = OptimizerUtils.getSparsity(mo.getNumRows(), mo.getNumColumns(), mo.getNnz());
                double size = OptimizerUtils.estimateSizeExactSparsity(mo.getNumRows(), mo.getNumColumns(), sp);
                if (!(size > OptimizerUtils.getLocalMemBudget())) continue;
                ret.add(var);
            }
            if (!ret.isEmpty()) {
                pfpb.setSparkRepartitionVariables(ret);
            }
        }
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'inject spark input repartition' - result=" + ret.size() + " (" + ProgramConverter.serializeStringCollection(ret) + ")"));
    }

    private void rCollectZipmmPartitioningCandidates(OptNode n, HashSet<String> cand) {
        Hop h;
        if (n.getNodeType() == OptNode.NodeType.HOP && (h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID())) instanceof AggBinaryOp && (((AggBinaryOp)h).getMMultMethod() == AggBinaryOp.MMultMethod.ZIPMM || ((AggBinaryOp)h).getMMultMethod() == AggBinaryOp.MMultMethod.CPMM)) {
            for (Hop in : h.getInput()) {
                if (in instanceof DataOp) {
                    cand.add(in.getName());
                    continue;
                }
                if (!HopRewriteUtils.isTransposeOperation(in) || !(in.getInput().get(0) instanceof DataOp)) continue;
                cand.add(in.getInput().get(0).getName());
            }
        }
        if (!n.isLeaf()) {
            for (OptNode c : n.getChilds()) {
                this.rCollectZipmmPartitioningCandidates(c, cand);
            }
        }
    }

    protected void rewriteSetSparkEagerRDDCaching(OptNode n, LocalVariableMap vars) throws DMLRuntimeException {
        Object[] progobj = OptTreeConverter.getAbstractPlanMapping().getMappedProg(n.getID());
        ParForStatementBlock pfsb = (ParForStatementBlock)progobj[0];
        ParForProgramBlock pfpb = (ParForProgramBlock)progobj[1];
        ArrayList<String> ret = new ArrayList<String>();
        if (OptimizerUtils.isSparkExecutionMode() && n.getExecType() == OptNode.ExecType.CP && this._N > 1L) {
            Set<String> cand = pfsb.variablesRead().getVariableNames();
            Collection<String> rpVars = pfpb.getSparkRepartitionVariables();
            for (String var : cand) {
                Data dat = vars.get(var);
                if (dat == null || !(dat instanceof MatrixObject) || ((MatrixObject)dat).getRDDHandle() == null) continue;
                MatrixObject mo = (MatrixObject)dat;
                MatrixCharacteristics mc = mo.getMatrixCharacteristics();
                RDDObject rdd = mo.getRDDHandle();
                if (rpVars != null && rpVars.contains(var) || !rdd.rHasCheckpointRDDChilds() || !(this._lm / (double)n.getK() < (double)OptimizerUtils.estimateSizeExactSparsity(mc))) continue;
                ret.add(var);
            }
            if (!ret.isEmpty()) {
                pfpb.setSparkEagerCacheVariables(ret);
            }
        }
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'set spark eager rdd caching' - result=" + ret.size() + " (" + ProgramConverter.serializeStringCollection(ret) + ")"));
    }

    protected void rewriteRemoveUnnecessaryCompareMatrix(OptNode n, ExecutionContext ec) throws DMLRuntimeException {
        ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(n.getID())[1];
        ArrayList<String> cleanedVars = new ArrayList<String>();
        ArrayList<String> resultVars = pfpb.getResultVariables();
        String itervar = pfpb.getIterablePredicateVars()[0];
        for (String rvar : resultVars) {
            Data dat = ec.getVariable(rvar);
            if (!(dat instanceof MatrixObject) || ((MatrixObject)dat).getNnz() == 0L || !n.hasOnlySimpleChilds() || !this.rContainsResultFullReplace(n, rvar, itervar, (MatrixObject)dat) || this.rIsReadInRightIndexing(n, rvar) || ((MatrixObject)dat).getNumRows() > Integer.MAX_VALUE || ((MatrixObject)dat).getNumColumns() > Integer.MAX_VALUE) continue;
            MatrixObject mo = (MatrixObject)dat;
            ec.cleanupMatrixObject(mo);
            ec.setMatrixOutput(rvar, new MatrixBlock((int)mo.getNumRows(), (int)mo.getNumColumns(), false));
            cleanedVars.add(rvar);
        }
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'remove unnecessary compare matrix' - result=" + !cleanedVars.isEmpty() + " (" + ProgramConverter.serializeStringCollection(cleanedVars) + ")"));
    }

    protected boolean rContainsResultFullReplace(OptNode n, String resultVar, String iterVarname, MatrixObject mo) throws DMLRuntimeException {
        boolean ret = false;
        if (n.getNodeType() == OptNode.NodeType.HOP) {
            ret |= this.isResultFullReplace(n, resultVar, iterVarname, mo);
        }
        if (!n.isLeaf()) {
            for (OptNode c : n.getChilds()) {
                ret |= this.rContainsResultFullReplace(c, resultVar, iterVarname, mo);
            }
        }
        return ret;
    }

    protected boolean isResultFullReplace(OptNode n, String resultVar, String iterVarname, MatrixObject mo) throws DMLRuntimeException {
        String opStr = n.getParam(OptNode.ParamType.OPSTRING);
        if (opStr == null || !opStr.equals(LeftIndexingOp.OPSTRING)) {
            return false;
        }
        Hop h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID());
        Hop base = h.getInput().get(0);
        if (!resultVar.equals(base.getName())) {
            return false;
        }
        Hop inpRowL = h.getInput().get(2);
        Hop inpRowU = h.getInput().get(3);
        Hop inpColL = h.getInput().get(4);
        Hop inpColU = h.getInput().get(5);
        if (inpRowL.getName().equals(iterVarname) && inpRowU.getName().equals(iterVarname) && inpColL instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)inpColL) == 1.0 && inpColU instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)inpColU) == (double)mo.getNumColumns()) {
            return true;
        }
        return inpColL.getName().equals(iterVarname) && inpColU.getName().equals(iterVarname) && inpRowL instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)inpRowL) == 1.0 && inpRowU instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)inpRowU) == (double)mo.getNumRows();
    }

    protected boolean rIsReadInRightIndexing(OptNode n, String var) {
        Hop h;
        boolean ret = false;
        if (n.getNodeType() == OptNode.NodeType.HOP && (h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID())) instanceof IndexingOp && h.getInput().get(0) instanceof DataOp && h.getInput().get(0).getName().equals(var)) {
            ret |= true;
        }
        if (!n.isLeaf()) {
            for (OptNode c : n.getChilds()) {
                ret |= this.rIsReadInRightIndexing(c, var);
            }
        }
        return ret;
    }

    protected void rewriteSetResultMerge(OptNode n, LocalVariableMap vars, boolean inLocal) throws DMLRuntimeException {
        ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(n.getID())[1];
        ParForProgramBlock.PResultMerge REMOTE = OptimizerUtils.isSparkExecutionMode() ? ParForProgramBlock.PResultMerge.REMOTE_SPARK : ParForProgramBlock.PResultMerge.REMOTE_MR;
        ParForProgramBlock.PResultMerge ret = null;
        boolean flagRemoteParFOR = n.getExecType() == this.getRemoteExecType();
        boolean flagLargeResult = this.hasLargeTotalResults(n, pfpb.getResultVariables(), vars, true);
        boolean flagRemoteLeftIndexing = this.hasResultMRLeftIndexing(n, pfpb.getResultVariables(), vars, true);
        boolean flagCellFormatWoCompare = this.determineFlagCellFormatWoCompare(pfpb.getResultVariables(), vars);
        boolean flagOnlyInMemResults = this.hasOnlyInMemoryResults(n, pfpb.getResultVariables(), vars, true);
        if (flagRemoteParFOR && flagLargeResult) {
            ret = REMOTE;
        } else if (flagOnlyInMemResults) {
            ret = ParForProgramBlock.PResultMerge.LOCAL_MEM;
        } else if (flagRemoteParFOR || flagRemoteLeftIndexing) {
            if (flagCellFormatWoCompare) {
                // empty if block
            }
            ret = REMOTE;
        } else {
            ret = ParForProgramBlock.PResultMerge.LOCAL_AUTOMATIC;
        }
        pfpb.setResultMerge(ret);
        n.addParam(OptNode.ParamType.RESULT_MERGE, ret.toString());
        if (n.getChilds() != null) {
            this.rInvokeSetResultMerge(n.getChilds(), vars, inLocal && !flagRemoteParFOR);
        }
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'set result merge' - result=" + (Object)((Object)ret)));
    }

    protected boolean determineFlagCellFormatWoCompare(ArrayList<String> resultVars, LocalVariableMap vars) {
        boolean ret = true;
        for (String rVar : resultVars) {
            Data dat = vars.get(rVar);
            if (dat == null || !(dat instanceof MatrixObject)) {
                ret = false;
                break;
            }
            MatrixObject mo = (MatrixObject)dat;
            MatrixFormatMetaData meta = (MatrixFormatMetaData)mo.getMetaData();
            OutputInfo oi = meta.getOutputInfo();
            long nnz = meta.getMatrixCharacteristics().getNonZeros();
            if (oi != OutputInfo.BinaryBlockOutputInfo && nnz == 0L) continue;
            ret = false;
            break;
        }
        return ret;
    }

    protected boolean hasResultMRLeftIndexing(OptNode n, ArrayList<String> resultVars, LocalVariableMap vars, boolean checkSize) throws DMLRuntimeException {
        boolean ret;
        block2: {
            block1: {
                long cols;
                LeftIndexingOp hop;
                String varName;
                ret = false;
                if (!n.isLeaf()) break block1;
                String opName = n.getParam(OptNode.ParamType.OPSTRING);
                if (opName == null || !opName.equals(LeftIndexingOp.OPSTRING) || n.getExecType() != this.getRemoteExecType() || !resultVars.contains(varName = (hop = (LeftIndexingOp)OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID())).getInput().get(0).getName())) break block2;
                ret = true;
                if (!checkSize || !vars.keySet().contains(varName)) break block2;
                MatrixObject mo = (MatrixObject)vars.get(hop.getInput().get(0).getName());
                long rows = mo.getNumRows();
                ret = !OptimizerRuleBased.isInMemoryResultMerge(rows, cols = mo.getNumColumns(), OptimizerUtils.getRemoteMemBudgetMap(false));
                break block2;
            }
            for (OptNode c : n.getChilds()) {
                ret |= this.hasResultMRLeftIndexing(c, resultVars, vars, checkSize);
            }
        }
        return ret;
    }

    protected boolean hasLargeTotalResults(OptNode pn, ArrayList<String> resultVars, LocalVariableMap vars, boolean checkSize) throws DMLRuntimeException {
        double totalSize = 0.0;
        ParForProgramBlock.PTaskPartitioner tp = ParForProgramBlock.PTaskPartitioner.valueOf(pn.getParam(OptNode.ParamType.TASK_PARTITIONER));
        int k = pn.getK();
        long W = this.estimateNumTasks(tp, this._N, k);
        for (String var : resultVars) {
            Data dat = vars.get(var);
            if (dat == null || !(dat instanceof MatrixObject)) continue;
            MatrixObject mo = (MatrixObject)vars.get(var);
            long rows = mo.getNumRows();
            long cols = mo.getNumColumns();
            long nnz = mo.getNnz();
            if (nnz > 0L) {
                totalSize += (double)(W * OptimizerUtils.estimateSizeExactSparsity(rows, cols, 1.0));
                continue;
            }
            totalSize += (double)OptimizerUtils.estimateSizeExactSparsity(rows, cols, 1.0);
        }
        return totalSize >= this._lm;
    }

    protected long estimateNumTasks(ParForProgramBlock.PTaskPartitioner tp, long N, int k) {
        long W = -1L;
        switch (tp) {
            case NAIVE: 
            case FIXED: {
                W = N;
                break;
            }
            case STATIC: {
                W = N / (long)k;
                break;
            }
            case FACTORING: 
            case FACTORING_CMIN: 
            case FACTORING_CMAX: {
                W = (long)k * (long)(Math.log((double)N / (double)k) / Math.log(2.0));
                break;
            }
            default: {
                W = N;
            }
        }
        return W;
    }

    protected boolean hasOnlyInMemoryResults(OptNode n, ArrayList<String> resultVars, LocalVariableMap vars, boolean inLocal) throws DMLRuntimeException {
        boolean ret = true;
        if (n.isLeaf()) {
            LeftIndexingOp hop;
            String varName;
            String opName = n.getParam(OptNode.ParamType.OPSTRING);
            if (opName.equals(LeftIndexingOp.OPSTRING) && resultVars.contains(varName = (hop = (LeftIndexingOp)OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID())).getInput().get(0).getName()) && vars.keySet().contains(varName)) {
                MatrixObject mo = (MatrixObject)vars.get(hop.getInput().get(0).getName());
                long rows = mo.getNumRows();
                long cols = mo.getNumColumns();
                double memBudget = inLocal ? OptimizerUtils.getLocalMemBudget() : OptimizerUtils.getRemoteMemBudgetMap();
                ret &= OptimizerRuleBased.isInMemoryResultMerge(rows, cols, memBudget);
            }
        } else {
            for (OptNode c : n.getChilds()) {
                ret &= this.hasOnlyInMemoryResults(c, resultVars, vars, inLocal);
            }
        }
        return ret;
    }

    protected void rInvokeSetResultMerge(Collection<OptNode> nodes, LocalVariableMap vars, boolean inLocal) throws DMLRuntimeException {
        for (OptNode n : nodes) {
            if (n.getNodeType() == OptNode.NodeType.PARFOR) {
                this.rewriteSetResultMerge(n, vars, inLocal);
                if (n.getExecType() != this.getRemoteExecType()) continue;
                inLocal = false;
                continue;
            }
            if (n.getChilds() == null) continue;
            this.rInvokeSetResultMerge(n.getChilds(), vars, inLocal);
        }
    }

    public static boolean isInMemoryResultMerge(long rows, long cols, double memBudget) {
        return rows >= 0L && cols >= 0L && (double)MatrixBlock.estimateSizeInMemory(rows, cols, 1.0) < memBudget / 4.0;
    }

    protected void rewriteSetRecompileMemoryBudget(OptNode n) {
        double newLocalMem = this._lm;
        if (n.getExecType() == OptNode.ExecType.CP) {
            int par = n.getTotalK();
            newLocalMem = this._lm / (double)par;
            ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(n.getID())[1];
            pfpb.setRecompileMemoryBudget(newLocalMem);
        }
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'set recompile memory budget' - result=" + OptimizerRuleBased.toMB(newLocalMem)));
    }

    protected void rewriteRemoveRecursiveParFor(OptNode n, LocalVariableMap vars) throws DMLRuntimeException {
        int count = 0;
        HashSet<ParForProgramBlock> recPBs = new HashSet<ParForProgramBlock>();
        this.rFindRecursiveParFor(n, recPBs, false);
        if (!recPBs.isEmpty()) {
            try {
                ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(n.getID())[1];
                if (recPBs.contains(pfpb)) {
                    this.rFindAndUnfoldRecursiveFunction(n, pfpb, recPBs, vars);
                }
            }
            catch (Exception ex) {
                throw new DMLRuntimeException(ex);
            }
            count = this.removeRecursiveParFor(n, recPBs);
        }
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'remove recursive parfor' - result=" + recPBs.size() + "/" + count));
    }

    protected void rFindRecursiveParFor(OptNode n, HashSet<ParForProgramBlock> cand, boolean recContext) {
        if (!n.isLeaf()) {
            for (OptNode c : n.getChilds()) {
                if (c.getNodeType() == OptNode.NodeType.FUNCCALL && c.isRecursive()) {
                    this.rFindRecursiveParFor(c, cand, true);
                    continue;
                }
                this.rFindRecursiveParFor(c, cand, recContext);
            }
        }
        if (recContext && n.getNodeType() == OptNode.NodeType.PARFOR) {
            ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(n.getID())[1];
            cand.add(pfpb);
        }
    }

    protected void rFindAndUnfoldRecursiveFunction(OptNode n, ParForProgramBlock parfor, HashSet<ParForProgramBlock> recPBs, LocalVariableMap vars) throws DMLRuntimeException, HopsException, LanguageException {
        if (n.getNodeType() == OptNode.NodeType.FUNCCALL && n.isRecursive()) {
            boolean exists = this.rContainsNode(n, parfor);
            if (exists) {
                String fnameKey = n.getParam(OptNode.ParamType.OPSTRING);
                String[] names = fnameKey.split("::");
                String fnamespace = names[0];
                String fname = names[1];
                String fnameNew = FUNCTION_UNFOLD_NAMEPREFIX + fname;
                FunctionOp fop = (FunctionOp)OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID());
                Program prog = parfor.getProgram();
                DMLProgram dmlprog = parfor.getStatementBlock().getDMLProg();
                FunctionProgramBlock fpb = prog.getFunctionProgramBlock(fnamespace, fname);
                FunctionProgramBlock copyfpb = ProgramConverter.createDeepCopyFunctionProgramBlock(fpb, new HashSet<String>(), new HashSet<String>());
                prog.addFunctionProgramBlock(fnamespace, fnameNew, copyfpb);
                dmlprog.addFunctionStatementBlock(fnamespace, fnameNew, (FunctionStatementBlock)copyfpb.getStatementBlock());
                this.rReplaceFunctionNames(n, fname, fnameNew);
                String fnameNewKey = fnamespace + "::" + fnameNew;
                OptNode nNew = new OptNode(OptNode.NodeType.FUNCCALL);
                OptTreeConverter.getAbstractPlanMapping().putHopMapping(fop, nNew);
                nNew.setExecType(OptNode.ExecType.CP);
                nNew.addParam(OptNode.ParamType.OPSTRING, fnameNewKey);
                long parentID = OptTreeConverter.getAbstractPlanMapping().getMappedParentID(n.getID());
                OptTreeConverter.getAbstractPlanMapping().getOptNode(parentID).exchangeChild(n, nNew);
                HashSet<String> memo = new HashSet<String>();
                memo.add(fnameKey);
                memo.add(fnameNewKey);
                for (int i = 0; i < copyfpb.getChildBlocks().size(); ++i) {
                    ProgramBlock lpb = copyfpb.getChildBlocks().get(i);
                    StatementBlock lsb = lpb.getStatementBlock();
                    nNew.addChild(OptTreeConverter.rCreateAbstractOptNode(lsb, lpb, vars, false, memo));
                }
                recPBs.removeAll(this.rGetAllParForPBs(n, new HashSet<ParForProgramBlock>()));
                recPBs.addAll(this.rGetAllParForPBs(nNew, new HashSet<ParForProgramBlock>()));
                this.rReplaceFunctionNames(nNew, fname, fnameNew);
            }
            return;
        }
        if (!n.isLeaf()) {
            for (OptNode c : n.getChilds()) {
                this.rFindAndUnfoldRecursiveFunction(c, parfor, recPBs, vars);
            }
        }
    }

    protected boolean rContainsNode(OptNode n, ParForProgramBlock parfor) {
        boolean ret;
        block2: {
            ret = false;
            if (n.getNodeType() == OptNode.NodeType.PARFOR) {
                ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(n.getID())[1];
                boolean bl = ret = parfor == pfpb;
            }
            if (ret || n.isLeaf()) break block2;
            for (OptNode c : n.getChilds()) {
                if (ret |= this.rContainsNode(c, parfor)) break;
            }
        }
        return ret;
    }

    protected HashSet<ParForProgramBlock> rGetAllParForPBs(OptNode n, HashSet<ParForProgramBlock> pbs) {
        if (n.getNodeType() == OptNode.NodeType.PARFOR) {
            ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(n.getID())[1];
            pbs.add(pfpb);
        }
        if (!n.isLeaf()) {
            for (OptNode c : n.getChilds()) {
                this.rGetAllParForPBs(c, pbs);
            }
        }
        return pbs;
    }

    protected void rReplaceFunctionNames(OptNode n, String oldName, String newName) throws DMLRuntimeException, HopsException {
        if (n.getNodeType() == OptNode.NodeType.FUNCCALL) {
            FunctionOp fop = (FunctionOp)OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID());
            String[] names = n.getParam(OptNode.ParamType.OPSTRING).split("::");
            String fnamespace = names[0];
            String fname = names[1];
            if (fname.equals(oldName) || fname.equals(newName)) {
                n.addParam(OptNode.ParamType.OPSTRING, DMLProgram.constructFunctionKey(fnamespace, newName));
                long parentID = OptTreeConverter.getAbstractPlanMapping().getMappedParentID(n.getID());
                ProgramBlock pb = (ProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(parentID)[1];
                ArrayList<Instruction> instArr = pb.getInstructions();
                for (int i = 0; i < instArr.size(); ++i) {
                    FunctionCallCPInstruction fci;
                    Instruction inst = instArr.get(i);
                    if (!(inst instanceof FunctionCallCPInstruction) || !oldName.equals((fci = (FunctionCallCPInstruction)inst).getFunctionName())) continue;
                    instArr.set(i, FunctionCallCPInstruction.parseInstruction(fci.toString().replaceAll(oldName, newName)));
                }
                if (fop.getFunctionName().equals(oldName)) {
                    fop.setFunctionName(newName);
                }
            }
        }
        if (!n.isLeaf()) {
            for (OptNode c : n.getChilds()) {
                this.rReplaceFunctionNames(c, oldName, newName);
            }
        }
    }

    protected int removeRecursiveParFor(OptNode n, HashSet<ParForProgramBlock> recPBs) throws DMLRuntimeException {
        int count = 0;
        if (!n.isLeaf()) {
            for (OptNode sub : n.getChilds()) {
                if (sub.getNodeType() == OptNode.NodeType.PARFOR) {
                    long id = sub.getID();
                    Object[] progobj = OptTreeConverter.getAbstractPlanMapping().getMappedProg(id);
                    ParForStatementBlock pfsb = (ParForStatementBlock)progobj[0];
                    ParForProgramBlock pfpb = (ParForProgramBlock)progobj[1];
                    if (recPBs.contains(pfpb)) {
                        Program prog = pfpb.getProgram();
                        ForProgramBlock fpb = ProgramConverter.createShallowCopyForProgramBlock(pfpb, prog);
                        OptTreeConverter.replaceProgramBlock(n, sub, pfpb, fpb, false);
                        fpb.setStatementBlock(pfsb);
                        sub.setNodeType(OptNode.NodeType.FOR);
                        sub.setK(1);
                        ++count;
                    }
                }
                count += this.removeRecursiveParFor(sub, recPBs);
            }
        }
        return count;
    }

    protected void rewriteRemoveUnnecessaryParFor(OptNode n) throws DMLRuntimeException {
        int count = this.removeUnnecessaryParFor(n);
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'remove unnecessary parfor' - result=" + count));
    }

    protected int removeUnnecessaryParFor(OptNode n) throws DMLRuntimeException {
        int count = 0;
        if (!n.isLeaf()) {
            for (OptNode sub : n.getChilds()) {
                if (sub.getNodeType() == OptNode.NodeType.PARFOR && sub.getK() == 1) {
                    long id = sub.getID();
                    Object[] progobj = OptTreeConverter.getAbstractPlanMapping().getMappedProg(id);
                    ParForStatementBlock pfsb = (ParForStatementBlock)progobj[0];
                    ParForProgramBlock pfpb = (ParForProgramBlock)progobj[1];
                    Program prog = pfpb.getProgram();
                    ForProgramBlock fpb = ProgramConverter.createShallowCopyForProgramBlock(pfpb, prog);
                    OptTreeConverter.replaceProgramBlock(n, sub, pfpb, fpb, false);
                    fpb.setStatementBlock(pfsb);
                    sub.setNodeType(OptNode.NodeType.FOR);
                    sub.setK(1);
                    ++count;
                }
                count += this.removeUnnecessaryParFor(sub);
            }
        }
        return count;
    }

    public static String toMB(double inB) {
        return OptimizerUtils.toMB(inB) + "MB";
    }

    class UIPCandidateHop {
        Hop hopCandidate;
        Hop hopLix;
        int iLocation = -1;
        ProgramBlock pb;
        Boolean bIntermediate = false;
        Boolean bIsLoopApplicable = false;
        Boolean bUpdateInPlace = true;
        ArrayList<Hop> consumerHops = null;

        UIPCandidateHop(Hop hopLix, ProgramBlock pb) {
            this.hopLix = hopLix;
            this.pb = pb;
        }

        Hop getLixHop() {
            return this.hopLix;
        }

        Hop getHop() {
            return this.hopCandidate;
        }

        void setHop(Hop hopCandidate) {
            this.hopCandidate = hopCandidate;
        }

        int getLocation() {
            return this.iLocation;
        }

        void setLocation(int iLocation) {
            this.iLocation = iLocation;
        }

        boolean isIntermediate() {
            return this.bIntermediate;
        }

        void setIntermediate(boolean bIntermediate) {
            this.bIntermediate = bIntermediate;
        }

        boolean isLoopApplicable() {
            return this.bIsLoopApplicable;
        }

        void setIsLoopApplicable(boolean bInWhileLoop) {
            this.bIsLoopApplicable = bInWhileLoop;
        }

        boolean isUpdateInPlace() {
            return this.bUpdateInPlace;
        }

        void setUpdateInPlace(boolean bUpdateInPlace) {
            this.bUpdateInPlace = bUpdateInPlace;
        }

        ArrayList<Hop> getConsumerHops() {
            return this.consumerHops;
        }

        void setConsumerHops(ArrayList<Hop> consumerHops) {
            this.consumerHops = consumerHops;
        }
    }
}

