/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import java.util.ArrayList;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.parfor.ResultMerge;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MatrixFormatMetaData;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.util.DataConverter;

public class ResultMergeLocalMemory
extends ResultMerge {
    private double[][] _compare = null;

    public ResultMergeLocalMemory(MatrixObject out, MatrixObject[] in, String outputFilename) {
        super(out, in, outputFilename);
    }

    @Override
    public MatrixObject executeSerialMerge() throws DMLRuntimeException {
        MatrixObject moNew = null;
        LOG.trace((Object)("ResultMerge (local, in-memory): Execute serial merge for output " + this._output.getVarName() + " (fname=" + this._output.getFileName() + ")"));
        try {
            MatrixBlock outMB = (MatrixBlock)this._output.acquireRead();
            int estnnz = outMB.getNumRows() * outMB.getNumColumns();
            MatrixBlock outMBNew = new MatrixBlock(outMB.getNumRows(), outMB.getNumColumns(), outMB.isInSparseFormat(), estnnz);
            boolean appendOnly = outMBNew.isInSparseFormat();
            this._compare = this.createCompareMatrix(outMB);
            if (this._compare != null) {
                outMBNew.copy(outMB);
            }
            boolean flagMerged = false;
            for (MatrixObject in : this._inputs) {
                boolean sparseToDense;
                if (in == null || in == this._output) continue;
                LOG.trace((Object)("ResultMerge (local, in-memory): Merge input " + in.getVarName() + " (fname=" + in.getFileName() + ")"));
                MatrixBlock inMB = (MatrixBlock)in.acquireRead();
                this.merge(outMBNew, inMB, appendOnly);
                in.release();
                in.clearData();
                flagMerged = true;
                boolean bl = sparseToDense = appendOnly && !MatrixBlock.evalSparseFormatInMemory(outMBNew.getNumRows(), outMBNew.getNumColumns(), outMBNew.getNonZeros());
                if (!sparseToDense) continue;
                outMBNew.sortSparseRows();
                outMBNew.examSparsity();
                appendOnly = false;
            }
            if (appendOnly) {
                outMBNew.sortSparseRows();
            }
            outMBNew.examSparsity();
            moNew = flagMerged ? this.createNewMatrixObject(outMBNew) : this._output;
            this._output.release();
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return moNew;
    }

    @Override
    public MatrixObject executeParallelMerge(int par) throws DMLRuntimeException {
        MatrixObject moNew = null;
        LOG.trace((Object)("ResultMerge (local, in-memory): Execute parallel (par=" + par + ") merge for output " + this._output.getVarName() + " (fname=" + this._output.getFileName() + ")"));
        try {
            MatrixBlock outMB = (MatrixBlock)this._output.acquireRead();
            ArrayList<MatrixObject> inMO = new ArrayList<MatrixObject>();
            for (MatrixObject in : this._inputs) {
                if (in == null || in == this._output) continue;
                inMO.add(in);
            }
            if (!inMO.isEmpty()) {
                long rows = outMB.getNumRows();
                long cols = outMB.getNumColumns();
                MatrixBlock outMBNew = new MatrixBlock((int)rows, (int)cols, false);
                outMBNew.allocateDenseBlockUnsafe((int)rows, (int)cols);
                this._compare = this.createCompareMatrix(outMB);
                if (this._compare != null) {
                    outMBNew.copy(outMB);
                }
                int numThreads = Math.min(par, inMO.size());
                numThreads = Math.min(numThreads, InfrastructureAnalyzer.getLocalParallelism());
                Thread[] threads = new Thread[numThreads];
                for (int k = 0; k < inMO.size(); k += numThreads) {
                    int i;
                    for (i = 0; i < threads.length; ++i) {
                        ResultMergeWorker rmw = new ResultMergeWorker((MatrixObject)inMO.get(k + i), outMBNew);
                        threads[i] = new Thread(rmw);
                        threads[i].setPriority(10);
                        threads[i].start();
                    }
                    for (i = 0; i < threads.length; ++i) {
                        threads[i].join();
                    }
                }
                moNew = this.createNewMatrixObject(outMBNew);
            } else {
                moNew = this._output;
            }
            this._output.release();
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return moNew;
    }

    private double[][] createCompareMatrix(MatrixBlock output) {
        double[][] ret = null;
        if (output.getNonZeros() > 0L) {
            ret = DataConverter.convertToDoubleMatrix(output);
        }
        return ret;
    }

    private MatrixObject createNewMatrixObject(MatrixBlock data) throws DMLRuntimeException {
        String varName = this._output.getVarName();
        Expression.ValueType vt = this._output.getValueType();
        MatrixFormatMetaData metadata = (MatrixFormatMetaData)this._output.getMetaData();
        MatrixObject moNew = new MatrixObject(vt, this._outputFName);
        moNew.setVarName(varName.contains("_rm") ? varName : varName + "_rm");
        moNew.setDataType(Expression.DataType.MATRIX);
        MatrixCharacteristics mcOld = metadata.getMatrixCharacteristics();
        OutputInfo oiOld = metadata.getOutputInfo();
        InputInfo iiOld = metadata.getInputInfo();
        MatrixCharacteristics mc = new MatrixCharacteristics(mcOld.getRows(), mcOld.getCols(), mcOld.getRowsPerBlock(), mcOld.getColsPerBlock());
        mc.setNonZeros(data.getNonZeros());
        MatrixFormatMetaData meta = new MatrixFormatMetaData(mc, oiOld, iiOld);
        moNew.setMetaData(meta);
        data.examSparsity();
        moNew.acquireModify(data);
        moNew.release();
        return moNew;
    }

    private void merge(MatrixBlock out, MatrixBlock in, boolean appendOnly) throws DMLRuntimeException {
        if (this._compare == null) {
            this.mergeWithoutComp(out, in, appendOnly);
        } else {
            this.mergeWithComp(out, in, this._compare);
        }
    }

    private class ResultMergeWorker
    implements Runnable {
        private MatrixObject _inMO = null;
        private MatrixBlock _outMB = null;

        public ResultMergeWorker(MatrixObject inMO, MatrixBlock outMB) {
            this._inMO = inMO;
            this._outMB = outMB;
        }

        @Override
        public void run() {
            try {
                ResultMerge.LOG.trace((Object)("ResultMerge (local, in-memory): Merge input " + this._inMO.getVarName() + " (fname=" + this._inMO.getFileName() + ")"));
                MatrixBlock inMB = (MatrixBlock)this._inMO.acquireRead();
                ResultMergeLocalMemory.this.merge(this._outMB, inMB, false);
                this._inMO.release();
                this._inMO.clearData();
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to parallel merge result.", ex);
            }
        }
    }
}

