/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.util.LongAccumulator;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.controlprogram.parfor.RemoteParForJobReturn;
import org.apache.sysml.runtime.controlprogram.parfor.RemoteParForSparkWorker;
import org.apache.sysml.runtime.controlprogram.parfor.RemoteParForUtils;
import org.apache.sysml.runtime.controlprogram.parfor.Task;
import org.apache.sysml.utils.Statistics;

public class RemoteParForSpark {
    protected static final Log LOG = LogFactory.getLog((String)RemoteParForSpark.class.getName());

    public static RemoteParForJobReturn runJob(long pfid, String program, HashMap<String, byte[]> clsMap, List<Task> tasks, ExecutionContext ec, boolean cpCaching, int numMappers) throws DMLRuntimeException {
        String jobname = "ParFor-ESP";
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        JavaSparkContext sc = sec.getSparkContext();
        LongAccumulator aTasks = sc.sc().longAccumulator("tasks");
        LongAccumulator aIters = sc.sc().longAccumulator("iterations");
        RemoteParForSparkWorker func = new RemoteParForSparkWorker(program, clsMap, cpCaching, aTasks, aIters);
        List out = sc.parallelize(tasks, tasks.size()).flatMapToPair((PairFlatMapFunction)func).collect();
        LocalVariableMap[] results = RemoteParForUtils.getResults(out, LOG);
        int numTasks = aTasks.value().intValue();
        int numIters = aIters.value().intValue();
        RemoteParForJobReturn ret = new RemoteParForJobReturn(true, numTasks, numIters, results);
        Statistics.incrementNoOfCompiledSPInst();
        Statistics.incrementNoOfExecutedSPInst();
        if (DMLScript.STATISTICS) {
            Statistics.maintainCPHeavyHitters(jobname, System.nanoTime() - t0);
        }
        return ret;
    }
}

