/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram;

import java.util.ArrayList;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.WhileStatementBlock;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.DMLScriptException;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.ProgramBlock;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.cp.BooleanObject;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.cp.StringObject;
import org.apache.sysml.runtime.instructions.cp.VariableCPInstruction;
import org.apache.sysml.yarn.DMLAppMasterUtils;

public class WhileProgramBlock
extends ProgramBlock {
    private ArrayList<Instruction> _predicate;
    private String _predicateResultVar;
    private ArrayList<Instruction> _exitInstructions;
    private ArrayList<ProgramBlock> _childBlocks;

    public WhileProgramBlock(Program prog, ArrayList<Instruction> predicate) {
        super(prog);
        this._predicate = predicate;
        this._predicateResultVar = this.findPredicateResultVar();
        this._exitInstructions = new ArrayList();
        this._childBlocks = new ArrayList();
    }

    public void addProgramBlock(ProgramBlock childBlock) {
        this._childBlocks.add(childBlock);
    }

    public void setExitInstructions2(ArrayList<Instruction> exitInstructions) {
        this._exitInstructions = exitInstructions;
    }

    public void setExitInstructions1(ArrayList<Instruction> predicate) {
        this._predicate = predicate;
    }

    public ArrayList<Instruction> getPredicate() {
        return this._predicate;
    }

    public void setPredicate(ArrayList<Instruction> predicate) {
        this._predicate = predicate;
        if (this._predicate != null && !this._predicate.isEmpty()) {
            this._predicateResultVar = this.findPredicateResultVar();
        }
    }

    public String getPredicateResultVar() {
        return this._predicateResultVar;
    }

    public void setPredicateResultVar(String resultVar) {
        this._predicateResultVar = resultVar;
    }

    public ArrayList<Instruction> getExitInstructions() {
        return this._exitInstructions;
    }

    private BooleanObject executePredicate(ExecutionContext ec) throws DMLRuntimeException {
        BooleanObject result = null;
        try {
            if (this._predicate != null && !this._predicate.isEmpty()) {
                if (this._sb != null) {
                    if (DMLScript.isActiveAM()) {
                        DMLAppMasterUtils.setupProgramBlockRemoteMaxMemory(this);
                    }
                    WhileStatementBlock wsb = (WhileStatementBlock)this._sb;
                    Hop predicateOp = wsb.getPredicateHops();
                    boolean recompile = wsb.requiresPredicateRecompilation();
                    result = (BooleanObject)this.executePredicate(this._predicate, predicateOp, recompile, Expression.ValueType.BOOLEAN, ec);
                } else {
                    result = (BooleanObject)this.executePredicate(this._predicate, null, false, Expression.ValueType.BOOLEAN, ec);
                }
            } else {
                ScalarObject scalarResult = null;
                Data resultData = ec.getVariable(this._predicateResultVar);
                scalarResult = resultData == null ? ec.getScalarInput(this._predicateResultVar, Expression.ValueType.BOOLEAN, true) : ec.getScalarInput(this._predicateResultVar, Expression.ValueType.BOOLEAN, false);
                if (scalarResult instanceof StringObject) {
                    throw new DMLRuntimeException(this.printBlockErrorLocation() + "\nWhile predicate variable " + this._predicateResultVar + " evaluated to string " + scalarResult + " which is not allowed for predicates in DML");
                }
                result = scalarResult instanceof BooleanObject ? (BooleanObject)scalarResult : new BooleanObject(scalarResult.getBooleanValue());
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Failed to evaluate the while predicate.", ex);
        }
        return result;
    }

    @Override
    public void execute(ExecutionContext ec) throws DMLRuntimeException {
        try {
            MatrixObject.UpdateType[] flags = this.prepareUpdateInPlaceVariables(ec, this._tid);
            while (this.executePredicate(ec).getBooleanValue()) {
                for (int i = 0; i < this._childBlocks.size(); ++i) {
                    ec.updateDebugState(i);
                    this._childBlocks.get(i).execute(ec);
                }
            }
            this.resetUpdateInPlaceVariableFlags(ec, flags);
        }
        catch (DMLScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Error evaluating while program block", e);
        }
        try {
            this.executeInstructions(this._exitInstructions, ec);
        }
        catch (Exception e) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Error executing while exit instructions.", e);
        }
    }

    public ArrayList<ProgramBlock> getChildBlocks() {
        return this._childBlocks;
    }

    public void setChildBlocks(ArrayList<ProgramBlock> childs) {
        this._childBlocks = childs;
    }

    private String findPredicateResultVar() {
        String result = null;
        for (Instruction si : this._predicate) {
            if (si.getType() == Instruction.INSTRUCTION_TYPE.CONTROL_PROGRAM && ((CPInstruction)si).getCPInstructionType() != CPInstruction.CPINSTRUCTION_TYPE.Variable) {
                result = ((ComputationCPInstruction)si).getOutputVariableName();
                continue;
            }
            if (!(si instanceof VariableCPInstruction) || !((VariableCPInstruction)si).isVariableCastInstruction()) continue;
            result = ((VariableCPInstruction)si).getOutputVariableName();
        }
        return result;
    }

    @Override
    public String printBlockErrorLocation() {
        return "ERROR: Runtime error in while program block generated from while statement block between lines " + this._beginLine + " and " + this._endLine + " -- ";
    }
}

