/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.DMLScriptException;
import org.apache.sysml.runtime.controlprogram.FunctionProgramBlock;
import org.apache.sysml.runtime.controlprogram.ProgramBlock;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;

public class Program {
    public static final String KEY_DELIM = "::";
    public ArrayList<ProgramBlock> _programBlocks;
    private HashMap<String, HashMap<String, FunctionProgramBlock>> _namespaceFunctions = new HashMap();

    public Program() throws DMLRuntimeException {
        this._programBlocks = new ArrayList();
    }

    public synchronized void addFunctionProgramBlock(String namespace, String fname, FunctionProgramBlock fpb) {
        if (namespace == null) {
            namespace = DMLProgram.DEFAULT_NAMESPACE;
        }
        HashMap<String, FunctionProgramBlock> namespaceBlocks = null;
        namespaceBlocks = this._namespaceFunctions.get(namespace);
        if (namespaceBlocks == null) {
            namespaceBlocks = new HashMap();
            this._namespaceFunctions.put(namespace, namespaceBlocks);
        }
        namespaceBlocks.put(fname, fpb);
    }

    public synchronized void removeFunctionProgramBlock(String namespace, String fname) {
        if (namespace == null) {
            namespace = DMLProgram.DEFAULT_NAMESPACE;
        }
        HashMap<String, FunctionProgramBlock> namespaceBlocks = null;
        if (this._namespaceFunctions.containsKey(namespace) && (namespaceBlocks = this._namespaceFunctions.get(namespace)).containsKey(fname)) {
            namespaceBlocks.remove(fname);
        }
    }

    public synchronized HashMap<String, FunctionProgramBlock> getFunctionProgramBlocks() {
        HashMap<String, FunctionProgramBlock> retVal = new HashMap<String, FunctionProgramBlock>();
        for (String namespace : this._namespaceFunctions.keySet()) {
            HashMap<String, FunctionProgramBlock> namespaceFSB = this._namespaceFunctions.get(namespace);
            for (Map.Entry<String, FunctionProgramBlock> e : namespaceFSB.entrySet()) {
                String fname = e.getKey();
                FunctionProgramBlock fpb = e.getValue();
                String fKey = DMLProgram.constructFunctionKey(namespace, fname);
                retVal.put(fKey, fpb);
            }
        }
        return retVal;
    }

    public synchronized FunctionProgramBlock getFunctionProgramBlock(String namespace, String fname) throws DMLRuntimeException {
        HashMap<String, FunctionProgramBlock> namespaceFunctBlocks;
        if (namespace == null) {
            namespace = DMLProgram.DEFAULT_NAMESPACE;
        }
        if ((namespaceFunctBlocks = this._namespaceFunctions.get(namespace)) == null) {
            throw new DMLRuntimeException("namespace " + namespace + " is undefined");
        }
        FunctionProgramBlock retVal = namespaceFunctBlocks.get(fname);
        if (retVal == null) {
            throw new DMLRuntimeException("function " + fname + " is undefined in namespace " + namespace);
        }
        return retVal;
    }

    public void addProgramBlock(ProgramBlock pb) {
        this._programBlocks.add(pb);
    }

    public ArrayList<ProgramBlock> getProgramBlocks() {
        return this._programBlocks;
    }

    public void execute(ExecutionContext ec) throws DMLRuntimeException {
        ec.initDebugProgramCounters();
        try {
            for (int i = 0; i < this._programBlocks.size(); ++i) {
                ec.updateDebugState(i);
                this._programBlocks.get(i).execute(ec);
            }
        }
        catch (DMLScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DMLRuntimeException(e);
        }
        ec.clearDebugProgramCounters();
    }
}

