/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.compress;

import java.util.Iterator;

public final class BitmapDecoderRLE
implements Iterator<Integer> {
    private int _bmOff;
    private int _bmLen;
    private char[] _bmPtr;
    private int _nextBmOffset;
    private int _runStartOffset;
    private int _curRunLen;
    private int _runBitsReturned;

    public BitmapDecoderRLE(char[] bmPtr, int off, int len) {
        this._bmOff = off;
        this._bmLen = len;
        this._bmPtr = bmPtr;
        this._nextBmOffset = 0;
        this._runStartOffset = 0;
        this._curRunLen = 0;
        this._runBitsReturned = 0;
        if (0 == this._bmLen) {
            return;
        }
        this.advanceToNextRun();
    }

    @Override
    public Integer next() {
        if (!this.hasNext()) {
            throw new RuntimeException("No next offset existing.");
        }
        int ret = this._runStartOffset + this._runBitsReturned;
        ++this._runBitsReturned;
        if (this._runBitsReturned == this._curRunLen) {
            this.advanceToNextRun();
        }
        return ret;
    }

    @Override
    public boolean hasNext() {
        return this._runBitsReturned < this._curRunLen;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented for BitmapDecoderRLE.");
    }

    private void advanceToNextRun() {
        while (this._runBitsReturned == this._curRunLen && this._nextBmOffset < this._bmLen) {
            this._runBitsReturned = 0;
            char delta = this._bmPtr[this._bmOff + this._nextBmOffset];
            this._runStartOffset += delta + this._curRunLen;
            this._curRunLen = this._bmPtr[this._bmOff + this._nextBmOffset + 1];
            this._nextBmOffset += 2;
        }
    }
}

