/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.codegen;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.codegen.LibSpoofPrimitives;
import org.apache.sysml.runtime.codegen.SpoofOperator;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.matrix.data.LibMatrixMult;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.SparseBlock;
import org.apache.sysml.runtime.util.UtilFunctions;

public abstract class SpoofRowwise
extends SpoofOperator {
    private static final long serialVersionUID = 6242910797139642998L;
    private static final long PAR_NUMCELL_THRESHOLD = 0x100000L;
    protected final RowType _type;
    protected final int _reqVectMem;

    public SpoofRowwise(RowType type, int reqVectMem) {
        this._type = type;
        this._reqVectMem = reqVectMem;
    }

    public RowType getRowType() {
        return this._type;
    }

    public int getNumIntermediates() {
        return this._reqVectMem;
    }

    @Override
    public String getSpoofType() {
        return "RA" + this.getClass().getName().split("\\.")[1];
    }

    @Override
    public void execute(ArrayList<MatrixBlock> inputs, ArrayList<ScalarObject> scalarObjects, MatrixBlock out) throws DMLRuntimeException {
        this.execute(inputs, scalarObjects, out, true, false);
    }

    public void execute(ArrayList<MatrixBlock> inputs, ArrayList<ScalarObject> scalarObjects, MatrixBlock out, boolean allocTmp, boolean aggIncr) throws DMLRuntimeException {
        if (inputs == null || inputs.size() < 1 || out == null) {
            throw new RuntimeException("Invalid input arguments.");
        }
        int m = inputs.get(0).getNumRows();
        int n = inputs.get(0).getNumColumns();
        if (!aggIncr || !out.isAllocated()) {
            this.allocateOutputMatrix(m, n, out);
        }
        double[] c = out.getDenseBlock();
        double[][] b = this.prepInputMatrices(inputs);
        double[] scalars = this.prepInputScalars(scalarObjects);
        if (allocTmp) {
            LibSpoofPrimitives.setupThreadLocalMemory(this._reqVectMem, n);
        }
        if (!inputs.get(0).isInSparseFormat()) {
            this.executeDense(inputs.get(0).getDenseBlock(), b, scalars, c, n, 0, m);
        } else {
            this.executeSparse(inputs.get(0).getSparseBlock(), b, scalars, c, n, 0, m);
        }
        if (allocTmp) {
            LibSpoofPrimitives.cleanupThreadLocalMemory();
        }
        out.recomputeNonZeros();
        out.examSparsity();
    }

    @Override
    public void execute(ArrayList<MatrixBlock> inputs, ArrayList<ScalarObject> scalarObjects, MatrixBlock out, int k) throws DMLRuntimeException {
        if (k <= 1 || (long)inputs.get(0).getNumRows() * (long)inputs.get(0).getNumColumns() < 0x100000L) {
            this.execute(inputs, scalarObjects, out);
            return;
        }
        if (inputs == null || inputs.size() < 1 || out == null) {
            throw new RuntimeException("Invalid input arguments.");
        }
        int m = inputs.get(0).getNumRows();
        int n = inputs.get(0).getNumColumns();
        this.allocateOutputMatrix(m, n, out);
        double[][] b = this.prepInputMatrices(inputs);
        double[] scalars = this.prepInputScalars(scalarObjects);
        ExecutorService pool = Executors.newFixedThreadPool(k);
        int nk = UtilFunctions.roundToNext(Math.min(8 * k, m / 32), k);
        int blklen = (int)Math.ceil((double)m / (double)nk);
        try {
            if (this._type.isColumnAgg()) {
                ArrayList<ParColAggTask> tasks = new ArrayList<ParColAggTask>();
                int i = 0;
                while (i < nk & i * blklen < m) {
                    tasks.add(new ParColAggTask(inputs.get(0), b, scalars, n, i * blklen, Math.min((i + 1) * blklen, m)));
                    ++i;
                }
                List taskret = pool.invokeAll(tasks);
                for (Future task : taskret) {
                    LibMatrixMult.vectAdd((double[])task.get(), out.getDenseBlock(), 0, 0, n);
                }
                out.recomputeNonZeros();
            } else {
                ArrayList<ParExecTask> tasks = new ArrayList<ParExecTask>();
                int i = 0;
                while (i < nk & i * blklen < m) {
                    tasks.add(new ParExecTask(inputs.get(0), b, out, scalars, n, i * blklen, Math.min((i + 1) * blklen, m)));
                    ++i;
                }
                List taskret = pool.invokeAll(tasks);
                long nnz = 0L;
                for (Future task : taskret) {
                    nnz += ((Long)task.get()).longValue();
                }
                out.setNonZeros(nnz);
            }
            pool.shutdown();
            out.examSparsity();
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    private void allocateOutputMatrix(int m, int n, MatrixBlock out) {
        switch (this._type) {
            case NO_AGG: {
                out.reset(m, n, false);
                break;
            }
            case ROW_AGG: {
                out.reset(m, 1, false);
                break;
            }
            case COL_AGG: {
                out.reset(1, n, false);
                break;
            }
            case COL_AGG_T: {
                out.reset(n, 1, false);
            }
        }
        out.allocateDenseBlock();
    }

    private void executeDense(double[] a, double[][] b, double[] scalars, double[] c, int n, int rl, int ru) {
        if (a == null) {
            return;
        }
        int i = rl;
        int aix = rl * n;
        while (i < ru) {
            this.genexecRowDense(a, aix, b, scalars, c, n, i);
            ++i;
            aix += n;
        }
    }

    private void executeSparse(SparseBlock sblock, double[][] b, double[] scalars, double[] c, int n, int rl, int ru) {
        if (sblock == null) {
            return;
        }
        for (int i = rl; i < ru; ++i) {
            if (sblock.isEmpty(i)) continue;
            double[] avals = sblock.values(i);
            int[] aix = sblock.indexes(i);
            int apos = sblock.pos(i);
            int alen = sblock.size(i);
            this.genexecRowSparse(avals, aix, apos, b, scalars, c, alen, i);
        }
    }

    protected abstract void genexecRowDense(double[] var1, int var2, double[][] var3, double[] var4, double[] var5, int var6, int var7);

    protected abstract void genexecRowSparse(double[] var1, int[] var2, int var3, double[][] var4, double[] var5, double[] var6, int var7, int var8);

    private class ParExecTask
    implements Callable<Long> {
        private final MatrixBlock _a;
        private final double[][] _b;
        private final MatrixBlock _c;
        private final double[] _scalars;
        private final int _clen;
        private final int _rl;
        private final int _ru;

        protected ParExecTask(MatrixBlock a, double[][] b, MatrixBlock c, double[] scalars, int clen, int rl, int ru) {
            this._a = a;
            this._b = b;
            this._c = c;
            this._scalars = scalars;
            this._clen = clen;
            this._rl = rl;
            this._ru = ru;
        }

        @Override
        public Long call() throws DMLRuntimeException {
            LibSpoofPrimitives.setupThreadLocalMemory(SpoofRowwise.this._reqVectMem, this._clen);
            if (!this._a.isInSparseFormat()) {
                SpoofRowwise.this.executeDense(this._a.getDenseBlock(), this._b, this._scalars, this._c.getDenseBlock(), this._clen, this._rl, this._ru);
            } else {
                SpoofRowwise.this.executeSparse(this._a.getSparseBlock(), this._b, this._scalars, this._c.getDenseBlock(), this._clen, this._rl, this._ru);
            }
            LibSpoofPrimitives.cleanupThreadLocalMemory();
            return this._c.recomputeNonZeros(this._rl, this._ru - 1, 0, this._c.getNumColumns() - 1);
        }
    }

    private class ParColAggTask
    implements Callable<double[]> {
        private final MatrixBlock _a;
        private final double[][] _b;
        private final double[] _scalars;
        private final int _clen;
        private final int _rl;
        private final int _ru;

        protected ParColAggTask(MatrixBlock a, double[][] b, double[] scalars, int clen, int rl, int ru) {
            this._a = a;
            this._b = b;
            this._scalars = scalars;
            this._clen = clen;
            this._rl = rl;
            this._ru = ru;
        }

        @Override
        public double[] call() throws DMLRuntimeException {
            LibSpoofPrimitives.setupThreadLocalMemory(SpoofRowwise.this._reqVectMem, this._clen);
            double[] c = new double[this._clen];
            if (!this._a.isInSparseFormat()) {
                SpoofRowwise.this.executeDense(this._a.getDenseBlock(), this._b, this._scalars, c, this._clen, this._rl, this._ru);
            } else {
                SpoofRowwise.this.executeSparse(this._a.getSparseBlock(), this._b, this._scalars, c, this._clen, this._rl, this._ru);
            }
            LibSpoofPrimitives.cleanupThreadLocalMemory();
            return c;
        }
    }

    public static enum RowType {
        NO_AGG,
        ROW_AGG,
        COL_AGG,
        COL_AGG_T;


        public boolean isColumnAgg() {
            return this == COL_AGG || this == COL_AGG_T;
        }
    }
}

