/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser.pydml;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.FunctionStatementBlock;
import org.apache.sysml.parser.ImportStatement;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.ParseException;
import org.apache.sysml.parser.ParserWrapper;
import org.apache.sysml.parser.Statement;
import org.apache.sysml.parser.common.CustomErrorListener;
import org.apache.sysml.parser.pydml.PydmlLexer;
import org.apache.sysml.parser.pydml.PydmlParser;
import org.apache.sysml.parser.pydml.PydmlPreprocessor;
import org.apache.sysml.parser.pydml.PydmlSyntacticValidator;

public class PyDMLParserWrapper
extends ParserWrapper {
    private static final Log LOG = LogFactory.getLog((String)DMLScript.class.getName());

    @Override
    public DMLProgram parse(String fileName, String dmlScript, Map<String, String> argVals) throws ParseException {
        DMLProgram prog = this.doParse(fileName, dmlScript, null, argVals);
        return prog;
    }

    public DMLProgram doParse(String fileName, String dmlScript, String sourceNamespace, Map<String, String> argVals) throws ParseException {
        ANTLRInputStream in;
        DMLProgram dmlPgm = null;
        try {
            if (dmlScript == null) {
                dmlScript = PyDMLParserWrapper.readDMLScript(fileName, LOG);
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(dmlScript.getBytes());
            in = new ANTLRInputStream(stream);
        }
        catch (FileNotFoundException e) {
            throw new ParseException("Cannot find file/resource: " + fileName, e);
        }
        catch (IOException e) {
            throw new ParseException("Cannot open file: " + fileName, e);
        }
        catch (LanguageException e) {
            throw new ParseException(e.getMessage(), e);
        }
        PydmlParser.ProgramrootContext ast = null;
        CustomErrorListener errorListener = new CustomErrorListener();
        try {
            PydmlLexer lexer = new PydmlLexer(in);
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            PydmlParser antlr4Parser = new PydmlParser(tokens);
            boolean tryOptimizedParsing = false;
            if (tryOptimizedParsing) {
                ((ParserATNSimulator)antlr4Parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
                antlr4Parser.removeErrorListeners();
                antlr4Parser.setErrorHandler(new BailErrorStrategy());
                try {
                    ast = antlr4Parser.programroot();
                }
                catch (ParseCancellationException ex) {
                    tokens.reset();
                    antlr4Parser.reset();
                    if (fileName != null) {
                        errorListener.setCurrentFileName(fileName);
                    } else {
                        errorListener.setCurrentFileName("MAIN_SCRIPT");
                    }
                    antlr4Parser.addErrorListener(errorListener);
                    antlr4Parser.setErrorHandler(new DefaultErrorStrategy());
                    ((ParserATNSimulator)antlr4Parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
                    ast = antlr4Parser.programroot();
                }
            } else {
                antlr4Parser.removeErrorListeners();
                antlr4Parser.addErrorListener(errorListener);
                errorListener.setCurrentFileName(fileName);
                ast = antlr4Parser.programroot();
            }
        }
        catch (Exception e) {
            throw new ParseException("ERROR: Cannot parse the program:" + fileName, e);
        }
        PydmlParser.ProgramrootContext tree = ast;
        ParseTreeWalker walker = new ParseTreeWalker();
        PydmlPreprocessor prep = new PydmlPreprocessor(errorListener);
        walker.walk(prep, tree);
        PydmlSyntacticValidator validator = new PydmlSyntacticValidator(errorListener, argVals, sourceNamespace, prep.getFunctionDefs());
        walker.walk(validator, tree);
        errorListener.unsetCurrentFileName();
        this.parseIssues = errorListener.getParseIssues();
        this.atLeastOneWarning = errorListener.isAtLeastOneWarning();
        this.atLeastOneError = errorListener.isAtLeastOneError();
        if (this.atLeastOneError) {
            throw new ParseException(this.parseIssues, dmlScript);
        }
        if (this.atLeastOneWarning) {
            LOG.warn((Object)CustomErrorListener.generateParseIssuesMessage(dmlScript, this.parseIssues));
        }
        dmlPgm = this.createDMLProgram(ast, sourceNamespace);
        return dmlPgm;
    }

    private DMLProgram createDMLProgram(PydmlParser.ProgramrootContext ast, String sourceNamespace) {
        DMLProgram dmlPgm = new DMLProgram();
        String namespace = sourceNamespace != null && sourceNamespace.length() > 0 ? sourceNamespace : DMLProgram.DEFAULT_NAMESPACE;
        dmlPgm.getNamespaces().put(namespace, dmlPgm);
        for (PydmlParser.FunctionStatementContext fn : ast.functionBlocks) {
            FunctionStatementBlock functionStmtBlk = new FunctionStatementBlock();
            functionStmtBlk.addStatement(fn.info.stmt);
            try {
                dmlPgm.addFunctionStatementBlock(namespace, fn.info.functionName, functionStmtBlk);
            }
            catch (LanguageException e) {
                LOG.error((Object)("line: " + fn.start.getLine() + ":" + fn.start.getCharPositionInLine() + " cannot process the function " + fn.info.functionName));
                return null;
            }
        }
        for (PydmlParser.StatementContext stmtCtx : ast.blocks) {
            Statement current = stmtCtx.info.stmt;
            if (current == null) {
                LOG.error((Object)("line: " + stmtCtx.start.getLine() + ":" + stmtCtx.start.getCharPositionInLine() + " cannot process the statement"));
                return null;
            }
            if (current.isEmptyNewLineStatement()) continue;
            if (current instanceof ImportStatement) {
                if (stmtCtx.info.namespaces != null) {
                    for (Map.Entry<String, DMLProgram> entry : stmtCtx.info.namespaces.entrySet()) {
                        DMLProgram prog = entry.getValue();
                        if (prog != null && prog.getNamespaces().size() > 0) {
                            dmlPgm.getNamespaces().put(entry.getKey(), prog);
                        }
                        for (Map.Entry<String, DMLProgram> dependency : entry.getValue().getNamespaces().entrySet()) {
                            String depNamespace = dependency.getKey();
                            DMLProgram depProgram = dependency.getValue();
                            if (dmlPgm.getNamespaces().get(depNamespace) != null) continue;
                            dmlPgm.getNamespaces().put(depNamespace, depProgram);
                        }
                    }
                } else {
                    LOG.error((Object)("line: " + stmtCtx.start.getLine() + ":" + stmtCtx.start.getCharPositionInLine() + " cannot process the import statement"));
                    return null;
                }
            }
            dmlPgm.addStatementBlock(PyDMLParserWrapper.getStatementBlock(current));
        }
        dmlPgm.mergeStatementBlocks();
        return dmlPgm;
    }
}

