/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import org.apache.sysml.parser.ConstIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.VariableSet;
import org.apache.sysml.runtime.util.UtilFunctions;

public class DoubleIdentifier
extends ConstIdentifier {
    private double _val;

    public DoubleIdentifier(double val, String filename, int blp, int bcp, int elp, int ecp) {
        this._val = val;
        this._kind = Expression.Kind.Data;
        this.setDimensions(0L, 0L);
        this.computeDataType();
        this.setValueType(Expression.ValueType.DOUBLE);
        this.setAllPositions(filename, blp, bcp, elp, ecp);
    }

    public DoubleIdentifier(DoubleIdentifier d, String filename, int blp, int bcp, int elp, int ecp) {
        this._val = d.getValue();
        this._kind = Expression.Kind.Data;
        this.setDimensions(0L, 0L);
        this.computeDataType();
        this.setValueType(Expression.ValueType.DOUBLE);
        this.setAllPositions(filename, blp, bcp, elp, ecp);
    }

    @Override
    public Expression rewriteExpression(String prefix) throws LanguageException {
        return this;
    }

    public void multiplyByMinusOne() {
        this._val = -1.0 * this._val;
    }

    public double getValue() {
        return this._val;
    }

    public void setValue(double v) {
        this._val = v;
    }

    public String toString() {
        return Double.toString(this._val);
    }

    @Override
    public VariableSet variablesRead() {
        return null;
    }

    @Override
    public VariableSet variablesUpdated() {
        return null;
    }

    @Override
    public long getLongValue() {
        return UtilFunctions.toLong(this.getValue());
    }
}

