/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.sysml.parser.BooleanIdentifier;
import org.apache.sysml.parser.ConstIdentifier;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.DoubleIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.ExpressionList;
import org.apache.sysml.parser.FunctionCallIdentifier;
import org.apache.sysml.parser.Identifier;
import org.apache.sysml.parser.IntIdentifier;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.MultiAssignmentStatement;
import org.apache.sysml.parser.ParameterExpression;
import org.apache.sysml.parser.VariableSet;
import org.apache.sysml.runtime.util.ConvolutionUtils;

public class BuiltinFunctionExpression
extends DataIdentifier {
    protected Expression[] _args = null;
    private Expression.BuiltinFunctionOp _opcode;

    public BuiltinFunctionExpression(Expression.BuiltinFunctionOp bifop, ArrayList<ParameterExpression> args, String fname, int blp, int bcp, int elp, int ecp) {
        this._kind = Expression.Kind.BuiltinFunctionOp;
        this._opcode = bifop;
        this.setAllPositions(fname, blp, bcp, elp, ecp);
        args = this.expandConvolutionArguments(args);
        this._args = new Expression[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            this._args[i] = args.get(i).getExpr();
        }
    }

    public BuiltinFunctionExpression(Expression.BuiltinFunctionOp bifop, Expression[] args, String fname, int blp, int bcp, int elp, int ecp) {
        this._kind = Expression.Kind.BuiltinFunctionOp;
        this._opcode = bifop;
        this._args = new Expression[args.length];
        for (int i = 0; i < args.length; ++i) {
            this._args[i] = args[i];
        }
        this.setAllPositions(fname, blp, bcp, elp, ecp);
    }

    @Override
    public Expression rewriteExpression(String prefix) throws LanguageException {
        Expression[] newArgs = new Expression[this._args.length];
        for (int i = 0; i < this._args.length; ++i) {
            newArgs[i] = this._args[i].rewriteExpression(prefix);
        }
        BuiltinFunctionExpression retVal = new BuiltinFunctionExpression(this._opcode, newArgs, this.getFilename(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
        return retVal;
    }

    public Expression.BuiltinFunctionOp getOpCode() {
        return this._opcode;
    }

    public Expression getFirstExpr() {
        return this._args.length >= 1 ? this._args[0] : null;
    }

    public Expression getSecondExpr() {
        return this._args.length >= 2 ? this._args[1] : null;
    }

    public Expression getThirdExpr() {
        return this._args.length >= 3 ? this._args[2] : null;
    }

    public Expression[] getAllExpr() {
        return this._args;
    }

    @Override
    public void validateExpression(MultiAssignmentStatement stmt, HashMap<String, DataIdentifier> ids, HashMap<String, ConstIdentifier> constVars, boolean conditional) throws LanguageException {
        if (this.getFirstExpr() instanceof FunctionCallIdentifier) {
            this.raiseValidateError("UDF function call not supported as parameter to built-in function call", false);
        }
        this.getFirstExpr().validateExpression(ids, constVars, conditional);
        if (this.getSecondExpr() != null) {
            if (this.getSecondExpr() instanceof FunctionCallIdentifier) {
                this.raiseValidateError("UDF function call not supported as parameter to built-in function call", false);
            }
            this.getSecondExpr().validateExpression(ids, constVars, conditional);
        }
        if (this.getThirdExpr() != null) {
            if (this.getThirdExpr() instanceof FunctionCallIdentifier) {
                this.raiseValidateError("UDF function call not supported as parameter to built-in function call", false);
            }
            this.getThirdExpr().validateExpression(ids, constVars, conditional);
        }
        this._outputs = new Identifier[stmt.getTargetList().size()];
        int count = 0;
        for (DataIdentifier outParam : stmt.getTargetList()) {
            DataIdentifier tmp = new DataIdentifier(outParam);
            tmp.setAllPositions(this.getFilename(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
            this._outputs[count++] = tmp;
        }
        switch (this._opcode) {
            case QR: {
                this.checkNumParameters(1);
                this.checkMatrixParam(this.getFirstExpr());
                DataIdentifier qrOut1 = (DataIdentifier)this.getOutputs()[0];
                DataIdentifier qrOut2 = (DataIdentifier)this.getOutputs()[1];
                long rows = this.getFirstExpr().getOutput().getDim1();
                long cols = this.getFirstExpr().getOutput().getDim2();
                qrOut1.setDataType(Expression.DataType.MATRIX);
                qrOut1.setValueType(Expression.ValueType.DOUBLE);
                qrOut1.setDimensions(rows, cols);
                qrOut1.setBlockDimensions(this.getFirstExpr().getOutput().getRowsInBlock(), this.getFirstExpr().getOutput().getColumnsInBlock());
                qrOut2.setDataType(Expression.DataType.MATRIX);
                qrOut2.setValueType(Expression.ValueType.DOUBLE);
                qrOut2.setDimensions(rows, cols);
                qrOut2.setBlockDimensions(this.getFirstExpr().getOutput().getRowsInBlock(), this.getFirstExpr().getOutput().getColumnsInBlock());
                break;
            }
            case LU: {
                this.checkNumParameters(1);
                this.checkMatrixParam(this.getFirstExpr());
                DataIdentifier luOut1 = (DataIdentifier)this.getOutputs()[0];
                DataIdentifier luOut2 = (DataIdentifier)this.getOutputs()[1];
                DataIdentifier luOut3 = (DataIdentifier)this.getOutputs()[2];
                long inrows = this.getFirstExpr().getOutput().getDim1();
                long incols = this.getFirstExpr().getOutput().getDim2();
                if (inrows != incols) {
                    this.raiseValidateError("LU Decomposition can only be done on a square matrix. Input matrix is rectangular (rows=" + inrows + ", cols=" + incols + ")", conditional);
                }
                luOut1.setDataType(Expression.DataType.MATRIX);
                luOut1.setValueType(Expression.ValueType.DOUBLE);
                luOut1.setDimensions(inrows, inrows);
                luOut1.setBlockDimensions(this.getFirstExpr().getOutput().getRowsInBlock(), this.getFirstExpr().getOutput().getColumnsInBlock());
                luOut2.setDataType(Expression.DataType.MATRIX);
                luOut2.setValueType(Expression.ValueType.DOUBLE);
                luOut2.setDimensions(inrows, inrows);
                luOut2.setBlockDimensions(this.getFirstExpr().getOutput().getRowsInBlock(), this.getFirstExpr().getOutput().getColumnsInBlock());
                luOut3.setDataType(Expression.DataType.MATRIX);
                luOut3.setValueType(Expression.ValueType.DOUBLE);
                luOut3.setDimensions(inrows, inrows);
                luOut3.setBlockDimensions(this.getFirstExpr().getOutput().getRowsInBlock(), this.getFirstExpr().getOutput().getColumnsInBlock());
                break;
            }
            case EIGEN: {
                this.checkNumParameters(1);
                this.checkMatrixParam(this.getFirstExpr());
                DataIdentifier eigenOut1 = (DataIdentifier)this.getOutputs()[0];
                DataIdentifier eigenOut2 = (DataIdentifier)this.getOutputs()[1];
                if (this.getFirstExpr().getOutput().getDim1() != this.getFirstExpr().getOutput().getDim2()) {
                    this.raiseValidateError("Eigen Decomposition can only be done on a square matrix. Input matrix is rectangular (rows=" + this.getFirstExpr().getOutput().getDim1() + ", cols=" + this.getFirstExpr().getOutput().getDim2() + ")", conditional);
                }
                eigenOut1.setDataType(Expression.DataType.MATRIX);
                eigenOut1.setValueType(Expression.ValueType.DOUBLE);
                eigenOut1.setDimensions(this.getFirstExpr().getOutput().getDim1(), 1L);
                eigenOut1.setBlockDimensions(this.getFirstExpr().getOutput().getRowsInBlock(), this.getFirstExpr().getOutput().getColumnsInBlock());
                eigenOut2.setDataType(Expression.DataType.MATRIX);
                eigenOut2.setValueType(Expression.ValueType.DOUBLE);
                eigenOut2.setDimensions(this.getFirstExpr().getOutput().getDim1(), this.getFirstExpr().getOutput().getDim2());
                eigenOut2.setBlockDimensions(this.getFirstExpr().getOutput().getRowsInBlock(), this.getFirstExpr().getOutput().getColumnsInBlock());
                break;
            }
            default: {
                this.raiseValidateError("Unknown Builtin Function opcode: " + (Object)((Object)this._opcode), false);
            }
        }
    }

    private ArrayList<ParameterExpression> orderConvolutionParams(ArrayList<ParameterExpression> paramExpression, int skip) throws LanguageException {
        ArrayList<ParameterExpression> newParams = new ArrayList<ParameterExpression>();
        for (int i = 0; i < skip; ++i) {
            newParams.add(paramExpression.get(i));
        }
        String[] orderedParams = new String[]{"stride1", "stride2", "padding1", "padding2", "input_shape1", "input_shape2", "input_shape3", "input_shape4", "filter_shape1", "filter_shape2", "filter_shape3", "filter_shape4"};
        for (int i = 0; i < orderedParams.length; ++i) {
            boolean found = false;
            for (ParameterExpression param : paramExpression) {
                if (param.getName() == null || !param.getName().equals(orderedParams[i])) continue;
                found = true;
                newParams.add(param);
            }
            if (found) continue;
            throw new LanguageException("Incorrect parameters. Expected " + orderedParams[i] + " to be expanded.");
        }
        return newParams;
    }

    private ArrayList<ParameterExpression> replaceListParams(ArrayList<ParameterExpression> paramExpression, String inputVarName, String outputVarName, int startIndex) throws LanguageException {
        ArrayList<ParameterExpression> newParamExpression = new ArrayList<ParameterExpression>();
        int i = startIndex;
        int j = 1;
        for (ParameterExpression expr : paramExpression) {
            if (expr.getName() != null && expr.getName().equals(inputVarName + j)) {
                newParamExpression.add(new ParameterExpression(outputVarName + i, expr.getExpr()));
                ++i;
                ++j;
                continue;
            }
            newParamExpression.add(expr);
        }
        return newParamExpression;
    }

    private ArrayList<ParameterExpression> expandListParams(ArrayList<ParameterExpression> paramExpression, HashSet<String> paramsToExpand) throws LanguageException {
        ArrayList<ParameterExpression> newParamExpressions = new ArrayList<ParameterExpression>();
        for (ParameterExpression expr : paramExpression) {
            if (paramsToExpand.contains(expr.getName())) {
                if (!(expr.getExpr() instanceof ExpressionList)) continue;
                int i = 1;
                for (Expression e : ((ExpressionList)expr.getExpr()).getValue()) {
                    newParamExpressions.add(new ParameterExpression(expr.getName() + i, e));
                    ++i;
                }
                continue;
            }
            if (expr.getExpr() instanceof ExpressionList) {
                throw new LanguageException("The parameter " + expr.getName() + " cannot be list or is not supported for the given function");
            }
            newParamExpressions.add(expr);
        }
        return newParamExpressions;
    }

    private ArrayList<ParameterExpression> expandConvolutionArguments(ArrayList<ParameterExpression> paramExpression) {
        try {
            if (this._opcode == Expression.BuiltinFunctionOp.CONV2D || this._opcode == Expression.BuiltinFunctionOp.CONV2D_BACKWARD_FILTER || this._opcode == Expression.BuiltinFunctionOp.CONV2D_BACKWARD_DATA) {
                HashSet<String> expand = new HashSet<String>();
                expand.add("input_shape");
                expand.add("filter_shape");
                expand.add("stride");
                expand.add("padding");
                paramExpression = this.expandListParams(paramExpression, expand);
                paramExpression = this.orderConvolutionParams(paramExpression, 2);
            } else if (this._opcode == Expression.BuiltinFunctionOp.MAX_POOL || this._opcode == Expression.BuiltinFunctionOp.MAX_POOL_BACKWARD) {
                HashSet<String> expand = new HashSet<String>();
                expand.add("input_shape");
                expand.add("pool_size");
                expand.add("stride");
                expand.add("padding");
                paramExpression = this.expandListParams(paramExpression, expand);
                paramExpression.add(new ParameterExpression("filter_shape1", new IntIdentifier(1L, this.getFilename(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn())));
                paramExpression.add(new ParameterExpression("filter_shape2", new IntIdentifier(1L, this.getFilename(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn())));
                paramExpression = this.replaceListParams(paramExpression, "pool_size", "filter_shape", 3);
                paramExpression = this._opcode == Expression.BuiltinFunctionOp.MAX_POOL_BACKWARD ? this.orderConvolutionParams(paramExpression, 2) : this.orderConvolutionParams(paramExpression, 1);
            }
        }
        catch (LanguageException e) {
            throw new RuntimeException(e);
        }
        return paramExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void validateExpression(HashMap<String, DataIdentifier> ids, HashMap<String, ConstIdentifier> constVars, boolean conditional) throws LanguageException {
        for (int i = 0; i < this._args.length; ++i) {
            if (this._args[i] instanceof FunctionCallIdentifier) {
                this.raiseValidateError("UDF function call not supported as parameter to built-in function call", false);
            }
            this._args[i].validateExpression(ids, constVars, conditional);
        }
        String outputName = BuiltinFunctionExpression.getTempName();
        DataIdentifier output = new DataIdentifier(outputName);
        output.setAllPositions(this.getFilename(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
        Identifier id = this.getFirstExpr().getOutput();
        output.setProperties(this.getFirstExpr().getOutput());
        output.setNnz(-1L);
        this.setOutput(output);
        switch (this.getOpCode()) {
            case COLSUM: 
            case COLMAX: 
            case COLMIN: 
            case COLMEAN: 
            case COLSD: 
            case COLVAR: {
                this.checkNumParameters(1);
                this.checkMatrixParam(this.getFirstExpr());
                output.setDataType(Expression.DataType.MATRIX);
                output.setDimensions(1L, id.getDim2());
                output.setBlockDimensions(id.getRowsInBlock(), id.getColumnsInBlock());
                output.setValueType(id.getValueType());
                return;
            }
            case ROWSUM: 
            case ROWMAX: 
            case ROWINDEXMAX: 
            case ROWMIN: 
            case ROWINDEXMIN: 
            case ROWMEAN: 
            case ROWSD: 
            case ROWVAR: {
                this.checkNumParameters(1);
                this.checkMatrixParam(this.getFirstExpr());
                output.setDataType(Expression.DataType.MATRIX);
                output.setDimensions(id.getDim1(), 1L);
                output.setBlockDimensions(id.getRowsInBlock(), id.getColumnsInBlock());
                output.setValueType(id.getValueType());
                return;
            }
            case SUM: 
            case PROD: 
            case TRACE: 
            case SD: 
            case VAR: {
                this.checkNumParameters(1);
                this.checkMatrixParam(this.getFirstExpr());
                output.setDataType(Expression.DataType.SCALAR);
                output.setDimensions(0L, 0L);
                output.setBlockDimensions(0L, 0L);
                output.setValueType(id.getValueType());
                return;
            }
            case MEAN: {
                if (this.getSecondExpr() != null) {
                    this.checkNumParameters(2);
                } else {
                    this.checkNumParameters(1);
                }
                this.checkMatrixParam(this.getFirstExpr());
                if (this.getSecondExpr() != null) {
                    this.checkMatchingDimensions(this.getFirstExpr(), this.getSecondExpr());
                }
                output.setDataType(Expression.DataType.SCALAR);
                output.setDimensions(0L, 0L);
                output.setBlockDimensions(0L, 0L);
                output.setValueType(id.getValueType());
                return;
            }
            case MIN: 
            case MAX: {
                if (this.getSecondExpr() == null) {
                    this.checkNumParameters(1);
                    this.checkMatrixParam(this.getFirstExpr());
                    output.setDataType(Expression.DataType.SCALAR);
                    output.setDimensions(0L, 0L);
                    output.setBlockDimensions(0L, 0L);
                } else {
                    Expression.DataType dtOut;
                    this.checkNumParameters(2);
                    Expression.DataType dt1 = this.getFirstExpr().getOutput().getDataType();
                    Expression.DataType dt2 = this.getSecondExpr().getOutput().getDataType();
                    Expression.DataType dataType = dtOut = dt1 == Expression.DataType.MATRIX || dt2 == Expression.DataType.MATRIX ? Expression.DataType.MATRIX : Expression.DataType.SCALAR;
                    if (dt1 == Expression.DataType.MATRIX && dt2 == Expression.DataType.MATRIX) {
                        this.checkMatchingDimensions(this.getFirstExpr(), this.getSecondExpr(), true);
                    }
                    long[] dims = BuiltinFunctionExpression.getBinaryMatrixCharacteristics(this.getFirstExpr(), this.getSecondExpr());
                    output.setDataType(dtOut);
                    output.setDimensions(dims[0], dims[1]);
                    output.setBlockDimensions(dims[2], dims[3]);
                }
                output.setValueType(id.getValueType());
                return;
            }
            case CUMSUM: 
            case CUMPROD: 
            case CUMMIN: 
            case CUMMAX: {
                this.checkNumParameters(1);
                this.checkMatrixParam(this.getFirstExpr());
                output.setDataType(Expression.DataType.MATRIX);
                output.setDimensions(id.getDim1(), id.getDim2());
                output.setBlockDimensions(id.getRowsInBlock(), id.getColumnsInBlock());
                output.setValueType(id.getValueType());
                return;
            }
            case CAST_AS_SCALAR: {
                this.checkNumParameters(1);
                this.checkMatrixFrameParam(this.getFirstExpr());
                if (this.getFirstExpr().getOutput().getDim1() != -1L && this.getFirstExpr().getOutput().getDim1() != 1L || this.getFirstExpr().getOutput().getDim2() != -1L && this.getFirstExpr().getOutput().getDim2() != 1L) {
                    this.raiseValidateError("dimension mismatch while casting matrix to scalar: dim1: " + this.getFirstExpr().getOutput().getDim1() + " dim2 " + this.getFirstExpr().getOutput().getDim2(), conditional, "Invalid Parameters");
                }
                output.setDataType(Expression.DataType.SCALAR);
                output.setDimensions(0L, 0L);
                output.setBlockDimensions(0L, 0L);
                output.setValueType(id.getValueType());
                return;
            }
            case CAST_AS_MATRIX: {
                this.checkNumParameters(1);
                this.checkScalarFrameParam(this.getFirstExpr());
                output.setDataType(Expression.DataType.MATRIX);
                output.setDimensions(id.getDim1(), id.getDim2());
                if (this.getFirstExpr().getOutput().getDataType() == Expression.DataType.SCALAR) {
                    output.setDimensions(1L, 1L);
                }
                output.setBlockDimensions(id.getRowsInBlock(), id.getColumnsInBlock());
                output.setValueType(id.getValueType());
                return;
            }
            case CAST_AS_FRAME: {
                this.checkNumParameters(1);
                this.checkMatrixScalarParam(this.getFirstExpr());
                output.setDataType(Expression.DataType.FRAME);
                output.setDimensions(id.getDim1(), id.getDim2());
                if (this.getFirstExpr().getOutput().getDataType() == Expression.DataType.SCALAR) {
                    output.setDimensions(1L, 1L);
                }
                output.setBlockDimensions(id.getRowsInBlock(), id.getColumnsInBlock());
                output.setValueType(id.getValueType());
                return;
            }
            case CAST_AS_DOUBLE: {
                this.checkNumParameters(1);
                this.checkScalarParam(this.getFirstExpr());
                output.setDataType(Expression.DataType.SCALAR);
                output.setDimensions(0L, 0L);
                output.setBlockDimensions(0L, 0L);
                output.setValueType(Expression.ValueType.DOUBLE);
                return;
            }
            case CAST_AS_INT: {
                this.checkNumParameters(1);
                this.checkScalarParam(this.getFirstExpr());
                output.setDataType(Expression.DataType.SCALAR);
                output.setDimensions(0L, 0L);
                output.setBlockDimensions(0L, 0L);
                output.setValueType(Expression.ValueType.INT);
                return;
            }
            case CAST_AS_BOOLEAN: {
                this.checkNumParameters(1);
                this.checkScalarParam(this.getFirstExpr());
                output.setDataType(Expression.DataType.SCALAR);
                output.setDimensions(0L, 0L);
                output.setBlockDimensions(0L, 0L);
                output.setValueType(Expression.ValueType.BOOLEAN);
                return;
            }
            case CBIND: 
            case RBIND: {
                this.checkNumParameters(2);
                if (this.getFirstExpr().getOutput().getDataType() == Expression.DataType.SCALAR) {
                    this.checkScalarParam(this.getFirstExpr());
                    this.checkScalarParam(this.getSecondExpr());
                    this.checkValueTypeParam(this.getFirstExpr(), Expression.ValueType.STRING);
                    this.checkValueTypeParam(this.getSecondExpr(), Expression.ValueType.STRING);
                } else {
                    this.checkMatrixFrameParam(this.getFirstExpr());
                    this.checkMatrixFrameParam(this.getSecondExpr());
                }
                output.setDataType(id.getDataType());
                output.setValueType(id.getValueType());
                long appendDim1 = -1L;
                long appendDim2 = -1L;
                long m1rlen = this.getFirstExpr().getOutput().getDim1();
                long m1clen = this.getFirstExpr().getOutput().getDim2();
                long m2rlen = this.getSecondExpr().getOutput().getDim1();
                long m2clen = this.getSecondExpr().getOutput().getDim2();
                if (this.getOpCode() == Expression.BuiltinFunctionOp.CBIND) {
                    if (m1rlen > 0L && m2rlen > 0L && m1rlen != m2rlen) {
                        this.raiseValidateError("inputs to cbind must have same number of rows: input 1 rows: " + m1rlen + ", input 2 rows: " + m2rlen, conditional, "Invalid Parameters");
                    }
                    appendDim1 = m1rlen > 0L ? m1rlen : m2rlen;
                    appendDim2 = m1clen > 0L && m2clen > 0L ? m1clen + m2clen : -1L;
                } else if (this.getOpCode() == Expression.BuiltinFunctionOp.RBIND) {
                    if (m1clen > 0L && m2clen > 0L && m1clen != m2clen) {
                        this.raiseValidateError("inputs to rbind must have same number of columns: input 1 columns: " + m1clen + ", input 2 columns: " + m2clen, conditional, "Invalid Parameters");
                    }
                    appendDim1 = m1rlen > 0L && m2rlen > 0L ? m1rlen + m2rlen : -1L;
                    appendDim2 = m1clen > 0L ? m1clen : m2clen;
                }
                output.setDimensions(appendDim1, appendDim2);
                output.setBlockDimensions(id.getRowsInBlock(), id.getColumnsInBlock());
                return;
            }
            case PPRED: {
                this.raiseValidateError("ppred() has been deprecated. Please use the operator directly.", true);
                this.checkNumParameters(3);
                Expression.DataType dt1 = this.getFirstExpr().getOutput().getDataType();
                Expression.DataType dt2 = this.getSecondExpr().getOutput().getDataType();
                if (dt1 == Expression.DataType.SCALAR && dt2 == Expression.DataType.SCALAR) {
                    this.raiseValidateError("ppred() requires at least one matrix input.", conditional, "Invalid Parameters");
                }
                if (dt1 == Expression.DataType.MATRIX) {
                    this.checkMatrixParam(this.getFirstExpr());
                }
                if (dt2 == Expression.DataType.MATRIX) {
                    this.checkMatrixParam(this.getSecondExpr());
                }
                if (dt1 == Expression.DataType.MATRIX && dt2 == Expression.DataType.MATRIX) {
                    this.checkMatchingDimensions(this.getFirstExpr(), this.getSecondExpr(), true);
                }
                if (this.getThirdExpr().getOutput().getDataType() != Expression.DataType.SCALAR || this.getThirdExpr().getOutput().getValueType() != Expression.ValueType.STRING) {
                    this.raiseValidateError("Third argument in ppred() is not an operator ", conditional, "Invalid Parameters");
                }
                long[] dims = BuiltinFunctionExpression.getBinaryMatrixCharacteristics(this.getFirstExpr(), this.getSecondExpr());
                output.setDataType(Expression.DataType.MATRIX);
                output.setDimensions(dims[0], dims[1]);
                output.setBlockDimensions(dims[2], dims[3]);
                output.setValueType(id.getValueType());
                return;
            }
            case TRANS: {
                this.checkNumParameters(1);
                this.checkMatrixParam(this.getFirstExpr());
                output.setDataType(Expression.DataType.MATRIX);
                output.setDimensions(id.getDim2(), id.getDim1());
                output.setBlockDimensions(id.getColumnsInBlock(), id.getRowsInBlock());
                output.setValueType(id.getValueType());
                return;
            }
            case REV: {
                this.checkNumParameters(1);
                this.checkMatrixParam(this.getFirstExpr());
                output.setDataType(Expression.DataType.MATRIX);
                output.setDimensions(id.getDim1(), id.getDim2());
                output.setBlockDimensions(id.getColumnsInBlock(), id.getRowsInBlock());
                output.setValueType(id.getValueType());
                return;
            }
            case DIAG: {
                this.checkNumParameters(1);
                this.checkMatrixParam(this.getFirstExpr());
                output.setDataType(Expression.DataType.MATRIX);
                if (id.getDim2() != -1L) {
                    if (id.getDim2() == 1L) {
                        output.setDimensions(id.getDim1(), id.getDim1());
                    } else {
                        if (id.getDim1() != id.getDim2()) {
                            this.raiseValidateError("diag can either: (1) create diagonal matrix from (n x 1) matrix, or (2) take diagonal from a square matrix. Error invoking diag on matrix with dimensions (" + id.getDim1() + "," + id.getDim2() + ") in " + this.toString(), conditional, "Invalid Parameters");
                        }
                        output.setDimensions(id.getDim1(), 1L);
                    }
                }
                output.setBlockDimensions(id.getRowsInBlock(), id.getColumnsInBlock());
                output.setValueType(id.getValueType());
                return;
            }
            case NROW: 
            case NCOL: 
            case LENGTH: {
                this.checkNumParameters(1);
                this.checkMatrixFrameParam(this.getFirstExpr());
                output.setDataType(Expression.DataType.SCALAR);
                output.setDimensions(0L, 0L);
                output.setBlockDimensions(0L, 0L);
                output.setValueType(Expression.ValueType.INT);
                return;
            }
            case TABLE: {
                this.checkMatrixParam(this.getFirstExpr());
                if (this.getSecondExpr() == null) {
                    this.raiseValidateError("Invalid number of arguments to table(): " + this.toString(), conditional, "Invalid Parameters");
                }
                if (this.getSecondExpr().getOutput().getDataType() == Expression.DataType.MATRIX) {
                    this.checkMatchingDimensions(this.getFirstExpr(), this.getSecondExpr());
                }
                long outputDim1 = -1L;
                long outputDim2 = -1L;
                switch (this._args.length) {
                    case 2: {
                        break;
                    }
                    case 3: {
                        if (this.getThirdExpr().getOutput().getDataType() != Expression.DataType.MATRIX) break;
                        this.checkMatchingDimensions(this.getFirstExpr(), this.getThirdExpr());
                        break;
                    }
                    case 4: {
                        if (this.getThirdExpr().getOutput().getDataType() != Expression.DataType.SCALAR || this._args[3].getOutput().getDataType() != Expression.DataType.SCALAR) {
                            this.raiseValidateError("Invalid argument types to table(): output dimensions must be of type scalar: " + this.toString(), conditional, "Invalid Parameters");
                            break;
                        }
                        if (this.getThirdExpr() instanceof DataIdentifier && constVars.containsKey(((DataIdentifier)this.getThirdExpr()).getName())) {
                            this._args[2] = constVars.get(((DataIdentifier)this.getThirdExpr()).getName());
                        }
                        if (this._args[3] instanceof DataIdentifier && constVars.containsKey(((DataIdentifier)this._args[3]).getName())) {
                            this._args[3] = constVars.get(((DataIdentifier)this._args[3]).getName());
                        }
                        if (this.getThirdExpr().getOutput() instanceof ConstIdentifier) {
                            outputDim1 = ((ConstIdentifier)this.getThirdExpr().getOutput()).getLongValue();
                        }
                        if (!(this._args[3].getOutput() instanceof ConstIdentifier)) break;
                        outputDim2 = ((ConstIdentifier)this._args[3].getOutput()).getLongValue();
                        break;
                    }
                    case 5: {
                        if (this.getThirdExpr().getOutput().getDataType() == Expression.DataType.MATRIX) {
                            this.checkMatchingDimensions(this.getFirstExpr(), this.getThirdExpr());
                        }
                        if (this._args[3].getOutput().getDataType() != Expression.DataType.SCALAR || this._args[4].getOutput().getDataType() != Expression.DataType.SCALAR) {
                            this.raiseValidateError("Invalid argument types to table(): output dimensions must be of type scalar: " + this.toString(), conditional, "Invalid Parameters");
                            break;
                        }
                        if (this._args[3] instanceof DataIdentifier && constVars.containsKey(((DataIdentifier)this._args[3]).getName())) {
                            this._args[3] = constVars.get(((DataIdentifier)this._args[3]).getName());
                        }
                        if (this._args[4] instanceof DataIdentifier && constVars.containsKey(((DataIdentifier)this._args[4]).getName())) {
                            this._args[4] = constVars.get(((DataIdentifier)this._args[4]).getName());
                        }
                        if (this._args[3].getOutput() instanceof ConstIdentifier) {
                            outputDim1 = ((ConstIdentifier)this._args[3].getOutput()).getLongValue();
                        }
                        if (!(this._args[4].getOutput() instanceof ConstIdentifier)) break;
                        outputDim2 = ((ConstIdentifier)this._args[4].getOutput()).getLongValue();
                        break;
                    }
                    default: {
                        this.raiseValidateError("Invalid number of arguments to table(): " + this.toString(), conditional, "Invalid Parameters");
                    }
                }
                output.setDimensions(outputDim1, outputDim2);
                output.setBlockDimensions(-1L, -1L);
                output.setDataType(Expression.DataType.MATRIX);
                output.setValueType(Expression.ValueType.DOUBLE);
                return;
            }
            case MOMENT: {
                this.checkMatrixParam(this.getFirstExpr());
                if (this.getThirdExpr() != null) {
                    this.checkNumParameters(3);
                    this.checkMatrixParam(this.getSecondExpr());
                    this.checkMatchingDimensions(this.getFirstExpr(), this.getSecondExpr());
                    this.checkScalarParam(this.getThirdExpr());
                } else {
                    this.checkNumParameters(2);
                    this.checkScalarParam(this.getSecondExpr());
                }
                output.setDataType(Expression.DataType.SCALAR);
                output.setValueType(Expression.ValueType.DOUBLE);
                output.setDimensions(0L, 0L);
                output.setBlockDimensions(0L, 0L);
                return;
            }
            case COV: {
                if (this.getThirdExpr() != null) {
                    this.checkNumParameters(3);
                } else {
                    this.checkNumParameters(2);
                }
                this.checkMatrixParam(this.getFirstExpr());
                this.checkMatrixParam(this.getSecondExpr());
                this.checkMatchingDimensions(this.getFirstExpr(), this.getSecondExpr());
                if (this.getThirdExpr() != null) {
                    this.checkMatrixParam(this.getThirdExpr());
                    this.checkMatchingDimensions(this.getFirstExpr(), this.getThirdExpr());
                }
                output.setDataType(Expression.DataType.SCALAR);
                output.setValueType(Expression.ValueType.DOUBLE);
                output.setDimensions(0L, 0L);
                output.setBlockDimensions(0L, 0L);
                return;
            }
            case QUANTILE: {
                if (this.getThirdExpr() != null) {
                    this.checkNumParameters(3);
                } else {
                    this.checkNumParameters(2);
                }
                this.check1DMatrixParam(this.getFirstExpr());
                if (this.getThirdExpr() != null) {
                    this.checkMatrixParam(this.getSecondExpr());
                    this.checkMatchingDimensions(this.getFirstExpr(), this.getSecondExpr());
                }
                if (this.getThirdExpr() != null) {
                    output.setDimensions(this.getThirdExpr().getOutput().getDim1(), this.getThirdExpr().getOutput().getDim2());
                    output.setBlockDimensions(this.getThirdExpr().getOutput().getRowsInBlock(), this.getThirdExpr().getOutput().getColumnsInBlock());
                    output.setDataType(this.getThirdExpr().getOutput().getDataType());
                    return;
                }
                output.setDimensions(this.getSecondExpr().getOutput().getDim1(), this.getSecondExpr().getOutput().getDim2());
                output.setBlockDimensions(this.getSecondExpr().getOutput().getRowsInBlock(), this.getSecondExpr().getOutput().getColumnsInBlock());
                output.setDataType(this.getSecondExpr().getOutput().getDataType());
                return;
            }
            case INTERQUANTILE: {
                if (this.getThirdExpr() != null) {
                    this.checkNumParameters(3);
                } else {
                    this.checkNumParameters(2);
                }
                this.checkMatrixParam(this.getFirstExpr());
                if (this.getThirdExpr() != null) {
                    this.checkMatrixParam(this.getSecondExpr());
                    this.checkMatchingDimensionsQuantile();
                }
                if (this.getThirdExpr() == null && this.getSecondExpr().getOutput().getDataType() != Expression.DataType.SCALAR && this.getThirdExpr() != null && this.getThirdExpr().getOutput().getDataType() != Expression.DataType.SCALAR) {
                    this.raiseValidateError("Invalid parameters to " + (Object)((Object)this.getOpCode()), conditional, "Invalid Parameters");
                }
                output.setValueType(id.getValueType());
                output.setDimensions(-1L, -1L);
                output.setBlockDimensions(-1L, -1L);
                output.setDataType(Expression.DataType.MATRIX);
                return;
            }
            case IQM: {
                if (this.getSecondExpr() != null) {
                    this.checkNumParameters(2);
                } else {
                    this.checkNumParameters(1);
                }
                this.checkMatrixParam(this.getFirstExpr());
                if (this.getSecondExpr() != null) {
                    this.checkMatrixParam(this.getSecondExpr());
                    this.checkMatchingDimensions(this.getFirstExpr(), this.getSecondExpr());
                }
                output.setValueType(id.getValueType());
                output.setDimensions(0L, 0L);
                output.setBlockDimensions(0L, 0L);
                output.setDataType(Expression.DataType.SCALAR);
                return;
            }
            case MEDIAN: {
                if (this.getSecondExpr() != null) {
                    this.checkNumParameters(2);
                } else {
                    this.checkNumParameters(1);
                }
                this.checkMatrixParam(this.getFirstExpr());
                if (this.getSecondExpr() != null) {
                    this.checkMatrixParam(this.getSecondExpr());
                    this.checkMatchingDimensions(this.getFirstExpr(), this.getSecondExpr());
                }
                output.setValueType(id.getValueType());
                output.setDimensions(0L, 0L);
                output.setBlockDimensions(0L, 0L);
                output.setDataType(Expression.DataType.SCALAR);
                return;
            }
            case SAMPLE: {
                long size;
                long range;
                Expression[] in;
                for (Expression e : in = this.getAllExpr()) {
                    this.checkScalarParam(e);
                }
                if (in[0].getOutput().getValueType() != Expression.ValueType.DOUBLE && in[0].getOutput().getValueType() != Expression.ValueType.INT) {
                    throw new LanguageException("First argument to sample() must be a number.");
                }
                if (in[1].getOutput().getValueType() != Expression.ValueType.DOUBLE && in[1].getOutput().getValueType() != Expression.ValueType.INT) {
                    throw new LanguageException("Second argument to sample() must be a number.");
                }
                boolean check = false;
                if (this.isConstant(in[0]) && this.isConstant(in[1]) && (range = ((ConstIdentifier)in[0]).getLongValue()) < (size = ((ConstIdentifier)in[1]).getLongValue())) {
                    check = true;
                }
                if (in.length == 4) {
                    this.checkNumParameters(4);
                    if (in[3].getOutput().getValueType() != Expression.ValueType.INT) {
                        throw new LanguageException("Fourth arugment, seed, to sample() must be an integer value.");
                    }
                    if (in[2].getOutput().getValueType() != Expression.ValueType.BOOLEAN) {
                        throw new LanguageException("Third arugment to sample() must either denote replacement policy (boolean) or seed (integer).");
                    }
                } else if (in.length == 3) {
                    this.checkNumParameters(3);
                    if (in[2].getOutput().getValueType() != Expression.ValueType.BOOLEAN && in[2].getOutput().getValueType() != Expression.ValueType.INT) {
                        throw new LanguageException("Third arugment to sample() must either denote replacement policy (boolean) or seed (integer).");
                    }
                }
                if (check && in.length >= 3 && this.isConstant(in[2]) && in[2].getOutput().getValueType() == Expression.ValueType.BOOLEAN && !((BooleanIdentifier)in[2]).getValue()) {
                    throw new LanguageException("Sample (size=" + ((ConstIdentifier)in[0]).getLongValue() + ") larger than population (size=" + ((ConstIdentifier)in[1]).getLongValue() + ") can only be generated with replacement.");
                }
                output.setDataType(Expression.DataType.MATRIX);
                output.setValueType(Expression.ValueType.DOUBLE);
                if (this.isConstant(in[1])) {
                    output.setDimensions(((ConstIdentifier)in[1]).getLongValue(), 1L);
                } else {
                    output.setDimensions(-1L, 1L);
                }
                this.setBlockDimensions(id.getRowsInBlock(), id.getColumnsInBlock());
                return;
            }
            case SEQ: {
                this.checkScalarParam(this.getFirstExpr());
                this.checkScalarParam(this.getSecondExpr());
                if (this.getThirdExpr() != null) {
                    this.checkNumParameters(3);
                    this.checkScalarParam(this.getThirdExpr());
                } else {
                    this.checkNumParameters(2);
                }
                if (this.getFirstExpr() instanceof DataIdentifier && constVars.containsKey(((DataIdentifier)this.getFirstExpr()).getName())) {
                    this._args[0] = constVars.get(((DataIdentifier)this.getFirstExpr()).getName());
                }
                if (this.getSecondExpr() instanceof DataIdentifier && constVars.containsKey(((DataIdentifier)this.getSecondExpr()).getName())) {
                    this._args[1] = constVars.get(((DataIdentifier)this.getSecondExpr()).getName());
                }
                if (this.getThirdExpr() != null && this.getThirdExpr() instanceof DataIdentifier && constVars.containsKey(((DataIdentifier)this.getThirdExpr()).getName())) {
                    this._args[2] = constVars.get(((DataIdentifier)this.getThirdExpr()).getName());
                }
                long dim1 = -1L;
                long dim2 = 1L;
                if (this.isConstant(this.getFirstExpr()) && this.isConstant(this.getSecondExpr()) && (this.getThirdExpr() == null || this.isConstant(this.getThirdExpr()))) {
                    double incr;
                    double to;
                    double from;
                    try {
                        from = this.getDoubleValue(this.getFirstExpr());
                        to = this.getDoubleValue(this.getSecondExpr());
                        if (this.getThirdExpr() == null) {
                            this.expandArguments();
                            this._args[2] = new DoubleIdentifier(from > to ? -1.0 : 1.0, this.getFilename(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
                        }
                        incr = this.getDoubleValue(this.getThirdExpr());
                    }
                    catch (LanguageException e) {
                        throw new LanguageException("Arguments for seq() must be numeric.");
                    }
                    if (from > to && incr >= 0.0) {
                        throw new LanguageException("Wrong sign for the increment in a call to seq()");
                    }
                    dim1 = 1L + (long)Math.floor((to - from) / incr);
                }
                output.setDataType(Expression.DataType.MATRIX);
                output.setValueType(Expression.ValueType.DOUBLE);
                output.setDimensions(dim1, dim2);
                output.setBlockDimensions(0L, 0L);
                return;
            }
            case SOLVE: {
                this.checkNumParameters(2);
                this.checkMatrixParam(this.getFirstExpr());
                this.checkMatrixParam(this.getSecondExpr());
                if (this.getSecondExpr().getOutput().dimsKnown() && !this.is1DMatrix(this.getSecondExpr())) {
                    this.raiseValidateError("Second input to solve() must be a vector", conditional);
                }
                if (this.getFirstExpr().getOutput().dimsKnown() && this.getSecondExpr().getOutput().dimsKnown() && this.getFirstExpr().getOutput().getDim1() != this.getSecondExpr().getOutput().getDim1()) {
                    this.raiseValidateError("Dimension mismatch in a call to solve()", conditional);
                }
                output.setDataType(Expression.DataType.MATRIX);
                output.setValueType(Expression.ValueType.DOUBLE);
                output.setDimensions(this.getFirstExpr().getOutput().getDim2(), 1L);
                output.setBlockDimensions(0L, 0L);
                return;
            }
            case INVERSE: {
                this.checkNumParameters(1);
                this.checkMatrixParam(this.getFirstExpr());
                output.setDataType(Expression.DataType.MATRIX);
                output.setValueType(Expression.ValueType.DOUBLE);
                Identifier in = this.getFirstExpr().getOutput();
                if (in.dimsKnown() && in.getDim1() != in.getDim2()) {
                    this.raiseValidateError("Input to inv() must be square matrix -- given: a " + in.getDim1() + "x" + in.getDim2() + " matrix.", conditional);
                }
                output.setDimensions(in.getDim1(), in.getDim2());
                output.setBlockDimensions(in.getRowsInBlock(), in.getColumnsInBlock());
                return;
            }
            case CHOLESKY: {
                this.checkNumParameters(1);
                this.checkMatrixParam(this.getFirstExpr());
                output.setDataType(Expression.DataType.MATRIX);
                output.setValueType(Expression.ValueType.DOUBLE);
                Identifier inA = this.getFirstExpr().getOutput();
                if (inA.dimsKnown() && inA.getDim1() != inA.getDim2()) {
                    this.raiseValidateError("Input to cholesky() must be square matrix -- given: a " + inA.getDim1() + "x" + inA.getDim2() + " matrix.", conditional);
                }
                output.setDimensions(inA.getDim1(), inA.getDim2());
                output.setBlockDimensions(inA.getRowsInBlock(), inA.getColumnsInBlock());
                return;
            }
            case OUTER: {
                Identifier id2 = this.getSecondExpr().getOutput();
                this.checkNumParameters(3);
                this.checkMatrixParam(this.getFirstExpr());
                this.checkMatrixParam(this.getSecondExpr());
                this.checkScalarParam(this.getThirdExpr());
                this.checkValueTypeParam(this.getThirdExpr(), Expression.ValueType.STRING);
                if (id.getDim2() > 1L || id2.getDim1() > 1L) {
                    this.raiseValidateError("Outer vector operations require a common dimension of one: " + id.getDim1() + "x" + id.getDim2() + " o " + id2.getDim1() + "x" + id2.getDim2() + ".", false);
                }
                output.setDataType(id.getDataType());
                output.setDimensions(id.getDim1(), id2.getDim2());
                output.setBlockDimensions(id.getRowsInBlock(), id.getColumnsInBlock());
                return;
            }
            case BIAS_ADD: 
            case BIAS_MULTIPLY: {
                Expression input = this._args[0];
                Expression bias = this._args[1];
                output.setDataType(Expression.DataType.MATRIX);
                output.setValueType(Expression.ValueType.DOUBLE);
                output.setDimensions(input.getOutput().getDim1(), input.getOutput().getDim2());
                output.setBlockDimensions(input.getOutput().getRowsInBlock(), input.getOutput().getColumnsInBlock());
                this.checkMatrixParam(input);
                this.checkMatrixParam(bias);
                return;
            }
            case CONV2D: 
            case CONV2D_BACKWARD_FILTER: 
            case CONV2D_BACKWARD_DATA: 
            case MAX_POOL: 
            case AVG_POOL: 
            case MAX_POOL_BACKWARD: {
                Expression input = this._args[0];
                Expression filter = null;
                if (this.getOpCode() != Expression.BuiltinFunctionOp.MAX_POOL && this.getOpCode() != Expression.BuiltinFunctionOp.AVG_POOL) {
                    filter = this._args[1];
                    this.checkMatrixParam(filter);
                }
                output.setDataType(Expression.DataType.MATRIX);
                output.setValueType(Expression.ValueType.DOUBLE);
                output.setBlockDimensions(input.getOutput().getRowsInBlock(), input.getOutput().getColumnsInBlock());
                if (this.getOpCode() == Expression.BuiltinFunctionOp.MAX_POOL_BACKWARD || this.getOpCode() == Expression.BuiltinFunctionOp.CONV2D_BACKWARD_DATA) {
                    output.setDimensions(input.getOutput().getDim1(), input.getOutput().getDim2());
                } else if (this.getOpCode() == Expression.BuiltinFunctionOp.CONV2D_BACKWARD_FILTER) {
                    output.setDimensions(filter.getOutput().getDim1(), filter.getOutput().getDim2());
                } else {
                    if (this.getOpCode() != Expression.BuiltinFunctionOp.CONV2D && this.getOpCode() != Expression.BuiltinFunctionOp.MAX_POOL) throw new LanguageException("Unsupported op: " + (Object)((Object)this.getOpCode()));
                    try {
                        int start = 1;
                        if (this.getOpCode() == Expression.BuiltinFunctionOp.CONV2D) {
                            start = 2;
                        }
                        long stride_h = (long)this.getDoubleValue(this._args[start++]);
                        long stride_w = (long)this.getDoubleValue(this._args[start++]);
                        long pad_h = (long)this.getDoubleValue(this._args[start++]);
                        long pad_w = (long)this.getDoubleValue(this._args[start++]);
                        int n = ++start;
                        long C = (long)this.getDoubleValue(this._args[n]);
                        int n2 = ++start;
                        long H = (long)this.getDoubleValue(this._args[n2]);
                        int n3 = ++start;
                        ++start;
                        long W = (long)this.getDoubleValue(this._args[n3]);
                        long K = -1L;
                        if (this.getOpCode() == Expression.BuiltinFunctionOp.CONV2D) {
                            K = (long)this.getDoubleValue(this._args[start]);
                        }
                        ++start;
                        int n4 = ++start;
                        long R = (long)this.getDoubleValue(this._args[n4]);
                        int n5 = ++start;
                        ++start;
                        long S = (long)this.getDoubleValue(this._args[n5]);
                        long P = ConvolutionUtils.getP(H, R, stride_h, pad_h);
                        long Q = ConvolutionUtils.getP(W, S, stride_w, pad_w);
                        if (this.getOpCode() == Expression.BuiltinFunctionOp.CONV2D) {
                            output.setDimensions(input.getOutput().getDim1(), K * P * Q);
                        }
                        output.setDimensions(input.getOutput().getDim1(), C * P * Q);
                    }
                    catch (Exception e) {
                        output.setDimensions(input.getOutput().getDim1(), -1L);
                    }
                }
                this.checkMatrixParam(input);
                return;
            }
            default: {
                if (this.isMathFunction()) {
                    if (this.getOpCode() == Expression.BuiltinFunctionOp.ABS) {
                        output.setValueType(this.getFirstExpr().getOutput().getValueType());
                    } else {
                        output.setValueType(Expression.ValueType.DOUBLE);
                    }
                    this.checkMathFunctionParam();
                    output.setDataType(id.getDataType());
                    output.setDimensions(id.getDim1(), id.getDim2());
                    output.setBlockDimensions(id.getRowsInBlock(), id.getColumnsInBlock());
                    return;
                }
                Expression.BuiltinFunctionOp op = this.getOpCode();
                if (op == Expression.BuiltinFunctionOp.EIGEN || op == Expression.BuiltinFunctionOp.LU || op == Expression.BuiltinFunctionOp.QR) {
                    this.raiseValidateError("Function " + (Object)((Object)op) + " needs to be called with multi-return assignment.", false, "Invalid Parameters");
                    return;
                }
                this.raiseValidateError("Unsupported function " + (Object)((Object)op), false, "Invalid Parameters");
            }
        }
    }

    private void expandArguments() {
        if (this._args == null) {
            this._args = new Expression[1];
            return;
        }
        Expression[] temp = (Expression[])this._args.clone();
        this._args = new Expression[this._args.length + 1];
        System.arraycopy(temp, 0, this._args, 0, temp.length);
    }

    @Override
    public boolean multipleReturns() {
        switch (this._opcode) {
            case QR: 
            case LU: 
            case EIGEN: {
                return true;
            }
        }
        return false;
    }

    private boolean isConstant(Expression expr) {
        return expr != null && expr instanceof ConstIdentifier;
    }

    private double getDoubleValue(Expression expr) throws LanguageException {
        if (expr instanceof DoubleIdentifier) {
            return ((DoubleIdentifier)expr).getValue();
        }
        if (expr instanceof IntIdentifier) {
            return ((IntIdentifier)expr).getValue();
        }
        throw new LanguageException("Expecting a numeric value.");
    }

    private boolean isMathFunction() {
        switch (this.getOpCode()) {
            case MEDIAN: 
            case COS: 
            case SIN: 
            case TAN: 
            case ACOS: 
            case ASIN: 
            case ATAN: 
            case SIGN: 
            case SQRT: 
            case ABS: 
            case LOG: 
            case EXP: 
            case ROUND: 
            case CEIL: 
            case FLOOR: {
                return true;
            }
        }
        return false;
    }

    private void checkMathFunctionParam() throws LanguageException {
        switch (this.getOpCode()) {
            case MEDIAN: 
            case COS: 
            case SIN: 
            case TAN: 
            case ACOS: 
            case ASIN: 
            case ATAN: 
            case SIGN: 
            case SQRT: 
            case ABS: 
            case EXP: 
            case ROUND: 
            case CEIL: 
            case FLOOR: {
                this.checkNumParameters(1);
                break;
            }
            case LOG: {
                if (this.getSecondExpr() != null) {
                    this.checkNumParameters(2);
                    break;
                }
                this.checkNumParameters(1);
                break;
            }
            default: {
                this.raiseValidateError("Unknown math function " + (Object)((Object)this.getOpCode()), false);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this._opcode.toString() + "(" + this._args[0].toString());
        for (int i = 1; i < this._args.length; ++i) {
            sb.append(",");
            sb.append(this._args[i].toString());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public VariableSet variablesRead() {
        VariableSet result = new VariableSet();
        for (int i = 0; i < this._args.length; ++i) {
            result.addVariables(this._args[i].variablesRead());
        }
        return result;
    }

    @Override
    public VariableSet variablesUpdated() {
        VariableSet result = new VariableSet();
        return result;
    }

    protected void checkNumParameters(int count) throws LanguageException {
        if (this.getFirstExpr() == null) {
            this.raiseValidateError("Missing parameter for function " + (Object)((Object)this.getOpCode()), false, "Invalid Parameters");
        }
        if (count == 1 && (this.getSecondExpr() != null || this.getThirdExpr() != null) || count == 2 && this.getThirdExpr() != null) {
            this.raiseValidateError("Invalid number of parameters for function " + (Object)((Object)this.getOpCode()), false, "Invalid Parameters");
        } else if (count == 2 && this.getSecondExpr() == null || count == 3 && (this.getSecondExpr() == null || this.getThirdExpr() == null)) {
            this.raiseValidateError("Missing parameter for function " + (Object)((Object)this.getOpCode()), false, "Invalid Parameters");
        }
    }

    protected void checkMatrixParam(Expression e) throws LanguageException {
        if (e.getOutput().getDataType() != Expression.DataType.MATRIX) {
            this.raiseValidateError("Expecting matrix parameter for function " + (Object)((Object)this.getOpCode()), false, "Unsupported Parameters");
        }
    }

    protected void checkMatrixFrameParam(Expression e) throws LanguageException {
        if (e.getOutput().getDataType() != Expression.DataType.MATRIX && e.getOutput().getDataType() != Expression.DataType.FRAME) {
            this.raiseValidateError("Expecting matrix or frame parameter for function " + (Object)((Object)this.getOpCode()), false, "Unsupported Parameters");
        }
    }

    protected void checkMatrixScalarParam(Expression e) throws LanguageException {
        if (e.getOutput().getDataType() != Expression.DataType.MATRIX && e.getOutput().getDataType() != Expression.DataType.SCALAR) {
            this.raiseValidateError("Expecting matrix or scalar parameter for function " + (Object)((Object)this.getOpCode()), false, "Unsupported Parameters");
        }
    }

    private void checkScalarParam(Expression e) throws LanguageException {
        if (e.getOutput().getDataType() != Expression.DataType.SCALAR) {
            this.raiseValidateError("Expecting scalar parameter for function " + (Object)((Object)this.getOpCode()), false, "Unsupported Parameters");
        }
    }

    private void checkScalarFrameParam(Expression e) throws LanguageException {
        if (e.getOutput().getDataType() != Expression.DataType.SCALAR && e.getOutput().getDataType() != Expression.DataType.FRAME) {
            this.raiseValidateError("Expecting scalar parameter for function " + (Object)((Object)this.getOpCode()), false, "Unsupported Parameters");
        }
    }

    private void checkValueTypeParam(Expression e, Expression.ValueType vt) throws LanguageException {
        if (e.getOutput().getValueType() != vt) {
            this.raiseValidateError("Expecting parameter of different value type " + (Object)((Object)this.getOpCode()), false, "Unsupported Parameters");
        }
    }

    private boolean is1DMatrix(Expression e) {
        return e.getOutput().getDim1() == 1L || e.getOutput().getDim2() == 1L;
    }

    private boolean dimsKnown(Expression e) {
        return e.getOutput().getDim1() != -1L && e.getOutput().getDim2() != -1L;
    }

    private void check1DMatrixParam(Expression e) throws LanguageException {
        this.checkMatrixParam(e);
        if (this.dimsKnown(e) && !this.is1DMatrix(e)) {
            this.raiseValidateError("Expecting one-dimensional matrix parameter for function " + (Object)((Object)this.getOpCode()), false, "Unsupported Parameters");
        }
    }

    private void checkMatchingDimensions(Expression expr1, Expression expr2) throws LanguageException {
        this.checkMatchingDimensions(expr1, expr2, false);
    }

    private void checkMatchingDimensions(Expression expr1, Expression expr2, boolean allowsMV) throws LanguageException {
        if (expr1 != null && expr2 != null) {
            if (expr1.getOutput().getDim1() == -1L || expr2.getOutput().getDim1() == -1L || expr1.getOutput().getDim2() == -1L || expr2.getOutput().getDim2() == -1L) {
                return;
            }
            if (!allowsMV && expr1.getOutput().getDim1() != expr2.getOutput().getDim1() || allowsMV && expr1.getOutput().getDim1() != expr2.getOutput().getDim1() && expr2.getOutput().getDim1() != 1L || !allowsMV && expr1.getOutput().getDim2() != expr2.getOutput().getDim2() || allowsMV && expr1.getOutput().getDim2() != expr2.getOutput().getDim2() && expr2.getOutput().getDim2() != 1L) {
                this.raiseValidateError("Mismatch in matrix dimensions of parameters for function " + (Object)((Object)this.getOpCode()), false, "Invalid Parameters");
            }
        }
    }

    private void checkMatchingDimensionsQuantile() throws LanguageException {
        if (this.getFirstExpr().getOutput().getDim1() != this.getSecondExpr().getOutput().getDim1()) {
            this.raiseValidateError("Mismatch in matrix dimensions for " + (Object)((Object)this.getOpCode()), false, "Invalid Parameters");
        }
    }

    public static BuiltinFunctionExpression getBuiltinFunctionExpression(String functionName, ArrayList<ParameterExpression> paramExprsPassed, String filename, int blp, int bcp, int elp, int ecp) {
        if (functionName == null || paramExprsPassed == null) {
            return null;
        }
        Expression.BuiltinFunctionOp bifop = null;
        if (functionName.equals("avg")) {
            bifop = Expression.BuiltinFunctionOp.MEAN;
        } else if (functionName.equals("cos")) {
            bifop = Expression.BuiltinFunctionOp.COS;
        } else if (functionName.equals("sin")) {
            bifop = Expression.BuiltinFunctionOp.SIN;
        } else if (functionName.equals("tan")) {
            bifop = Expression.BuiltinFunctionOp.TAN;
        } else if (functionName.equals("acos")) {
            bifop = Expression.BuiltinFunctionOp.ACOS;
        } else if (functionName.equals("asin")) {
            bifop = Expression.BuiltinFunctionOp.ASIN;
        } else if (functionName.equals("atan")) {
            bifop = Expression.BuiltinFunctionOp.ATAN;
        } else if (functionName.equals("diag")) {
            bifop = Expression.BuiltinFunctionOp.DIAG;
        } else if (functionName.equals("exp")) {
            bifop = Expression.BuiltinFunctionOp.EXP;
        } else if (functionName.equals("abs")) {
            bifop = Expression.BuiltinFunctionOp.ABS;
        } else if (functionName.equals("min")) {
            bifop = Expression.BuiltinFunctionOp.MIN;
        } else if (functionName.equals("max")) {
            bifop = Expression.BuiltinFunctionOp.MAX;
        } else if (functionName.equals("pmin")) {
            bifop = Expression.BuiltinFunctionOp.MIN;
        } else if (functionName.equals("pmax")) {
            bifop = Expression.BuiltinFunctionOp.MAX;
        } else if (functionName.equals("ppred")) {
            bifop = Expression.BuiltinFunctionOp.PPRED;
        } else if (functionName.equals("log")) {
            bifop = Expression.BuiltinFunctionOp.LOG;
        } else if (functionName.equals("length")) {
            bifop = Expression.BuiltinFunctionOp.LENGTH;
        } else if (functionName.equals("ncol")) {
            bifop = Expression.BuiltinFunctionOp.NCOL;
        } else if (functionName.equals("nrow")) {
            bifop = Expression.BuiltinFunctionOp.NROW;
        } else if (functionName.equals("sign")) {
            bifop = Expression.BuiltinFunctionOp.SIGN;
        } else if (functionName.equals("sqrt")) {
            bifop = Expression.BuiltinFunctionOp.SQRT;
        } else if (functionName.equals("sum")) {
            bifop = Expression.BuiltinFunctionOp.SUM;
        } else if (functionName.equals("mean")) {
            bifop = Expression.BuiltinFunctionOp.MEAN;
        } else if (functionName.equals("sd")) {
            bifop = Expression.BuiltinFunctionOp.SD;
        } else if (functionName.equals("var")) {
            bifop = Expression.BuiltinFunctionOp.VAR;
        } else if (functionName.equals("trace")) {
            bifop = Expression.BuiltinFunctionOp.TRACE;
        } else if (functionName.equals("t")) {
            bifop = Expression.BuiltinFunctionOp.TRANS;
        } else if (functionName.equals("rev")) {
            bifop = Expression.BuiltinFunctionOp.REV;
        } else if (functionName.equals("cbind") || functionName.equals("append")) {
            bifop = Expression.BuiltinFunctionOp.CBIND;
        } else if (functionName.equals("rbind")) {
            bifop = Expression.BuiltinFunctionOp.RBIND;
        } else if (functionName.equals("range")) {
            bifop = Expression.BuiltinFunctionOp.RANGE;
        } else if (functionName.equals("prod")) {
            bifop = Expression.BuiltinFunctionOp.PROD;
        } else if (functionName.equals("rowSums")) {
            bifop = Expression.BuiltinFunctionOp.ROWSUM;
        } else if (functionName.equals("colSums")) {
            bifop = Expression.BuiltinFunctionOp.COLSUM;
        } else if (functionName.equals("rowMins")) {
            bifop = Expression.BuiltinFunctionOp.ROWMIN;
        } else if (functionName.equals("colMins")) {
            bifop = Expression.BuiltinFunctionOp.COLMIN;
        } else if (functionName.equals("rowMaxs")) {
            bifop = Expression.BuiltinFunctionOp.ROWMAX;
        } else if (functionName.equals("rowIndexMax")) {
            bifop = Expression.BuiltinFunctionOp.ROWINDEXMAX;
        } else if (functionName.equals("rowIndexMin")) {
            bifop = Expression.BuiltinFunctionOp.ROWINDEXMIN;
        } else if (functionName.equals("colMaxs")) {
            bifop = Expression.BuiltinFunctionOp.COLMAX;
        } else if (functionName.equals("rowMeans")) {
            bifop = Expression.BuiltinFunctionOp.ROWMEAN;
        } else if (functionName.equals("colMeans")) {
            bifop = Expression.BuiltinFunctionOp.COLMEAN;
        } else if (functionName.equals("rowSds")) {
            bifop = Expression.BuiltinFunctionOp.ROWSD;
        } else if (functionName.equals("colSds")) {
            bifop = Expression.BuiltinFunctionOp.COLSD;
        } else if (functionName.equals("rowVars")) {
            bifop = Expression.BuiltinFunctionOp.ROWVAR;
        } else if (functionName.equals("colVars")) {
            bifop = Expression.BuiltinFunctionOp.COLVAR;
        } else if (functionName.equals("cummax")) {
            bifop = Expression.BuiltinFunctionOp.CUMMAX;
        } else if (functionName.equals("cummin")) {
            bifop = Expression.BuiltinFunctionOp.CUMMIN;
        } else if (functionName.equals("cumprod")) {
            bifop = Expression.BuiltinFunctionOp.CUMPROD;
        } else if (functionName.equals("cumsum")) {
            bifop = Expression.BuiltinFunctionOp.CUMSUM;
        } else if (functionName.equals("as.scalar") || functionName.equals("castAsScalar")) {
            bifop = Expression.BuiltinFunctionOp.CAST_AS_SCALAR;
        } else if (functionName.equals("as.matrix")) {
            bifop = Expression.BuiltinFunctionOp.CAST_AS_MATRIX;
        } else if (functionName.equals("as.frame")) {
            bifop = Expression.BuiltinFunctionOp.CAST_AS_FRAME;
        } else if (functionName.equals("as.double")) {
            bifop = Expression.BuiltinFunctionOp.CAST_AS_DOUBLE;
        } else if (functionName.equals("as.integer")) {
            bifop = Expression.BuiltinFunctionOp.CAST_AS_INT;
        } else if (functionName.equals("as.logical")) {
            bifop = Expression.BuiltinFunctionOp.CAST_AS_BOOLEAN;
        } else if (functionName.equals("quantile")) {
            bifop = Expression.BuiltinFunctionOp.QUANTILE;
        } else if (functionName.equals("interQuantile")) {
            bifop = Expression.BuiltinFunctionOp.INTERQUANTILE;
        } else if (functionName.equals("interQuartileMean")) {
            bifop = Expression.BuiltinFunctionOp.IQM;
        } else if (functionName.equals("table") || functionName.equals("ctable")) {
            bifop = Expression.BuiltinFunctionOp.TABLE;
        } else if (functionName.equals("round")) {
            bifop = Expression.BuiltinFunctionOp.ROUND;
        } else if (functionName.equals("moment") || functionName.equals("centralMoment")) {
            bifop = Expression.BuiltinFunctionOp.MOMENT;
        } else if (functionName.equals("cov")) {
            bifop = Expression.BuiltinFunctionOp.COV;
        } else if (functionName.equals("seq")) {
            bifop = Expression.BuiltinFunctionOp.SEQ;
        } else if (functionName.equals("qr")) {
            bifop = Expression.BuiltinFunctionOp.QR;
        } else if (functionName.equals("lu")) {
            bifop = Expression.BuiltinFunctionOp.LU;
        } else if (functionName.equals("eigen")) {
            bifop = Expression.BuiltinFunctionOp.EIGEN;
        } else if (functionName.equals("conv2d")) {
            bifop = Expression.BuiltinFunctionOp.CONV2D;
        } else if (functionName.equals("bias_add")) {
            bifop = Expression.BuiltinFunctionOp.BIAS_ADD;
        } else if (functionName.equals("bias_multiply")) {
            bifop = Expression.BuiltinFunctionOp.BIAS_MULTIPLY;
        } else if (functionName.equals("conv2d_backward_filter")) {
            bifop = Expression.BuiltinFunctionOp.CONV2D_BACKWARD_FILTER;
        } else if (functionName.equals("conv2d_backward_data")) {
            bifop = Expression.BuiltinFunctionOp.CONV2D_BACKWARD_DATA;
        } else if (functionName.equals("max_pool")) {
            bifop = Expression.BuiltinFunctionOp.MAX_POOL;
        } else if (functionName.equals("max_pool_backward")) {
            bifop = Expression.BuiltinFunctionOp.MAX_POOL_BACKWARD;
        } else if (functionName.equals("avg_pool")) {
            bifop = Expression.BuiltinFunctionOp.AVG_POOL;
        } else if (functionName.equals("solve")) {
            bifop = Expression.BuiltinFunctionOp.SOLVE;
        } else if (functionName.equals("ceil")) {
            bifop = Expression.BuiltinFunctionOp.CEIL;
        } else if (functionName.equals("floor")) {
            bifop = Expression.BuiltinFunctionOp.FLOOR;
        } else if (functionName.equals("median")) {
            bifop = Expression.BuiltinFunctionOp.MEDIAN;
        } else if (functionName.equals("inv")) {
            bifop = Expression.BuiltinFunctionOp.INVERSE;
        } else if (functionName.equals("cholesky")) {
            bifop = Expression.BuiltinFunctionOp.CHOLESKY;
        } else if (functionName.equals("sample")) {
            bifop = Expression.BuiltinFunctionOp.SAMPLE;
        } else if (functionName.equals("outer")) {
            bifop = Expression.BuiltinFunctionOp.OUTER;
        } else {
            return null;
        }
        BuiltinFunctionExpression retVal = new BuiltinFunctionExpression(bifop, paramExprsPassed, filename, blp, bcp, elp, ecp);
        return retVal;
    }

    public static Expression.BuiltinFunctionOp getValueTypeCastOperator(Expression.ValueType vt) throws LanguageException {
        switch (vt) {
            case DOUBLE: {
                return Expression.BuiltinFunctionOp.CAST_AS_DOUBLE;
            }
            case INT: {
                return Expression.BuiltinFunctionOp.CAST_AS_INT;
            }
            case BOOLEAN: {
                return Expression.BuiltinFunctionOp.CAST_AS_BOOLEAN;
            }
        }
        throw new LanguageException("No cast for value type " + (Object)((Object)vt));
    }
}

