/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import java.util.HashMap;
import org.apache.sysml.parser.ConstIdentifier;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.FunctionCallIdentifier;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.VariableSet;

public class BooleanExpression
extends Expression {
    private Expression _left;
    private Expression _right;
    private Expression.BooleanOp _opcode;

    public BooleanExpression(Expression.BooleanOp bop) {
        this._kind = Expression.Kind.BooleanOp;
        this._opcode = bop;
        this.setFilename("MAIN SCRIPT");
        this.setBeginLine(0);
        this.setBeginColumn(0);
        this.setEndLine(0);
        this.setEndColumn(0);
    }

    public BooleanExpression(Expression.BooleanOp bop, String filename, int beginLine, int beginColumn, int endLine, int endColumn) {
        this._kind = Expression.Kind.BooleanOp;
        this._opcode = bop;
        this.setFilename(filename);
        this.setBeginLine(beginLine);
        this.setBeginColumn(beginColumn);
        this.setEndLine(endLine);
        this.setEndColumn(endColumn);
    }

    public Expression.BooleanOp getOpCode() {
        return this._opcode;
    }

    public void setLeft(Expression l) {
        this._left = l;
        if (this._left != null) {
            this.setFilename(this._left.getFilename());
            this.setBeginLine(this._left.getBeginLine());
            this.setBeginColumn(this._left.getBeginColumn());
        }
    }

    public void setRight(Expression r) {
        this._right = r;
        if (this._right != null) {
            this.setFilename(this._right.getFilename());
            this.setBeginLine(this._right.getBeginLine());
            this.setBeginColumn(this._right.getBeginColumn());
        }
    }

    public Expression getLeft() {
        return this._left;
    }

    public Expression getRight() {
        return this._right;
    }

    @Override
    public Expression rewriteExpression(String prefix) throws LanguageException {
        BooleanExpression newExpr = new BooleanExpression(this._opcode, this.getFilename(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
        newExpr.setLeft(this._left.rewriteExpression(prefix));
        if (this._right != null) {
            newExpr.setRight(this._right.rewriteExpression(prefix));
        }
        return newExpr;
    }

    @Override
    public void validateExpression(HashMap<String, DataIdentifier> ids, HashMap<String, ConstIdentifier> constVars, boolean conditional) throws LanguageException {
        this.getLeft().validateExpression(ids, constVars, conditional);
        if (this._left instanceof FunctionCallIdentifier) {
            this.raiseValidateError("user-defined function calls not supported in boolean expressions", false, "Unsupported Expression");
        }
        if (this.getRight() != null) {
            if (this._right instanceof FunctionCallIdentifier) {
                this.raiseValidateError("user-defined function calls not supported in boolean expressions", false, "Unsupported Expression");
            }
            this.getRight().validateExpression(ids, constVars, conditional);
        }
        String outputName = BooleanExpression.getTempName();
        DataIdentifier output = new DataIdentifier(outputName);
        output.setAllPositions(this.getFilename(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
        output.setBooleanProperties();
        this.setOutput(output);
        if (this._opcode == Expression.BooleanOp.CONDITIONALAND || this._opcode == Expression.BooleanOp.CONDITIONALOR) {
            this.raiseValidateError("Unsupported boolean operation " + this._opcode.toString(), false, "Unsupported Parameters");
        }
    }

    public String toString() {
        if (this._opcode == Expression.BooleanOp.NOT) {
            return "(" + this._opcode.toString() + " " + this._left.toString() + ")";
        }
        return "(" + this._left.toString() + " " + this._opcode.toString() + " " + this._right.toString() + ")";
    }

    @Override
    public VariableSet variablesRead() {
        VariableSet result = new VariableSet();
        result.addVariables(this._left.variablesRead());
        if (this._right != null) {
            result.addVariables(this._right.variablesRead());
        }
        return result;
    }

    @Override
    public VariableSet variablesUpdated() {
        VariableSet result = new VariableSet();
        result.addVariables(this._left.variablesUpdated());
        if (this._right != null) {
            result.addVariables(this._right.variablesUpdated());
        }
        return result;
    }
}

