/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class AppendGAlignedSP
extends Lop {
    public static final String OPCODE = "galignedappend";
    private boolean _cbind = true;

    public AppendGAlignedSP(Lop input1, Lop input2, Lop input3, Expression.DataType dt, Expression.ValueType vt, boolean cbind) {
        super(Lop.Type.Append, dt, vt);
        this.init(input1, input2, input3, dt, vt);
        this._cbind = true;
    }

    public void init(Lop input1, Lop input2, Lop input3, Expression.DataType dt, Expression.ValueType vt) {
        this.addInput(input1);
        input1.addOutput(this);
        this.addInput(input2);
        input2.addOutput(this);
        this.addInput(input3);
        input3.addOutput(this);
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = false;
        this.lps.addCompatibility(JobType.INVALID);
        this.lps.setProperties(this.inputs, LopProperties.ExecType.SPARK, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
    }

    @Override
    public String toString() {
        return " AppendGSP: ";
    }

    @Override
    public String getInstructions(String input_index1, String input_index2, String input_index3, String output_index) throws LopsException {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(OPCODE);
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input_index1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepInputOperand(input_index2));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(2).prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output_index));
        sb.append("\u00b0");
        sb.append(this._cbind);
        return sb.toString();
    }
}

