/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.rewrite;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.hops.AggBinaryOp;
import org.apache.sysml.hops.AggUnaryOp;
import org.apache.sysml.hops.BinaryOp;
import org.apache.sysml.hops.DataGenOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.IndexingOp;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.ParameterizedBuiltinOp;
import org.apache.sysml.hops.ReorgOp;
import org.apache.sysml.hops.TernaryOp;
import org.apache.sysml.hops.UnaryOp;
import org.apache.sysml.hops.rewrite.HopRewriteRule;
import org.apache.sysml.hops.rewrite.HopRewriteUtils;
import org.apache.sysml.hops.rewrite.ProgramRewriteStatus;
import org.apache.sysml.parser.Expression;

public class RewriteAlgebraicSimplificationStatic
extends HopRewriteRule {
    private static final Log LOG = LogFactory.getLog((String)RewriteAlgebraicSimplificationStatic.class.getName());
    private static Hop.AggOp[] LOOKUP_VALID_ROW_COL_AGGREGATE = new Hop.AggOp[]{Hop.AggOp.SUM, Hop.AggOp.SUM_SQ, Hop.AggOp.MIN, Hop.AggOp.MAX, Hop.AggOp.MEAN, Hop.AggOp.VAR};
    private static Hop.OpOp2[] LOOKUP_VALID_DISTRIBUTIVE_BINARY = new Hop.OpOp2[]{Hop.OpOp2.PLUS, Hop.OpOp2.MINUS};
    private static Hop.OpOp2[] LOOKUP_VALID_ASSOCIATIVE_BINARY = new Hop.OpOp2[]{Hop.OpOp2.PLUS, Hop.OpOp2.MULT};

    @Override
    public ArrayList<Hop> rewriteHopDAGs(ArrayList<Hop> roots, ProgramRewriteStatus state) throws HopsException {
        if (roots == null) {
            return roots;
        }
        for (Hop h : roots) {
            this.rule_AlgebraicSimplification(h, false);
        }
        Hop.resetVisitStatus(roots);
        for (Hop h : roots) {
            this.rule_AlgebraicSimplification(h, true);
        }
        return roots;
    }

    @Override
    public Hop rewriteHopDAG(Hop root, ProgramRewriteStatus state) throws HopsException {
        if (root == null) {
            return root;
        }
        this.rule_AlgebraicSimplification(root, false);
        root.resetVisitStatus();
        this.rule_AlgebraicSimplification(root, true);
        return root;
    }

    private void rule_AlgebraicSimplification(Hop hop, boolean descendFirst) throws HopsException {
        if (hop.isVisited()) {
            return;
        }
        for (int i = 0; i < hop.getInput().size(); ++i) {
            Hop hi = hop.getInput().get(i);
            if (descendFirst) {
                this.rule_AlgebraicSimplification(hi, descendFirst);
            }
            hi = this.removeUnnecessaryVectorizeOperation(hi);
            hi = this.removeUnnecessaryBinaryOperation(hop, hi, i);
            hi = this.fuseDatagenAndBinaryOperation(hi);
            hi = this.fuseDatagenAndMinusOperation(hi);
            hi = this.simplifyBinaryToUnaryOperation(hop, hi, i);
            hi = this.canonicalizeMatrixMultScalarAdd(hi);
            hi = this.simplifyReverseOperation(hop, hi, i);
            if (OptimizerUtils.ALLOW_OPERATOR_FUSION) {
                hi = this.simplifyMultiBinaryToBinaryOperation(hi);
            }
            hi = this.simplifyDistributiveBinaryOperation(hop, hi, i);
            hi = this.simplifyBushyBinaryOperation(hop, hi, i);
            hi = this.simplifyUnaryAggReorgOperation(hop, hi, i);
            hi = this.simplifyBinaryMatrixScalarOperation(hop, hi, i);
            hi = this.pushdownUnaryAggTransposeOperation(hop, hi, i);
            hi = this.pushdownCSETransposeScalarOperation(hop, hi, i);
            hi = this.pushdownSumBinaryMult(hop, hi, i);
            hi = this.simplifyUnaryPPredOperation(hop, hi, i);
            hi = this.simplifyTransposedAppend(hop, hi, i);
            if (OptimizerUtils.ALLOW_OPERATOR_FUSION) {
                hi = this.fuseBinarySubDAGToUnaryOperation(hop, hi, i);
            }
            hi = this.simplifyTraceMatrixMult(hop, hi, i);
            hi = this.simplifySlicedMatrixMult(hop, hi, i);
            hi = this.simplifyConstantSort(hop, hi, i);
            hi = this.simplifyOrderedSort(hop, hi, i);
            hi = this.removeUnnecessaryReorgOperation(hop, hi, i);
            hi = this.simplifyTransposeAggBinBinaryChains(hop, hi, i);
            hi = this.removeUnnecessaryMinus(hop, hi, i);
            hi = this.simplifyGroupedAggregate(hi);
            if (OptimizerUtils.ALLOW_OPERATOR_FUSION) {
                hi = this.fuseMinusNzBinaryOperation(hop, hi, i);
                hi = this.fuseLogNzUnaryOperation(hop, hi, i);
                hi = this.fuseLogNzBinaryOperation(hop, hi, i);
            }
            hi = this.simplifyOuterSeqExpand(hop, hi, i);
            if (descendFirst) continue;
            this.rule_AlgebraicSimplification(hi, descendFirst);
        }
        hop.setVisited();
    }

    private Hop removeUnnecessaryVectorizeOperation(Hop hi) {
        if (hi instanceof BinaryOp && hi.getDataType() == Expression.DataType.MATRIX && ((BinaryOp)hi).supportsMatrixScalarOperations()) {
            BinaryOp bop = (BinaryOp)hi;
            Hop left = bop.getInput().get(0);
            Hop right = bop.getInput().get(1);
            if (left.getDim1() <= 1L || left.getDim2() != 1L || right.getDim1() != 1L || right.getDim2() <= 1L) {
                DataGenOp dleft;
                if (left.getDataType() == Expression.DataType.MATRIX && right instanceof DataGenOp) {
                    DataGenOp dright = (DataGenOp)right;
                    if (dright.getOp() == Hop.DataGenMethod.RAND && dright.hasConstantValue()) {
                        Hop drightIn = dright.getInput().get(dright.getParamIndex("min"));
                        HopRewriteUtils.replaceChildReference(bop, dright, drightIn, 1);
                        HopRewriteUtils.cleanupUnreferenced(dright);
                        LOG.debug((Object)"Applied removeUnnecessaryVectorizeOperation1");
                    }
                } else if (right.getDataType() == Expression.DataType.MATRIX && left instanceof DataGenOp && (dleft = (DataGenOp)left).getOp() == Hop.DataGenMethod.RAND && dleft.hasConstantValue() && (left.getDim2() == 1L || right.getDim2() > 1L) && (left.getDim1() == 1L || right.getDim1() > 1L)) {
                    Hop dleftIn = dleft.getInput().get(dleft.getParamIndex("min"));
                    HopRewriteUtils.replaceChildReference(bop, dleft, dleftIn, 0);
                    HopRewriteUtils.cleanupUnreferenced(dleft);
                    LOG.debug((Object)"Applied removeUnnecessaryVectorizeOperation2");
                }
            }
        }
        return hi;
    }

    private Hop removeUnnecessaryBinaryOperation(Hop parent, Hop hi, int pos) throws HopsException {
        if (hi instanceof BinaryOp) {
            BinaryOp bop = (BinaryOp)hi;
            Hop left = bop.getInput().get(0);
            Hop right = bop.getInput().get(1);
            if (left.getDataType() == Expression.DataType.MATRIX && right instanceof LiteralOp && ((LiteralOp)right).getDoubleValue() == 1.0) {
                if (bop.getOp() == Hop.OpOp2.DIV || bop.getOp() == Hop.OpOp2.MULT) {
                    HopRewriteUtils.replaceChildReference(parent, bop, left, pos);
                    hi = left;
                    LOG.debug((Object)("Applied removeUnnecessaryBinaryOperation1 (line " + bop.getBeginLine() + ")"));
                }
            } else if (left.getDataType() == Expression.DataType.MATRIX && right instanceof LiteralOp && ((LiteralOp)right).getDoubleValue() == 0.0) {
                if (bop.getOp() == Hop.OpOp2.MINUS) {
                    HopRewriteUtils.replaceChildReference(parent, bop, left, pos);
                    hi = left;
                    LOG.debug((Object)("Applied removeUnnecessaryBinaryOperation2 (line " + bop.getBeginLine() + ")"));
                }
            } else if (right.getDataType() == Expression.DataType.MATRIX && left instanceof LiteralOp && ((LiteralOp)left).getDoubleValue() == 1.0) {
                if (bop.getOp() == Hop.OpOp2.MULT) {
                    HopRewriteUtils.replaceChildReference(parent, bop, right, pos);
                    hi = right;
                    LOG.debug((Object)("Applied removeUnnecessaryBinaryOperation3 (line " + bop.getBeginLine() + ")"));
                }
            } else if (right.getDataType() == Expression.DataType.MATRIX && left instanceof LiteralOp && ((LiteralOp)left).getDoubleValue() == -1.0) {
                if (bop.getOp() == Hop.OpOp2.MULT) {
                    bop.setOp(Hop.OpOp2.MINUS);
                    HopRewriteUtils.replaceChildReference(bop, left, new LiteralOp(0L), 0);
                    hi = bop;
                    LOG.debug((Object)("Applied removeUnnecessaryBinaryOperation4 (line " + bop.getBeginLine() + ")"));
                }
            } else if (left.getDataType() == Expression.DataType.MATRIX && right instanceof LiteralOp && ((LiteralOp)right).getDoubleValue() == -1.0 && bop.getOp() == Hop.OpOp2.MULT) {
                bop.setOp(Hop.OpOp2.MINUS);
                HopRewriteUtils.removeChildReferenceByPos(bop, right, 1);
                HopRewriteUtils.addChildReference(bop, new LiteralOp(0L), 0);
                hi = bop;
                LOG.debug((Object)("Applied removeUnnecessaryBinaryOperation5 (line " + bop.getBeginLine() + ")"));
            }
        }
        return hi;
    }

    private Hop fuseDatagenAndBinaryOperation(Hop hi) throws HopsException {
        if (hi instanceof BinaryOp) {
            BinaryOp bop = (BinaryOp)hi;
            Hop left = bop.getInput().get(0);
            Hop right = bop.getInput().get(1);
            if (left instanceof DataGenOp && ((DataGenOp)left).getOp() == Hop.DataGenMethod.RAND && right instanceof LiteralOp && left.getParent().size() == 1) {
                DataGenOp inputGen = (DataGenOp)left;
                HashMap<String, Integer> params = inputGen.getParamIndexMap();
                Hop pdf = left.getInput().get(params.get("pdf"));
                Hop min = left.getInput().get(params.get("min"));
                Hop max = left.getInput().get(params.get("max"));
                double sval = ((LiteralOp)right).getDoubleValue();
                if ((bop.getOp() == Hop.OpOp2.MULT || bop.getOp() == Hop.OpOp2.PLUS || bop.getOp() == Hop.OpOp2.MINUS) && min instanceof LiteralOp && max instanceof LiteralOp && pdf instanceof LiteralOp && "uniform".equals(((LiteralOp)pdf).getStringValue())) {
                    DataGenOp gen = null;
                    gen = bop.getOp() == Hop.OpOp2.MULT ? HopRewriteUtils.copyDataGenOp(inputGen, sval, 0.0) : HopRewriteUtils.copyDataGenOp(inputGen, 1.0, sval *= bop.getOp() == Hop.OpOp2.MINUS ? -1.0 : 1.0);
                    ArrayList<Hop> parents = new ArrayList<Hop>(bop.getParent());
                    for (Hop p : parents) {
                        HopRewriteUtils.replaceChildReference(p, bop, gen);
                    }
                    hi = gen;
                    LOG.debug((Object)("Applied fuseDatagenAndBinaryOperation1 (line " + bop.getBeginLine() + ")."));
                }
            } else if (right instanceof DataGenOp && ((DataGenOp)right).getOp() == Hop.DataGenMethod.RAND && left instanceof LiteralOp && right.getParent().size() == 1) {
                DataGenOp inputGen = (DataGenOp)right;
                HashMap<String, Integer> params = inputGen.getParamIndexMap();
                Hop pdf = right.getInput().get(params.get("pdf"));
                Hop min = right.getInput().get(params.get("min"));
                Hop max = right.getInput().get(params.get("max"));
                double sval = ((LiteralOp)left).getDoubleValue();
                if ((bop.getOp() == Hop.OpOp2.MULT || bop.getOp() == Hop.OpOp2.PLUS) && min instanceof LiteralOp && max instanceof LiteralOp && pdf instanceof LiteralOp && "uniform".equals(((LiteralOp)pdf).getStringValue())) {
                    DataGenOp gen = null;
                    gen = bop.getOp() == Hop.OpOp2.MULT ? HopRewriteUtils.copyDataGenOp(inputGen, sval, 0.0) : HopRewriteUtils.copyDataGenOp(inputGen, 1.0, sval);
                    ArrayList<Hop> parents = new ArrayList<Hop>(bop.getParent());
                    for (Hop p : parents) {
                        HopRewriteUtils.replaceChildReference(p, bop, gen);
                    }
                    hi = gen;
                    LOG.debug((Object)("Applied fuseDatagenAndBinaryOperation2 (line " + bop.getBeginLine() + ")."));
                }
            }
        }
        return hi;
    }

    private Hop fuseDatagenAndMinusOperation(Hop hi) throws HopsException {
        if (hi instanceof BinaryOp) {
            BinaryOp bop = (BinaryOp)hi;
            Hop left = bop.getInput().get(0);
            Hop right = bop.getInput().get(1);
            if (right instanceof DataGenOp && ((DataGenOp)right).getOp() == Hop.DataGenMethod.RAND && left instanceof LiteralOp && ((LiteralOp)left).getDoubleValue() == 0.0) {
                DataGenOp inputGen = (DataGenOp)right;
                HashMap<String, Integer> params = inputGen.getParamIndexMap();
                Hop pdf = right.getInput().get(params.get("pdf"));
                int ixMin = params.get("min");
                int ixMax = params.get("max");
                Hop min = right.getInput().get(ixMin);
                Hop max = right.getInput().get(ixMax);
                if (inputGen.getParent().size() == 1 && min instanceof LiteralOp && max instanceof LiteralOp && pdf instanceof LiteralOp && "uniform".equals(((LiteralOp)pdf).getStringValue())) {
                    double newMinVal = ((LiteralOp)max).getDoubleValue() == 0.0 ? 0.0 : -1.0 * ((LiteralOp)max).getDoubleValue();
                    double newMaxVal = ((LiteralOp)min).getDoubleValue() == 0.0 ? 0.0 : -1.0 * ((LiteralOp)min).getDoubleValue();
                    LiteralOp newMin = new LiteralOp(newMinVal);
                    LiteralOp newMax = new LiteralOp(newMaxVal);
                    HopRewriteUtils.removeChildReferenceByPos(inputGen, min, ixMin);
                    HopRewriteUtils.addChildReference(inputGen, newMin, ixMin);
                    HopRewriteUtils.removeChildReferenceByPos(inputGen, max, ixMax);
                    HopRewriteUtils.addChildReference(inputGen, newMax, ixMax);
                    ArrayList<Hop> parents = new ArrayList<Hop>(bop.getParent());
                    for (Hop p : parents) {
                        HopRewriteUtils.replaceChildReference(p, bop, inputGen);
                    }
                    hi = inputGen;
                    LOG.debug((Object)("Applied fuseDatagenAndMinusOperation (line " + bop.getBeginLine() + ")."));
                }
            }
        }
        return hi;
    }

    private Hop simplifyBinaryToUnaryOperation(Hop parent, Hop hi, int pos) throws HopsException {
        if (hi instanceof BinaryOp) {
            Hop right;
            BinaryOp bop = (BinaryOp)hi;
            Hop left = hi.getInput().get(0);
            if (left == (right = hi.getInput().get(1)) && left.getDataType() == Expression.DataType.MATRIX) {
                if (bop.getOp() == Hop.OpOp2.PLUS) {
                    bop.setOp(Hop.OpOp2.MULT);
                    LiteralOp tmp = new LiteralOp(2L);
                    bop.getInput().remove(1);
                    right.getParent().remove(bop);
                    HopRewriteUtils.addChildReference(hi, tmp, 1);
                    LOG.debug((Object)"Applied simplifyBinaryToUnaryOperation1");
                } else if (bop.getOp() == Hop.OpOp2.MULT) {
                    bop.setOp(Hop.OpOp2.POW);
                    LiteralOp tmp = new LiteralOp(2L);
                    bop.getInput().remove(1);
                    right.getParent().remove(bop);
                    HopRewriteUtils.addChildReference(hi, tmp, 1);
                    LOG.debug((Object)"Applied simplifyBinaryToUnaryOperation2");
                }
            } else if (bop.getOp() == Hop.OpOp2.MINUS && HopRewriteUtils.isBinary(left, Hop.OpOp2.GREATER) && HopRewriteUtils.isBinary(right, Hop.OpOp2.LESS) && left.getInput().get(0) == right.getInput().get(0) && left.getInput().get(1) instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)left.getInput().get(1)) == 0.0 && right.getInput().get(1) instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)right.getInput().get(1)) == 0.0) {
                UnaryOp uop = HopRewriteUtils.createUnary(left.getInput().get(0), Hop.OpOp1.SIGN);
                HopRewriteUtils.replaceChildReference(parent, hi, uop, pos);
                HopRewriteUtils.cleanupUnreferenced(hi, left, right);
                hi = uop;
                LOG.debug((Object)"Applied simplifyBinaryToUnaryOperation3");
            }
        }
        return hi;
    }

    private Hop canonicalizeMatrixMultScalarAdd(Hop hi) throws HopsException {
        if (hi instanceof BinaryOp) {
            BinaryOp bop = (BinaryOp)hi;
            Hop left = hi.getInput().get(0);
            Hop right = hi.getInput().get(1);
            if (left.getDataType().isScalar() && right instanceof AggBinaryOp && bop.getOp() == Hop.OpOp2.PLUS) {
                HopRewriteUtils.removeAllChildReferences(bop);
                HopRewriteUtils.addChildReference(bop, right, 0);
                HopRewriteUtils.addChildReference(bop, left, 1);
                LOG.debug((Object)("Applied canonicalizeMatrixMultScalarAdd1 (line " + hi.getBeginLine() + ")."));
            } else if (right.getDataType().isScalar() && left instanceof AggBinaryOp && bop.getOp() == Hop.OpOp2.MINUS) {
                bop.setOp(Hop.OpOp2.PLUS);
                HopRewriteUtils.replaceChildReference(bop, right, HopRewriteUtils.createBinaryMinus(right), 1);
                LOG.debug((Object)("Applied canonicalizeMatrixMultScalarAdd2 (line " + hi.getBeginLine() + ")."));
            }
        }
        return hi;
    }

    private Hop simplifyReverseOperation(Hop parent, Hop hi, int pos) throws HopsException {
        TernaryOp top;
        if (hi instanceof AggBinaryOp && hi.getInput().get(0) instanceof TernaryOp && (top = (TernaryOp)hi.getInput().get(0)).getOp() == Hop.OpOp3.CTABLE && HopRewriteUtils.isBasic1NSequence(top.getInput().get(0)) && HopRewriteUtils.isBasicN1Sequence(top.getInput().get(1)) && top.getInput().get(0).getDim1() == top.getInput().get(1).getDim1()) {
            ReorgOp rop = HopRewriteUtils.createReorg(hi.getInput().get(1), Hop.ReOrgOp.REV);
            HopRewriteUtils.replaceChildReference(parent, hi, rop, pos);
            HopRewriteUtils.cleanupUnreferenced(hi, top);
            hi = rop;
            LOG.debug((Object)"Applied simplifyReverseOperation.");
        }
        return hi;
    }

    private Hop simplifyMultiBinaryToBinaryOperation(Hop hi) {
        if (HopRewriteUtils.isBinary(hi, Hop.OpOp2.MINUS) && hi.getDataType() == Expression.DataType.MATRIX && hi.getInput().get(0) instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)hi.getInput().get(0)) == 1.0 && HopRewriteUtils.isBinary(hi.getInput().get(1), Hop.OpOp2.MULT) && hi.getInput().get(1).getParent().size() == 1) {
            BinaryOp bop = (BinaryOp)hi;
            Hop left = hi.getInput().get(1).getInput().get(0);
            Hop right = hi.getInput().get(1).getInput().get(1);
            bop.setOp(Hop.OpOp2.MINUS1_MULT);
            HopRewriteUtils.removeAllChildReferences(hi);
            HopRewriteUtils.addChildReference(bop, left);
            HopRewriteUtils.addChildReference(bop, right);
            LOG.debug((Object)"Applied simplifyMultiBinaryToBinaryOperation.");
        }
        return hi;
    }

    private Hop simplifyDistributiveBinaryOperation(Hop parent, Hop hi, int pos) {
        if (hi instanceof BinaryOp) {
            BinaryOp bop = (BinaryOp)hi;
            Hop left = bop.getInput().get(0);
            Hop right = bop.getInput().get(1);
            boolean applied = false;
            if (left.getDataType() == Expression.DataType.MATRIX && right.getDataType() == Expression.DataType.MATRIX && HopRewriteUtils.isValidOp(bop.getOp(), LOOKUP_VALID_DISTRIBUTIVE_BINARY)) {
                BinaryOp mult;
                BinaryOp plus;
                LiteralOp literal;
                Hop X = null;
                Hop Y = null;
                if (HopRewriteUtils.isBinary(left, Hop.OpOp2.MULT)) {
                    Hop leftC1 = left.getInput().get(0);
                    Hop leftC2 = left.getInput().get(1);
                    if (leftC1.getDataType() == Expression.DataType.MATRIX && leftC2.getDataType() == Expression.DataType.MATRIX && (right == leftC1 || right == leftC2) && leftC1 != leftC2) {
                        X = right;
                        Hop hop = Y = right == leftC1 ? leftC2 : leftC1;
                    }
                    if (X != null) {
                        literal = new LiteralOp(1L);
                        plus = HopRewriteUtils.createBinary(Y, literal, bop.getOp());
                        mult = HopRewriteUtils.createBinary(plus, X, Hop.OpOp2.MULT);
                        HopRewriteUtils.replaceChildReference(parent, hi, mult, pos);
                        HopRewriteUtils.cleanupUnreferenced(hi, left);
                        hi = mult;
                        applied = true;
                        LOG.debug((Object)"Applied simplifyDistributiveBinaryOperation1");
                    }
                }
                if (!applied && HopRewriteUtils.isBinary(right, Hop.OpOp2.MULT)) {
                    Hop rightC1 = right.getInput().get(0);
                    Hop rightC2 = right.getInput().get(1);
                    if (rightC1.getDataType() == Expression.DataType.MATRIX && rightC2.getDataType() == Expression.DataType.MATRIX && (left == rightC1 || left == rightC2) && rightC1 != rightC2) {
                        X = left;
                        Hop hop = Y = left == rightC1 ? rightC2 : rightC1;
                    }
                    if (X != null) {
                        literal = new LiteralOp(1L);
                        plus = HopRewriteUtils.createBinary(literal, Y, bop.getOp());
                        mult = HopRewriteUtils.createBinary(plus, X, Hop.OpOp2.MULT);
                        HopRewriteUtils.replaceChildReference(parent, hi, mult, pos);
                        HopRewriteUtils.cleanupUnreferenced(hi, right);
                        hi = mult;
                        LOG.debug((Object)"Applied simplifyDistributiveBinaryOperation2");
                    }
                }
            }
        }
        return hi;
    }

    private Hop simplifyBushyBinaryOperation(Hop parent, Hop hi, int pos) {
        if (hi instanceof BinaryOp && parent instanceof AggBinaryOp) {
            BinaryOp bop = (BinaryOp)hi;
            Hop left = bop.getInput().get(0);
            Hop right = bop.getInput().get(1);
            Hop.OpOp2 op = bop.getOp();
            if (left.getDataType() == Expression.DataType.MATRIX && right.getDataType() == Expression.DataType.MATRIX && HopRewriteUtils.isValidOp(op, LOOKUP_VALID_ASSOCIATIVE_BINARY)) {
                BinaryOp bop4;
                BinaryOp bop3;
                Hop.OpOp2 op2;
                Hop right2;
                Hop left2;
                BinaryOp bop2;
                boolean applied = false;
                if (right instanceof BinaryOp) {
                    bop2 = (BinaryOp)right;
                    left2 = bop2.getInput().get(0);
                    right2 = bop2.getInput().get(1);
                    op2 = bop2.getOp();
                    if (op == op2 && right2.getDataType() == Expression.DataType.MATRIX && right2 instanceof AggBinaryOp) {
                        bop3 = HopRewriteUtils.createBinary(left, left2, op);
                        bop4 = HopRewriteUtils.createBinary(bop3, right2, op);
                        HopRewriteUtils.replaceChildReference(parent, bop, bop4, pos);
                        HopRewriteUtils.cleanupUnreferenced(bop, bop2);
                        hi = bop4;
                        applied = true;
                        LOG.debug((Object)"Applied simplifyBushyBinaryOperation1");
                    }
                }
                if (!applied && left instanceof BinaryOp) {
                    bop2 = (BinaryOp)left;
                    left2 = bop2.getInput().get(0);
                    right2 = bop2.getInput().get(1);
                    op2 = bop2.getOp();
                    if (!(op != op2 || left2.getDataType() != Expression.DataType.MATRIX || !(left2 instanceof AggBinaryOp) || right2.getDim2() <= 1L && right.getDim2() != 1L || right2.getDim1() <= 1L && right.getDim1() != 1L)) {
                        bop3 = HopRewriteUtils.createBinary(right2, right, op);
                        bop4 = HopRewriteUtils.createBinary(left2, bop3, op);
                        HopRewriteUtils.replaceChildReference(parent, bop, bop4, pos);
                        HopRewriteUtils.cleanupUnreferenced(bop, bop2);
                        hi = bop4;
                        LOG.debug((Object)"Applied simplifyBushyBinaryOperation2");
                    }
                }
            }
        }
        return hi;
    }

    private Hop simplifyUnaryAggReorgOperation(Hop parent, Hop hi, int pos) {
        ReorgOp rop;
        if (hi instanceof AggUnaryOp && ((AggUnaryOp)hi).getDirection() == Hop.Direction.RowCol && hi.getInput().get(0) instanceof ReorgOp && ((rop = (ReorgOp)hi.getInput().get(0)).getOp() == Hop.ReOrgOp.TRANSPOSE || rop.getOp() == Hop.ReOrgOp.RESHAPE || rop.getOp() == Hop.ReOrgOp.REV) && rop.getParent().size() == 1) {
            Hop input = rop.getInput().get(0);
            HopRewriteUtils.removeAllChildReferences(hi);
            HopRewriteUtils.removeAllChildReferences(rop);
            HopRewriteUtils.addChildReference(hi, input);
            LOG.debug((Object)"Applied simplifyUnaryAggReorgOperation");
        }
        return hi;
    }

    private Hop simplifyBinaryMatrixScalarOperation(Hop parent, Hop hi, int pos) throws HopsException {
        if (HopRewriteUtils.isUnary(hi, Hop.OpOp1.CAST_AS_SCALAR) && hi.getInput().get(0) instanceof BinaryOp) {
            BinaryOp bin = (BinaryOp)hi.getInput().get(0);
            BinaryOp bout = null;
            if (bin.getInput().get(0).getDataType() == Expression.DataType.MATRIX && bin.getInput().get(1).getDataType() == Expression.DataType.MATRIX) {
                UnaryOp cast1 = HopRewriteUtils.createUnary(bin.getInput().get(0), Hop.OpOp1.CAST_AS_SCALAR);
                UnaryOp cast2 = HopRewriteUtils.createUnary(bin.getInput().get(1), Hop.OpOp1.CAST_AS_SCALAR);
                bout = HopRewriteUtils.createBinary(cast1, cast2, bin.getOp());
            } else if (bin.getInput().get(0).getDataType() == Expression.DataType.MATRIX) {
                UnaryOp cast = HopRewriteUtils.createUnary(bin.getInput().get(0), Hop.OpOp1.CAST_AS_SCALAR);
                bout = HopRewriteUtils.createBinary(cast, bin.getInput().get(1), bin.getOp());
            } else if (bin.getInput().get(1).getDataType() == Expression.DataType.MATRIX) {
                UnaryOp cast = HopRewriteUtils.createUnary(bin.getInput().get(1), Hop.OpOp1.CAST_AS_SCALAR);
                bout = HopRewriteUtils.createBinary(bin.getInput().get(0), cast, bin.getOp());
            }
            if (bout != null) {
                HopRewriteUtils.replaceChildReference(parent, hi, bout, pos);
                LOG.debug((Object)"Applied simplifyBinaryMatrixScalarOperation.");
            }
        }
        return hi;
    }

    private Hop pushdownUnaryAggTransposeOperation(Hop parent, Hop hi, int pos) {
        if (hi instanceof AggUnaryOp && hi.getParent().size() == 1 && (((AggUnaryOp)hi).getDirection() == Hop.Direction.Row || ((AggUnaryOp)hi).getDirection() == Hop.Direction.Col) && HopRewriteUtils.isTransposeOperation(hi.getInput().get(0), 1) && HopRewriteUtils.isValidOp(((AggUnaryOp)hi).getOp(), LOOKUP_VALID_ROW_COL_AGGREGATE)) {
            AggUnaryOp uagg = (AggUnaryOp)hi;
            Hop input = uagg.getInput().get(0).getInput().get(0);
            HopRewriteUtils.removeAllChildReferences(hi.getInput().get(0));
            HopRewriteUtils.removeAllChildReferences(hi);
            HopRewriteUtils.removeChildReferenceByPos(parent, hi, pos);
            if (uagg.getDirection() == Hop.Direction.Row) {
                uagg.setDirection(Hop.Direction.Col);
                LOG.debug((Object)("Applied pushdownUnaryAggTransposeOperation1 (line " + hi.getBeginLine() + ")."));
            } else if (uagg.getDirection() == Hop.Direction.Col) {
                uagg.setDirection(Hop.Direction.Row);
                LOG.debug((Object)("Applied pushdownUnaryAggTransposeOperation2 (line " + hi.getBeginLine() + ")."));
            }
            HopRewriteUtils.addChildReference(uagg, input);
            uagg.refreshSizeInformation();
            ReorgOp trans = HopRewriteUtils.createTranspose(uagg);
            HopRewriteUtils.addChildReference(parent, trans, pos);
            hi = trans;
        }
        return hi;
    }

    private Hop pushdownCSETransposeScalarOperation(Hop parent, Hop hi, int pos) {
        if (HopRewriteUtils.isTransposeOperation(hi, 1) && HopRewriteUtils.isBinaryMatrixScalarOperation(hi.getInput().get(0)) && hi.getInput().get(0).getParent().size() == 1) {
            int Xpos = hi.getInput().get(0).getInput().get(0).getDataType().isMatrix() ? 0 : 1;
            Hop X = hi.getInput().get(0).getInput().get(Xpos);
            BinaryOp binary = (BinaryOp)hi.getInput().get(0);
            if (HopRewriteUtils.containsTransposeOperation(X.getParent()) && !HopRewriteUtils.isValidOp(binary.getOp(), new Hop.OpOp2[]{Hop.OpOp2.CENTRALMOMENT, Hop.OpOp2.QUANTILE})) {
                HopRewriteUtils.removeChildReferenceByPos(parent, hi, pos);
                HopRewriteUtils.removeChildReference(hi, binary);
                HopRewriteUtils.removeChildReference(binary, X);
                HopRewriteUtils.addChildReference(parent, binary, pos);
                HopRewriteUtils.addChildReference(binary, hi, Xpos);
                HopRewriteUtils.addChildReference(hi, X);
                hi = binary;
                LOG.debug((Object)("Applied pushdownCSETransposeScalarOperation (line " + hi.getBeginLine() + ")."));
            }
        }
        return hi;
    }

    private Hop pushdownSumBinaryMult(Hop parent, Hop hi, int pos) throws HopsException {
        if (hi instanceof AggUnaryOp && ((AggUnaryOp)hi).getDirection() == Hop.Direction.RowCol && ((AggUnaryOp)hi).getOp() == Hop.AggOp.SUM && HopRewriteUtils.isBinary(hi.getInput().get(0), Hop.OpOp2.MULT, 1) && (hi.getInput().get(0).getInput().get(0).getDataType() == Expression.DataType.SCALAR && hi.getInput().get(0).getInput().get(1).getDataType() == Expression.DataType.MATRIX || hi.getInput().get(0).getInput().get(0).getDataType() == Expression.DataType.MATRIX && hi.getInput().get(0).getInput().get(1).getDataType() == Expression.DataType.SCALAR)) {
            Hop operand1 = hi.getInput().get(0).getInput().get(0);
            Hop operand2 = hi.getInput().get(0).getInput().get(1);
            Hop lamda = operand1.getDataType() == Expression.DataType.SCALAR ? operand1 : operand2;
            Hop matrix = operand1.getDataType() == Expression.DataType.MATRIX ? operand1 : operand2;
            AggUnaryOp aggOp = HopRewriteUtils.createAggUnaryOp(matrix, Hop.AggOp.SUM, Hop.Direction.RowCol);
            BinaryOp bop = HopRewriteUtils.createBinary(lamda, aggOp, Hop.OpOp2.MULT);
            HopRewriteUtils.replaceChildReference(parent, hi, bop, pos);
            LOG.debug((Object)"Applied pushdownSumBinaryMult.");
            return bop;
        }
        return hi;
    }

    private Hop simplifyUnaryPPredOperation(Hop parent, Hop hi, int pos) {
        UnaryOp uop;
        if (hi instanceof UnaryOp && hi.getDataType() == Expression.DataType.MATRIX && hi.getInput().get(0) instanceof BinaryOp && ((BinaryOp)hi.getInput().get(0)).isPPredOperation() && ((uop = (UnaryOp)hi).getOp() == Hop.OpOp1.ABS || uop.getOp() == Hop.OpOp1.SIGN || uop.getOp() == Hop.OpOp1.SELP || uop.getOp() == Hop.OpOp1.CEIL || uop.getOp() == Hop.OpOp1.FLOOR || uop.getOp() == Hop.OpOp1.ROUND)) {
            Hop input = uop.getInput().get(0);
            HopRewriteUtils.replaceChildReference(parent, hi, input, pos);
            HopRewriteUtils.cleanupUnreferenced(hi);
            hi = input;
            LOG.debug((Object)"Applied simplifyUnaryPPredOperation.");
        }
        return hi;
    }

    private Hop simplifyTransposedAppend(Hop parent, Hop hi, int pos) {
        BinaryOp bop;
        if (HopRewriteUtils.isTransposeOperation(hi) && hi.getInput().get(0) instanceof BinaryOp && (((BinaryOp)hi.getInput().get(0)).getOp() == Hop.OpOp2.CBIND || ((BinaryOp)hi.getInput().get(0)).getOp() == Hop.OpOp2.RBIND) && hi.getInput().get(0).getParent().size() == 1 && HopRewriteUtils.isTransposeOperation((bop = (BinaryOp)hi.getInput().get(0)).getInput().get(0), 1) && HopRewriteUtils.isTransposeOperation(bop.getInput().get(1), 1)) {
            Hop left = bop.getInput().get(0).getInput().get(0);
            Hop right = bop.getInput().get(1).getInput().get(0);
            Hop.OpOp2 binop = bop.getOp() == Hop.OpOp2.CBIND ? Hop.OpOp2.RBIND : Hop.OpOp2.CBIND;
            BinaryOp bopnew = HopRewriteUtils.createBinary(left, right, binop);
            HopRewriteUtils.replaceChildReference(parent, hi, bopnew, pos);
            hi = bopnew;
            LOG.debug((Object)("Applied simplifyTransposedAppend (line " + hi.getBeginLine() + ")."));
        }
        return hi;
    }

    private Hop fuseBinarySubDAGToUnaryOperation(Hop parent, Hop hi, int pos) throws HopsException {
        if (hi instanceof BinaryOp) {
            UnaryOp unary;
            Hop right2;
            Hop right1;
            BinaryOp bright;
            UnaryOp unary2;
            Hop left2;
            Hop left1;
            BinaryOp bleft;
            BinaryOp bop = (BinaryOp)hi;
            Hop left = hi.getInput().get(0);
            Hop right = hi.getInput().get(1);
            boolean applied = false;
            if (bop.getOp() == Hop.OpOp2.MULT && left.getDataType() == Expression.DataType.MATRIX && right.getDataType() == Expression.DataType.MATRIX) {
                if (left instanceof BinaryOp) {
                    bleft = (BinaryOp)left;
                    left1 = bleft.getInput().get(0);
                    left2 = bleft.getInput().get(1);
                    if (left1 instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)left1) == 1.0 && left2 == right && bleft.getOp() == Hop.OpOp2.MINUS) {
                        unary2 = HopRewriteUtils.createUnary(right, Hop.OpOp1.SPROP);
                        HopRewriteUtils.replaceChildReference(parent, bop, unary2, pos);
                        HopRewriteUtils.cleanupUnreferenced(bop, left);
                        hi = unary2;
                        applied = true;
                        LOG.debug((Object)"Applied fuseBinarySubDAGToUnaryOperation-sprop1");
                    }
                }
                if (!applied && right instanceof BinaryOp) {
                    bright = (BinaryOp)right;
                    right1 = bright.getInput().get(0);
                    right2 = bright.getInput().get(1);
                    if (right1 instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)right1) == 1.0 && right2 == left && bright.getOp() == Hop.OpOp2.MINUS) {
                        unary2 = HopRewriteUtils.createUnary(left, Hop.OpOp1.SPROP);
                        HopRewriteUtils.replaceChildReference(parent, bop, unary2, pos);
                        HopRewriteUtils.cleanupUnreferenced(bop, left);
                        hi = unary2;
                        applied = true;
                        LOG.debug((Object)"Applied fuseBinarySubDAGToUnaryOperation-sprop2");
                    }
                }
            }
            if (!applied && bop.getOp() == Hop.OpOp2.DIV && left.getDataType() == Expression.DataType.SCALAR && right.getDataType() == Expression.DataType.MATRIX && left instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)left) == 1.0 && right instanceof BinaryOp) {
                BinaryOp bop2 = (BinaryOp)right;
                Hop left22 = bop2.getInput().get(0);
                right2 = bop2.getInput().get(1);
                if (bop2.getOp() == Hop.OpOp2.PLUS && left22.getDataType() == Expression.DataType.SCALAR && right2.getDataType() == Expression.DataType.MATRIX && left22 instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)left22) == 1.0 && right2 instanceof UnaryOp) {
                    UnaryOp uop = (UnaryOp)right2;
                    Hop uopin = uop.getInput().get(0);
                    if (uop.getOp() == Hop.OpOp1.EXP) {
                        UnaryOp unary3 = null;
                        if (HopRewriteUtils.isBinary(uopin, Hop.OpOp2.MINUS)) {
                            BinaryOp bop3 = (BinaryOp)uopin;
                            Hop left3 = bop3.getInput().get(0);
                            Hop right3 = bop3.getInput().get(1);
                            if (left3 instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)left3) == 0.0) {
                                unary3 = HopRewriteUtils.createUnary(right3, Hop.OpOp1.SIGMOID);
                            }
                        } else {
                            BinaryOp minus = HopRewriteUtils.createBinaryMinus(uopin);
                            unary3 = HopRewriteUtils.createUnary(minus, Hop.OpOp1.SIGMOID);
                        }
                        if (unary3 != null) {
                            HopRewriteUtils.replaceChildReference(parent, bop, unary3, pos);
                            HopRewriteUtils.cleanupUnreferenced(bop, bop2, uop);
                            hi = unary3;
                            applied = true;
                            LOG.debug((Object)"Applied fuseBinarySubDAGToUnaryOperation-sigmoid1");
                        }
                    }
                }
            }
            if (!applied && bop.getOp() == Hop.OpOp2.MULT && left.getDataType() == Expression.DataType.MATRIX && right.getDataType() == Expression.DataType.MATRIX) {
                if (left instanceof BinaryOp) {
                    bleft = (BinaryOp)left;
                    left1 = bleft.getInput().get(0);
                    left2 = bleft.getInput().get(1);
                    if (left2 instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)left2) == 0.0 && left1 == right && bleft.getOp() == Hop.OpOp2.GREATER) {
                        unary2 = HopRewriteUtils.createUnary(right, Hop.OpOp1.SELP);
                        HopRewriteUtils.replaceChildReference(parent, bop, unary2, pos);
                        HopRewriteUtils.cleanupUnreferenced(bop, left);
                        hi = unary2;
                        applied = true;
                        LOG.debug((Object)"Applied fuseBinarySubDAGToUnaryOperation-selp1");
                    }
                }
                if (!applied && right instanceof BinaryOp) {
                    bright = (BinaryOp)right;
                    right1 = bright.getInput().get(0);
                    right2 = bright.getInput().get(1);
                    if (right2 instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)right2) == 0.0 && right1 == left && bright.getOp() == Hop.OpOp2.GREATER) {
                        unary2 = HopRewriteUtils.createUnary(left, Hop.OpOp1.SELP);
                        HopRewriteUtils.replaceChildReference(parent, bop, unary2, pos);
                        HopRewriteUtils.cleanupUnreferenced(bop, left);
                        hi = unary2;
                        applied = true;
                        LOG.debug((Object)"Applied fuseBinarySubDAGToUnaryOperation-selp2");
                    }
                }
            }
            if (!applied && bop.getOp() == Hop.OpOp2.MAX && left.getDataType() == Expression.DataType.MATRIX && right instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)right) == 0.0) {
                unary = HopRewriteUtils.createUnary(left, Hop.OpOp1.SELP);
                HopRewriteUtils.replaceChildReference(parent, bop, unary, pos);
                HopRewriteUtils.cleanupUnreferenced(bop);
                hi = unary;
                applied = true;
                LOG.debug((Object)"Applied fuseBinarySubDAGToUnaryOperation-selp3");
            }
            if (!applied && bop.getOp() == Hop.OpOp2.MAX && right.getDataType() == Expression.DataType.MATRIX && left instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)left) == 0.0) {
                unary = HopRewriteUtils.createUnary(right, Hop.OpOp1.SELP);
                HopRewriteUtils.replaceChildReference(parent, bop, unary, pos);
                HopRewriteUtils.cleanupUnreferenced(bop);
                hi = unary;
                applied = true;
                LOG.debug((Object)"Applied fuseBinarySubDAGToUnaryOperation-selp4");
            }
        }
        return hi;
    }

    private Hop simplifyTraceMatrixMult(Hop parent, Hop hi, int pos) {
        Hop hi2;
        if (hi instanceof AggUnaryOp && ((AggUnaryOp)hi).getOp() == Hop.AggOp.TRACE && HopRewriteUtils.isMatrixMultiply(hi2 = hi.getInput().get(0))) {
            Hop left = hi2.getInput().get(0);
            Hop right = hi2.getInput().get(1);
            ReorgOp trans = HopRewriteUtils.createTranspose(right);
            BinaryOp mult = HopRewriteUtils.createBinary(left, trans, Hop.OpOp2.MULT);
            AggUnaryOp sum = HopRewriteUtils.createSum(mult);
            HopRewriteUtils.replaceChildReference(parent, hi, sum, pos);
            HopRewriteUtils.cleanupUnreferenced(hi, hi2);
            hi = sum;
            LOG.debug((Object)"Applied simplifyTraceMatrixMult");
        }
        return hi;
    }

    private Hop simplifySlicedMatrixMult(Hop parent, Hop hi, int pos) throws HopsException {
        if (hi instanceof IndexingOp && ((IndexingOp)hi).isRowLowerEqualsUpper() && ((IndexingOp)hi).isColLowerEqualsUpper() && hi.getInput().get(0).getParent().size() == 1 && HopRewriteUtils.isMatrixMultiply(hi.getInput().get(0))) {
            Hop mm = hi.getInput().get(0);
            Hop X = mm.getInput().get(0);
            Hop Y = mm.getInput().get(1);
            Hop rowExpr = hi.getInput().get(1);
            Hop colExpr = hi.getInput().get(3);
            HopRewriteUtils.removeAllChildReferences(mm);
            IndexingOp ix1 = new IndexingOp("tmp1", Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, X, rowExpr, rowExpr, new LiteralOp(1L), HopRewriteUtils.createValueHop(X, false), true, false);
            ix1.setOutputBlocksizes(X.getRowsInBlock(), X.getColsInBlock());
            ix1.refreshSizeInformation();
            IndexingOp ix2 = new IndexingOp("tmp2", Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, Y, new LiteralOp(1L), HopRewriteUtils.createValueHop(Y, true), colExpr, colExpr, false, true);
            ix2.setOutputBlocksizes(Y.getRowsInBlock(), Y.getColsInBlock());
            ix2.refreshSizeInformation();
            HopRewriteUtils.addChildReference(mm, ix1, 0);
            HopRewriteUtils.addChildReference(mm, ix2, 1);
            mm.refreshSizeInformation();
            hi = mm;
            LOG.debug((Object)"Applied simplifySlicedMatrixMult");
        }
        return hi;
    }

    private Hop simplifyConstantSort(Hop parent, Hop hi, int pos) throws HopsException {
        Hop hi2;
        if (hi instanceof ReorgOp && ((ReorgOp)hi).getOp() == Hop.ReOrgOp.SORT && (hi2 = hi.getInput().get(0)) instanceof DataGenOp && ((DataGenOp)hi2).getOp() == Hop.DataGenMethod.RAND && ((DataGenOp)hi2).hasConstantValue() && hi.getInput().get(3) instanceof LiteralOp) {
            if (HopRewriteUtils.getBooleanValue((LiteralOp)hi.getInput().get(3))) {
                DataGenOp seq = HopRewriteUtils.createSeqDataGenOp(hi2);
                ((Hop)seq).refreshSizeInformation();
                HopRewriteUtils.replaceChildReference(parent, hi, seq, pos);
                HopRewriteUtils.cleanupUnreferenced(hi);
                hi = seq;
                LOG.debug((Object)"Applied simplifyConstantSort1.");
            } else {
                HopRewriteUtils.replaceChildReference(parent, hi, hi2, pos);
                HopRewriteUtils.cleanupUnreferenced(hi);
                hi = hi2;
                LOG.debug((Object)"Applied simplifyConstantSort2.");
            }
        }
        return hi;
    }

    private Hop simplifyOrderedSort(Hop parent, Hop hi, int pos) throws HopsException {
        Hop incr;
        Hop hi2;
        if (hi instanceof ReorgOp && ((ReorgOp)hi).getOp() == Hop.ReOrgOp.SORT && (hi2 = hi.getInput().get(0)) instanceof DataGenOp && ((DataGenOp)hi2).getOp() == Hop.DataGenMethod.SEQ && (incr = hi2.getInput().get(((DataGenOp)hi2).getParamIndex("incr"))) instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)incr) == 1.0 && hi.getInput().get(2) instanceof LiteralOp && hi.getInput().get(3) instanceof LiteralOp) {
            if (HopRewriteUtils.getBooleanValue((LiteralOp)hi.getInput().get(3))) {
                boolean desc = HopRewriteUtils.getBooleanValue((LiteralOp)hi.getInput().get(2));
                DataGenOp seq = HopRewriteUtils.createSeqDataGenOp(hi2, !desc);
                ((Hop)seq).refreshSizeInformation();
                HopRewriteUtils.replaceChildReference(parent, hi, seq, pos);
                HopRewriteUtils.cleanupUnreferenced(hi);
                hi = seq;
                LOG.debug((Object)"Applied simplifyOrderedSort1.");
            } else if (!HopRewriteUtils.getBooleanValue((LiteralOp)hi.getInput().get(2))) {
                HopRewriteUtils.replaceChildReference(parent, hi, hi2, pos);
                HopRewriteUtils.cleanupUnreferenced(hi);
                hi = hi2;
                LOG.debug((Object)"Applied simplifyOrderedSort2.");
            }
        }
        return hi;
    }

    private Hop simplifyTransposeAggBinBinaryChains(Hop parent, Hop hi, int pos) throws HopsException {
        if (HopRewriteUtils.isTransposeOperation(hi) && hi.getInput().get(0) instanceof BinaryOp && ((BinaryOp)hi.getInput().get(0)).supportsMatrixScalarOperations()) {
            Hop left = hi.getInput().get(0).getInput().get(0);
            Hop C = hi.getInput().get(0).getInput().get(1);
            if (left instanceof AggBinaryOp && C.getDataType().isMatrix() && HopRewriteUtils.isTransposeOperation(left.getInput().get(0)) && left.getInput().get(0).getParent().size() == 1 && HopRewriteUtils.isTransposeOperation(left.getInput().get(1)) && left.getInput().get(1).getParent().size() == 1) {
                Hop A = left.getInput().get(0).getInput().get(0);
                Hop B = left.getInput().get(1).getInput().get(0);
                AggBinaryOp abop = HopRewriteUtils.createMatrixMultiply(B, A);
                ReorgOp rop = HopRewriteUtils.createTranspose(C);
                BinaryOp bop = HopRewriteUtils.createBinary(abop, rop, Hop.OpOp2.PLUS);
                HopRewriteUtils.replaceChildReference(parent, hi, bop, pos);
                hi = bop;
                LOG.debug((Object)("Applied simplifyTransposeAggBinBinaryChains (line " + hi.getBeginLine() + ")."));
            }
        }
        return hi;
    }

    private Hop removeUnnecessaryReorgOperation(Hop parent, Hop hi, int pos) {
        Hop.ReOrgOp[] lookup = new Hop.ReOrgOp[]{Hop.ReOrgOp.TRANSPOSE, Hop.ReOrgOp.REV};
        if (hi instanceof ReorgOp && HopRewriteUtils.isValidOp(((ReorgOp)hi).getOp(), lookup)) {
            Hop.ReOrgOp firstOp = ((ReorgOp)hi).getOp();
            Hop hi2 = hi.getInput().get(0);
            if (hi2 instanceof ReorgOp && ((ReorgOp)hi2).getOp() == firstOp) {
                Hop hi3 = hi2.getInput().get(0);
                HopRewriteUtils.replaceChildReference(parent, hi, hi3, pos);
                HopRewriteUtils.cleanupUnreferenced(hi, hi2);
                hi = hi3;
                LOG.debug((Object)"Applied removeUnecessaryReorgOperation.");
            }
        }
        return hi;
    }

    private Hop removeUnnecessaryMinus(Hop parent, Hop hi, int pos) throws HopsException {
        Hop hi2;
        if (hi.getDataType() == Expression.DataType.MATRIX && hi instanceof BinaryOp && ((BinaryOp)hi).getOp() == Hop.OpOp2.MINUS && hi.getInput().get(0) instanceof LiteralOp && ((LiteralOp)hi.getInput().get(0)).getDoubleValue() == 0.0 && (hi2 = hi.getInput().get(1)).getDataType() == Expression.DataType.MATRIX && hi2 instanceof BinaryOp && ((BinaryOp)hi2).getOp() == Hop.OpOp2.MINUS && hi2.getInput().get(0) instanceof LiteralOp && ((LiteralOp)hi2.getInput().get(0)).getDoubleValue() == 0.0) {
            Hop hi3 = hi2.getInput().get(1);
            HopRewriteUtils.replaceChildReference(parent, hi, hi3, pos);
            HopRewriteUtils.cleanupUnreferenced(hi, hi2);
            hi = hi3;
            LOG.debug((Object)"Applied removeUnecessaryMinus");
        }
        return hi;
    }

    private Hop simplifyGroupedAggregate(Hop hi) {
        int ix2;
        HashMap<String, Integer> params;
        int ix1;
        ParameterizedBuiltinOp phi;
        if (hi instanceof ParameterizedBuiltinOp && ((ParameterizedBuiltinOp)hi).getOp() == Hop.ParamBuiltinOp.GROUPEDAGG && (phi = (ParameterizedBuiltinOp)hi).isCountFunction() && phi.getTargetHop().getDim2() == 1L && (ix1 = (params = phi.getParamIndexMap()).get("target").intValue()) != (ix2 = params.get("groups").intValue()) && phi.getInput().get(ix1) != phi.getInput().get(ix2)) {
            Hop th = phi.getInput().get(ix1);
            Hop gh = phi.getInput().get(ix2);
            HopRewriteUtils.replaceChildReference(hi, th, gh, ix1);
            LOG.debug((Object)"Applied simplifyGroupedAggregateCount");
        }
        return hi;
    }

    private Hop fuseMinusNzBinaryOperation(Hop parent, Hop hi, int pos) throws HopsException {
        if (HopRewriteUtils.isBinary(hi, Hop.OpOp2.MINUS) && hi.getInput().get(0).getDataType() == Expression.DataType.MATRIX && hi.getInput().get(1).getDataType() == Expression.DataType.MATRIX && HopRewriteUtils.isBinary(hi.getInput().get(1), Hop.OpOp2.MULT)) {
            Hop X = hi.getInput().get(0);
            Hop s = hi.getInput().get(1).getInput().get(0);
            Hop pred = hi.getInput().get(1).getInput().get(1);
            if (s.getDataType() == Expression.DataType.SCALAR && pred.getDataType() == Expression.DataType.MATRIX && HopRewriteUtils.isBinary(pred, Hop.OpOp2.NOTEQUAL) && pred.getInput().get(0) == X && pred.getInput().get(1) instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)pred.getInput().get(1)) == 0.0) {
                BinaryOp hnew = HopRewriteUtils.createBinary(X, s, Hop.OpOp2.MINUS_NZ);
                HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
                hi = hnew;
                LOG.debug((Object)("Applied fuseMinusNzBinaryOperation (line " + hi.getBeginLine() + ")"));
            }
        }
        return hi;
    }

    private Hop fuseLogNzUnaryOperation(Hop parent, Hop hi, int pos) throws HopsException {
        if (HopRewriteUtils.isBinary(hi, Hop.OpOp2.MULT) && hi.getInput().get(0).getDataType() == Expression.DataType.MATRIX && hi.getInput().get(1).getDataType() == Expression.DataType.MATRIX && HopRewriteUtils.isUnary(hi.getInput().get(1), Hop.OpOp1.LOG)) {
            Hop pred = hi.getInput().get(0);
            Hop X = hi.getInput().get(1).getInput().get(0);
            if (HopRewriteUtils.isBinary(pred, Hop.OpOp2.NOTEQUAL) && pred.getInput().get(0) == X && pred.getInput().get(1) instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)pred.getInput().get(1)) == 0.0) {
                UnaryOp hnew = HopRewriteUtils.createUnary(X, Hop.OpOp1.LOG_NZ);
                HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
                hi = hnew;
                LOG.debug((Object)("Applied fuseLogNzUnaryOperation (line " + hi.getBeginLine() + ")."));
            }
        }
        return hi;
    }

    private Hop fuseLogNzBinaryOperation(Hop parent, Hop hi, int pos) throws HopsException {
        if (HopRewriteUtils.isBinary(hi, Hop.OpOp2.MULT) && hi.getInput().get(0).getDataType() == Expression.DataType.MATRIX && hi.getInput().get(1).getDataType() == Expression.DataType.MATRIX && HopRewriteUtils.isBinary(hi.getInput().get(1), Hop.OpOp2.LOG)) {
            Hop pred = hi.getInput().get(0);
            Hop X = hi.getInput().get(1).getInput().get(0);
            Hop log = hi.getInput().get(1).getInput().get(1);
            if (HopRewriteUtils.isBinary(pred, Hop.OpOp2.NOTEQUAL) && pred.getInput().get(0) == X && pred.getInput().get(1) instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)pred.getInput().get(1)) == 0.0) {
                BinaryOp hnew = HopRewriteUtils.createBinary(X, log, Hop.OpOp2.LOG_NZ);
                HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
                hi = hnew;
                LOG.debug((Object)("Applied fuseLogNzBinaryOperation (line " + hi.getBeginLine() + ")"));
            }
        }
        return hi;
    }

    private Hop simplifyOuterSeqExpand(Hop parent, Hop hi, int pos) throws HopsException {
        if (HopRewriteUtils.isBinary(hi, Hop.OpOp2.EQUAL) && ((BinaryOp)hi).isOuterVectorOperator() && (HopRewriteUtils.isTransposeOperation(hi.getInput().get(1)) && HopRewriteUtils.isBasic1NSequence(hi.getInput().get(1).getInput().get(0)) || HopRewriteUtils.isBasic1NSequence(hi.getInput().get(0)))) {
            boolean isPatternB = HopRewriteUtils.isBasic1NSequence(hi.getInput().get(0));
            boolean isTransposeRight = HopRewriteUtils.isTransposeOperation(hi.getInput().get(1));
            Hop trgt = isPatternB ? (isTransposeRight ? hi.getInput().get(1).getInput().get(0) : HopRewriteUtils.createTranspose(hi.getInput().get(1))) : hi.getInput().get(0);
            Hop seq = isPatternB ? hi.getInput().get(0) : hi.getInput().get(1).getInput().get(0);
            String direction = HopRewriteUtils.isBasic1NSequence(hi.getInput().get(0)) ? "rows" : "cols";
            HashMap<String, Hop> inputargs = new HashMap<String, Hop>();
            inputargs.put("target", trgt);
            inputargs.put("max", HopRewriteUtils.getBasic1NSequenceMaxLiteral(seq));
            inputargs.put("dir", new LiteralOp(direction));
            inputargs.put("ignore", new LiteralOp(true));
            inputargs.put("cast", new LiteralOp(false));
            ParameterizedBuiltinOp pbop = new ParameterizedBuiltinOp("tmp", Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, Hop.ParamBuiltinOp.REXPAND, inputargs);
            pbop.setOutputBlocksizes(hi.getRowsInBlock(), hi.getColsInBlock());
            pbop.refreshSizeInformation();
            HopRewriteUtils.replaceChildReference(parent, hi, pbop, pos);
            hi = pbop;
            LOG.debug((Object)("Applied simplifyOuterSeqExpand (line " + hi.getBeginLine() + ")"));
        }
        return hi;
    }

    private Hop removeUnecessaryPPred(Hop parent, Hop hi, int pos) throws HopsException {
        if (hi instanceof BinaryOp) {
            BinaryOp bop = (BinaryOp)hi;
            Hop left = bop.getInput().get(0);
            Hop right = bop.getInput().get(1);
            Hop datagen = null;
            if (left == right && bop.getOp() == Hop.OpOp2.EQUAL || bop.getOp() == Hop.OpOp2.GREATEREQUAL || bop.getOp() == Hop.OpOp2.LESSEQUAL) {
                datagen = HopRewriteUtils.createDataGenOp(left, 1.0);
            }
            if (left == right && bop.getOp() == Hop.OpOp2.NOTEQUAL || bop.getOp() == Hop.OpOp2.GREATER || bop.getOp() == Hop.OpOp2.LESS) {
                datagen = HopRewriteUtils.createDataGenOp(left, 0.0);
            }
            if (datagen != null) {
                HopRewriteUtils.replaceChildReference(parent, hi, datagen, pos);
                hi = datagen;
            }
        }
        return hi;
    }
}

