/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.ipa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import org.apache.sysml.hops.FunctionOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.ForStatement;
import org.apache.sysml.parser.ForStatementBlock;
import org.apache.sysml.parser.FunctionStatement;
import org.apache.sysml.parser.FunctionStatementBlock;
import org.apache.sysml.parser.IfStatement;
import org.apache.sysml.parser.IfStatementBlock;
import org.apache.sysml.parser.StatementBlock;
import org.apache.sysml.parser.WhileStatement;
import org.apache.sysml.parser.WhileStatementBlock;

public class FunctionCallGraph {
    private static final String MAIN_FUNCTION_KEY = "_main";
    private final HashMap<String, HashSet<String>> _fGraph = new HashMap();
    private final HashSet<String> _fRecursive = new HashSet();

    public FunctionCallGraph(DMLProgram prog) {
        this.constructFunctionCallGraph(prog);
    }

    public Collection<String> getCalledFunctions(String fnamespace, String fname) {
        return this.getCalledFunctions(DMLProgram.constructFunctionKey(fnamespace, fname));
    }

    public Collection<String> getCalledFunctions(String fkey) {
        String lfkey = fkey == null ? MAIN_FUNCTION_KEY : fkey;
        return this._fGraph.get(lfkey);
    }

    public boolean isRecursiveFunction(String fnamespace, String fname) {
        return this.isRecursiveFunction(DMLProgram.constructFunctionKey(fnamespace, fname));
    }

    public boolean isRecursiveFunction(String fkey) {
        String lfkey = fkey == null ? MAIN_FUNCTION_KEY : fkey;
        return this._fRecursive.contains(lfkey);
    }

    public Collection<String> getReachableFunctions(Collection<String> blacklist) {
        HashSet<String> ret = new HashSet<String>();
        for (String tmp : this._fGraph.keySet()) {
            if (blacklist.contains(tmp) || MAIN_FUNCTION_KEY.equals(tmp)) continue;
            ret.add(tmp);
        }
        return ret;
    }

    public boolean isReachableFunction(String fnamespace, String fname) {
        return this.isReachableFunction(DMLProgram.constructFunctionKey(fnamespace, fname));
    }

    public boolean isReachableFunction(String fkey) {
        String lfkey = fkey == null ? MAIN_FUNCTION_KEY : fkey;
        return this._fGraph.containsKey(lfkey);
    }

    private void constructFunctionCallGraph(DMLProgram prog) {
        if (!prog.hasFunctionStatementBlocks()) {
            return;
        }
        try {
            Stack<String> fstack = new Stack<String>();
            HashSet<String> lfset = new HashSet<String>();
            this._fGraph.put(MAIN_FUNCTION_KEY, new HashSet());
            for (StatementBlock sblk : prog.getStatementBlocks()) {
                this.rConstructFunctionCallGraph(MAIN_FUNCTION_KEY, sblk, fstack, lfset);
            }
        }
        catch (HopsException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void rConstructFunctionCallGraph(String fkey, StatementBlock sb, Stack<String> fstack, HashSet<String> lfset) throws HopsException {
        if (sb instanceof WhileStatementBlock) {
            WhileStatement ws = (WhileStatement)sb.getStatement(0);
            for (StatementBlock current : ws.getBody()) {
                this.rConstructFunctionCallGraph(fkey, current, fstack, lfset);
            }
        } else if (sb instanceof IfStatementBlock) {
            IfStatement ifs = (IfStatement)sb.getStatement(0);
            for (StatementBlock current : ifs.getIfBody()) {
                this.rConstructFunctionCallGraph(fkey, current, fstack, lfset);
            }
            for (StatementBlock current : ifs.getElseBody()) {
                this.rConstructFunctionCallGraph(fkey, current, fstack, lfset);
            }
        } else if (sb instanceof ForStatementBlock) {
            ForStatement fs = (ForStatement)sb.getStatement(0);
            for (StatementBlock current : fs.getBody()) {
                this.rConstructFunctionCallGraph(fkey, current, fstack, lfset);
            }
        } else if (sb instanceof FunctionStatementBlock) {
            FunctionStatement fsb = (FunctionStatement)sb.getStatement(0);
            for (StatementBlock current : fsb.getBody()) {
                this.rConstructFunctionCallGraph(fkey, current, fstack, lfset);
            }
        } else {
            ArrayList<Hop> hopsDAG = sb.get_hops();
            if (hopsDAG == null || hopsDAG.isEmpty()) {
                return;
            }
            for (Hop h : hopsDAG) {
                FunctionOp fop;
                String lfkey;
                if (!(h instanceof FunctionOp) || lfset.contains(lfkey = DMLProgram.constructFunctionKey((fop = (FunctionOp)h).getFunctionNamespace(), fop.getFunctionName())) || fop.getFunctionNamespace().equals(DMLProgram.INTERNAL_NAMESPACE)) continue;
                if (!this._fGraph.containsKey(lfkey)) {
                    this._fGraph.put(lfkey, new HashSet());
                }
                if (!fstack.contains(lfkey)) {
                    fstack.push(lfkey);
                    this._fGraph.get(fkey).add(lfkey);
                    FunctionStatementBlock fsb = sb.getDMLProg().getFunctionStatementBlock(fop.getFunctionNamespace(), fop.getFunctionName());
                    FunctionStatement fs = (FunctionStatement)fsb.getStatement(0);
                    for (StatementBlock csb : fs.getBody()) {
                        this.rConstructFunctionCallGraph(lfkey, csb, fstack, new HashSet<String>());
                    }
                    fstack.pop();
                } else {
                    this._fGraph.get(fkey).add(lfkey);
                    this._fRecursive.add(lfkey);
                    int ix = fstack.indexOf(lfkey);
                    for (int i = ix + 1; i < fstack.size(); ++i) {
                        this._fRecursive.add((String)fstack.get(i));
                    }
                }
                lfset.add(lfkey);
            }
        }
    }
}

