/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.codegen.cplan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.sysml.hops.codegen.SpoofFusedOp;
import org.apache.sysml.hops.codegen.cplan.CNode;
import org.apache.sysml.hops.codegen.cplan.CNodeData;
import org.apache.sysml.hops.codegen.cplan.CNodeUnary;
import org.apache.sysml.hops.codegen.template.TemplateUtils;
import org.apache.sysml.parser.Expression;

public abstract class CNodeTpl
extends CNode
implements Cloneable {
    public CNodeTpl(ArrayList<CNode> inputs, CNode output) {
        if (inputs.size() < 1) {
            throw new RuntimeException("Cannot pass empty inputs to the CNodeTpl");
        }
        for (CNode input : inputs) {
            this.addInput(input);
        }
        this._output = output;
    }

    public void addInput(CNode in) {
        if (this.containsInput(in) || in.isLiteral()) {
            return;
        }
        this._inputs.add(in);
    }

    public void cleanupInputs(HashSet<Long> filter) {
        ArrayList<CNode> tmp = new ArrayList<CNode>();
        for (CNode in : this._inputs) {
            if (!(in instanceof CNodeData) || !filter.contains(((CNodeData)in).getHopID())) continue;
            tmp.add(in);
        }
        this._inputs = tmp;
    }

    public String[] getInputNames() {
        String[] ret = new String[this._inputs.size()];
        for (int i = 0; i < this._inputs.size(); ++i) {
            ret[i] = ((CNode)this._inputs.get(i)).getVarname();
        }
        return ret;
    }

    public void resetVisitStatusOutputs() {
        this.getOutput().resetVisitStatus();
    }

    public String codegen() {
        return this.codegen(false);
    }

    public abstract CNodeTpl clone();

    public abstract SpoofFusedOp.SpoofOutputDimsType getOutputDimType();

    public abstract String getTemplateInfo();

    protected void renameInputs(ArrayList<CNode> inputs, int startIndex) {
        this.renameInputs(Collections.singletonList(this._output), inputs, startIndex);
    }

    protected void renameInputs(List<CNode> outputs, ArrayList<CNode> inputs, int startIndex) {
        HashMap<Long, CNode> nodes = new HashMap<Long, CNode>();
        int sPos = 0;
        int mPos = 0;
        for (int i = startIndex; i < inputs.size(); ++i) {
            CNode cnode = inputs.get(i);
            if (cnode instanceof CNodeData && ((CNodeData)cnode).isLiteral()) continue;
            CNodeData cdata = (CNodeData)cnode;
            if (cdata.getDataType() == Expression.DataType.SCALAR || cdata.getNumCols() == 0L && cdata.getNumRows() == 0L) {
                nodes.put(cdata.getHopID(), new CNodeData(cdata, "scalars[" + mPos++ + "]"));
                continue;
            }
            nodes.put(cdata.getHopID(), new CNodeData(cdata, "b[" + sPos++ + "]"));
        }
        for (CNode output : outputs) {
            this.rReplaceDataNode(output, nodes, new HashMap<Long, CNode>());
        }
    }

    protected void rReplaceDataNode(CNode root, CNode input, String newName) {
        if (!(input instanceof CNodeData)) {
            return;
        }
        HashMap<Long, CNode> names = new HashMap<Long, CNode>();
        CNodeData tmp = (CNodeData)input;
        names.put(tmp.getHopID(), new CNodeData(tmp, newName));
        this.rReplaceDataNode(root, names, new HashMap<Long, CNode>());
    }

    protected void rReplaceDataNode(ArrayList<CNode> roots, CNode input, String newName) {
        if (!(input instanceof CNodeData)) {
            return;
        }
        HashMap<Long, CNode> names = new HashMap<Long, CNode>();
        CNodeData tmp = (CNodeData)input;
        names.put(tmp.getHopID(), new CNodeData(tmp, newName));
        for (CNode root : roots) {
            this.rReplaceDataNode(root, names, new HashMap<Long, CNode>());
        }
    }

    protected void rReplaceDataNode(CNode node, HashMap<Long, CNode> dnodes, HashMap<Long, CNode> lnodes) {
        for (int i = 0; i < node._inputs.size(); ++i) {
            CNodeData tmp;
            this.rReplaceDataNode(node._inputs.get(i), dnodes, lnodes);
            if (node._inputs.get(i) instanceof CNodeData && dnodes.containsKey((tmp = (CNodeData)node._inputs.get(i)).getHopID())) {
                node._inputs.set(i, dnodes.get(tmp.getHopID()));
            }
            if (!(node._inputs.get(i) instanceof CNodeUnary) || !(node._inputs.get((int)i)._inputs.get(0) instanceof CNodeData) || ((CNodeUnary)node._inputs.get(i)).getType() != CNodeUnary.UnaryType.LOOKUP_R && ((CNodeUnary)node._inputs.get(i)).getType() != CNodeUnary.UnaryType.LOOKUP_RC) continue;
            tmp = (CNodeData)node._inputs.get((int)i)._inputs.get(0);
            if (!lnodes.containsKey(tmp.getHopID())) {
                lnodes.put(tmp.getHopID(), node._inputs.get(i));
                continue;
            }
            node._inputs.set(i, lnodes.get(tmp.getHopID()));
        }
    }

    public void rReplaceDataNode(CNode node, long hopID, CNode newNode) {
        for (int i = 0; i < node._inputs.size(); ++i) {
            CNodeData tmp;
            if (node._inputs.get(i) instanceof CNodeData && (tmp = (CNodeData)node._inputs.get(i)).getHopID() == hopID) {
                node._inputs.set(i, newNode);
            }
            this.rReplaceDataNode(node._inputs.get(i), hopID, newNode);
            if (!(node._inputs.get(i) instanceof CNodeUnary) || ((CNodeUnary)node._inputs.get(i)).getType() != CNodeUnary.UnaryType.LOOKUP_R && ((CNodeUnary)node._inputs.get(i)).getType() != CNodeUnary.UnaryType.LOOKUP_RC || node._inputs.get((int)i)._inputs.get(0).getDataType() != Expression.DataType.SCALAR) continue;
            node._inputs.set(i, node._inputs.get((int)i)._inputs.get(0));
        }
    }

    public void rInsertLookupNode(CNode node, long hopID, HashMap<Long, CNode> memo, CNodeUnary.UnaryType lookupType) {
        for (int i = 0; i < node._inputs.size(); ++i) {
            CNodeData tmp;
            this.rInsertLookupNode(node._inputs.get(i), hopID, memo, lookupType);
            if (!(node._inputs.get(i) instanceof CNodeData) || (tmp = (CNodeData)node._inputs.get(i)).getHopID() != hopID) continue;
            CNode lookup = memo.get(hopID);
            if (lookup == null && !TemplateUtils.isLookup(node)) {
                lookup = new CNodeUnary(tmp, lookupType);
                memo.put(hopID, lookup);
                continue;
            }
            if (TemplateUtils.isLookup(node)) {
                ((CNodeUnary)node).setType(lookupType);
                continue;
            }
            node._inputs.set(i, lookup);
        }
    }

    private boolean containsInput(CNode input) {
        if (!(input instanceof CNodeData)) {
            return false;
        }
        CNodeData input2 = (CNodeData)input;
        for (CNode cnode : this._inputs) {
            if (!(cnode instanceof CNodeData)) continue;
            CNodeData cnode2 = (CNodeData)cnode;
            if (!cnode2._name.equals(input2._name) || cnode2._hopID != input2._hopID) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof CNodeTpl && super.equals(o);
    }

    protected static boolean equalInputReferences(CNode current1, CNode current2, ArrayList<CNode> input1, ArrayList<CNode> input2) {
        boolean ret = current1.getInput().size() == current2.getInput().size();
        for (int i = 0; ret && i < current1.getInput().size(); ret &= CNodeTpl.equalInputReferences(current1.getInput().get(i), current2.getInput().get(i), input1, input2), ++i) {
        }
        if (ret && current1 instanceof CNodeData) {
            ret &= current2 instanceof CNodeData && CNodeTpl.indexOf(input1, (CNodeData)current1) == CNodeTpl.indexOf(input2, (CNodeData)current2);
        }
        return ret;
    }

    protected static boolean equalInputReferences(ArrayList<CNode> current1, ArrayList<CNode> current2, ArrayList<CNode> input1, ArrayList<CNode> input2) {
        boolean ret = current1.size() == current2.size();
        for (int i = 0; ret && i < current1.size(); ret &= CNodeTpl.equalInputReferences(current1.get(i), current2.get(i), input1, input2), ++i) {
        }
        return ret;
    }

    private static int indexOf(ArrayList<CNode> inputs, CNodeData probe) {
        for (int i = 0; i < inputs.size(); ++i) {
            CNodeData cd = (CNodeData)inputs.get(i);
            if (cd.getHopID() != probe.getHopID()) continue;
            return i;
        }
        return -1;
    }
}

