/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops;

import java.util.HashMap;
import java.util.Map;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.AggBinaryOp;
import org.apache.sysml.hops.AggUnaryOp;
import org.apache.sysml.hops.BinaryOp;
import org.apache.sysml.hops.DataGenOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.MemoTable;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.ReorgOp;
import org.apache.sysml.hops.TernaryOp;
import org.apache.sysml.hops.UnaryOp;
import org.apache.sysml.hops.rewrite.HopRewriteUtils;
import org.apache.sysml.lops.Aggregate;
import org.apache.sysml.lops.AppendR;
import org.apache.sysml.lops.Data;
import org.apache.sysml.lops.DataPartition;
import org.apache.sysml.lops.Group;
import org.apache.sysml.lops.GroupedAggregate;
import org.apache.sysml.lops.GroupedAggregateM;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.OutputParameters;
import org.apache.sysml.lops.PMMJ;
import org.apache.sysml.lops.ParameterizedBuiltin;
import org.apache.sysml.lops.PartialAggregate;
import org.apache.sysml.lops.RepMat;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.util.UtilFunctions;

public class ParameterizedBuiltinOp
extends Hop
implements Hop.MultiThreadedHop {
    private static boolean COMPILE_PARALLEL_REMOVEEMPTY = true;
    public static boolean FORCE_DIST_RM_EMPTY = false;
    private Hop.ParamBuiltinOp _op;
    private int _maxNumThreads = -1;
    private boolean _outputEmptyBlocks = true;
    private boolean _outputPermutationMatrix = false;
    private boolean _bRmEmptyBC = false;
    private HashMap<String, Integer> _paramIndexMap = new HashMap();

    private ParameterizedBuiltinOp() {
    }

    public ParameterizedBuiltinOp(String l, Expression.DataType dt, Expression.ValueType vt, Hop.ParamBuiltinOp op, HashMap<String, Hop> inputParameters) {
        super(l, dt, vt);
        this._op = op;
        int index = 0;
        for (Map.Entry<String, Hop> e : inputParameters.entrySet()) {
            String s = e.getKey();
            Hop input = e.getValue();
            this.getInput().add(input);
            input.getParent().add(this);
            this._paramIndexMap.put(s, index);
            ++index;
        }
        this.refreshSizeInformation();
    }

    public HashMap<String, Integer> getParamIndexMap() {
        return this._paramIndexMap;
    }

    public Hop getInputParameter(String val) {
        Integer index = this.getParamIndexMap().get(val);
        if (index == null) {
            return null;
        }
        return this.getInput().get(index);
    }

    @Override
    public String getOpString() {
        return "" + (Object)((Object)this._op);
    }

    public Hop.ParamBuiltinOp getOp() {
        return this._op;
    }

    @Override
    public void setOutputEmptyBlocks(boolean flag) {
        this._outputEmptyBlocks = flag;
    }

    public void setOutputPermutationMatrix(boolean flag) {
        this._outputPermutationMatrix = flag;
    }

    public Hop getTargetHop() {
        return this._paramIndexMap.containsKey("target") ? this.getInput().get(this._paramIndexMap.get("target")) : null;
    }

    public Hop getParameterHop(String name) {
        return this._paramIndexMap.containsKey(name) ? this.getInput().get(this._paramIndexMap.get(name)) : null;
    }

    @Override
    public void setMaxNumThreads(int k) {
        this._maxNumThreads = k;
    }

    @Override
    public int getMaxNumThreads() {
        return this._maxNumThreads;
    }

    @Override
    public Lop constructLops() throws HopsException, LopsException {
        if (this.getLops() != null) {
            return this.getLops();
        }
        HashMap<String, Lop> inputlops = new HashMap<String, Lop>();
        for (Map.Entry<String, Integer> cur : this._paramIndexMap.entrySet()) {
            inputlops.put(cur.getKey(), this.getInput().get(cur.getValue()).constructLops());
        }
        switch (this._op) {
            case GROUPEDAGG: {
                LopProperties.ExecType et = this.optFindExecType();
                this.constructLopsGroupedAggregate(inputlops, et);
                break;
            }
            case RMEMPTY: {
                LopProperties.ExecType et = this.optFindExecType();
                et = et == LopProperties.ExecType.MR && !COMPILE_PARALLEL_REMOVEEMPTY ? LopProperties.ExecType.CP_FILE : et;
                this.constructLopsRemoveEmpty(inputlops, et);
                break;
            }
            case REXPAND: {
                LopProperties.ExecType et = this.optFindExecType();
                this.constructLopsRExpand(inputlops, et);
                break;
            }
            case TRANSFORM: {
                LopProperties.ExecType et = this.optFindExecType();
                ParameterizedBuiltin pbilop = new ParameterizedBuiltin(inputlops, (ParameterizedBuiltin.OperationTypes)((Object)HopsParameterizedBuiltinLops.get((Object)this._op)), this.getDataType(), this.getValueType(), et);
                this.setOutputDimensions(pbilop);
                this.setLineNumbers(pbilop);
                pbilop.getOutputParameters().setFormat(OutputParameters.Format.CSV);
                this.setLops(pbilop);
                break;
            }
            case CDF: 
            case INVCDF: 
            case REPLACE: 
            case TRANSFORMAPPLY: 
            case TRANSFORMDECODE: 
            case TRANSFORMMETA: 
            case TOSTRING: {
                LopProperties.ExecType et = this.optFindExecType();
                ParameterizedBuiltin pbilop = new ParameterizedBuiltin(inputlops, (ParameterizedBuiltin.OperationTypes)((Object)HopsParameterizedBuiltinLops.get((Object)this._op)), this.getDataType(), this.getValueType(), et);
                this.setOutputDimensions(pbilop);
                this.setLineNumbers(pbilop);
                this.setLops(pbilop);
                break;
            }
            default: {
                throw new HopsException("Unknown ParamBuiltinOp: " + (Object)((Object)this._op));
            }
        }
        this.constructAndSetLopsDataFlowProperties();
        return this.getLops();
    }

    private void constructLopsGroupedAggregate(HashMap<String, Lop> inputlops, LopProperties.ExecType et) throws HopsException, LopsException {
        this.setRequiresReblock(false);
        long outputDim1 = -1L;
        long outputDim2 = -1L;
        Lop numGroups = inputlops.get("ngroups");
        if (!this.dimsKnown() && numGroups != null && numGroups instanceof Data && ((Data)numGroups).isLiteral()) {
            boolean rowwise;
            long ngroups = ((Data)numGroups).getLongValue();
            Lop input = inputlops.get("combinedinput");
            long inDim1 = input.getOutputParameters().getNumRows();
            long inDim2 = input.getOutputParameters().getNumCols();
            boolean bl = rowwise = inDim1 == 1L && inDim2 > 1L;
            if (rowwise) {
                outputDim1 = ngroups;
                outputDim2 = 1L;
            } else {
                outputDim1 = inDim2;
                outputDim2 = ngroups;
            }
        }
        if (et == LopProperties.ExecType.MR) {
            boolean isWeighted;
            Lop grp_agg = null;
            boolean bl = isWeighted = this._paramIndexMap.get("weights") != null;
            if (isWeighted) {
                Lop append = BinaryOp.constructAppendLopChain(this.getInput().get(this._paramIndexMap.get("target")), this.getInput().get(this._paramIndexMap.get("groups")), this.getInput().get(this._paramIndexMap.get("weights")), Expression.DataType.MATRIX, this.getValueType(), true, this.getInput().get(this._paramIndexMap.get("target")));
                inputlops.put("combinedinput", append);
                inputlops.remove("target");
                inputlops.remove("groups");
                inputlops.remove("weights");
                grp_agg = new GroupedAggregate(inputlops, isWeighted, this.getDataType(), this.getValueType());
                grp_agg.getOutputParameters().setDimensions(outputDim1, outputDim2, this.getRowsInBlock(), this.getColsInBlock(), -1L);
                this.setRequiresReblock(true);
            } else {
                Hop target = this.getInput().get(this._paramIndexMap.get("target"));
                Hop groups = this.getInput().get(this._paramIndexMap.get("groups"));
                Lop append = null;
                double groupsSizeP = OptimizerUtils.estimatePartitionedSizeExactSparsity(groups.getDim1(), groups.getDim2(), groups.getRowsInBlock(), groups.getColsInBlock(), groups.getNnz());
                if (groupsSizeP < OptimizerUtils.getRemoteMemBudgetMap(true) && this.getInput().get(this._paramIndexMap.get("fn")) instanceof LiteralOp && ((LiteralOp)this.getInput().get(this._paramIndexMap.get("fn"))).getStringValue().equals("sum") && inputlops.get("ngroups") != null) {
                    boolean needPart;
                    boolean bl2 = needPart = groups.dimsKnown() && groups.getDim1() * groups.getDim2() > 4000000L;
                    if (needPart) {
                        LopProperties.ExecType etPart = (double)OptimizerUtils.estimateSizeExactSparsity(groups.getDim1(), groups.getDim2(), 1.0) < OptimizerUtils.getLocalMemBudget() ? LopProperties.ExecType.CP : LopProperties.ExecType.MR;
                        DataPartition dcinput = new DataPartition(groups.constructLops(), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, etPart, ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE_N);
                        dcinput.getOutputParameters().setDimensions(groups.getDim1(), groups.getDim2(), target.getRowsInBlock(), target.getColsInBlock(), groups.getNnz());
                        this.setLineNumbers(dcinput);
                        inputlops.put("groups", dcinput);
                    }
                    GroupedAggregateM grp_agg_m = new GroupedAggregateM(inputlops, this.getDataType(), this.getValueType(), needPart, LopProperties.ExecType.MR);
                    grp_agg_m.getOutputParameters().setDimensions(outputDim1, outputDim2, target.getRowsInBlock(), target.getColsInBlock(), -1L);
                    this.setLineNumbers(grp_agg_m);
                    Group grp = new Group(grp_agg_m, Group.OperationTypes.Sort, this.getDataType(), this.getValueType());
                    grp.getOutputParameters().setDimensions(outputDim1, outputDim2, target.getRowsInBlock(), target.getColsInBlock(), -1L);
                    this.setLineNumbers(grp);
                    Aggregate agg1 = new Aggregate(grp, (Aggregate.OperationTypes)((Object)HopsAgg2Lops.get((Object)Hop.AggOp.SUM)), this.getDataType(), this.getValueType(), LopProperties.ExecType.MR);
                    agg1.setupCorrectionLocation(PartialAggregate.CorrectionLocationType.NONE);
                    agg1.getOutputParameters().setDimensions(outputDim1, outputDim2, target.getRowsInBlock(), target.getColsInBlock(), -1L);
                    grp_agg = agg1;
                } else {
                    if (target.getDim2() >= target.getColsInBlock() || target.getDim2() <= 0L) {
                        long m1_dim1 = target.getDim1();
                        long m1_dim2 = target.getDim2();
                        long m2_dim1 = groups.getDim1();
                        long m2_dim2 = groups.getDim2();
                        long m3_dim1 = m1_dim1;
                        long m3_dim2 = m1_dim2 > 0L && m2_dim2 > 0L ? m1_dim2 + m2_dim2 : -1L;
                        long m3_nnz = target.getNnz() > 0L && groups.getNnz() > 0L ? target.getNnz() + groups.getNnz() : -1L;
                        long brlen = target.getRowsInBlock();
                        long bclen = target.getColsInBlock();
                        Lop offset = ParameterizedBuiltinOp.createOffsetLop(target, true);
                        RepMat rep = new RepMat(groups.constructLops(), offset, true, groups.getDataType(), groups.getValueType());
                        this.setOutputDimensions(rep);
                        this.setLineNumbers(rep);
                        Group group1 = new Group(target.constructLops(), Group.OperationTypes.Sort, Expression.DataType.MATRIX, target.getValueType());
                        group1.getOutputParameters().setDimensions(m1_dim1, m1_dim2, brlen, bclen, target.getNnz());
                        this.setLineNumbers(group1);
                        Group group2 = new Group(rep, Group.OperationTypes.Sort, Expression.DataType.MATRIX, groups.getValueType());
                        group1.getOutputParameters().setDimensions(m2_dim1, m2_dim2, brlen, bclen, groups.getNnz());
                        this.setLineNumbers(group2);
                        append = new AppendR(group1, group2, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, true, LopProperties.ExecType.MR);
                        append.getOutputParameters().setDimensions(m3_dim1, m3_dim2, brlen, bclen, m3_nnz);
                        this.setLineNumbers(append);
                    } else {
                        append = BinaryOp.constructMRAppendLop(target, groups, Expression.DataType.MATRIX, this.getValueType(), true, target);
                    }
                    inputlops.put("combinedinput", append);
                    inputlops.remove("target");
                    inputlops.remove("groups");
                    grp_agg = new GroupedAggregate(inputlops, isWeighted, this.getDataType(), this.getValueType());
                    grp_agg.getOutputParameters().setDimensions(outputDim1, outputDim2, this.getRowsInBlock(), this.getColsInBlock(), -1L);
                    this.setRequiresReblock(true);
                }
            }
            this.setLineNumbers(grp_agg);
            this.setLops(grp_agg);
        } else {
            Lop grp_agg = null;
            if (et == LopProperties.ExecType.CP) {
                int k = OptimizerUtils.getConstrainedNumThreads(this._maxNumThreads);
                grp_agg = new GroupedAggregate(inputlops, this.getDataType(), this.getValueType(), et, k);
                grp_agg.getOutputParameters().setDimensions(outputDim1, outputDim2, this.getRowsInBlock(), this.getColsInBlock(), -1L);
            } else if (et == LopProperties.ExecType.SPARK) {
                boolean broadcastGroups;
                Hop groups = this.getInput().get(this._paramIndexMap.get("groups"));
                boolean bl = broadcastGroups = this._paramIndexMap.get("weights") == null && OptimizerUtils.checkSparkBroadcastMemoryBudget(groups.getDim1(), groups.getDim2(), groups.getRowsInBlock(), groups.getColsInBlock(), groups.getNnz());
                if (broadcastGroups && this.getInput().get(this._paramIndexMap.get("fn")) instanceof LiteralOp && ((LiteralOp)this.getInput().get(this._paramIndexMap.get("fn"))).getStringValue().equals("sum") && inputlops.get("ngroups") != null) {
                    Hop target = this.getInput().get(this._paramIndexMap.get("target"));
                    grp_agg = new GroupedAggregateM(inputlops, this.getDataType(), this.getValueType(), true, LopProperties.ExecType.SPARK);
                    grp_agg.getOutputParameters().setDimensions(outputDim1, outputDim2, target.getRowsInBlock(), target.getColsInBlock(), -1L);
                } else {
                    grp_agg = new GroupedAggregate(inputlops, this.getDataType(), this.getValueType(), et, broadcastGroups);
                    grp_agg.getOutputParameters().setDimensions(outputDim1, outputDim2, -1L, -1L, -1L);
                    this.setRequiresReblock(true);
                }
            }
            this.setLineNumbers(grp_agg);
            this.setLops(grp_agg);
        }
    }

    private void constructLopsRemoveEmpty(HashMap<String, Lop> inputlops, LopProperties.ExecType et) throws HopsException, LopsException {
        Hop selectHop;
        Hop targetHop = this.getInput().get(this._paramIndexMap.get("target"));
        Hop marginHop = this.getInput().get(this._paramIndexMap.get("margin"));
        Hop hop = selectHop = this._paramIndexMap.get("select") != null ? this.getInput().get(this._paramIndexMap.get("select")) : null;
        if (et == LopProperties.ExecType.CP || et == LopProperties.ExecType.CP_FILE) {
            ParameterizedBuiltin pbilop = new ParameterizedBuiltin(inputlops, (ParameterizedBuiltin.OperationTypes)((Object)HopsParameterizedBuiltinLops.get((Object)this._op)), this.getDataType(), this.getValueType(), et);
            this.setOutputDimensions(pbilop);
            this.setLineNumbers(pbilop);
            this.setLops(pbilop);
        } else if (et == LopProperties.ExecType.MR) {
            if (this.isTargetDiagInput() && marginHop instanceof LiteralOp && ((LiteralOp)marginHop).getStringValue().equals("rows")) {
                Hop input = targetHop.getInput().get(0);
                long brlen = input.getRowsInBlock();
                long bclen = input.getColsInBlock();
                MemoTable memo = new MemoTable();
                boolean isPPredInput = input instanceof BinaryOp && ((BinaryOp)input).isPPredOperation();
                Hop ppred0 = input;
                if (!isPPredInput) {
                    ppred0 = HopRewriteUtils.createBinary(input, new LiteralOp(0L), Hop.OpOp2.NOTEQUAL);
                    HopRewriteUtils.updateHopCharacteristics(ppred0, brlen, bclen, memo, this);
                }
                UnaryOp cumsum = HopRewriteUtils.createUnary(ppred0, Hop.OpOp1.CUMSUM);
                HopRewriteUtils.updateHopCharacteristics(cumsum, brlen, bclen, memo, this);
                Lop loutput = null;
                double mest = AggBinaryOp.getMapmmMemEstimate(input.getDim1(), 1L, brlen, bclen, -1L, brlen, bclen, brlen, bclen, -1L, 1, true);
                double mbudget = OptimizerUtils.getRemoteMemBudgetMap(true);
                if (this._outputPermutationMatrix && mest < mbudget) {
                    BinaryOp sel = HopRewriteUtils.createBinary(ppred0, cumsum, Hop.OpOp2.MULT);
                    HopRewriteUtils.updateHopCharacteristics(sel, brlen, bclen, memo, this);
                    loutput = sel.constructLops();
                } else {
                    BinaryOp max = HopRewriteUtils.createBinary(cumsum, new LiteralOp(1L), Hop.OpOp2.MAX);
                    HopRewriteUtils.updateHopCharacteristics(max, brlen, bclen, memo, this);
                    DataGenOp seq = HopRewriteUtils.createSeqDataGenOp(input);
                    seq.setName("tmp4");
                    HopRewriteUtils.updateHopCharacteristics(seq, brlen, bclen, memo, this);
                    TernaryOp table = new TernaryOp("tmp5", Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, Hop.OpOp3.CTABLE, max, seq, input);
                    table.setOutputBlocksizes(brlen, bclen);
                    table.refreshSizeInformation();
                    table.setForcedExecType(LopProperties.ExecType.MR);
                    HopRewriteUtils.copyLineNumbers(this, table);
                    table.setDisjointInputs(true);
                    table.setOutputEmptyBlocks(this._outputEmptyBlocks);
                    loutput = table.constructLops();
                    HopRewriteUtils.removeChildReference(table, input);
                }
                HopRewriteUtils.removeChildReference(ppred0, input);
                this.setLops(loutput);
            } else if (et == LopProperties.ExecType.MR) {
                if (!(marginHop instanceof LiteralOp)) {
                    throw new HopsException("Parameter 'margin' must be a literal argument.");
                }
                Hop input = targetHop;
                long rlen = input.getDim1();
                long clen = input.getDim2();
                long brlen = input.getRowsInBlock();
                long bclen = input.getColsInBlock();
                long nnz = input.getNnz();
                boolean rmRows = ((LiteralOp)marginHop).getStringValue().equals("rows");
                BinaryOp ppred0 = null;
                Hop emptyInd = null;
                if (selectHop == null) {
                    ppred0 = HopRewriteUtils.createBinary(input, new LiteralOp(0L), Hop.OpOp2.NOTEQUAL);
                    ppred0.setForcedExecType(LopProperties.ExecType.MR);
                    emptyInd = ppred0;
                    if (!(rmRows && clen == 1L || !rmRows && rlen == 1L)) {
                        emptyInd = HopRewriteUtils.createAggUnaryOp(ppred0, Hop.AggOp.MAX, rmRows ? Hop.Direction.Row : Hop.Direction.Col);
                        emptyInd.setForcedExecType(LopProperties.ExecType.MR);
                        HopRewriteUtils.copyLineNumbers(this, emptyInd);
                    }
                } else {
                    emptyInd = selectHop;
                    emptyInd.setOutputBlocksizes(brlen, bclen);
                    emptyInd.refreshSizeInformation();
                    emptyInd.setForcedExecType(LopProperties.ExecType.MR);
                    HopRewriteUtils.copyLineNumbers(this, emptyInd);
                }
                Hop cumsumInput = emptyInd;
                if (!rmRows) {
                    cumsumInput = HopRewriteUtils.createTranspose(emptyInd);
                    HopRewriteUtils.updateHopCharacteristics(cumsumInput, brlen, bclen, this);
                }
                UnaryOp cumsum = HopRewriteUtils.createUnary(cumsumInput, Hop.OpOp1.CUMSUM);
                HopRewriteUtils.updateHopCharacteristics(cumsum, brlen, bclen, this);
                Hop cumsumOutput = cumsum;
                if (!rmRows) {
                    cumsumOutput = HopRewriteUtils.createTranspose(cumsum);
                    HopRewriteUtils.updateHopCharacteristics(cumsumOutput, brlen, bclen, this);
                }
                AggUnaryOp maxDim = HopRewriteUtils.createAggUnaryOp(cumsumOutput, Hop.AggOp.MAX, Hop.Direction.RowCol);
                HopRewriteUtils.updateHopCharacteristics(maxDim, brlen, bclen, this);
                BinaryOp offsets = HopRewriteUtils.createBinary(cumsumOutput, emptyInd, Hop.OpOp2.MULT);
                HopRewriteUtils.updateHopCharacteristics(offsets, brlen, bclen, this);
                Lop linput = input.constructLops();
                Lop loffset = offsets.constructLops();
                Lop lmaxdim = ((Hop)maxDim).constructLops();
                double mestPM = OptimizerUtils.estimatePartitionedSizeExactSparsity(rlen, 1L, brlen, bclen, 1.0);
                Lop rmEmpty = null;
                if (rmRows && rlen > 0L && mestPM < OptimizerUtils.getRemoteMemBudgetMap()) {
                    boolean needPart;
                    boolean bl = needPart = !offsets.dimsKnown() || offsets.getDim1() > 4000000L;
                    if (needPart) {
                        loffset = new DataPartition(loffset, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, mestPM > OptimizerUtils.getLocalMemBudget() ? LopProperties.ExecType.MR : LopProperties.ExecType.CP, ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE_N);
                        loffset.getOutputParameters().setDimensions(rlen, 1L, brlen, bclen, rlen);
                        this.setLineNumbers(loffset);
                    }
                    rmEmpty = new PMMJ(loffset, linput, lmaxdim, this.getDataType(), this.getValueType(), needPart, true, LopProperties.ExecType.MR);
                    this.setOutputDimensions(rmEmpty);
                    this.setLineNumbers(rmEmpty);
                } else {
                    boolean requiresRep;
                    boolean bl = requiresRep = (clen > bclen || clen <= 0L) && rmRows || (rlen > brlen || rlen <= 0L) && !rmRows;
                    if (requiresRep) {
                        Lop pos = ParameterizedBuiltinOp.createOffsetLop(input, rmRows);
                        loffset = new RepMat(loffset, pos, rmRows, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE);
                        loffset.getOutputParameters().setDimensions(rlen, clen, brlen, bclen, nnz);
                        this.setLineNumbers(loffset);
                    }
                    Group group1 = new Group(linput, Group.OperationTypes.Sort, this.getDataType(), this.getValueType());
                    this.setLineNumbers(group1);
                    group1.getOutputParameters().setDimensions(rlen, clen, brlen, bclen, nnz);
                    Group group2 = new Group(loffset, Group.OperationTypes.Sort, this.getDataType(), this.getValueType());
                    this.setLineNumbers(group2);
                    group2.getOutputParameters().setDimensions(rlen, clen, brlen, bclen, nnz);
                    HashMap<String, Lop> inMap = new HashMap<String, Lop>();
                    inMap.put("target", group1);
                    inMap.put("offset", group2);
                    inMap.put("maxdim", lmaxdim);
                    inMap.put("margin", inputlops.get("margin"));
                    rmEmpty = new ParameterizedBuiltin(inMap, (ParameterizedBuiltin.OperationTypes)((Object)HopsParameterizedBuiltinLops.get((Object)this._op)), this.getDataType(), this.getValueType(), et);
                    this.setOutputDimensions(rmEmpty);
                    this.setLineNumbers(rmEmpty);
                }
                Group group3 = new Group(rmEmpty, Group.OperationTypes.Sort, this.getDataType(), this.getValueType());
                this.setLineNumbers(group3);
                group3.getOutputParameters().setDimensions(-1L, -1L, brlen, bclen, -1L);
                Aggregate finalagg = new Aggregate(group3, Aggregate.OperationTypes.Sum, Expression.DataType.MATRIX, this.getValueType(), LopProperties.ExecType.MR);
                this.setOutputDimensions(finalagg);
                this.setLineNumbers(finalagg);
                if (selectHop == null) {
                    HopRewriteUtils.removeChildReference(ppred0, input);
                }
                this.setLops(finalagg);
            }
        } else if (et == LopProperties.ExecType.SPARK) {
            if (!(marginHop instanceof LiteralOp)) {
                throw new HopsException("Parameter 'margin' must be a literal argument.");
            }
            Hop input = targetHop;
            long rlen = input.getDim1();
            long clen = input.getDim2();
            long brlen = input.getRowsInBlock();
            long bclen = input.getColsInBlock();
            boolean rmRows = ((LiteralOp)marginHop).getStringValue().equals("rows");
            BinaryOp ppred0 = null;
            Hop emptyInd = null;
            if (selectHop == null) {
                ppred0 = HopRewriteUtils.createBinary(input, new LiteralOp(0L), Hop.OpOp2.NOTEQUAL);
                ppred0.setForcedExecType(LopProperties.ExecType.SPARK);
                emptyInd = ppred0;
                if (!(rmRows && clen == 1L || !rmRows && rlen == 1L)) {
                    emptyInd = HopRewriteUtils.createAggUnaryOp(ppred0, Hop.AggOp.MAX, rmRows ? Hop.Direction.Row : Hop.Direction.Col);
                    emptyInd.setForcedExecType(LopProperties.ExecType.SPARK);
                }
            } else {
                emptyInd = selectHop;
                emptyInd.setOutputBlocksizes(brlen, bclen);
                emptyInd.refreshSizeInformation();
                emptyInd.setForcedExecType(LopProperties.ExecType.SPARK);
                HopRewriteUtils.copyLineNumbers(this, emptyInd);
            }
            Hop cumsumInput = emptyInd;
            if (!rmRows) {
                cumsumInput = HopRewriteUtils.createTranspose(emptyInd);
                HopRewriteUtils.updateHopCharacteristics(cumsumInput, brlen, bclen, this);
            }
            UnaryOp cumsum = HopRewriteUtils.createUnary(cumsumInput, Hop.OpOp1.CUMSUM);
            HopRewriteUtils.updateHopCharacteristics(cumsum, brlen, bclen, this);
            Hop cumsumOutput = cumsum;
            if (!rmRows) {
                cumsumOutput = HopRewriteUtils.createTranspose(cumsum);
                HopRewriteUtils.updateHopCharacteristics(cumsumOutput, brlen, bclen, this);
            }
            AggUnaryOp maxDim = HopRewriteUtils.createAggUnaryOp(cumsumOutput, Hop.AggOp.MAX, Hop.Direction.RowCol);
            HopRewriteUtils.updateHopCharacteristics(maxDim, brlen, bclen, this);
            BinaryOp offsets = HopRewriteUtils.createBinary(cumsumOutput, emptyInd, Hop.OpOp2.MULT);
            HopRewriteUtils.updateHopCharacteristics(offsets, brlen, bclen, this);
            Lop linput = input.constructLops();
            Lop loffset = offsets.constructLops();
            Lop lmaxdim = ((Hop)maxDim).constructLops();
            HashMap<String, Lop> inMap = new HashMap<String, Lop>();
            inMap.put("target", linput);
            inMap.put("offset", loffset);
            inMap.put("maxdim", lmaxdim);
            inMap.put("margin", inputlops.get("margin"));
            if (!FORCE_DIST_RM_EMPTY && this.isRemoveEmptyBcSP()) {
                this._bRmEmptyBC = true;
            }
            ParameterizedBuiltin pbilop = new ParameterizedBuiltin(inMap, (ParameterizedBuiltin.OperationTypes)((Object)HopsParameterizedBuiltinLops.get((Object)this._op)), this.getDataType(), this.getValueType(), et, this._bRmEmptyBC);
            this.setOutputDimensions(pbilop);
            this.setLineNumbers(pbilop);
            if (selectHop == null) {
                HopRewriteUtils.removeChildReference(ppred0, input);
            }
            this.setLops(pbilop);
        }
    }

    private void constructLopsRExpand(HashMap<String, Lop> inputlops, LopProperties.ExecType et) throws HopsException, LopsException {
        if (et == LopProperties.ExecType.CP || et == LopProperties.ExecType.SPARK) {
            ParameterizedBuiltin pbilop = new ParameterizedBuiltin(inputlops, (ParameterizedBuiltin.OperationTypes)((Object)HopsParameterizedBuiltinLops.get((Object)this._op)), this.getDataType(), this.getValueType(), et);
            this.setOutputDimensions(pbilop);
            this.setLineNumbers(pbilop);
            this.setLops(pbilop);
        } else if (et == LopProperties.ExecType.MR) {
            ParameterizedBuiltin pbilop = new ParameterizedBuiltin(inputlops, (ParameterizedBuiltin.OperationTypes)((Object)HopsParameterizedBuiltinLops.get((Object)this._op)), this.getDataType(), this.getValueType(), et);
            this.setOutputDimensions(pbilop);
            this.setLineNumbers(pbilop);
            Group group1 = new Group(pbilop, Group.OperationTypes.Sort, this.getDataType(), this.getValueType());
            this.setOutputDimensions(group1);
            this.setLineNumbers(group1);
            Aggregate finalagg = new Aggregate(group1, Aggregate.OperationTypes.Sum, Expression.DataType.MATRIX, this.getValueType(), LopProperties.ExecType.MR);
            this.setOutputDimensions(finalagg);
            this.setLineNumbers(finalagg);
            this.setLops(finalagg);
        }
    }

    @Override
    protected double computeOutputMemEstimate(long dim1, long dim2, long nnz) {
        if (this.getOp() == Hop.ParamBuiltinOp.TOSTRING) {
            long numCols;
            long numRows;
            long AVERAGE_CHARS_PER_VALUE = 7L;
            long AVERAGE_CHARS_PER_INDEX = 4L;
            long specifiedRows = 100L;
            long specifiedCols = 100L;
            boolean sparsePrint = false;
            String sep = " ";
            String linesep = "\n";
            Hop rowsHop = this.getInputParameter("rows");
            Hop colsHop = this.getInputParameter("cols");
            Hop sparsePrintHOP = this.getInputParameter("sparse");
            Hop sepHop = this.getInputParameter("sep");
            Hop linesepHop = this.getInputParameter("linesep");
            long numNonZeroes = this.getInput().get(0).getNnz();
            if (numNonZeroes < 0L) {
                numNonZeroes = specifiedRows * specifiedCols;
            }
            if ((numRows = this.getInput().get(0).getDim1()) < 0L) {
                numRows = specifiedRows;
            }
            if ((numCols = this.getInput().get(0).getDim2()) < 0L) {
                numCols = specifiedCols;
            }
            long DEFAULT_SIZE = 160036L;
            try {
                if (rowsHop != null && rowsHop instanceof LiteralOp) {
                    specifiedRows = ((LiteralOp)rowsHop).getLongValue();
                }
                long l = numRows = numRows < specifiedRows ? numRows : specifiedRows;
                if (colsHop != null && colsHop instanceof LiteralOp) {
                    specifiedCols = ((LiteralOp)colsHop).getLongValue();
                }
                long l2 = numCols = numCols < specifiedCols ? numCols : specifiedCols;
                if (sparsePrintHOP != null && sparsePrintHOP instanceof LiteralOp) {
                    sparsePrint = ((LiteralOp)sparsePrintHOP).getBooleanValue();
                }
                if (sepHop != null && sepHop instanceof LiteralOp) {
                    sep = ((LiteralOp)sepHop).getStringValue();
                }
                if (linesepHop != null && linesepHop instanceof LiteralOp) {
                    linesep = ((LiteralOp)linesepHop).getStringValue();
                }
                long numberOfChars = -1L;
                numberOfChars = sparsePrint ? 7L * numNonZeroes + 8L * numNonZeroes + (long)sep.length() * 2L * numNonZeroes + (long)linesep.length() * numNonZeroes : 7L * numRows * numCols + (long)sep.length() * numRows * (numCols - 1L) + (long)linesep.length() * numRows;
                return 36L + numberOfChars * 2L;
            }
            catch (HopsException e) {
                LOG.warn((Object)"Invalid values when trying to compute dims1, dims2 & nnz", (Throwable)e);
                return 160036.0;
            }
        }
        double sparsity = OptimizerUtils.getSparsity(dim1, dim2, nnz);
        return OptimizerUtils.estimateSizeExactSparsity(dim1, dim2, sparsity);
    }

    @Override
    protected double computeIntermediateMemEstimate(long dim1, long dim2, long nnz) {
        Hop dir;
        String dirVal;
        double ret = 0.0;
        if (this._op == Hop.ParamBuiltinOp.RMEMPTY) {
            boolean cols;
            Hop marginHop = this.getInput().get(this._paramIndexMap.get("margin"));
            boolean bl = cols = marginHop instanceof LiteralOp && "cols".equals(((LiteralOp)marginHop).getStringValue());
            if (cols) {
                ret += (double)(1L * dim2);
                ret += (double)(4L * dim2);
            } else {
                ret += (double)(1L * dim1);
            }
        } else if (this._op == Hop.ParamBuiltinOp.REXPAND && "rows".equals(dirVal = ((LiteralOp)(dir = this.getInput().get(this._paramIndexMap.get("dir")))).getStringValue())) {
            ret = 12L * Math.min(dim1, 0x100000L);
        }
        return ret;
    }

    @Override
    protected long[] inferOutputCharacteristics(MemoTable memo) {
        long[] ret = null;
        Hop input = this.getTargetHop();
        MatrixCharacteristics mc = memo.getAllInputStats(input);
        if (this._op == Hop.ParamBuiltinOp.GROUPEDAGG) {
            long n;
            Hop ngroups;
            if (this._paramIndexMap.get("ngroups") != null && (ngroups = this.getInput().get(this._paramIndexMap.get("ngroups"))) != null && ngroups instanceof LiteralOp) {
                long m = HopRewriteUtils.getIntValueSafe((LiteralOp)ngroups);
                long n2 = mc.getRows() == 1L ? 1L : mc.getCols();
                return new long[]{m, n2, m};
            }
            long m = mc.getRows();
            long l = n = mc.getRows() == 1L ? 1L : mc.getCols();
            if (m >= 1L) {
                ret = new long[]{m, n, m};
            }
        } else if (this._op == Hop.ParamBuiltinOp.RMEMPTY) {
            if (mc.dimsKnown()) {
                String margin = "rows";
                Hop marginHop = this.getInput().get(this._paramIndexMap.get("margin"));
                if (marginHop instanceof LiteralOp && "cols".equals(((LiteralOp)marginHop).getStringValue())) {
                    margin = new String("cols");
                }
                MatrixCharacteristics mcSelect = null;
                if (this._paramIndexMap.get("select") != null) {
                    Hop select = this.getInput().get(this._paramIndexMap.get("select"));
                    mcSelect = memo.getAllInputStats(select);
                }
                long lDim1 = 0L;
                long lDim2 = 0L;
                if (margin.equals("rows")) {
                    lDim1 = mcSelect == null || !mcSelect.nnzKnown() ? mc.getRows() : mcSelect.getNonZeros();
                    lDim2 = mc.getCols();
                } else {
                    lDim1 = mc.getRows();
                    lDim2 = mcSelect == null || !mcSelect.nnzKnown() ? mc.getCols() : mcSelect.getNonZeros();
                }
                ret = new long[]{lDim1, lDim2, mc.getNonZeros()};
            }
        } else if (this._op == Hop.ParamBuiltinOp.REPLACE) {
            if (mc.dimsKnown()) {
                ret = this.isNonZeroReplaceArguments() ? new long[]{mc.getRows(), mc.getCols(), mc.getNonZeros()} : new long[]{mc.getRows(), mc.getCols(), -1L};
            }
        } else if (this._op == Hop.ParamBuiltinOp.REXPAND) {
            Hop max = this.getInput().get(this._paramIndexMap.get("max"));
            Hop dir = this.getInput().get(this._paramIndexMap.get("dir"));
            double maxVal = HopRewriteUtils.getDoubleValueSafe((LiteralOp)max);
            String dirVal = ((LiteralOp)dir).getStringValue();
            if (mc.dimsKnown()) {
                long lnnz;
                long l = lnnz = mc.nnzKnown() ? mc.getNonZeros() : mc.getRows();
                if ("cols".equals(dirVal)) {
                    ret = new long[]{mc.getRows(), UtilFunctions.toLong(maxVal), lnnz};
                } else if ("rows".equals(dirVal)) {
                    ret = new long[]{UtilFunctions.toLong(maxVal), mc.getRows(), lnnz};
                }
            }
        } else if (this._op == Hop.ParamBuiltinOp.TRANSFORMDECODE ? mc.dimsKnown() : this._op == Hop.ParamBuiltinOp.TRANSFORMAPPLY && mc.dimsKnown()) {
            return new long[]{mc.getRows(), mc.getCols(), mc.getRows() * mc.getCols()};
        }
        return ret;
    }

    @Override
    public boolean allowsAllExecTypes() {
        return false;
    }

    @Override
    protected LopProperties.ExecType optFindExecType() throws HopsException {
        LopProperties.ExecType REMOTE;
        this.checkAndSetForcedPlatform();
        LopProperties.ExecType execType = REMOTE = OptimizerUtils.isSparkExecutionMode() ? LopProperties.ExecType.SPARK : LopProperties.ExecType.MR;
        if (this._etypeForced != null) {
            this._etype = this._etypeForced;
        } else {
            if (this._op == Hop.ParamBuiltinOp.TRANSFORM) {
                this._etype = REMOTE;
                return this._etype;
            }
            this._etype = OptimizerUtils.isMemoryBasedOptLevel() ? this.findExecTypeByMemEstimate() : (this._op == Hop.ParamBuiltinOp.GROUPEDAGG && this.getInput().get(0).areDimsBelowThreshold() ? LopProperties.ExecType.CP : REMOTE);
            this.checkAndSetInvalidCPDimsAndSize();
        }
        if (this._op == Hop.ParamBuiltinOp.TRANSFORMAPPLY && REMOTE == LopProperties.ExecType.MR || this._op == Hop.ParamBuiltinOp.TRANSFORMDECODE && REMOTE == LopProperties.ExecType.MR || this._op == Hop.ParamBuiltinOp.TRANSFORMMETA || this._op == Hop.ParamBuiltinOp.TOSTRING || this._op == Hop.ParamBuiltinOp.CDF || this._op == Hop.ParamBuiltinOp.INVCDF) {
            this._etype = LopProperties.ExecType.CP;
        }
        if (ConfigurationManager.isDynamicRecompilation() && !this.dimsKnown(true) && this._etype == REMOTE) {
            this.setRequiresRecompile();
        }
        return this._etype;
    }

    @Override
    public void refreshSizeInformation() {
        switch (this._op) {
            case CDF: 
            case INVCDF: {
                break;
            }
            case GROUPEDAGG: {
                Hop target;
                Hop ngroups;
                long ldim1 = -1L;
                if (this._paramIndexMap.get("ngroups") != null && (ngroups = this.getInput().get(this._paramIndexMap.get("ngroups"))) != null && ngroups instanceof LiteralOp) {
                    ldim1 = HopRewriteUtils.getIntValueSafe((LiteralOp)ngroups);
                }
                long ldim2 = (target = this.getInput().get(this._paramIndexMap.get("target"))).getDim1() == 1L ? 1L : target.getDim2();
                this.setDim1(ldim1);
                this.setDim2(ldim2);
                break;
            }
            case RMEMPTY: {
                Hop target = this.getInput().get(this._paramIndexMap.get("target"));
                Hop margin = this.getInput().get(this._paramIndexMap.get("margin"));
                if (margin instanceof LiteralOp) {
                    LiteralOp lmargin = (LiteralOp)margin;
                    if ("rows".equals(lmargin.getStringValue())) {
                        this.setDim2(target.getDim2());
                    } else if ("cols".equals(lmargin.getStringValue())) {
                        this.setDim1(target.getDim1());
                    }
                }
                this.setNnz(target.getNnz());
                break;
            }
            case REPLACE: {
                Hop target = this.getInput().get(this._paramIndexMap.get("target"));
                this.setDim1(target.getDim1());
                this.setDim2(target.getDim2());
                if (!this.isNonZeroReplaceArguments()) break;
                this.setNnz(target.getNnz());
                break;
            }
            case REXPAND: {
                Hop target = this.getInput().get(this._paramIndexMap.get("target"));
                Hop max = this.getInput().get(this._paramIndexMap.get("max"));
                Hop dir = this.getInput().get(this._paramIndexMap.get("dir"));
                double maxVal = HopRewriteUtils.getDoubleValueSafe((LiteralOp)max);
                String dirVal = ((LiteralOp)dir).getStringValue();
                if ("cols".equals(dirVal)) {
                    this.setDim1(target.getDim1());
                    this.setDim2(UtilFunctions.toLong(maxVal));
                    break;
                }
                if (!"rows".equals(dirVal)) break;
                this.setDim1(UtilFunctions.toLong(maxVal));
                this.setDim2(target.getDim1());
                break;
            }
            case TRANSFORMDECODE: {
                Hop target = this.getInput().get(this._paramIndexMap.get("target"));
                this.setDim1(target.getDim1());
                break;
            }
            case TRANSFORMAPPLY: {
                break;
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ParameterizedBuiltinOp ret = new ParameterizedBuiltinOp();
        ret.clone(this, false);
        ret._op = this._op;
        ret._outputEmptyBlocks = this._outputEmptyBlocks;
        ret._outputPermutationMatrix = this._outputPermutationMatrix;
        ret._paramIndexMap = (HashMap)this._paramIndexMap.clone();
        return ret;
    }

    @Override
    public boolean compare(Hop that) {
        boolean ret;
        if (!(that instanceof ParameterizedBuiltinOp)) {
            return false;
        }
        ParameterizedBuiltinOp that2 = (ParameterizedBuiltinOp)that;
        boolean bl = ret = this._op == that2._op && this._paramIndexMap != null && that2._paramIndexMap != null && this._paramIndexMap.size() == that2._paramIndexMap.size() && this._outputEmptyBlocks == that2._outputEmptyBlocks && this._outputPermutationMatrix == that2._outputPermutationMatrix;
        if (ret) {
            for (Map.Entry<String, Integer> e : this._paramIndexMap.entrySet()) {
                String key1 = e.getKey();
                int pos1 = e.getValue();
                int pos2 = that2._paramIndexMap.get(key1);
                ret &= that2.getInput().get(pos2) != null && this.getInput().get(pos1) == that2.getInput().get(pos2);
            }
        }
        return ret;
    }

    @Override
    public boolean isTransposeSafe() {
        boolean ret = false;
        try {
            if (this._op == Hop.ParamBuiltinOp.GROUPEDAGG) {
                int ix = this._paramIndexMap.get("fn");
                Hop fnHop = this.getInput().get(ix);
                ret = fnHop instanceof LiteralOp && "sum".equals(((LiteralOp)fnHop).getStringValue());
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)"Check for transpose-safeness failed, continue assuming false.", (Throwable)ex);
        }
        return ret;
    }

    public boolean isCountFunction() {
        boolean ret = false;
        try {
            if (this._op == Hop.ParamBuiltinOp.GROUPEDAGG) {
                int ix = this._paramIndexMap.get("fn");
                Hop fnHop = this.getInput().get(ix);
                ret = fnHop instanceof LiteralOp && "count".equals(((LiteralOp)fnHop).getStringValue());
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)"Check for count function failed, continue assuming false.", (Throwable)ex);
        }
        return ret;
    }

    private boolean isNonZeroReplaceArguments() {
        boolean ret = false;
        try {
            Hop pattern = this.getInput().get(this._paramIndexMap.get("pattern"));
            Hop replace = this.getInput().get(this._paramIndexMap.get("replacement"));
            if (pattern instanceof LiteralOp && ((LiteralOp)pattern).getDoubleValue() != 0.0 && replace instanceof LiteralOp && ((LiteralOp)replace).getDoubleValue() != 0.0) {
                ret = true;
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)ex.getMessage());
        }
        return ret;
    }

    public boolean isTargetDiagInput() {
        Hop targetHop = this.getTargetHop();
        return targetHop instanceof ReorgOp && ((ReorgOp)targetHop).getOp() == Hop.ReOrgOp.DIAG && targetHop.getInput().get(0).getDim2() == 1L;
    }

    private boolean isRemoveEmptyBcSP() {
        double size;
        boolean ret = false;
        Hop input = this.getInput().get(0);
        double d = size = input.dimsKnown() ? (double)OptimizerUtils.estimateSize(input.getDim1(), 1L) : input.getOutputMemEstimate();
        if (OptimizerUtils.checkSparkBroadcastMemoryBudget(size)) {
            ret = true;
        }
        return ret;
    }
}

