/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.debug;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.sysml.debug.DMLBreakpointManager;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.runtime.controlprogram.ExternalFunctionProgramBlock;
import org.apache.sysml.runtime.controlprogram.ForProgramBlock;
import org.apache.sysml.runtime.controlprogram.FunctionProgramBlock;
import org.apache.sysml.runtime.controlprogram.IfProgramBlock;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.ProgramBlock;
import org.apache.sysml.runtime.controlprogram.WhileProgramBlock;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.MRJobInstruction;
import org.apache.sysml.runtime.instructions.cp.BreakPointInstruction;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.spark.SPInstruction;

public class DMLDebuggerProgramInfo {
    public Program rtprog;
    private TreeMap<Integer, ArrayList<Instruction>> disassembler = new TreeMap();
    private int prevLineNum = 0;
    private long instID = 1L;
    private String location = null;

    public TreeMap<Integer, ArrayList<Instruction>> getDMLInstMap() {
        this.setDMLInstMap();
        return this.disassembler;
    }

    public void accessBreakpoint(int lineNumber, int op, BreakPointInstruction.BPINSTRUCTION_STATUS status) {
        if (this.rtprog != null) {
            HashMap<String, FunctionProgramBlock> funcMap = this.rtprog.getFunctionProgramBlocks();
            if (funcMap != null && !funcMap.isEmpty()) {
                for (Map.Entry entry : funcMap.entrySet()) {
                    this.location = (String)entry.getKey();
                    FunctionProgramBlock fpb = (FunctionProgramBlock)entry.getValue();
                    if (fpb instanceof ExternalFunctionProgramBlock) continue;
                    for (ProgramBlock pb : fpb.getChildBlocks()) {
                        this.accessProgramBlockBreakpoint(pb, lineNumber, op, status);
                    }
                }
            }
            this.location = DMLProgram.constructFunctionKey(DMLProgram.DEFAULT_NAMESPACE, "main");
            for (ProgramBlock programBlock : this.rtprog.getProgramBlocks()) {
                if (programBlock == null) continue;
                this.accessProgramBlockBreakpoint(programBlock, lineNumber, op, status);
            }
        }
    }

    private void accessProgramBlockBreakpoint(ProgramBlock pb, int lineNumber, int op, BreakPointInstruction.BPINSTRUCTION_STATUS status) {
        if (pb instanceof FunctionProgramBlock) {
            FunctionProgramBlock fpb = (FunctionProgramBlock)pb;
            for (ProgramBlock pbc : fpb.getChildBlocks()) {
                this.accessProgramBlockBreakpoint(pbc, lineNumber, op, status);
            }
        } else if (pb instanceof WhileProgramBlock) {
            WhileProgramBlock wpb = (WhileProgramBlock)pb;
            this.accesBreakpointInstruction(wpb.getPredicate(), lineNumber, op, status);
            for (ProgramBlock pbc : wpb.getChildBlocks()) {
                this.accessProgramBlockBreakpoint(pbc, lineNumber, op, status);
            }
        } else if (pb instanceof IfProgramBlock) {
            IfProgramBlock ipb = (IfProgramBlock)pb;
            this.accesBreakpointInstruction(ipb.getPredicate(), lineNumber, op, status);
            for (ProgramBlock pbc : ipb.getChildBlocksIfBody()) {
                this.accessProgramBlockBreakpoint(pbc, lineNumber, op, status);
            }
            if (!ipb.getChildBlocksElseBody().isEmpty()) {
                for (ProgramBlock pbc : ipb.getChildBlocksElseBody()) {
                    this.accessProgramBlockBreakpoint(pbc, lineNumber, op, status);
                }
            }
        } else if (pb instanceof ForProgramBlock) {
            ForProgramBlock fpb = (ForProgramBlock)pb;
            this.accesBreakpointInstruction(fpb.getFromInstructions(), lineNumber, op, status);
            this.accesBreakpointInstruction(fpb.getToInstructions(), lineNumber, op, status);
            this.accesBreakpointInstruction(fpb.getIncrementInstructions(), lineNumber, op, status);
            for (ProgramBlock pbc : fpb.getChildBlocks()) {
                this.accessProgramBlockBreakpoint(pbc, lineNumber, op, status);
            }
        } else {
            this.accesBreakpointInstruction(pb.getInstructions(), lineNumber, op, status);
        }
    }

    private void accesBreakpointInstruction(ArrayList<Instruction> instructions, int lineNumber, int op, BreakPointInstruction.BPINSTRUCTION_STATUS status) {
        for (int i = 0; i < instructions.size(); ++i) {
            BreakPointInstruction breakpoint;
            Instruction currInst = instructions.get(i);
            if (op == 0) {
                if (currInst instanceof MRJobInstruction) {
                    MRJobInstruction currMRInst = (MRJobInstruction)currInst;
                    if (!currMRInst.findMRInstructions(lineNumber)) continue;
                    BreakPointInstruction breakpoint2 = new BreakPointInstruction();
                    breakpoint2.setLocation(currInst);
                    breakpoint2.setInstID(this.instID++);
                    breakpoint2.setBPInstructionLocation(this.location);
                    instructions.add(i, breakpoint2);
                    DMLBreakpointManager.insertBreakpoint(breakpoint2, lineNumber);
                    return;
                }
                if (currInst instanceof CPInstruction || currInst instanceof SPInstruction) {
                    if (currInst.getLineNum() != lineNumber) continue;
                    breakpoint = new BreakPointInstruction();
                    breakpoint.setLocation(currInst);
                    breakpoint.setInstID(this.instID++);
                    breakpoint.setBPInstructionLocation(this.location);
                    instructions.add(i, breakpoint);
                    DMLBreakpointManager.insertBreakpoint(breakpoint, lineNumber);
                    return;
                }
                if (!(currInst instanceof BreakPointInstruction) || currInst.getLineNum() != lineNumber) continue;
                breakpoint = (BreakPointInstruction)currInst;
                breakpoint.setBPInstructionStatus(BreakPointInstruction.BPINSTRUCTION_STATUS.ENABLED);
                breakpoint.setBPInstructionLocation(this.location);
                instructions.set(i, breakpoint);
                DMLBreakpointManager.updateBreakpoint(lineNumber, status);
                return;
            }
            if (!(currInst instanceof BreakPointInstruction) || currInst.getLineNum() != lineNumber) continue;
            if (op == 1) {
                breakpoint = (BreakPointInstruction)currInst;
                breakpoint.setLocation(currInst);
                breakpoint.setInstID(currInst.getInstID());
                breakpoint.setBPInstructionStatus(status);
                breakpoint.setBPInstructionLocation(this.location);
                instructions.set(i, breakpoint);
                DMLBreakpointManager.updateBreakpoint(lineNumber, status);
            } else {
                instructions.remove(i);
                DMLBreakpointManager.removeBreakpoint(lineNumber, status);
            }
            return;
        }
    }

    public void setDMLInstMap() {
        this.disassembler = new TreeMap();
        if (this.rtprog != null) {
            HashMap<String, FunctionProgramBlock> funcMap = this.rtprog.getFunctionProgramBlocks();
            if (funcMap != null && !funcMap.isEmpty()) {
                for (Map.Entry entry : funcMap.entrySet()) {
                    FunctionProgramBlock fpb = (FunctionProgramBlock)entry.getValue();
                    if (fpb instanceof ExternalFunctionProgramBlock) continue;
                    for (ProgramBlock pb : fpb.getChildBlocks()) {
                        this.setProgramBlockInstMap(pb);
                    }
                }
            }
            for (ProgramBlock programBlock : this.rtprog.getProgramBlocks()) {
                if (programBlock == null) continue;
                this.setProgramBlockInstMap(programBlock);
            }
        }
    }

    private void setProgramBlockInstMap(ProgramBlock pb) {
        if (pb instanceof FunctionProgramBlock) {
            FunctionProgramBlock fpb = (FunctionProgramBlock)pb;
            for (ProgramBlock pbc : fpb.getChildBlocks()) {
                this.setProgramBlockInstMap(pbc);
            }
        } else if (pb instanceof WhileProgramBlock) {
            WhileProgramBlock wpb = (WhileProgramBlock)pb;
            this.setInstMap(wpb.getPredicate());
            for (ProgramBlock pbc : wpb.getChildBlocks()) {
                this.setProgramBlockInstMap(pbc);
            }
        } else if (pb instanceof IfProgramBlock) {
            IfProgramBlock ipb = (IfProgramBlock)pb;
            this.setInstMap(ipb.getPredicate());
            for (ProgramBlock pbc : ipb.getChildBlocksIfBody()) {
                this.setProgramBlockInstMap(pbc);
            }
            if (!ipb.getChildBlocksElseBody().isEmpty()) {
                for (ProgramBlock pbc : ipb.getChildBlocksElseBody()) {
                    this.setProgramBlockInstMap(pbc);
                }
            }
        } else if (pb instanceof ForProgramBlock) {
            ForProgramBlock fpb = (ForProgramBlock)pb;
            this.setInstMap(fpb.getFromInstructions());
            this.setInstMap(fpb.getToInstructions());
            this.setInstMap(fpb.getIncrementInstructions());
            for (ProgramBlock pbc : fpb.getChildBlocks()) {
                this.setProgramBlockInstMap(pbc);
            }
        } else {
            this.setInstMap(pb.getInstructions());
        }
    }

    private void setInstMap(ArrayList<Instruction> instructions) {
        for (int i = 0; i < instructions.size(); ++i) {
            Instruction currInst = instructions.get(i);
            if (currInst.getInstID() == 0L) {
                currInst.setInstID(this.instID++);
            }
            if (currInst instanceof MRJobInstruction) {
                MRJobInstruction currMRInst = (MRJobInstruction)currInst;
                int min = Integer.MAX_VALUE;
                for (Integer lineNumber : currMRInst.getMRJobInstructionsLineNumbers()) {
                    if (lineNumber >= min) continue;
                    min = lineNumber;
                }
                if (min == 0 || min == Integer.MAX_VALUE) {
                    currMRInst.setLocation(this.prevLineNum, this.prevLineNum, -1, -1);
                } else {
                    currMRInst.setLocation(min, min, -1, -1);
                }
                if (!this.disassembler.containsKey(currMRInst.getLineNum())) {
                    this.disassembler.put(currMRInst.getLineNum(), new ArrayList());
                }
                this.disassembler.get(currMRInst.getLineNum()).add(currMRInst);
            } else if (currInst instanceof CPInstruction || currInst instanceof SPInstruction) {
                if (currInst.getLineNum() == 0) {
                    currInst.setLocation(this.prevLineNum, this.prevLineNum, -1, -1);
                }
                if (!this.disassembler.containsKey(currInst.getLineNum())) {
                    this.disassembler.put(currInst.getLineNum(), new ArrayList());
                }
                this.disassembler.get(currInst.getLineNum()).add(currInst);
            } else if (currInst instanceof BreakPointInstruction) {
                BreakPointInstruction currBPInst = (BreakPointInstruction)currInst;
                if (!this.disassembler.containsKey(currBPInst.getLineNum())) {
                    this.disassembler.put(currBPInst.getLineNum(), new ArrayList());
                }
                this.disassembler.get(currInst.getLineNum()).add(currBPInst);
            }
            if (currInst.getLineNum() == 0) continue;
            this.prevLineNum = currInst.getLineNum();
        }
    }
}

