/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.api.mlcontext;

import org.apache.sysml.api.mlcontext.MatrixFormat;
import org.apache.sysml.api.mlcontext.Metadata;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;

public class MatrixMetadata
extends Metadata {
    private Long numRows = null;
    private Long numColumns = null;
    private Long numNonZeros = null;
    private Integer numRowsPerBlock = null;
    private Integer numColumnsPerBlock = null;
    private MatrixFormat matrixFormat;

    public MatrixMetadata() {
    }

    public MatrixMetadata(MatrixFormat matrixFormat) {
        this.matrixFormat = matrixFormat;
    }

    public MatrixMetadata(MatrixFormat matrixFormat, Long numRows, Long numColumns) {
        this.matrixFormat = matrixFormat;
        this.numRows = numRows;
        this.numColumns = numColumns;
    }

    public MatrixMetadata(MatrixFormat matrixFormat, int numRows, int numColumns) {
        this.matrixFormat = matrixFormat;
        this.numRows = numRows;
        this.numColumns = numColumns;
    }

    public MatrixMetadata(MatrixFormat matrixFormat, Long numRows, Long numColumns, Long numNonZeros) {
        this.matrixFormat = matrixFormat;
        this.numRows = numRows;
        this.numColumns = numColumns;
        this.numNonZeros = numNonZeros;
    }

    public MatrixMetadata(MatrixFormat matrixFormat, int numRows, int numColumns, int numNonZeros) {
        this.matrixFormat = matrixFormat;
        this.numRows = numRows;
        this.numColumns = numColumns;
        this.numNonZeros = numNonZeros;
    }

    public MatrixMetadata(MatrixFormat matrixFormat, Long numRows, Long numColumns, Long numNonZeros, Integer numRowsPerBlock, Integer numColumnsPerBlock) {
        this.matrixFormat = matrixFormat;
        this.numRows = numRows;
        this.numColumns = numColumns;
        this.numNonZeros = numNonZeros;
        this.numRowsPerBlock = numRowsPerBlock;
        this.numColumnsPerBlock = numColumnsPerBlock;
    }

    public MatrixMetadata(MatrixFormat matrixFormat, int numRows, int numColumns, int numNonZeros, int numRowsPerBlock, int numColumnsPerBlock) {
        this.matrixFormat = matrixFormat;
        this.numRows = numRows;
        this.numColumns = numColumns;
        this.numNonZeros = numNonZeros;
        this.numRowsPerBlock = numRowsPerBlock;
        this.numColumnsPerBlock = numColumnsPerBlock;
    }

    public MatrixMetadata(Long numRows, Long numColumns) {
        this.numRows = numRows;
        this.numColumns = numColumns;
    }

    public MatrixMetadata(int numRows, int numColumns) {
        this.numRows = numRows;
        this.numColumns = numColumns;
    }

    public MatrixMetadata(Long numRows, Long numColumns, Long numNonZeros) {
        this.numRows = numRows;
        this.numColumns = numColumns;
        this.numNonZeros = numNonZeros;
    }

    public MatrixMetadata(int numRows, int numColumns, int numNonZeros) {
        this.numRows = numRows;
        this.numColumns = numColumns;
        this.numNonZeros = numNonZeros;
    }

    public MatrixMetadata(Long numRows, Long numColumns, Integer numRowsPerBlock, Integer numColumnsPerBlock) {
        this.numRows = numRows;
        this.numColumns = numColumns;
        this.numRowsPerBlock = numRowsPerBlock;
        this.numColumnsPerBlock = numColumnsPerBlock;
    }

    public MatrixMetadata(int numRows, int numColumns, int numRowsPerBlock, int numColumnsPerBlock) {
        this.numRows = numRows;
        this.numColumns = numColumns;
        this.numRowsPerBlock = numRowsPerBlock;
        this.numColumnsPerBlock = numColumnsPerBlock;
    }

    public MatrixMetadata(Long numRows, Long numColumns, Long numNonZeros, Integer numRowsPerBlock, Integer numColumnsPerBlock) {
        this.numRows = numRows;
        this.numColumns = numColumns;
        this.numNonZeros = numNonZeros;
        this.numRowsPerBlock = numRowsPerBlock;
        this.numColumnsPerBlock = numColumnsPerBlock;
    }

    public MatrixMetadata(int numRows, int numColumns, int numNonZeros, int numRowsPerBlock, int numColumnsPerBlock) {
        this.numRows = numRows;
        this.numColumns = numColumns;
        this.numNonZeros = numNonZeros;
        this.numRowsPerBlock = numRowsPerBlock;
        this.numColumnsPerBlock = numColumnsPerBlock;
    }

    public MatrixMetadata(MatrixCharacteristics matrixCharacteristics) {
        this.numRows = matrixCharacteristics.getRows();
        this.numColumns = matrixCharacteristics.getCols();
        this.numNonZeros = matrixCharacteristics.getNonZeros();
        this.numRowsPerBlock = matrixCharacteristics.getRowsPerBlock();
        this.numColumnsPerBlock = matrixCharacteristics.getColsPerBlock();
    }

    public void setMatrixCharacteristics(MatrixCharacteristics matrixCharacteristics) {
        this.numRows = matrixCharacteristics.getRows();
        this.numColumns = matrixCharacteristics.getCols();
        this.numNonZeros = matrixCharacteristics.getNonZeros();
        this.numRowsPerBlock = matrixCharacteristics.getRowsPerBlock();
        this.numColumnsPerBlock = matrixCharacteristics.getColsPerBlock();
    }

    public Long getNumRows() {
        return this.numRows;
    }

    public void setNumRows(Long numRows) {
        this.numRows = numRows;
    }

    public Long getNumColumns() {
        return this.numColumns;
    }

    public void setNumColumns(Long numColumns) {
        this.numColumns = numColumns;
    }

    public Long getNumNonZeros() {
        return this.numNonZeros;
    }

    public void setNumNonZeros(Long numNonZeros) {
        this.numNonZeros = numNonZeros;
    }

    public Integer getNumRowsPerBlock() {
        return this.numRowsPerBlock;
    }

    public void setNumRowsPerBlock(Integer numRowsPerBlock) {
        this.numRowsPerBlock = numRowsPerBlock;
    }

    public Integer getNumColumnsPerBlock() {
        return this.numColumnsPerBlock;
    }

    public void setNumColumnsPerBlock(Integer numColumnsPerBlock) {
        this.numColumnsPerBlock = numColumnsPerBlock;
    }

    public MatrixCharacteristics asMatrixCharacteristics() {
        if (this.numRows == null && this.numColumns == null && this.numRowsPerBlock == null && this.numColumnsPerBlock == null && this.numNonZeros == null) {
            return null;
        }
        long nr = this.numRows == null ? -1L : this.numRows;
        long nc = this.numColumns == null ? -1L : this.numColumns;
        int nrpb = this.numRowsPerBlock == null ? ConfigurationManager.getBlocksize() : this.numRowsPerBlock;
        int ncpb = this.numColumnsPerBlock == null ? ConfigurationManager.getBlocksize() : this.numColumnsPerBlock;
        long nnz = this.numNonZeros == null ? -1L : this.numNonZeros;
        return new MatrixCharacteristics(nr, nc, nrpb, ncpb, nnz);
    }

    public String toString() {
        return "rows: " + this.fieldDisplay(this.numRows) + ", columns: " + this.fieldDisplay(this.numColumns) + ", non-zeros: " + this.fieldDisplay(this.numNonZeros) + ", rows per block: " + this.fieldDisplay(this.numRowsPerBlock) + ", columns per block: " + this.fieldDisplay(this.numColumnsPerBlock);
    }

    private String fieldDisplay(Object field) {
        if (field == null) {
            return "None";
        }
        return field.toString();
    }

    public MatrixFormat getMatrixFormat() {
        return this.matrixFormat;
    }

    public void setMatrixFormat(MatrixFormat matrixFormat) {
        this.matrixFormat = matrixFormat;
    }
}

