/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.api.mlcontext;

import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.sysml.api.mlcontext.BinaryBlockMatrix;
import org.apache.sysml.api.mlcontext.MLContextConversionUtil;
import org.apache.sysml.api.mlcontext.MatrixMetadata;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;

public class Matrix {
    private MatrixObject matrixObject;
    private SparkExecutionContext sparkExecutionContext;

    public Matrix(MatrixObject matrixObject, SparkExecutionContext sparkExecutionContext) {
        this.matrixObject = matrixObject;
        this.sparkExecutionContext = sparkExecutionContext;
    }

    public MatrixObject toMatrixObject() {
        return this.matrixObject;
    }

    public double[][] to2DDoubleArray() {
        return MLContextConversionUtil.matrixObjectTo2DDoubleArray(this.matrixObject);
    }

    public JavaRDD<String> toJavaRDDStringIJV() {
        return MLContextConversionUtil.matrixObjectToJavaRDDStringIJV(this.matrixObject);
    }

    public JavaRDD<String> toJavaRDDStringCSV() {
        return MLContextConversionUtil.matrixObjectToJavaRDDStringCSV(this.matrixObject);
    }

    public RDD<String> toRDDStringCSV() {
        return MLContextConversionUtil.matrixObjectToRDDStringCSV(this.matrixObject);
    }

    public RDD<String> toRDDStringIJV() {
        return MLContextConversionUtil.matrixObjectToRDDStringIJV(this.matrixObject);
    }

    public Dataset<Row> toDF() {
        return MLContextConversionUtil.matrixObjectToDataFrame(this.matrixObject, this.sparkExecutionContext, false);
    }

    public Dataset<Row> toDFDoubleWithIDColumn() {
        return MLContextConversionUtil.matrixObjectToDataFrame(this.matrixObject, this.sparkExecutionContext, false);
    }

    public Dataset<Row> toDFDoubleNoIDColumn() {
        Dataset<Row> df = MLContextConversionUtil.matrixObjectToDataFrame(this.matrixObject, this.sparkExecutionContext, false);
        return df.drop("__INDEX");
    }

    public Dataset<Row> toDFVectorWithIDColumn() {
        return MLContextConversionUtil.matrixObjectToDataFrame(this.matrixObject, this.sparkExecutionContext, true);
    }

    public Dataset<Row> toDFVectorNoIDColumn() {
        Dataset<Row> df = MLContextConversionUtil.matrixObjectToDataFrame(this.matrixObject, this.sparkExecutionContext, true);
        return df.drop("__INDEX");
    }

    public BinaryBlockMatrix toBinaryBlockMatrix() {
        return MLContextConversionUtil.matrixObjectToBinaryBlockMatrix(this.matrixObject, this.sparkExecutionContext);
    }

    public MatrixMetadata getMatrixMetadata() {
        return new MatrixMetadata(this.matrixObject.getMatrixCharacteristics());
    }

    public String toString() {
        return this.matrixObject.toString();
    }
}

