/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.api.mlcontext;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.sysml.api.mlcontext.BinaryBlockFrame;
import org.apache.sysml.api.mlcontext.BinaryBlockMatrix;
import org.apache.sysml.api.mlcontext.FrameFormat;
import org.apache.sysml.api.mlcontext.FrameMetadata;
import org.apache.sysml.api.mlcontext.FrameSchema;
import org.apache.sysml.api.mlcontext.MLContextException;
import org.apache.sysml.api.mlcontext.MLContextUtil;
import org.apache.sysml.api.mlcontext.MatrixFormat;
import org.apache.sysml.api.mlcontext.MatrixMetadata;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.CacheException;
import org.apache.sysml.runtime.controlprogram.caching.FrameObject;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.instructions.spark.data.DatasetObject;
import org.apache.sysml.runtime.instructions.spark.data.RDDObject;
import org.apache.sysml.runtime.instructions.spark.functions.ConvertStringToLongTextPair;
import org.apache.sysml.runtime.instructions.spark.functions.CopyTextInputFunction;
import org.apache.sysml.runtime.instructions.spark.utils.FrameRDDConverterUtils;
import org.apache.sysml.runtime.instructions.spark.utils.RDDConverterUtils;
import org.apache.sysml.runtime.instructions.spark.utils.SparkUtils;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MatrixFormatMetaData;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.IJV;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.util.DataConverter;
import org.apache.sysml.runtime.util.UtilFunctions;
import scala.collection.JavaConversions;
import scala.collection.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;

public class MLContextConversionUtil {
    public static MatrixObject doubleMatrixToMatrixObject(String variableName, double[][] doubleMatrix) {
        return MLContextConversionUtil.doubleMatrixToMatrixObject(variableName, doubleMatrix, null);
    }

    public static MatrixObject doubleMatrixToMatrixObject(String variableName, double[][] doubleMatrix, MatrixMetadata matrixMetadata) {
        try {
            MatrixBlock matrixBlock = DataConverter.convertToMatrixBlock(doubleMatrix);
            MatrixCharacteristics mc = matrixMetadata != null ? matrixMetadata.asMatrixCharacteristics() : new MatrixCharacteristics(matrixBlock.getNumRows(), matrixBlock.getNumColumns(), ConfigurationManager.getBlocksize(), ConfigurationManager.getBlocksize());
            MatrixObject matrixObject = new MatrixObject(Expression.ValueType.DOUBLE, OptimizerUtils.getUniqueTempFileName(), new MatrixFormatMetaData(mc, OutputInfo.BinaryBlockOutputInfo, InputInfo.BinaryBlockInputInfo));
            matrixObject.acquireModify(matrixBlock);
            matrixObject.release();
            return matrixObject;
        }
        catch (DMLRuntimeException e) {
            throw new MLContextException("Exception converting double[][] array to MatrixObject", e);
        }
    }

    public static MatrixObject urlToMatrixObject(String variableName, URL url, MatrixMetadata matrixMetadata) {
        try {
            InputStream is = url.openStream();
            List lines = IOUtils.readLines((InputStream)is);
            JavaRDD javaRDD = MLContextConversionUtil.jsc().parallelize(lines);
            if (matrixMetadata == null || matrixMetadata.getMatrixFormat() == MatrixFormat.CSV) {
                return MLContextConversionUtil.javaRDDStringCSVToMatrixObject(variableName, (JavaRDD<String>)javaRDD, matrixMetadata);
            }
            if (matrixMetadata.getMatrixFormat() == MatrixFormat.IJV) {
                return MLContextConversionUtil.javaRDDStringIJVToMatrixObject(variableName, (JavaRDD<String>)javaRDD, matrixMetadata);
            }
            return null;
        }
        catch (Exception e) {
            throw new MLContextException("Exception converting URL to MatrixObject", e);
        }
    }

    public static MatrixObject matrixBlockToMatrixObject(String variableName, MatrixBlock matrixBlock, MatrixMetadata matrixMetadata) {
        try {
            MatrixCharacteristics mc = matrixMetadata != null ? matrixMetadata.asMatrixCharacteristics() : new MatrixCharacteristics();
            MatrixObject matrixObject = new MatrixObject(Expression.ValueType.DOUBLE, OptimizerUtils.getUniqueTempFileName(), new MatrixFormatMetaData(mc, OutputInfo.BinaryBlockOutputInfo, InputInfo.BinaryBlockInputInfo));
            matrixObject.acquireModify(matrixBlock);
            matrixObject.release();
            return matrixObject;
        }
        catch (CacheException e) {
            throw new MLContextException("Exception converting MatrixBlock to MatrixObject", e);
        }
    }

    public static FrameObject frameBlockToFrameObject(String variableName, FrameBlock frameBlock, FrameMetadata frameMetadata) {
        try {
            MatrixCharacteristics mc = frameMetadata != null ? frameMetadata.asMatrixCharacteristics() : new MatrixCharacteristics();
            MatrixFormatMetaData mtd = new MatrixFormatMetaData(mc, OutputInfo.BinaryBlockOutputInfo, InputInfo.BinaryBlockInputInfo);
            FrameObject frameObject = new FrameObject(OptimizerUtils.getUniqueTempFileName(), mtd, frameMetadata.getFrameSchema().getSchema().toArray(new Expression.ValueType[0]));
            frameObject.acquireModify(frameBlock);
            frameObject.release();
            return frameObject;
        }
        catch (CacheException e) {
            throw new MLContextException("Exception converting FrameBlock to FrameObject", e);
        }
    }

    public static MatrixObject binaryBlocksToMatrixObject(String variableName, JavaPairRDD<MatrixIndexes, MatrixBlock> binaryBlocks) {
        return MLContextConversionUtil.binaryBlocksToMatrixObject(variableName, binaryBlocks, null);
    }

    public static MatrixObject binaryBlocksToMatrixObject(String variableName, JavaPairRDD<MatrixIndexes, MatrixBlock> binaryBlocks, MatrixMetadata matrixMetadata) {
        return MLContextConversionUtil.binaryBlocksToMatrixObject(variableName, binaryBlocks, matrixMetadata, true);
    }

    private static MatrixObject binaryBlocksToMatrixObject(String variableName, JavaPairRDD<MatrixIndexes, MatrixBlock> binaryBlocks, MatrixMetadata matrixMetadata, boolean copy) {
        MatrixCharacteristics mc = matrixMetadata != null ? matrixMetadata.asMatrixCharacteristics() : new MatrixCharacteristics();
        JavaPairRDD<MatrixIndexes, MatrixBlock> javaPairRdd = SparkUtils.copyBinaryBlockMatrix(binaryBlocks, copy);
        MatrixObject matrixObject = new MatrixObject(Expression.ValueType.DOUBLE, OptimizerUtils.getUniqueTempFileName(), new MatrixFormatMetaData(mc, OutputInfo.BinaryBlockOutputInfo, InputInfo.BinaryBlockInputInfo));
        matrixObject.setRDDHandle(new RDDObject(javaPairRdd, variableName));
        return matrixObject;
    }

    public static FrameObject binaryBlocksToFrameObject(String variableName, JavaPairRDD<Long, FrameBlock> binaryBlocks) {
        return MLContextConversionUtil.binaryBlocksToFrameObject(variableName, binaryBlocks, null);
    }

    public static FrameObject binaryBlocksToFrameObject(String variableName, JavaPairRDD<Long, FrameBlock> binaryBlocks, FrameMetadata frameMetadata) {
        MatrixCharacteristics mc = frameMetadata != null ? frameMetadata.asMatrixCharacteristics() : new MatrixCharacteristics();
        FrameObject frameObject = new FrameObject(OptimizerUtils.getUniqueTempFileName(), new MatrixFormatMetaData(mc, OutputInfo.BinaryBlockOutputInfo, InputInfo.BinaryBlockInputInfo), frameMetadata.getFrameSchema().getSchema().toArray(new Expression.ValueType[0]));
        frameObject.setRDDHandle(new RDDObject(binaryBlocks, variableName));
        return frameObject;
    }

    public static MatrixObject dataFrameToMatrixObject(String variableName, Dataset<Row> dataFrame) {
        return MLContextConversionUtil.dataFrameToMatrixObject(variableName, dataFrame, null);
    }

    public static MatrixObject dataFrameToMatrixObject(String variableName, Dataset<Row> dataFrame, MatrixMetadata matrixMetadata) {
        matrixMetadata = matrixMetadata != null ? matrixMetadata : new MatrixMetadata();
        JavaPairRDD<MatrixIndexes, MatrixBlock> binaryBlock = MLContextConversionUtil.dataFrameToMatrixBinaryBlocks(dataFrame, matrixMetadata);
        MatrixObject mo = MLContextConversionUtil.binaryBlocksToMatrixObject(variableName, binaryBlock, matrixMetadata, false);
        mo.getRDDHandle().addLineageChild(new DatasetObject(dataFrame, variableName, MLContextConversionUtil.isDataFrameWithIDColumn(matrixMetadata), MLContextConversionUtil.isVectorBasedDataFrame(matrixMetadata)));
        return mo;
    }

    public static FrameObject dataFrameToFrameObject(String variableName, Dataset<Row> dataFrame) {
        return MLContextConversionUtil.dataFrameToFrameObject(variableName, dataFrame, null);
    }

    public static FrameObject dataFrameToFrameObject(String variableName, Dataset<Row> dataFrame, FrameMetadata frameMetadata) {
        try {
            if (frameMetadata == null) {
                frameMetadata = new FrameMetadata();
            }
            MLContextConversionUtil.determineFrameFormatIfNeeded(dataFrame, frameMetadata);
            boolean containsID = MLContextConversionUtil.isDataFrameWithIDColumn(frameMetadata);
            MatrixCharacteristics mc = frameMetadata.asMatrixCharacteristics();
            if (mc == null) {
                mc = new MatrixCharacteristics();
            }
            Pair<String[], Expression.ValueType[]> ret = new Pair<String[], Expression.ValueType[]>();
            JavaPairRDD<Long, FrameBlock> binaryBlock = FrameRDDConverterUtils.dataFrameToBinaryBlock(MLContextConversionUtil.jsc(), dataFrame, mc, containsID, ret);
            frameMetadata.setFrameSchema(new FrameSchema(Arrays.asList((Object[])ret.getValue())));
            frameMetadata.setMatrixCharacteristics(mc);
            return MLContextConversionUtil.binaryBlocksToFrameObject(variableName, binaryBlock, frameMetadata);
        }
        catch (DMLRuntimeException e) {
            throw new MLContextException("Exception converting DataFrame to FrameObject", e);
        }
    }

    public static JavaPairRDD<MatrixIndexes, MatrixBlock> dataFrameToMatrixBinaryBlocks(Dataset<Row> dataFrame) {
        return MLContextConversionUtil.dataFrameToMatrixBinaryBlocks(dataFrame, null);
    }

    public static JavaPairRDD<MatrixIndexes, MatrixBlock> dataFrameToMatrixBinaryBlocks(Dataset<Row> dataFrame, MatrixMetadata matrixMetadata) {
        MLContextConversionUtil.determineMatrixFormatIfNeeded(dataFrame, matrixMetadata);
        MatrixCharacteristics mc = matrixMetadata != null && matrixMetadata.asMatrixCharacteristics() != null ? matrixMetadata.asMatrixCharacteristics() : new MatrixCharacteristics();
        boolean containsID = MLContextConversionUtil.isDataFrameWithIDColumn(matrixMetadata);
        boolean isVector = MLContextConversionUtil.isVectorBasedDataFrame(matrixMetadata);
        JavaPairRDD<MatrixIndexes, MatrixBlock> out = RDDConverterUtils.dataFrameToBinaryBlock(MLContextConversionUtil.jsc(), dataFrame, mc, containsID, isVector);
        if (matrixMetadata != null) {
            matrixMetadata.setMatrixCharacteristics(mc);
        }
        return out;
    }

    public static JavaPairRDD<Long, FrameBlock> dataFrameToFrameBinaryBlocks(Dataset<Row> dataFrame, FrameMetadata frameMetadata) {
        throw new MLContextException("dataFrameToFrameBinaryBlocks is unimplemented");
    }

    public static void determineMatrixFormatIfNeeded(Dataset<Row> dataFrame, MatrixMetadata matrixMetadata) {
        MatrixFormat matrixFormat = matrixMetadata.getMatrixFormat();
        if (matrixFormat != null) {
            return;
        }
        StructType schema = dataFrame.schema();
        boolean hasID = false;
        try {
            schema.fieldIndex("__INDEX");
            hasID = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        StructField[] fields = schema.fields();
        MatrixFormat mf = null;
        mf = hasID ? (fields[1].dataType() instanceof VectorUDT ? MatrixFormat.DF_VECTOR_WITH_INDEX : MatrixFormat.DF_DOUBLES_WITH_INDEX) : (fields[0].dataType() instanceof VectorUDT ? MatrixFormat.DF_VECTOR : MatrixFormat.DF_DOUBLES);
        if (mf == null) {
            throw new MLContextException("DataFrame format not recognized as an accepted SystemML MatrixFormat");
        }
        matrixMetadata.setMatrixFormat(mf);
    }

    public static void determineFrameFormatIfNeeded(Dataset<Row> dataFrame, FrameMetadata frameMetadata) {
        FrameFormat frameFormat = frameMetadata.getFrameFormat();
        if (frameFormat != null) {
            return;
        }
        StructType schema = dataFrame.schema();
        boolean hasID = false;
        try {
            schema.fieldIndex("__INDEX");
            hasID = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        FrameFormat ff = hasID ? FrameFormat.DF_WITH_INDEX : FrameFormat.DF;
        frameMetadata.setFrameFormat(ff);
    }

    public static boolean isDataFrameWithIDColumn(MatrixMetadata matrixMetadata) {
        return matrixMetadata != null && matrixMetadata.getMatrixFormat() != null && matrixMetadata.getMatrixFormat().hasIDColumn();
    }

    public static boolean isDataFrameWithIDColumn(FrameMetadata frameMetadata) {
        return frameMetadata != null && frameMetadata.getFrameFormat() != null && frameMetadata.getFrameFormat().hasIDColumn();
    }

    public static boolean isVectorBasedDataFrame(MatrixMetadata matrixMetadata) {
        return matrixMetadata != null && matrixMetadata.getMatrixFormat() != null && matrixMetadata.getMatrixFormat().isVectorBased();
    }

    public static MatrixObject javaRDDStringCSVToMatrixObject(String variableName, JavaRDD<String> javaRDD) {
        return MLContextConversionUtil.javaRDDStringCSVToMatrixObject(variableName, javaRDD, null);
    }

    public static MatrixObject javaRDDStringCSVToMatrixObject(String variableName, JavaRDD<String> javaRDD, MatrixMetadata matrixMetadata) {
        JavaPairRDD javaPairRDD = javaRDD.mapToPair((PairFunction)new ConvertStringToLongTextPair());
        MatrixCharacteristics mc = matrixMetadata != null ? matrixMetadata.asMatrixCharacteristics() : new MatrixCharacteristics();
        MatrixObject matrixObject = new MatrixObject(Expression.ValueType.DOUBLE, OptimizerUtils.getUniqueTempFileName(), new MatrixFormatMetaData(mc, OutputInfo.CSVOutputInfo, InputInfo.CSVInputInfo));
        JavaPairRDD javaPairRDD2 = javaPairRDD.mapToPair((PairFunction)new CopyTextInputFunction());
        matrixObject.setRDDHandle(new RDDObject(javaPairRDD2, variableName));
        return matrixObject;
    }

    public static FrameObject javaRDDStringCSVToFrameObject(String variableName, JavaRDD<String> javaRDD) {
        return MLContextConversionUtil.javaRDDStringCSVToFrameObject(variableName, javaRDD, null);
    }

    public static FrameObject javaRDDStringCSVToFrameObject(String variableName, JavaRDD<String> javaRDD, FrameMetadata frameMetadata) {
        JavaPairRDD<Long, FrameBlock> rdd;
        JavaPairRDD javaPairRDD = javaRDD.mapToPair((PairFunction)new ConvertStringToLongTextPair());
        MatrixCharacteristics mc = frameMetadata != null ? frameMetadata.asMatrixCharacteristics() : new MatrixCharacteristics();
        JavaPairRDD javaPairRDDText = javaPairRDD.mapToPair((PairFunction)new CopyTextInputFunction());
        FrameObject frameObject = new FrameObject(OptimizerUtils.getUniqueTempFileName(), new MatrixFormatMetaData(mc, OutputInfo.BinaryBlockOutputInfo, InputInfo.BinaryBlockInputInfo), frameMetadata.getFrameSchema().getSchema().toArray(new Expression.ValueType[0]));
        try {
            rdd = FrameRDDConverterUtils.csvToBinaryBlock(MLContextConversionUtil.jsc(), (JavaPairRDD<LongWritable, Text>)javaPairRDDText, mc, frameObject.getSchema(), false, ",", false, -1.0);
        }
        catch (DMLRuntimeException e) {
            e.printStackTrace();
            return null;
        }
        frameObject.setRDDHandle(new RDDObject(rdd, variableName));
        return frameObject;
    }

    public static MatrixObject javaRDDStringIJVToMatrixObject(String variableName, JavaRDD<String> javaRDD, MatrixMetadata matrixMetadata) {
        JavaPairRDD javaPairRDD = javaRDD.mapToPair((PairFunction)new ConvertStringToLongTextPair());
        MatrixCharacteristics mc = matrixMetadata != null ? matrixMetadata.asMatrixCharacteristics() : new MatrixCharacteristics();
        MatrixObject matrixObject = new MatrixObject(Expression.ValueType.DOUBLE, OptimizerUtils.getUniqueTempFileName(), new MatrixFormatMetaData(mc, OutputInfo.TextCellOutputInfo, InputInfo.TextCellInputInfo));
        JavaPairRDD javaPairRDD2 = javaPairRDD.mapToPair((PairFunction)new CopyTextInputFunction());
        matrixObject.setRDDHandle(new RDDObject(javaPairRDD2, variableName));
        return matrixObject;
    }

    public static FrameObject javaRDDStringIJVToFrameObject(String variableName, JavaRDD<String> javaRDD, FrameMetadata frameMetadata) {
        JavaPairRDD<Long, FrameBlock> rdd;
        JavaPairRDD javaPairRDD = javaRDD.mapToPair((PairFunction)new ConvertStringToLongTextPair());
        MatrixCharacteristics mc = frameMetadata != null ? frameMetadata.asMatrixCharacteristics() : new MatrixCharacteristics();
        JavaPairRDD javaPairRDDText = javaPairRDD.mapToPair((PairFunction)new CopyTextInputFunction());
        FrameObject frameObject = new FrameObject(OptimizerUtils.getUniqueTempFileName(), new MatrixFormatMetaData(mc, OutputInfo.BinaryBlockOutputInfo, InputInfo.BinaryBlockInputInfo), frameMetadata.getFrameSchema().getSchema().toArray(new Expression.ValueType[0]));
        try {
            Expression.ValueType[] lschema = null;
            if (lschema == null) {
                lschema = UtilFunctions.nCopies((int)mc.getCols(), Expression.ValueType.STRING);
            }
            rdd = FrameRDDConverterUtils.textCellToBinaryBlock(MLContextConversionUtil.jsc(), (JavaPairRDD<LongWritable, Text>)javaPairRDDText, mc, lschema);
        }
        catch (DMLRuntimeException e) {
            e.printStackTrace();
            return null;
        }
        frameObject.setRDDHandle(new RDDObject(rdd, variableName));
        return frameObject;
    }

    public static MatrixObject rddStringCSVToMatrixObject(String variableName, RDD<String> rdd) {
        return MLContextConversionUtil.rddStringCSVToMatrixObject(variableName, rdd, null);
    }

    public static MatrixObject rddStringCSVToMatrixObject(String variableName, RDD<String> rdd, MatrixMetadata matrixMetadata) {
        ClassTag tag = ClassTag$.MODULE$.apply(String.class);
        JavaRDD javaRDD = JavaRDD.fromRDD(rdd, (ClassTag)tag);
        return MLContextConversionUtil.javaRDDStringCSVToMatrixObject(variableName, (JavaRDD<String>)javaRDD, matrixMetadata);
    }

    public static FrameObject rddStringCSVToFrameObject(String variableName, RDD<String> rdd) {
        return MLContextConversionUtil.rddStringCSVToFrameObject(variableName, rdd, null);
    }

    public static FrameObject rddStringCSVToFrameObject(String variableName, RDD<String> rdd, FrameMetadata frameMetadata) {
        ClassTag tag = ClassTag$.MODULE$.apply(String.class);
        JavaRDD javaRDD = JavaRDD.fromRDD(rdd, (ClassTag)tag);
        return MLContextConversionUtil.javaRDDStringCSVToFrameObject(variableName, (JavaRDD<String>)javaRDD, frameMetadata);
    }

    public static MatrixObject rddStringIJVToMatrixObject(String variableName, RDD<String> rdd, MatrixMetadata matrixMetadata) {
        ClassTag tag = ClassTag$.MODULE$.apply(String.class);
        JavaRDD javaRDD = JavaRDD.fromRDD(rdd, (ClassTag)tag);
        return MLContextConversionUtil.javaRDDStringIJVToMatrixObject(variableName, (JavaRDD<String>)javaRDD, matrixMetadata);
    }

    public static FrameObject rddStringIJVToFrameObject(String variableName, RDD<String> rdd, FrameMetadata frameMetadata) {
        ClassTag tag = ClassTag$.MODULE$.apply(String.class);
        JavaRDD javaRDD = JavaRDD.fromRDD(rdd, (ClassTag)tag);
        return MLContextConversionUtil.javaRDDStringIJVToFrameObject(variableName, (JavaRDD<String>)javaRDD, frameMetadata);
    }

    public static JavaRDD<String> binaryBlockMatrixToJavaRDDStringIJV(BinaryBlockMatrix binaryBlockMatrix) {
        JavaPairRDD<MatrixIndexes, MatrixBlock> binaryBlock = binaryBlockMatrix.getBinaryBlocks();
        MatrixCharacteristics mc = binaryBlockMatrix.getMatrixCharacteristics();
        return RDDConverterUtils.binaryBlockToTextCell(binaryBlock, mc);
    }

    public static RDD<String> binaryBlockMatrixToRDDStringIJV(BinaryBlockMatrix binaryBlockMatrix) {
        JavaRDD<String> javaRDD = MLContextConversionUtil.binaryBlockMatrixToJavaRDDStringIJV(binaryBlockMatrix);
        return JavaRDD.toRDD(javaRDD);
    }

    public static JavaRDD<String> matrixObjectToJavaRDDStringCSV(MatrixObject matrixObject) {
        List<String> list = MLContextConversionUtil.matrixObjectToListStringCSV(matrixObject);
        return MLContextConversionUtil.jsc().parallelize(list);
    }

    public static JavaRDD<String> frameObjectToJavaRDDStringCSV(FrameObject frameObject, String delimiter) {
        List<String> list = MLContextConversionUtil.frameObjectToListStringCSV(frameObject, delimiter);
        return MLContextConversionUtil.jsc().parallelize(list);
    }

    public static JavaRDD<String> matrixObjectToJavaRDDStringIJV(MatrixObject matrixObject) {
        List<String> list = MLContextConversionUtil.matrixObjectToListStringIJV(matrixObject);
        return MLContextConversionUtil.jsc().parallelize(list);
    }

    public static JavaRDD<String> frameObjectToJavaRDDStringIJV(FrameObject frameObject) {
        List<String> list = MLContextConversionUtil.frameObjectToListStringIJV(frameObject);
        return MLContextConversionUtil.jsc().parallelize(list);
    }

    public static RDD<String> matrixObjectToRDDStringIJV(MatrixObject matrixObject) {
        List<String> list = MLContextConversionUtil.matrixObjectToListStringIJV(matrixObject);
        ClassTag tag = ClassTag$.MODULE$.apply(String.class);
        return MLContextConversionUtil.sc().parallelize((Seq)JavaConversions.asScalaBuffer(list), MLContextConversionUtil.sc().defaultParallelism(), tag);
    }

    public static RDD<String> frameObjectToRDDStringIJV(FrameObject frameObject) {
        List<String> list = MLContextConversionUtil.frameObjectToListStringIJV(frameObject);
        ClassTag tag = ClassTag$.MODULE$.apply(String.class);
        return MLContextConversionUtil.sc().parallelize((Seq)JavaConversions.asScalaBuffer(list), MLContextConversionUtil.sc().defaultParallelism(), tag);
    }

    public static RDD<String> matrixObjectToRDDStringCSV(MatrixObject matrixObject) {
        List<String> list = MLContextConversionUtil.matrixObjectToListStringCSV(matrixObject);
        ClassTag tag = ClassTag$.MODULE$.apply(String.class);
        return MLContextConversionUtil.sc().parallelize((Seq)JavaConversions.asScalaBuffer(list), MLContextConversionUtil.sc().defaultParallelism(), tag);
    }

    public static RDD<String> frameObjectToRDDStringCSV(FrameObject frameObject, String delimiter) {
        List<String> list = MLContextConversionUtil.frameObjectToListStringCSV(frameObject, delimiter);
        ClassTag tag = ClassTag$.MODULE$.apply(String.class);
        return MLContextConversionUtil.sc().parallelize((Seq)JavaConversions.asScalaBuffer(list), MLContextConversionUtil.sc().defaultParallelism(), tag);
    }

    public static List<String> matrixObjectToListStringCSV(MatrixObject matrixObject) {
        try {
            MatrixBlock mb = (MatrixBlock)matrixObject.acquireRead();
            int rows = mb.getNumRows();
            int cols = mb.getNumColumns();
            ArrayList<String> list = new ArrayList<String>();
            if (mb.getNonZeros() > 0L) {
                if (mb.isInSparseFormat()) {
                    Iterator<IJV> iter = mb.getSparseBlockIterator();
                    int prevCellRow = -1;
                    StringBuilder sb = null;
                    while (iter.hasNext()) {
                        IJV cell = iter.next();
                        int i = cell.getI();
                        double v = cell.getV();
                        if (i > prevCellRow) {
                            if (sb == null) {
                                sb = new StringBuilder();
                            } else {
                                list.add(sb.toString());
                                sb = new StringBuilder();
                            }
                            sb.append(v);
                            prevCellRow = i;
                            continue;
                        }
                        if (i != prevCellRow) continue;
                        sb.append(",");
                        sb.append(v);
                    }
                    if (sb != null) {
                        list.add(sb.toString());
                    }
                } else {
                    for (int i = 0; i < rows; ++i) {
                        StringBuilder sb = new StringBuilder();
                        for (int j = 0; j < cols; ++j) {
                            if (j > 0) {
                                sb.append(",");
                            }
                            sb.append(mb.getValueDenseUnsafe(i, j));
                        }
                        list.add(sb.toString());
                    }
                }
            }
            matrixObject.release();
            return list;
        }
        catch (CacheException e) {
            throw new MLContextException("Cache exception while converting matrix object to List<String> CSV format", e);
        }
    }

    public static List<String> frameObjectToListStringCSV(FrameObject frameObject, String delimiter) {
        try {
            FrameBlock fb = (FrameBlock)frameObject.acquireRead();
            int rows = fb.getNumRows();
            int cols = fb.getNumColumns();
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < rows; ++i) {
                StringBuilder sb = new StringBuilder();
                for (int j = 0; j < cols; ++j) {
                    if (j > 0) {
                        sb.append(delimiter);
                    }
                    if (fb.get(i, j) == null) continue;
                    sb.append(fb.get(i, j));
                }
                list.add(sb.toString());
            }
            frameObject.release();
            return list;
        }
        catch (CacheException e) {
            throw new MLContextException("Cache exception while converting frame object to List<String> CSV format", e);
        }
    }

    public static List<String> matrixObjectToListStringIJV(MatrixObject matrixObject) {
        try {
            MatrixBlock mb = (MatrixBlock)matrixObject.acquireRead();
            int rows = mb.getNumRows();
            int cols = mb.getNumColumns();
            ArrayList<String> list = new ArrayList<String>();
            if (mb.getNonZeros() > 0L) {
                if (mb.isInSparseFormat()) {
                    Iterator<IJV> iter = mb.getSparseBlockIterator();
                    StringBuilder sb = null;
                    while (iter.hasNext()) {
                        IJV cell = iter.next();
                        sb = new StringBuilder();
                        sb.append(cell.getI() + 1);
                        sb.append(" ");
                        sb.append(cell.getJ() + 1);
                        sb.append(" ");
                        sb.append(cell.getV());
                        list.add(sb.toString());
                    }
                } else {
                    StringBuilder sb = null;
                    for (int i = 0; i < rows; ++i) {
                        sb = new StringBuilder();
                        for (int j = 0; j < cols; ++j) {
                            sb = new StringBuilder();
                            sb.append(i + 1);
                            sb.append(" ");
                            sb.append(j + 1);
                            sb.append(" ");
                            sb.append(mb.getValueDenseUnsafe(i, j));
                            list.add(sb.toString());
                        }
                    }
                }
            }
            matrixObject.release();
            return list;
        }
        catch (CacheException e) {
            throw new MLContextException("Cache exception while converting matrix object to List<String> IJV format", e);
        }
    }

    public static List<String> frameObjectToListStringIJV(FrameObject frameObject) {
        try {
            FrameBlock fb = (FrameBlock)frameObject.acquireRead();
            int rows = fb.getNumRows();
            int cols = fb.getNumColumns();
            ArrayList<String> list = new ArrayList<String>();
            StringBuilder sb = null;
            for (int i = 0; i < rows; ++i) {
                sb = new StringBuilder();
                for (int j = 0; j < cols; ++j) {
                    if (fb.get(i, j) == null) continue;
                    sb = new StringBuilder();
                    sb.append(i + 1);
                    sb.append(" ");
                    sb.append(j + 1);
                    sb.append(" ");
                    sb.append(fb.get(i, j));
                    list.add(sb.toString());
                }
            }
            frameObject.release();
            return list;
        }
        catch (CacheException e) {
            throw new MLContextException("Cache exception while converting frame object to List<String> IJV format", e);
        }
    }

    public static double[][] matrixObjectTo2DDoubleArray(MatrixObject matrixObject) {
        try {
            MatrixBlock mb = (MatrixBlock)matrixObject.acquireRead();
            double[][] matrix = DataConverter.convertToDoubleMatrix(mb);
            matrixObject.release();
            return matrix;
        }
        catch (CacheException e) {
            throw new MLContextException("Cache exception while converting matrix object to double matrix", e);
        }
    }

    public static Dataset<Row> matrixObjectToDataFrame(MatrixObject matrixObject, SparkExecutionContext sparkExecutionContext, boolean isVectorDF) {
        try {
            JavaPairRDD<?, ?> binaryBlockMatrix = sparkExecutionContext.getRDDHandleForMatrixObject(matrixObject, InputInfo.BinaryBlockInputInfo);
            MatrixCharacteristics mc = matrixObject.getMatrixCharacteristics();
            return RDDConverterUtils.binaryBlockToDataFrame(MLContextConversionUtil.spark(), binaryBlockMatrix, mc, isVectorDF);
        }
        catch (DMLRuntimeException e) {
            throw new MLContextException("DMLRuntimeException while converting matrix object to DataFrame", e);
        }
    }

    public static Dataset<Row> frameObjectToDataFrame(FrameObject frameObject, SparkExecutionContext sparkExecutionContext) {
        try {
            JavaPairRDD<?, ?> binaryBlockFrame = sparkExecutionContext.getRDDHandleForFrameObject(frameObject, InputInfo.BinaryBlockInputInfo);
            MatrixCharacteristics mc = frameObject.getMatrixCharacteristics();
            return FrameRDDConverterUtils.binaryBlockToDataFrame(MLContextConversionUtil.spark(), binaryBlockFrame, mc, frameObject.getSchema());
        }
        catch (DMLRuntimeException e) {
            throw new MLContextException("DMLRuntimeException while converting frame object to DataFrame", e);
        }
    }

    public static BinaryBlockMatrix matrixObjectToBinaryBlockMatrix(MatrixObject matrixObject, SparkExecutionContext sparkExecutionContext) {
        try {
            JavaPairRDD<?, ?> binaryBlock = sparkExecutionContext.getRDDHandleForMatrixObject(matrixObject, InputInfo.BinaryBlockInputInfo);
            MatrixCharacteristics matrixCharacteristics = matrixObject.getMatrixCharacteristics();
            return new BinaryBlockMatrix(binaryBlock, matrixCharacteristics);
        }
        catch (DMLRuntimeException e) {
            throw new MLContextException("DMLRuntimeException while converting matrix object to BinaryBlockMatrix", e);
        }
    }

    public static BinaryBlockFrame frameObjectToBinaryBlockFrame(FrameObject frameObject, SparkExecutionContext sparkExecutionContext) {
        try {
            JavaPairRDD<?, ?> binaryBlock = sparkExecutionContext.getRDDHandleForFrameObject(frameObject, InputInfo.BinaryBlockInputInfo);
            MatrixCharacteristics matrixCharacteristics = frameObject.getMatrixCharacteristics();
            FrameSchema fs = new FrameSchema(Arrays.asList(frameObject.getSchema()));
            FrameMetadata fm = new FrameMetadata(fs, matrixCharacteristics);
            return new BinaryBlockFrame(binaryBlock, fm);
        }
        catch (DMLRuntimeException e) {
            throw new MLContextException("DMLRuntimeException while converting frame object to BinaryBlockFrame", e);
        }
    }

    public static String[][] frameObjectTo2DStringArray(FrameObject frameObject) {
        try {
            FrameBlock fb = (FrameBlock)frameObject.acquireRead();
            String[][] frame = DataConverter.convertToStringFrame(fb);
            frameObject.release();
            return frame;
        }
        catch (CacheException e) {
            throw new MLContextException("CacheException while converting frame object to 2D string array", e);
        }
        catch (DMLRuntimeException e) {
            throw new MLContextException("DMLRuntimeException while converting frame object to 2D string array", e);
        }
    }

    public static JavaSparkContext jsc() {
        return MLContextUtil.getJavaSparkContextFromProxy();
    }

    public static SparkContext sc() {
        return MLContextUtil.getSparkContextFromProxy();
    }

    public static SparkSession spark() {
        return MLContextUtil.getSparkSessionFromProxy();
    }
}

