/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.api.mlcontext;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.sysml.api.mlcontext.FrameMetadata;
import org.apache.sysml.api.mlcontext.FrameSchema;
import org.apache.sysml.api.mlcontext.MLContextConversionUtil;
import org.apache.sysml.api.mlcontext.MLContextException;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.FrameBlock;

public class BinaryBlockFrame {
    JavaPairRDD<Long, FrameBlock> binaryBlocks;
    FrameMetadata frameMetadata;

    public BinaryBlockFrame(Dataset<Row> dataFrame, FrameMetadata frameMetadata) {
        this.frameMetadata = frameMetadata;
        this.binaryBlocks = MLContextConversionUtil.dataFrameToFrameBinaryBlocks(dataFrame, frameMetadata);
    }

    public BinaryBlockFrame(Dataset<Row> dataFrame, long numRows, long numCols) {
        this(dataFrame, new FrameMetadata(numRows, (Long)numCols, (Integer)ConfigurationManager.getBlocksize(), (Integer)ConfigurationManager.getBlocksize()));
    }

    public BinaryBlockFrame(Dataset<Row> dataFrame) {
        this(dataFrame, new FrameMetadata());
    }

    public BinaryBlockFrame(JavaPairRDD<Long, FrameBlock> binaryBlocks, MatrixCharacteristics matrixCharacteristics) {
        this.binaryBlocks = binaryBlocks;
        this.frameMetadata = new FrameMetadata(matrixCharacteristics);
    }

    public BinaryBlockFrame(JavaPairRDD<Long, FrameBlock> binaryBlocks, FrameMetadata frameMetadata) {
        this.binaryBlocks = binaryBlocks;
        this.frameMetadata = frameMetadata;
    }

    public JavaPairRDD<Long, FrameBlock> getBinaryBlocks() {
        return this.binaryBlocks;
    }

    public FrameBlock getFrameBlock() {
        try {
            MatrixCharacteristics mc = this.getMatrixCharacteristics();
            FrameSchema frameSchema = this.frameMetadata.getFrameSchema();
            return SparkExecutionContext.toFrameBlock(this.binaryBlocks, frameSchema.getSchema().toArray(new Expression.ValueType[0]), (int)mc.getRows(), (int)mc.getCols());
        }
        catch (DMLRuntimeException e) {
            throw new MLContextException("Exception while getting FrameBlock from binary-block frame", e);
        }
    }

    public MatrixCharacteristics getMatrixCharacteristics() {
        return this.frameMetadata.asMatrixCharacteristics();
    }

    public FrameMetadata getFrameMetadata() {
        return this.frameMetadata;
    }

    public void setFrameMetadata(FrameMetadata frameMetadata) {
        this.frameMetadata = frameMetadata;
    }

    public void setBinaryBlocks(JavaPairRDD<Long, FrameBlock> binaryBlocks) {
        this.binaryBlocks = binaryBlocks;
    }

    public String toString() {
        if (this.frameMetadata != null) {
            return this.frameMetadata.toString();
        }
        return super.toString();
    }
}

