/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.api.jmlc;

import java.util.HashMap;
import java.util.Set;
import org.apache.sysml.api.DMLException;
import org.apache.sysml.runtime.controlprogram.caching.FrameObject;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.util.DataConverter;

public class ResultVariables {
    private HashMap<String, Data> _out = new HashMap();

    public Set<String> getVariableNames() {
        return this._out.keySet();
    }

    public int size() {
        return this._out.size();
    }

    public double[][] getMatrix(String varname) throws DMLException {
        if (!this._out.containsKey(varname)) {
            throw new DMLException("Non-existent output variable: " + varname);
        }
        double[][] ret = null;
        Data dat = this._out.get(varname);
        if (!(dat instanceof MatrixObject)) {
            throw new DMLException("Expected matrix result '" + varname + "' not a matrix.");
        }
        MatrixObject mo = (MatrixObject)dat;
        MatrixBlock mb = (MatrixBlock)mo.acquireRead();
        ret = DataConverter.convertToDoubleMatrix(mb);
        mo.release();
        return ret;
    }

    public String[][] getFrame(String varname) throws DMLException {
        if (!this._out.containsKey(varname)) {
            throw new DMLException("Non-existent output variable: " + varname);
        }
        Data dat = this._out.get(varname);
        if (!(dat instanceof FrameObject)) {
            throw new DMLException("Expected frame result '" + varname + "' not a frame.");
        }
        FrameObject fo = (FrameObject)dat;
        FrameBlock frame = (FrameBlock)fo.acquireRead();
        String[][] ret = DataConverter.convertToStringFrame(frame);
        fo.release();
        return ret;
    }

    public double getDouble(String varname) throws DMLException {
        ScalarObject sObj = this.getScalarObject(varname);
        return sObj.getDoubleValue();
    }

    public boolean getBoolean(String varname) throws DMLException {
        ScalarObject sObj = this.getScalarObject(varname);
        return sObj.getBooleanValue();
    }

    public long getLong(String varname) throws DMLException {
        ScalarObject sObj = this.getScalarObject(varname);
        return sObj.getLongValue();
    }

    public String getString(String varname) throws DMLException {
        ScalarObject sObj = this.getScalarObject(varname);
        return sObj.getStringValue();
    }

    public ScalarObject getScalarObject(String varname) throws DMLException {
        if (!this._out.containsKey(varname)) {
            throw new DMLException("Non-existent output variable: " + varname);
        }
        Data dat = this._out.get(varname);
        if (!(dat instanceof ScalarObject)) {
            throw new DMLException("Expected scalar result '" + varname + "' not a scalar.");
        }
        return (ScalarObject)dat;
    }

    protected void addResult(String ovar, Data data) {
        this._out.put(ovar, data);
    }
}

