/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.api.jmlc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.sysml.runtime.controlprogram.ForProgramBlock;
import org.apache.sysml.runtime.controlprogram.FunctionProgramBlock;
import org.apache.sysml.runtime.controlprogram.IfProgramBlock;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.ProgramBlock;
import org.apache.sysml.runtime.controlprogram.WhileProgramBlock;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.cp.VariableCPInstruction;

public class JMLCUtils {
    public static void cleanupRuntimeProgram(Program prog, String[] outputs) {
        HashMap<String, FunctionProgramBlock> funcMap = prog.getFunctionProgramBlocks();
        if (funcMap != null && !funcMap.isEmpty()) {
            for (Map.Entry entry : funcMap.entrySet()) {
                FunctionProgramBlock fpb = (FunctionProgramBlock)entry.getValue();
                for (ProgramBlock pb : fpb.getChildBlocks()) {
                    JMLCUtils.rCleanupRuntimeProgram(pb, outputs);
                }
            }
        }
        for (ProgramBlock programBlock : prog.getProgramBlocks()) {
            JMLCUtils.rCleanupRuntimeProgram(programBlock, outputs);
        }
    }

    public static void rCleanupRuntimeProgram(ProgramBlock pb, String[] outputs) {
        if (pb instanceof WhileProgramBlock) {
            WhileProgramBlock wpb = (WhileProgramBlock)pb;
            for (ProgramBlock pbc : wpb.getChildBlocks()) {
                JMLCUtils.rCleanupRuntimeProgram(pbc, outputs);
            }
        } else if (pb instanceof IfProgramBlock) {
            IfProgramBlock ipb = (IfProgramBlock)pb;
            for (ProgramBlock pbc : ipb.getChildBlocksIfBody()) {
                JMLCUtils.rCleanupRuntimeProgram(pbc, outputs);
            }
            for (ProgramBlock pbc : ipb.getChildBlocksElseBody()) {
                JMLCUtils.rCleanupRuntimeProgram(pbc, outputs);
            }
        } else if (pb instanceof ForProgramBlock) {
            ForProgramBlock fpb = (ForProgramBlock)pb;
            for (ProgramBlock pbc : fpb.getChildBlocks()) {
                JMLCUtils.rCleanupRuntimeProgram(pbc, outputs);
            }
        } else {
            ArrayList<Instruction> tmp = pb.getInstructions();
            JMLCUtils.cleanupRuntimeInstructions(tmp, outputs);
        }
    }

    public static ArrayList<Instruction> cleanupRuntimeInstructions(ArrayList<Instruction> insts, String[] outputs) {
        block0: for (int i = 0; i < insts.size(); ++i) {
            Instruction linst = insts.get(i);
            if (!(linst instanceof VariableCPInstruction) || !((VariableCPInstruction)linst).isRemoveVariable()) continue;
            VariableCPInstruction varinst = (VariableCPInstruction)linst;
            for (String var : outputs) {
                if (!varinst.isRemoveVariable(var)) continue;
                insts.remove(i);
                --i;
                continue block0;
            }
        }
        return insts;
    }
}

