/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.api;

import java.util.Map;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import org.apache.sysml.api.MLBlock;
import org.apache.sysml.api.MLContext;
import org.apache.sysml.api.MLMatrix;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.instructions.spark.functions.GetMLBlock;
import org.apache.sysml.runtime.instructions.spark.utils.FrameRDDConverterUtils;
import org.apache.sysml.runtime.instructions.spark.utils.RDDConverterUtils;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.CSVFileFormatProperties;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;

@Deprecated
public class MLOutput {
    Map<String, JavaPairRDD<?, ?>> _outputs;
    private Map<String, MatrixCharacteristics> _outMetadata = null;

    public MLOutput(Map<String, JavaPairRDD<?, ?>> outputs, Map<String, MatrixCharacteristics> outMetadata) {
        this._outputs = outputs;
        this._outMetadata = outMetadata;
    }

    public MatrixBlock getMatrixBlock(String varName) throws DMLRuntimeException {
        MatrixCharacteristics mc = this.getMatrixCharacteristics(varName);
        return SparkExecutionContext.toMatrixBlock(this.getBinaryBlockedRDD(varName), (int)mc.getRows(), (int)mc.getCols(), mc.getRowsPerBlock(), mc.getColsPerBlock(), mc.getNonZeros());
    }

    public JavaPairRDD<MatrixIndexes, MatrixBlock> getBinaryBlockedRDD(String varName) throws DMLRuntimeException {
        if (this._outputs.containsKey(varName)) {
            return this._outputs.get(varName);
        }
        throw new DMLRuntimeException("Variable " + varName + " not found in the outputs.");
    }

    public JavaPairRDD<Long, FrameBlock> getFrameBinaryBlockedRDD(String varName) throws DMLRuntimeException {
        if (this._outputs.containsKey(varName)) {
            return this._outputs.get(varName);
        }
        throw new DMLRuntimeException("Variable " + varName + " not found in the outputs.");
    }

    public MatrixCharacteristics getMatrixCharacteristics(String varName) throws DMLRuntimeException {
        if (this._outputs.containsKey(varName)) {
            return this._outMetadata.get(varName);
        }
        throw new DMLRuntimeException("Variable " + varName + " not found in the output symbol table.");
    }

    public Dataset<Row> getDF(SparkSession sparkSession, String varName) throws DMLRuntimeException {
        if (sparkSession == null) {
            throw new DMLRuntimeException("SparkSession is not created.");
        }
        JavaPairRDD<MatrixIndexes, MatrixBlock> rdd = this.getBinaryBlockedRDD(varName);
        if (rdd != null) {
            MatrixCharacteristics mc = this._outMetadata.get(varName);
            return RDDConverterUtils.binaryBlockToDataFrame(sparkSession, rdd, mc, false);
        }
        throw new DMLRuntimeException("Variable " + varName + " not found in the output symbol table.");
    }

    public Dataset<Row> getDF(SQLContext sqlContext, String varName) throws DMLRuntimeException {
        if (sqlContext == null) {
            throw new DMLRuntimeException("SQLContext is not created");
        }
        SparkSession sparkSession = sqlContext.sparkSession();
        return this.getDF(sparkSession, varName);
    }

    public Dataset<Row> getDF(SparkSession sparkSession, String varName, boolean outputVector) throws DMLRuntimeException {
        if (sparkSession == null) {
            throw new DMLRuntimeException("SparkSession is not created.");
        }
        if (outputVector) {
            JavaPairRDD<MatrixIndexes, MatrixBlock> rdd = this.getBinaryBlockedRDD(varName);
            if (rdd != null) {
                MatrixCharacteristics mc = this._outMetadata.get(varName);
                return RDDConverterUtils.binaryBlockToDataFrame(sparkSession, rdd, mc, true);
            }
            throw new DMLRuntimeException("Variable " + varName + " not found in the output symbol table.");
        }
        return this.getDF(sparkSession, varName);
    }

    public Dataset<Row> getDF(SQLContext sqlContext, String varName, boolean outputVector) throws DMLRuntimeException {
        if (sqlContext == null) {
            throw new DMLRuntimeException("SQLContext is not created");
        }
        SparkSession sparkSession = sqlContext.sparkSession();
        return this.getDF(sparkSession, varName, outputVector);
    }

    public Dataset<Row> getDF(SparkSession sparkSession, String varName, MatrixCharacteristics mc) throws DMLRuntimeException {
        if (sparkSession == null) {
            throw new DMLRuntimeException("SparkSession is not created.");
        }
        JavaPairRDD<MatrixIndexes, MatrixBlock> binaryBlockRDD = this.getBinaryBlockedRDD(varName);
        return RDDConverterUtils.binaryBlockToDataFrame(sparkSession, binaryBlockRDD, mc, true);
    }

    public Dataset<Row> getDF(SQLContext sqlContext, String varName, MatrixCharacteristics mc) throws DMLRuntimeException {
        if (sqlContext == null) {
            throw new DMLRuntimeException("SQLContext is not created");
        }
        SparkSession sparkSession = sqlContext.sparkSession();
        return this.getDF(sparkSession, varName, mc);
    }

    public JavaRDD<String> getStringRDD(String varName, String format) throws DMLRuntimeException {
        if (format.equals("text")) {
            JavaPairRDD<MatrixIndexes, MatrixBlock> binaryRDD = this.getBinaryBlockedRDD(varName);
            MatrixCharacteristics mcIn = this.getMatrixCharacteristics(varName);
            return RDDConverterUtils.binaryBlockToTextCell(binaryRDD, mcIn);
        }
        throw new DMLRuntimeException("The output format:" + format + " is not implemented yet.");
    }

    public JavaRDD<String> getStringFrameRDD(String varName, String format, CSVFileFormatProperties fprop) throws DMLRuntimeException {
        JavaPairRDD<Long, FrameBlock> binaryRDD = this.getFrameBinaryBlockedRDD(varName);
        MatrixCharacteristics mcIn = this.getMatrixCharacteristics(varName);
        if (format.equals("csv")) {
            return FrameRDDConverterUtils.binaryBlockToCsv(binaryRDD, mcIn, fprop, false);
        }
        if (format.equals("text")) {
            return FrameRDDConverterUtils.binaryBlockToTextCell(binaryRDD, mcIn);
        }
        throw new DMLRuntimeException("The output format:" + format + " is not implemented yet.");
    }

    public Dataset<Row> getDataFrameRDD(String varName, JavaSparkContext jsc) throws DMLRuntimeException {
        JavaPairRDD<Long, FrameBlock> binaryRDD = this.getFrameBinaryBlockedRDD(varName);
        MatrixCharacteristics mcIn = this.getMatrixCharacteristics(varName);
        SparkSession sparkSession = SparkSession.builder().sparkContext(jsc.sc()).getOrCreate();
        return FrameRDDConverterUtils.binaryBlockToDataFrame(sparkSession, binaryRDD, mcIn, null);
    }

    public MLMatrix getMLMatrix(MLContext ml, SparkSession sparkSession, String varName) throws DMLRuntimeException {
        if (sparkSession == null) {
            throw new DMLRuntimeException("SparkSession is not created.");
        }
        if (ml == null) {
            throw new DMLRuntimeException("MLContext is not created.");
        }
        JavaPairRDD<MatrixIndexes, MatrixBlock> rdd = this.getBinaryBlockedRDD(varName);
        if (rdd != null) {
            MatrixCharacteristics mc = this.getMatrixCharacteristics(varName);
            StructType schema = MLBlock.getDefaultSchemaForBinaryBlock();
            return new MLMatrix((Dataset<Row>)sparkSession.createDataFrame(rdd.map((Function)new GetMLBlock()).rdd(), schema), mc, ml);
        }
        throw new DMLRuntimeException("Variable " + varName + " not found in the output symbol table.");
    }

    public MLMatrix getMLMatrix(MLContext ml, SQLContext sqlContext, String varName) throws DMLRuntimeException {
        if (sqlContext == null) {
            throw new DMLRuntimeException("SQLContext is not created");
        }
        SparkSession sparkSession = sqlContext.sparkSession();
        return this.getMLMatrix(ml, sparkSession, varName);
    }
}

