/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.upgrade;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.Optional;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.jdbc.schema.SchemaGroup;
import org.apache.openjpa.jdbc.schema.SchemaTool;
import org.apache.openjpa.jdbc.schema.Sequence;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.schema.Unique;

public class WiserSchemaTool
extends SchemaTool {
    public WiserSchemaTool(JDBCConfiguration conf) {
        super(conf);
    }

    public WiserSchemaTool(JDBCConfiguration conf, String action) {
        super(conf, action);
    }

    protected void buildSchema(SchemaGroup db, SchemaGroup repos, boolean considerDatabaseState) throws SQLException {
        Table dbTable;
        if (this.getSequences()) {
            for (Schema schema : repos.getSchemas()) {
                for (Sequence seq : schema.getSequences()) {
                    if (considerDatabaseState && db.findSequence(schema, seq.getQualifiedPath()) != null) continue;
                    if (this.createSequence(seq)) {
                        Schema dbSchema = Optional.ofNullable(db.getSchema(seq.getSchemaIdentifier())).orElseGet(() -> db.addSchema(seq.getSchemaIdentifier()));
                        dbSchema.importSequence(seq);
                        continue;
                    }
                    this._log.warn((Object)_loc.get("add-seq", (Object)seq));
                }
            }
        }
        DBIdentifier defaultSchemaName = DBIdentifier.newSchema((String)this._dict.getDefaultSchemaName());
        for (Schema schema : repos.getSchemas()) {
            for (Table tab : schema.getTables()) {
                Table dbTable2;
                Table table = dbTable2 = considerDatabaseState ? db.findTable(schema, tab.getQualifiedPath(), defaultSchemaName) : null;
                if (dbTable2 == null) continue;
                for (Column col : tab.getColumns()) {
                    Column dbCol = dbTable2.getColumn(col.getIdentifier());
                    if (dbCol == null) {
                        if (this.addColumn(col)) {
                            dbTable2.importColumn(col);
                            continue;
                        }
                        this._log.warn((Object)_loc.get("add-col", (Object)col, (Object)tab));
                        continue;
                    }
                    if (col.equalsColumn(this._dict, dbCol)) continue;
                    this._log.warn((Object)_loc.get("bad-col", new Object[]{dbCol, dbTable2, dbCol.getDescription(), col.getDescription()}));
                }
            }
        }
        if (this.getPrimaryKeys()) {
            for (Schema schema : repos.getSchemas()) {
                for (Table tab : schema.getTables()) {
                    PrimaryKey pk = tab.getPrimaryKey();
                    Table table = dbTable = considerDatabaseState ? db.findTable(schema, (DBIdentifier)tab.getQualifiedPath()) : null;
                    if (pk == null || pk.isLogical() || dbTable == null) continue;
                    if (dbTable.getPrimaryKey() == null && this.addPrimaryKey(pk)) {
                        dbTable.importPrimaryKey(pk);
                        continue;
                    }
                    if (dbTable.getPrimaryKey() == null) {
                        this._log.warn((Object)_loc.get("add-pk", (Object)pk, (Object)tab));
                        continue;
                    }
                    if (pk.equalsPrimaryKey(dbTable.getPrimaryKey())) continue;
                    this._log.warn((Object)_loc.get("bad-pk", (Object)dbTable.getPrimaryKey(), (Object)dbTable));
                }
            }
        }
        HashSet<Table> newTables = new HashSet<Table>();
        for (Schema schema : repos.getSchemas()) {
            for (Table tab : schema.getTables()) {
                if (considerDatabaseState && db.findTable(schema, (DBIdentifier)tab.getQualifiedPath()) != null) continue;
                if (this.createTable(tab)) {
                    newTables.add(tab);
                    Schema dbSchema = Optional.ofNullable(db.getSchema(tab.getSchemaIdentifier())).orElseGet(() -> db.addSchema(tab.getSchemaIdentifier()));
                    dbSchema.importTable(tab);
                    continue;
                }
                this._log.warn((Object)_loc.get("add-table", (Object)tab));
            }
        }
        for (Schema schema : repos.getSchemas()) {
            Table[] tabs;
            for (Table tab : tabs = schema.getTables()) {
                Table dbTable3;
                if (!this.getIndexes() && !newTables.contains(tab)) continue;
                Table table = dbTable3 = considerDatabaseState ? db.findTable(schema, (DBIdentifier)tab.getQualifiedPath()) : null;
                if (dbTable3 == null) continue;
                for (Index idx : tab.getIndexes()) {
                    Index dbIdx = this.findIndex(dbTable3, idx);
                    if (dbIdx == null) {
                        if (this.createIndex(idx, dbTable3, tab.getUniques())) {
                            dbTable3.importIndex(idx);
                            continue;
                        }
                        this._log.warn((Object)_loc.get("add-index", (Object)idx, (Object)tab));
                        continue;
                    }
                    if (idx.equalsIndex(dbIdx)) continue;
                    this._log.warn((Object)_loc.get("bad-index", (Object)dbIdx, (Object)dbTable3));
                }
            }
        }
        for (Schema schema : repos.getSchemas()) {
            for (Table tab : schema.getTables()) {
                Table dbTable4;
                Unique[] uniques;
                if (!newTables.contains(tab) || (uniques = tab.getUniques()) == null || uniques.length == 0) continue;
                Table table = dbTable4 = considerDatabaseState ? db.findTable(tab) : null;
                if (dbTable4 == null) continue;
                for (Unique unique : uniques) {
                    dbTable4.importUnique(unique);
                }
            }
        }
        for (Schema schema : repos.getSchemas()) {
            for (Table tab : schema.getTables()) {
                if (!this.getForeignKeys() && !newTables.contains(tab)) continue;
                Table table = dbTable = considerDatabaseState ? db.findTable(schema, (DBIdentifier)tab.getQualifiedPath()) : null;
                if (dbTable == null) continue;
                for (ForeignKey fk : tab.getForeignKeys()) {
                    if (fk.isLogical()) continue;
                    ForeignKey dbFk = this.findForeignKey(dbTable, fk);
                    if (dbFk == null) {
                        if (this.addForeignKey(fk)) {
                            dbTable.importForeignKey(fk);
                            continue;
                        }
                        this._log.warn((Object)_loc.get("add-fk", (Object)fk, (Object)tab));
                        continue;
                    }
                    if (fk.equalsForeignKey(dbFk)) continue;
                    this._log.warn((Object)_loc.get("bad-fk", (Object)dbFk, (Object)dbTable));
                }
            }
        }
    }
}

