/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.upgrade;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.schema.FileSchemaFactory;
import org.apache.openjpa.jdbc.schema.SchemaFactory;
import org.apache.syncope.core.persistence.jpa.upgrade.GenerateUpgradeSQL;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class PersistenceUpgraderContext {
    @Bean
    public DataSource syncopeDataSource(@Value(value="${db.jdbcDriverClassName}") String jdbcDriver, @Value(value="${db.jdbcURL}") String jdbcURL, @Value(value="${db.username}") String dbUser, @Value(value="${db.password}") String dbPassword) {
        HikariConfig config = new HikariConfig();
        config.setDriverClassName(jdbcDriver);
        config.setJdbcUrl(jdbcURL);
        config.setUsername(dbUser);
        config.setPassword(dbPassword);
        return new HikariDataSource(config);
    }

    @Bean
    public JDBCConfiguration jdbcConf(DataSource syncopeDataSource, @Value(value="${db.jdbcDriverClassName}") String jdbcDriver, @Value(value="${db.dictionary}") String dbDictionary) {
        JDBCConfigurationImpl jdbcConf = new JDBCConfigurationImpl();
        jdbcConf.setConnection2DriverName(jdbcDriver);
        jdbcConf.setDBDictionary(dbDictionary);
        jdbcConf.setConnectionFactory2((Object)syncopeDataSource);
        FileSchemaFactory schemaFactory = new FileSchemaFactory();
        schemaFactory.setConfiguration((org.apache.openjpa.lib.conf.Configuration)jdbcConf);
        schemaFactory.setFile("schema.xml");
        jdbcConf.setSchemaFactory((SchemaFactory)schemaFactory);
        return jdbcConf;
    }

    @Bean
    public GenerateUpgradeSQL generateUpgradeSQL(JDBCConfiguration jdbcConf) {
        return new GenerateUpgradeSQL(jdbcConf);
    }
}

