/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.validation;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apereo.cas.validation.Assertion;
import org.apereo.cas.validation.CasProtocolValidationSpecification;
import org.apereo.inspektr.audit.annotation.Audit;

public class ChainingCasProtocolValidationSpecification
implements CasProtocolValidationSpecification {
    private final List<CasProtocolValidationSpecification> specifications = new ArrayList<CasProtocolValidationSpecification>(0);
    private final boolean canBeSatisfiedByAnySpecification;
    private boolean renew;

    @Audit(action="PROTOCOL_SPECIFICATION_VALIDATE", actionResolverName="VALIDATE_PROTOCOL_SPECIFICATION_RESOLVER", resourceResolverName="VALIDATE_PROTOCOL_SPECIFICATION_RESOURCE_RESOLVER")
    public boolean isSatisfiedBy(Assertion assertion, HttpServletRequest request) {
        if (this.canBeSatisfiedByAnySpecification) {
            return this.specifications.stream().peek(spec -> spec.setRenew(this.renew)).anyMatch(spec -> spec.isSatisfiedBy(assertion, request));
        }
        return this.specifications.stream().peek(spec -> spec.setRenew(this.renew)).allMatch(spec -> spec.isSatisfiedBy(assertion, request));
    }

    public void reset() {
        this.specifications.forEach(CasProtocolValidationSpecification::reset);
        this.setRenew(false);
    }

    public void addSpecification(CasProtocolValidationSpecification policy) {
        this.specifications.add(policy);
    }

    public void addSpecifications(CasProtocolValidationSpecification ... policies) {
        this.specifications.addAll(Arrays.stream(policies).toList());
    }

    public int size() {
        return this.specifications.size();
    }

    @Generated
    public List<CasProtocolValidationSpecification> getSpecifications() {
        return this.specifications;
    }

    @Generated
    public boolean isCanBeSatisfiedByAnySpecification() {
        return this.canBeSatisfiedByAnySpecification;
    }

    @Generated
    public boolean isRenew() {
        return this.renew;
    }

    @Generated
    public void setRenew(boolean renew) {
        this.renew = renew;
    }

    @Generated
    public ChainingCasProtocolValidationSpecification() {
        this.canBeSatisfiedByAnySpecification = false;
    }

    @Generated
    public ChainingCasProtocolValidationSpecification(boolean canBeSatisfiedByAnySpecification) {
        this.canBeSatisfiedByAnySpecification = canBeSatisfiedByAnySpecification;
    }
}

