/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.validation;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.services.CasModelRegisteredService;
import org.apereo.cas.services.CasProtocolVersions;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.validation.Assertion;
import org.apereo.cas.validation.CasProtocolValidationSpecification;

public class CasProtocolVersionValidationSpecification
implements CasProtocolValidationSpecification {
    private final Set<CasProtocolVersions> supportedVersions;

    public boolean isSatisfiedBy(Assertion assertion, HttpServletRequest request) {
        RegisteredService registeredService = assertion.getRegisteredService();
        if (registeredService instanceof CasModelRegisteredService) {
            CasModelRegisteredService casService = (CasModelRegisteredService)registeredService;
            return casService.getSupportedProtocols().isEmpty() || casService.getSupportedProtocols().containsAll(this.supportedVersions);
        }
        return true;
    }

    @Generated
    public CasProtocolVersionValidationSpecification(Set<CasProtocolVersions> supportedVersions) {
        this.supportedVersions = supportedVersions;
    }
}

