/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.api.entity;

import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.User;

public class AnyUtilsFactory {
    protected final AnyUtils userAnyUtils;
    protected final AnyUtils linkedAccountAnyUtils;
    protected final AnyUtils groupAnyUtils;
    protected final AnyUtils anyObjectAnyUtils;

    public AnyUtilsFactory(AnyUtils userAnyUtils, AnyUtils linkedAccountAnyUtils, AnyUtils groupAnyUtils, AnyUtils anyObjectAnyUtils) {
        this.userAnyUtils = userAnyUtils;
        this.linkedAccountAnyUtils = linkedAccountAnyUtils;
        this.groupAnyUtils = groupAnyUtils;
        this.anyObjectAnyUtils = anyObjectAnyUtils;
    }

    public AnyUtils getInstance(AnyTypeKind anyTypeKind) {
        switch (anyTypeKind) {
            case ANY_OBJECT: {
                return this.anyObjectAnyUtils;
            }
            case GROUP: {
                return this.groupAnyUtils;
            }
        }
        return this.userAnyUtils;
    }

    public AnyUtils getInstance(Any<?> any) {
        AnyTypeKind anyTypeKind = null;
        if (any instanceof User) {
            anyTypeKind = AnyTypeKind.USER;
        } else if (any instanceof Group) {
            anyTypeKind = AnyTypeKind.GROUP;
        } else if (any instanceof AnyObject) {
            anyTypeKind = AnyTypeKind.ANY_OBJECT;
        }
        if (anyTypeKind == null) {
            throw new IllegalArgumentException("Any type not supported: " + any.getClass().getName());
        }
        return this.getInstance(anyTypeKind);
    }

    public AnyUtils getLinkedAccountInstance() {
        return this.linkedAccountAnyUtils;
    }
}

