/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.surrogate;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.Map;
import org.apereo.cas.authentication.surrogate.SimpleSurrogateAuthenticationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.io.FileWatcherService;
import org.apereo.cas.util.io.WatcherService;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.springframework.beans.factory.DisposableBean;

public class JsonResourceSurrogateAuthenticationService
extends SimpleSurrogateAuthenticationService
implements DisposableBean {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private final WatcherService watcherService;

    public JsonResourceSurrogateAuthenticationService(File json, ServicesManager servicesManager, CasConfigurationProperties casProperties) throws Exception {
        super(JsonResourceSurrogateAuthenticationService.readAccountsFromFile(json), servicesManager, casProperties);
        this.watcherService = new FileWatcherService(json, this::loadServices);
        this.watcherService.start(this.getClass().getSimpleName());
    }

    public JsonResourceSurrogateAuthenticationService(ServicesManager servicesManager, CasConfigurationProperties casProperties) throws Exception {
        this(casProperties.getAuthn().getSurrogate().getJson().getLocation().getFile(), servicesManager, casProperties);
    }

    private static Map readAccountsFromFile(File json) throws Exception {
        return (Map)MAPPER.readValue(json, Map.class);
    }

    private void loadServices(File file) {
        FunctionUtils.doAndHandle(__ -> {
            this.getEligibleAccounts().clear();
            this.getEligibleAccounts().putAll(JsonResourceSurrogateAuthenticationService.readAccountsFromFile(file));
        });
    }

    public void destroy() {
        if (this.watcherService != null) {
            this.watcherService.close();
        }
    }
}

