/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.surrogate;

import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.MutableCredential;
import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationRequest;
import org.apereo.cas.authentication.surrogate.SurrogateCredentialParser;
import org.apereo.cas.configuration.model.support.surrogate.SurrogateAuthenticationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSurrogateCredentialParser
implements SurrogateCredentialParser {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSurrogateCredentialParser.class);
    private final SurrogateAuthenticationProperties properties;

    public Optional<SurrogateAuthenticationRequest> parse(MutableCredential credential) {
        if (credential != null) {
            String separator = this.properties.getCore().getSeparator();
            if (credential.getId().contains(separator)) {
                String givenUserName = credential.getId();
                String surrogateUsername = givenUserName.substring(0, givenUserName.indexOf(separator));
                String primaryUserName = givenUserName.substring(givenUserName.indexOf(separator) + separator.length());
                LOGGER.debug("Converting to surrogate credential for username [{}], surrogate username [{}]", (Object)primaryUserName, (Object)surrogateUsername);
                return Optional.of(SurrogateAuthenticationRequest.builder().surrogateUsername(surrogateUsername).username(primaryUserName).credential(credential).build());
            }
        }
        LOGGER.debug("Credential is undefined or does not indicate a surrogate authentication request");
        return Optional.empty();
    }

    @Generated
    public DefaultSurrogateCredentialParser(SurrogateAuthenticationProperties properties) {
        this.properties = properties;
    }
}

