/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.surrogate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationService;
import org.apereo.cas.services.RegisteredServiceSurrogatePolicy;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.WebBasedRegisteredService;
import org.jooq.lambda.Unchecked;

public class ChainingSurrogateAuthenticationService
implements SurrogateAuthenticationService {
    private final List<SurrogateAuthenticationService> surrogateServices;
    private final ServicesManager servicesManager;

    public boolean canImpersonate(String surrogate, Principal principal, Optional<? extends Service> givenService) throws Throwable {
        return this.isImpersonationAllowedFor(givenService) && this.surrogateServices.stream().anyMatch(Unchecked.predicate(impl -> impl.canImpersonate(surrogate, principal, givenService)));
    }

    public Collection<String> getImpersonationAccounts(String username, Optional<? extends Service> givenService) throws Throwable {
        return this.isImpersonationAllowedFor(givenService) ? this.surrogateServices.stream().map(Unchecked.function(impl -> impl.getImpersonationAccounts(username, givenService))).flatMap(Collection::stream).toList() : new ArrayList<String>();
    }

    public boolean isWildcardedAccount(String surrogate, Principal principal, Optional<? extends Service> givenService) throws Throwable {
        return this.isImpersonationAllowedFor(givenService) && this.surrogateServices.stream().anyMatch(Unchecked.predicate(impl -> impl.isWildcardedAccount(surrogate, principal, givenService)));
    }

    public boolean isWildcardedAccount(Collection<String> accounts, Optional<? extends Service> givenService) {
        return this.isImpersonationAllowedFor(givenService) && this.surrogateServices.stream().anyMatch(Unchecked.predicate(impl -> impl.isWildcardedAccount(accounts, givenService)));
    }

    protected boolean isImpersonationAllowedFor(Optional<? extends Service> givenService) {
        Optional<RegisteredServiceSurrogatePolicy> surrogatePolicyResult = givenService.map(arg_0 -> ((ServicesManager)this.servicesManager).findServiceBy(arg_0)).filter(WebBasedRegisteredService.class::isInstance).map(WebBasedRegisteredService.class::cast).filter(service -> Objects.nonNull(service.getSurrogatePolicy())).map(WebBasedRegisteredService::getSurrogatePolicy).stream().findFirst();
        return surrogatePolicyResult.map(RegisteredServiceSurrogatePolicy::isEnabled).orElse(Boolean.TRUE);
    }

    @Generated
    public ChainingSurrogateAuthenticationService(List<SurrogateAuthenticationService> surrogateServices, ServicesManager servicesManager) {
        this.surrogateServices = surrogateServices;
        this.servicesManager = servicesManager;
    }
}

