/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.surrogate;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.surrogate.SurrogateCoreAuthenticationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.WebBasedRegisteredService;
import org.apereo.cas.util.RegexUtils;

public abstract class BaseSurrogateAuthenticationService
implements SurrogateAuthenticationService {
    protected final ServicesManager servicesManager;
    protected final CasConfigurationProperties casProperties;

    public final boolean canImpersonate(String surrogate, Principal principal, Optional<? extends Service> service) throws Throwable {
        boolean serviceAuthorized = this.isServiceAuthorizedForImpersonation(principal, service);
        return serviceAuthorized && (surrogate.equalsIgnoreCase(principal.getId()) || this.isPrincipalAuthorizedForImpersonation(surrogate, principal, service) || this.isWildcardedAccount(surrogate, principal, service) || this.canImpersonateInternal(surrogate, principal, service));
    }

    protected boolean isServiceAuthorizedForImpersonation(Principal principal, Optional<? extends Service> givenService) throws Throwable {
        if (givenService.isPresent()) {
            WebBasedRegisteredService wbrs;
            RegisteredService registeredService;
            Service service = givenService.get();
            return RegisteredServiceAccessStrategyUtils.ensurePrincipalAccessIsAllowedForService((Service)service, (RegisteredService)(registeredService = this.servicesManager.findServiceBy(service)), (String)principal.getId(), (Map)principal.getAttributes()) && registeredService instanceof WebBasedRegisteredService && (wbrs = (WebBasedRegisteredService)registeredService).getSurrogatePolicy().isEnabled();
        }
        return true;
    }

    protected boolean isPrincipalAuthorizedForImpersonation(String surrogate, Principal principal, Optional<? extends Service> givenService) throws Throwable {
        SurrogateCoreAuthenticationProperties core = this.casProperties.getAuthn().getSurrogate().getCore();
        if (!core.getPrincipalAttributeNames().isEmpty() && !core.getPrincipalAttributeValues().isEmpty()) {
            return core.getPrincipalAttributeNames().stream().filter(name -> principal.getAttributes().containsKey(name)).anyMatch(name -> {
                List attributeValues = (List)principal.getAttributes().get(name);
                return RegexUtils.findFirst((Collection)core.getPrincipalAttributeValues(), (Collection)attributeValues).isPresent();
            });
        }
        return false;
    }

    protected abstract boolean canImpersonateInternal(String var1, Principal var2, Optional<? extends Service> var3) throws Throwable;

    @Generated
    protected BaseSurrogateAuthenticationService(ServicesManager servicesManager, CasConfigurationProperties casProperties) {
        this.servicesManager = servicesManager;
        this.casProperties = casProperties;
    }
}

