/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.event;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.event.SurrogateAuthenticationEventListener;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.email.EmailProperties;
import org.apereo.cas.configuration.model.support.sms.SmsProperties;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.notifications.mail.EmailMessageBodyBuilder;
import org.apereo.cas.notifications.mail.EmailMessageRequest;
import org.apereo.cas.notifications.sms.SmsBodyBuilder;
import org.apereo.cas.notifications.sms.SmsRequest;
import org.apereo.cas.support.events.AbstractCasEvent;
import org.apereo.cas.support.events.authentication.surrogate.CasSurrogateAuthenticationFailureEvent;
import org.apereo.cas.support.events.authentication.surrogate.CasSurrogateAuthenticationSuccessfulEvent;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSurrogateAuthenticationEventListener
implements SurrogateAuthenticationEventListener {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSurrogateAuthenticationEventListener.class);
    private final CommunicationsManager communicationsManager;
    private final CasConfigurationProperties casProperties;

    @Override
    public void handleSurrogateAuthenticationFailureEvent(CasSurrogateAuthenticationFailureEvent event) throws Throwable {
        this.notify(event.getPrincipal(), (AbstractCasEvent)event);
    }

    @Override
    public void handleSurrogateAuthenticationSuccessEvent(CasSurrogateAuthenticationSuccessfulEvent event) throws Throwable {
        this.notify(event.getPrincipal(), (AbstractCasEvent)event);
    }

    protected void notify(Principal principal, AbstractCasEvent event) throws Throwable {
        String eventDetails = event.toString();
        if (this.communicationsManager.isSmsSenderDefined()) {
            SmsProperties sms = this.casProperties.getAuthn().getSurrogate().getSms();
            String text = SmsBodyBuilder.builder().properties(sms).parameters(Map.of("details", eventDetails)).build().get();
            List smsRequests = sms.getAttributeName().stream().map(attribute -> SmsRequest.builder().principal(principal).attribute(SpringExpressionLanguageValueResolver.getInstance().resolve(attribute)).from(sms.getFrom()).text(text).build()).collect(Collectors.toList());
            this.communicationsManager.sms(smsRequests);
        } else {
            LOGGER.trace("CAS is unable to send surrogate-authentication SMS messages given no settings are defined to account for servers, etc");
        }
        if (this.communicationsManager.isMailSenderDefined()) {
            List emailAttributes = this.casProperties.getAuthn().getSurrogate().getMail().getAttributeName();
            emailAttributes.forEach(attribute -> this.sendEmail(principal, (String)attribute, eventDetails));
        } else {
            LOGGER.trace("CAS is unable to send surrogate-authentication email messages given no settings are defined to account for servers, etc");
        }
    }

    protected void sendEmail(Principal principal, String emailAttribute, String eventDetails) {
        EmailProperties mail = this.casProperties.getAuthn().getSurrogate().getMail();
        String resolvedAttribute = SpringExpressionLanguageValueResolver.getInstance().resolve(emailAttribute);
        List to = (List)principal.getAttributes().get(resolvedAttribute);
        if (to != null) {
            CollectionUtils.firstElement((Object)to).ifPresent(address -> {
                String body = EmailMessageBodyBuilder.builder().properties(mail).parameters(Map.of("event", eventDetails)).build().get();
                EmailMessageRequest emailRequest = EmailMessageRequest.builder().emailProperties(mail).to(List.of(address.toString())).body(body).build();
                this.communicationsManager.email(emailRequest);
            });
        } else {
            LOGGER.trace("The principal has no [{}] attribute, cannot send email notification", (Object)resolvedAttribute);
        }
    }

    @Generated
    public DefaultSurrogateAuthenticationEventListener(CommunicationsManager communicationsManager, CasConfigurationProperties casProperties) {
        this.communicationsManager = communicationsManager;
        this.casProperties = casProperties;
    }
}

