/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.SurrogateAuthenticationException;
import org.apereo.cas.authentication.metadata.BaseAuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.surrogate.SurrogateCredentialTrait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurrogateAuthenticationMetaDataPopulator
extends BaseAuthenticationMetaDataPopulator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SurrogateAuthenticationMetaDataPopulator.class);

    public void populateAttributes(AuthenticationBuilder builder, AuthenticationTransaction transaction) {
        Optional primaryCredential = transaction.getPrimaryCredential();
        primaryCredential.ifPresentOrElse(credential -> {
            String surrogateUsername = credential.getCredentialMetadata().getTrait(SurrogateCredentialTrait.class).map(SurrogateCredentialTrait::getSurrogateUsername).orElseThrow();
            LOGGER.debug("Recording surrogate username [{}] as an authentication attribute", (Object)surrogateUsername);
            builder.addAttribute("surrogateUser", (Object)surrogateUsername);
            builder.addAttribute("surrogatePrincipal", (Object)credential.getId());
            builder.addAttribute("surrogateEnabled", (Object)Boolean.TRUE.toString());
        }, () -> {
            throw new SurrogateAuthenticationException("The authentication transaction does not have a primary principal");
        });
    }

    public boolean supports(Credential credential) {
        return credential.getCredentialMetadata().getTrait(SurrogateCredentialTrait.class).stream().anyMatch(trait -> StringUtils.isNotBlank((CharSequence)trait.getSurrogateUsername()));
    }
}

