/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.SurrogateAuthenticationException;
import org.apereo.cas.authentication.SurrogateAuthenticationPrincipalBuilder;
import org.apereo.cas.authentication.SurrogatePrincipal;
import org.apereo.cas.authentication.attribute.AttributeRepositoryResolver;
import org.apereo.cas.authentication.attribute.PrincipalAttributeRepositoryFetcher;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.authentication.principal.resolvers.PrincipalResolverUtils;
import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationService;
import org.apereo.cas.authentication.surrogate.SurrogateCredentialTrait;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PersonDirectoryPrincipalResolverProperties;
import org.apereo.cas.services.RegisteredService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSurrogateAuthenticationPrincipalBuilder
implements SurrogateAuthenticationPrincipalBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSurrogateAuthenticationPrincipalBuilder.class);
    private final PrincipalFactory principalFactory;
    private final PersonAttributeDao attributeRepository;
    private final SurrogateAuthenticationService surrogateAuthenticationService;
    private final AttributeRepositoryResolver attributeRepositoryResolver;
    private final CasConfigurationProperties casProperties;

    @Override
    public Principal buildSurrogatePrincipal(String surrogate, Principal primaryPrincipal, RegisteredService registeredService) throws Throwable {
        Set activeAttributeRepositoryIdentifiers = PrincipalResolverUtils.buildActiveAttributeRepositoryIds((PersonDirectoryPrincipalResolverProperties[])new PersonDirectoryPrincipalResolverProperties[]{this.casProperties.getPersonDirectory()});
        AttributeRepositoryResolver.AttributeRepositoryQuery query = new AttributeRepositoryResolver.AttributeRepositoryQuery(primaryPrincipal, activeAttributeRepositoryIdentifiers).withRegisteredService(registeredService);
        Set repositoryIds = this.attributeRepositoryResolver.resolve(query);
        Map attributes = PrincipalAttributeRepositoryFetcher.builder().attributeRepository(this.attributeRepository).principalId(surrogate).activeAttributeRepositoryIdentifiers(repositoryIds).currentPrincipal(primaryPrincipal).build().retrieve();
        Principal surrogatePrincipal = this.principalFactory.createPrincipal(surrogate, attributes);
        LOGGER.debug("Built surrogate principal [{}] with primary principal [{}]", (Object)surrogatePrincipal, (Object)primaryPrincipal);
        return new SurrogatePrincipal(primaryPrincipal, surrogatePrincipal);
    }

    @Override
    public Optional<AuthenticationResultBuilder> buildSurrogateAuthenticationResult(AuthenticationResultBuilder authenticationResultBuilder, Credential mutableCredential, RegisteredService registeredService) throws Throwable {
        Optional currentAuthn = authenticationResultBuilder.getInitialAuthentication();
        if (currentAuthn.isPresent()) {
            String surrogateUsername;
            Authentication authentication = (Authentication)currentAuthn.get();
            Principal principal = authentication.getPrincipal();
            if (authentication.getPrincipal() instanceof SurrogatePrincipal) {
                principal = ((SurrogatePrincipal)authentication.getPrincipal()).getPrimary();
            }
            if (!this.surrogateAuthenticationService.canImpersonate(surrogateUsername = mutableCredential.getCredentialMetadata().getTrait(SurrogateCredentialTrait.class).map(SurrogateCredentialTrait::getSurrogateUsername).orElseThrow(() -> new SurrogateAuthenticationException("Unable to locate surrogate credential")), principal, Optional.empty())) {
                throw new SurrogateAuthenticationException("Unable to authorize surrogate authentication request for " + surrogateUsername);
            }
            Principal surrogatePrincipal = this.buildSurrogatePrincipal(surrogateUsername, principal, registeredService);
            AuthenticationBuilder builder = DefaultAuthenticationBuilder.newInstance((Authentication)authentication).setPrincipal(surrogatePrincipal);
            builder.addAttribute("surrogateUser", (Object)surrogateUsername);
            builder.addAttribute("surrogatePrincipal", (Object)principal.getId());
            builder.addAttribute("surrogateEnabled", (Object)Boolean.TRUE.toString());
            Authentication auth = builder.build();
            return Optional.of(authenticationResultBuilder.collect(auth));
        }
        return Optional.empty();
    }

    @Generated
    public DefaultSurrogateAuthenticationPrincipalBuilder(PrincipalFactory principalFactory, PersonAttributeDao attributeRepository, SurrogateAuthenticationService surrogateAuthenticationService, AttributeRepositoryResolver attributeRepositoryResolver, CasConfigurationProperties casProperties) {
        this.principalFactory = principalFactory;
        this.attributeRepository = attributeRepository;
        this.surrogateAuthenticationService = surrogateAuthenticationService;
        this.attributeRepositoryResolver = attributeRepositoryResolver;
        this.casProperties = casProperties;
    }

    @Generated
    public PrincipalFactory getPrincipalFactory() {
        return this.principalFactory;
    }

    @Generated
    public PersonAttributeDao getAttributeRepository() {
        return this.attributeRepository;
    }

    @Generated
    public SurrogateAuthenticationService getSurrogateAuthenticationService() {
        return this.surrogateAuthenticationService;
    }

    @Generated
    public AttributeRepositoryResolver getAttributeRepositoryResolver() {
        return this.attributeRepositoryResolver;
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }
}

