/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.rest;

import jakarta.ws.rs.core.GenericType;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.rest.BaseRestClient;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserRequest;
import org.apache.syncope.common.lib.to.UserRequestForm;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.beans.UserRequestQuery;
import org.apache.syncope.common.rest.api.service.UserRequestService;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;

public class UserRequestRestClient
extends BaseRestClient {
    private static final long serialVersionUID = -4785231164900813921L;

    public long countRequests() {
        return ((UserRequestService)this.getService(UserRequestService.class)).listRequests((UserRequestQuery)((UserRequestQuery.Builder)((UserRequestQuery.Builder)new UserRequestQuery.Builder().user(SyncopeEnduserSession.get().getSelfTO().getUsername()).page(Integer.valueOf(1))).size(Integer.valueOf(0))).build()).getTotalCount();
    }

    public List<UserRequest> listRequests(int page, int size, String username, SortParam<String> sort) {
        return ((UserRequestService)this.getService(UserRequestService.class)).listRequests((UserRequestQuery)((UserRequestQuery.Builder)((UserRequestQuery.Builder)((UserRequestQuery.Builder)new UserRequestQuery.Builder().user(StringUtils.isBlank((CharSequence)username) ? SyncopeEnduserSession.get().getSelfTO().getUsername() : username).page(Integer.valueOf(page))).size(Integer.valueOf(size))).orderBy(this.toOrderBy(sort))).build()).getResult();
    }

    public void cancelRequest(String executionId, String reason) {
        ((UserRequestService)this.getService(UserRequestService.class)).cancelRequest(executionId, reason);
    }

    public long countForms() {
        return ((UserRequestService)this.getService(UserRequestService.class)).listForms((UserRequestQuery)((UserRequestQuery.Builder)((UserRequestQuery.Builder)new UserRequestQuery.Builder().page(Integer.valueOf(1))).size(Integer.valueOf(0))).build()).getTotalCount();
    }

    public List<UserRequestForm> listForms(int page, int size, SortParam<String> sort) {
        return ((UserRequestService)this.getService(UserRequestService.class)).listForms((UserRequestQuery)((UserRequestQuery.Builder)((UserRequestQuery.Builder)((UserRequestQuery.Builder)new UserRequestQuery.Builder().page(Integer.valueOf(page))).size(Integer.valueOf(size))).orderBy(this.toOrderBy(sort))).build()).getResult();
    }

    public Optional<UserRequestForm> getForm(String username, String taskId) {
        return Optional.ofNullable(((UserRequestService)this.getService(UserRequestService.class)).getForm(StringUtils.isBlank((CharSequence)username) ? SyncopeEnduserSession.get().getSelfTO().getUsername() : username, taskId));
    }

    public ProvisioningResult<UserTO> submitForm(UserRequestForm form) {
        return (ProvisioningResult)((UserRequestService)this.getService(UserRequestService.class)).submitForm(form).readEntity((GenericType)new GenericType<ProvisioningResult<UserTO>>(this){});
    }

    public void startRequest(String bpmnProcess, String user) {
        UserRequestService service = (UserRequestService)this.getService(UserRequestService.class);
        WebClient.getConfig((Object)WebClient.client((Object)service)).getRequestContext().put("use.async.http.conduit", Boolean.FALSE);
        service.startRequest(bpmnProcess, user, null);
        WebClient.getConfig((Object)WebClient.client((Object)service)).getRequestContext().put("use.async.http.conduit", Boolean.TRUE);
    }

    public UserRequestForm claimForm(String taskKey) {
        return ((UserRequestService)this.getService(UserRequestService.class)).claimForm(taskKey);
    }
}

