/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.util.spring.boot.ConditionalOnFeaturesEnabled;
import org.apereo.cas.web.CasWebSecurityConfigurer;
import org.apereo.cas.web.flow.CasDefaultFlowUrlHandler;
import org.apereo.cas.web.flow.CasFlowHandlerAdapter;
import org.apereo.cas.web.flow.CasFlowHandlerMapping;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlan;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.configurer.acct.AccountProfileWebflowConfigurer;
import org.apereo.cas.web.flow.executor.WebflowExecutorFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.webflow.context.servlet.FlowUrlHandler;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.executor.FlowExecutor;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeaturesEnabled(value={@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Webflow}), @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.AccountManagement}, enabledByDefault=false)})
@Configuration(value="CasWebflowAccountProfileConfiguration", proxyBeanMethods=false)
class CasWebflowAccountProfileConfiguration {
    private static final FlowExecutionListener[] FLOW_EXECUTION_LISTENERS = new FlowExecutionListener[0];

    CasWebflowAccountProfileConfiguration() {
    }

    @ConditionalOnMissingBean(name={"accountProfileWebflowConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasWebflowConfigurer accountProfileWebflowConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
        return new AccountProfileWebflowConfigurer(flowBuilderServices, loginFlowRegistry, applicationContext, casProperties);
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"accountProfileWebflowExecutionPlanConfigurer"})
    public CasWebflowExecutionPlanConfigurer accountProfileWebflowExecutionPlanConfigurer(@Qualifier(value="accountProfileWebflowConfigurer") CasWebflowConfigurer accountProfileWebflowConfigurer) {
        return plan -> plan.registerWebflowConfigurer(accountProfileWebflowConfigurer);
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    public FlowExecutor accountProfileFlowExecutor(@Qualifier(value="accountProfileWebflowUrlHandler") FlowUrlHandler accountProfileWebflowUrlHandler, CasConfigurationProperties casProperties, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry flowDefinitionRegistry, @Qualifier(value="webflowCipherExecutor") CipherExecutor webflowCipherExecutor) {
        WebflowExecutorFactory factory = new WebflowExecutorFactory(casProperties.getWebflow(), flowDefinitionRegistry, webflowCipherExecutor, FLOW_EXECUTION_LISTENERS, accountProfileWebflowUrlHandler);
        return factory.build();
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    public FlowUrlHandler accountProfileWebflowUrlHandler() {
        return new CasDefaultFlowUrlHandler();
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    public HandlerAdapter accountProfileWebflowHandlerAdapter(@Qualifier(value="accountProfileWebflowUrlHandler") FlowUrlHandler accountProfileWebflowUrlHandler, ConfigurableApplicationContext applicationContext, @Qualifier(value="accountProfileFlowExecutor") FlowExecutor accountProfileFlowExecutor) {
        CasFlowHandlerAdapter handler = new CasFlowHandlerAdapter("account");
        handler.setFlowExecutor(accountProfileFlowExecutor);
        handler.setFlowUrlHandler(accountProfileWebflowUrlHandler);
        return handler;
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public HandlerMapping accountProfileFlowHandlerMapping(@Qualifier(value="casWebflowExecutionPlan") CasWebflowExecutionPlan webflowExecutionPlan, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry flowDefinitionRegistry) {
        CasFlowHandlerMapping handler = new CasFlowHandlerMapping();
        handler.setOrder(0);
        handler.setFlowRegistry(flowDefinitionRegistry);
        handler.setInterceptors(webflowExecutionPlan.getWebflowInterceptors().toArray());
        handler.setFlowUrlHandler((FlowUrlHandler)new CasDefaultFlowUrlHandler());
        return handler;
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"accountProfileFlowEndpointConfigurer"})
    public CasWebSecurityConfigurer<Void> accountProfileFlowEndpointConfigurer() {
        return new CasWebSecurityConfigurer<Void>(this){

            public List<String> getIgnoredEndpoints() {
                return List.of(StringUtils.prependIfMissing((String)"account", (CharSequence)"/", (CharSequence[])new CharSequence[0]));
            }
        };
    }
}

